/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.util;

import de.grogra.pf.ui.Widget;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;

public final class WidgetList
implements Widget {
    private final Object component;
    private final WidgetHandle[] widgets;

    public WidgetList(Object object, Widget ... widgetArray) {
        this.component = object;
        this.widgets = new WidgetHandle[widgetArray.length];
        for (int i = 0; i < widgetArray.length; ++i) {
            this.widgets[i] = new WidgetHandle(widgetArray[i]);
        }
    }

    public Object getComponent() {
        return this.component;
    }

    public void setEnabled(boolean bl) {
        for (int i = 0; i < this.widgets.length; ++i) {
            this.widgets[i].widget.setEnabled(bl);
        }
    }

    public void updateValue(Object object) {
        this.updateValue(object, null);
    }

    void updateValue(Object object, WidgetHandle widgetHandle) {
        for (int i = 0; i < this.widgets.length; ++i) {
            if (this.widgets[i] == widgetHandle) continue;
            this.widgets[i].widget.updateValue(object);
        }
    }

    public void dispose() {
        for (int i = 0; i < this.widgets.length; ++i) {
            this.widgets[i].dispose();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        for (int i = 0; i < this.widgets.length; ++i) {
            this.widgets[i].widget.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        for (int i = 0; i < this.widgets.length; ++i) {
            this.widgets[i].widget.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        for (int i = 0; i < this.widgets.length; ++i) {
            this.widgets[i].widget.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        for (int i = 0; i < this.widgets.length; ++i) {
            this.widgets[i].widget.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    private class WidgetHandle
    implements PropertyChangeListener {
        final Widget widget;

        WidgetHandle(Widget widget) {
            this.widget = widget;
            widget.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            WidgetList.this.updateValue(propertyChangeEvent.getNewValue(), this);
        }

        void dispose() {
            this.widget.removePropertyChangeListener(this);
            this.widget.dispose();
        }
    }
}

