/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.io;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;

public class SerialUtilities {
    private SerialUtilities() {
    }

    public static boolean isSerializable(Class clazz) {
        return Serializable.class.isAssignableFrom(clazz);
    }

    public static Paint readPaint(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        Paint paint = null;
        boolean bl = objectInputStream.readBoolean();
        if (!bl) {
            Class clazz = (Class)objectInputStream.readObject();
            if (SerialUtilities.isSerializable(clazz)) {
                paint = (Paint)objectInputStream.readObject();
            } else if (clazz.equals(GradientPaint.class)) {
                float f = objectInputStream.readFloat();
                float f2 = objectInputStream.readFloat();
                Color color = (Color)objectInputStream.readObject();
                float f3 = objectInputStream.readFloat();
                float f4 = objectInputStream.readFloat();
                Color color2 = (Color)objectInputStream.readObject();
                boolean bl2 = objectInputStream.readBoolean();
                paint = new GradientPaint(f, f2, color, f3, f4, color2, bl2);
            }
        }
        return paint;
    }

    public static void writePaint(Paint paint, ObjectOutputStream objectOutputStream) throws IOException {
        if (objectOutputStream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        if (paint != null) {
            objectOutputStream.writeBoolean(false);
            objectOutputStream.writeObject(paint.getClass());
            if (paint instanceof Serializable) {
                objectOutputStream.writeObject(paint);
            } else if (paint instanceof GradientPaint) {
                GradientPaint gradientPaint = (GradientPaint)paint;
                objectOutputStream.writeFloat((float)gradientPaint.getPoint1().getX());
                objectOutputStream.writeFloat((float)gradientPaint.getPoint1().getY());
                objectOutputStream.writeObject(gradientPaint.getColor1());
                objectOutputStream.writeFloat((float)gradientPaint.getPoint2().getX());
                objectOutputStream.writeFloat((float)gradientPaint.getPoint2().getY());
                objectOutputStream.writeObject(gradientPaint.getColor2());
                objectOutputStream.writeBoolean(gradientPaint.isCyclic());
            }
        } else {
            objectOutputStream.writeBoolean(true);
        }
    }

    public static Stroke readStroke(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        Stroke stroke = null;
        boolean bl = objectInputStream.readBoolean();
        if (!bl) {
            Class clazz = (Class)objectInputStream.readObject();
            if (clazz.equals(BasicStroke.class)) {
                float f = objectInputStream.readFloat();
                int n = objectInputStream.readInt();
                int n2 = objectInputStream.readInt();
                float f2 = objectInputStream.readFloat();
                float[] fArray = (float[])objectInputStream.readObject();
                float f3 = objectInputStream.readFloat();
                stroke = new BasicStroke(f, n, n2, f2, fArray, f3);
            } else {
                stroke = (Stroke)objectInputStream.readObject();
            }
        }
        return stroke;
    }

    public static void writeStroke(Stroke stroke, ObjectOutputStream objectOutputStream) throws IOException {
        if (objectOutputStream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        if (stroke != null) {
            objectOutputStream.writeBoolean(false);
            if (stroke instanceof BasicStroke) {
                BasicStroke basicStroke = (BasicStroke)stroke;
                objectOutputStream.writeObject(BasicStroke.class);
                objectOutputStream.writeFloat(basicStroke.getLineWidth());
                objectOutputStream.writeInt(basicStroke.getEndCap());
                objectOutputStream.writeInt(basicStroke.getLineJoin());
                objectOutputStream.writeFloat(basicStroke.getMiterLimit());
                objectOutputStream.writeObject(basicStroke.getDashArray());
                objectOutputStream.writeFloat(basicStroke.getDashPhase());
            } else {
                objectOutputStream.writeObject(stroke.getClass());
                objectOutputStream.writeObject(stroke);
            }
        } else {
            objectOutputStream.writeBoolean(true);
        }
    }

    public static Shape readShape(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        Shape shape = null;
        boolean bl = objectInputStream.readBoolean();
        if (!bl) {
            Class clazz = (Class)objectInputStream.readObject();
            if (clazz.equals(Line2D.class)) {
                double d = objectInputStream.readDouble();
                double d2 = objectInputStream.readDouble();
                double d3 = objectInputStream.readDouble();
                double d4 = objectInputStream.readDouble();
                shape = new Line2D.Double(d, d2, d3, d4);
            } else if (clazz.equals(Rectangle2D.class)) {
                double d = objectInputStream.readDouble();
                double d5 = objectInputStream.readDouble();
                double d6 = objectInputStream.readDouble();
                double d7 = objectInputStream.readDouble();
                shape = new Rectangle2D.Double(d, d5, d6, d7);
            } else if (clazz.equals(Ellipse2D.class)) {
                double d = objectInputStream.readDouble();
                double d8 = objectInputStream.readDouble();
                double d9 = objectInputStream.readDouble();
                double d10 = objectInputStream.readDouble();
                shape = new Ellipse2D.Double(d, d8, d9, d10);
            } else if (clazz.equals(Arc2D.class)) {
                double d = objectInputStream.readDouble();
                double d11 = objectInputStream.readDouble();
                double d12 = objectInputStream.readDouble();
                double d13 = objectInputStream.readDouble();
                double d14 = objectInputStream.readDouble();
                double d15 = objectInputStream.readDouble();
                int n = objectInputStream.readInt();
                shape = new Arc2D.Double(d, d11, d12, d13, d14, d15, n);
            } else if (clazz.equals(GeneralPath.class)) {
                GeneralPath generalPath = new GeneralPath();
                float[] fArray = new float[6];
                boolean bl2 = objectInputStream.readBoolean();
                while (!bl2) {
                    int n = objectInputStream.readInt();
                    for (int i = 0; i < 6; ++i) {
                        fArray[i] = objectInputStream.readFloat();
                    }
                    switch (n) {
                        case 0: {
                            generalPath.moveTo(fArray[0], fArray[1]);
                            break;
                        }
                        case 1: {
                            generalPath.lineTo(fArray[0], fArray[1]);
                            break;
                        }
                        case 3: {
                            generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                            break;
                        }
                        case 2: {
                            generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            throw new RuntimeException("JFreeChart - No path exists");
                        }
                    }
                    generalPath.setWindingRule(objectInputStream.readInt());
                    bl2 = objectInputStream.readBoolean();
                }
                shape = generalPath;
            } else {
                shape = (Shape)objectInputStream.readObject();
            }
        }
        return shape;
    }

    public static void writeShape(Shape shape, ObjectOutputStream objectOutputStream) throws IOException {
        if (objectOutputStream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        if (shape != null) {
            objectOutputStream.writeBoolean(false);
            if (shape instanceof Line2D) {
                Line2D line2D = (Line2D)shape;
                objectOutputStream.writeObject(Line2D.class);
                objectOutputStream.writeDouble(line2D.getX1());
                objectOutputStream.writeDouble(line2D.getY1());
                objectOutputStream.writeDouble(line2D.getX2());
                objectOutputStream.writeDouble(line2D.getY2());
            } else if (shape instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)shape;
                objectOutputStream.writeObject(Rectangle2D.class);
                objectOutputStream.writeDouble(rectangle2D.getX());
                objectOutputStream.writeDouble(rectangle2D.getY());
                objectOutputStream.writeDouble(rectangle2D.getWidth());
                objectOutputStream.writeDouble(rectangle2D.getHeight());
            } else if (shape instanceof Ellipse2D) {
                Ellipse2D ellipse2D = (Ellipse2D)shape;
                objectOutputStream.writeObject(Ellipse2D.class);
                objectOutputStream.writeDouble(ellipse2D.getX());
                objectOutputStream.writeDouble(ellipse2D.getY());
                objectOutputStream.writeDouble(ellipse2D.getWidth());
                objectOutputStream.writeDouble(ellipse2D.getHeight());
            } else if (shape instanceof Arc2D) {
                Arc2D arc2D = (Arc2D)shape;
                objectOutputStream.writeObject(Arc2D.class);
                objectOutputStream.writeDouble(arc2D.getX());
                objectOutputStream.writeDouble(arc2D.getY());
                objectOutputStream.writeDouble(arc2D.getWidth());
                objectOutputStream.writeDouble(arc2D.getHeight());
                objectOutputStream.writeDouble(arc2D.getAngleStart());
                objectOutputStream.writeDouble(arc2D.getAngleExtent());
                objectOutputStream.writeInt(arc2D.getArcType());
            } else if (shape instanceof GeneralPath) {
                objectOutputStream.writeObject(GeneralPath.class);
                PathIterator pathIterator = shape.getPathIterator(null);
                float[] fArray = new float[6];
                objectOutputStream.writeBoolean(pathIterator.isDone());
                while (!pathIterator.isDone()) {
                    int n = pathIterator.currentSegment(fArray);
                    objectOutputStream.writeInt(n);
                    for (int i = 0; i < 6; ++i) {
                        objectOutputStream.writeFloat(fArray[i]);
                    }
                    objectOutputStream.writeInt(pathIterator.getWindingRule());
                    pathIterator.next();
                    objectOutputStream.writeBoolean(pathIterator.isDone());
                }
            } else {
                objectOutputStream.writeObject(shape.getClass());
                objectOutputStream.writeObject(shape);
            }
        } else {
            objectOutputStream.writeBoolean(true);
        }
    }

    public static Point2D readPoint2D(ObjectInputStream objectInputStream) throws IOException {
        if (objectInputStream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        Point2D.Double double_ = null;
        boolean bl = objectInputStream.readBoolean();
        if (!bl) {
            double d = objectInputStream.readDouble();
            double d2 = objectInputStream.readDouble();
            double_ = new Point2D.Double(d, d2);
        }
        return double_;
    }

    public static void writePoint2D(Point2D point2D, ObjectOutputStream objectOutputStream) throws IOException {
        if (objectOutputStream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        if (point2D != null) {
            objectOutputStream.writeBoolean(false);
            objectOutputStream.writeDouble(point2D.getX());
            objectOutputStream.writeDouble(point2D.getY());
        } else {
            objectOutputStream.writeBoolean(true);
        }
    }

    public static AttributedString readAttributedString(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        AttributedString attributedString = null;
        boolean bl = objectInputStream.readBoolean();
        if (!bl) {
            String string = (String)objectInputStream.readObject();
            attributedString = new AttributedString(string);
            char c = objectInputStream.readChar();
            int n = 0;
            while (c != '\uffff') {
                int n2 = objectInputStream.readInt();
                Map map = (Map)objectInputStream.readObject();
                attributedString.addAttributes(map, n, n2);
                n = n2;
                c = objectInputStream.readChar();
            }
        }
        return attributedString;
    }

    public static void writeAttributedString(AttributedString attributedString, ObjectOutputStream objectOutputStream) throws IOException {
        if (objectOutputStream == null) {
            throw new IllegalArgumentException("Null 'stream' argument.");
        }
        if (attributedString != null) {
            objectOutputStream.writeBoolean(false);
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            StringBuffer stringBuffer = new StringBuffer();
            char c = attributedCharacterIterator.first();
            while (c != '\uffff') {
                stringBuffer = stringBuffer.append(c);
                c = attributedCharacterIterator.next();
            }
            objectOutputStream.writeObject(stringBuffer.toString());
            c = attributedCharacterIterator.first();
            int n = attributedCharacterIterator.getBeginIndex();
            while (c != '\uffff') {
                objectOutputStream.writeChar(c);
                int n2 = attributedCharacterIterator.getRunLimit();
                objectOutputStream.writeInt(n2 - n);
                HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>(attributedCharacterIterator.getAttributes());
                objectOutputStream.writeObject(hashMap);
                c = attributedCharacterIterator.setIndex(n2);
            }
            objectOutputStream.writeChar(65535);
        } else {
            objectOutputStream.writeBoolean(true);
        }
    }
}

