/*
 * Decompiled with CFR 0.152.
 */
package pi6.geom;

import java.util.Vector;
import pi6.geom.DList;
import pi6.geom.Point2;
import pi6.geom.Triangle2;

public final class Delaunay2 {
    private int nPoints = 0;
    private final DList SiteList = new DList();
    private Triangle2 startTriangle;
    private Triangle2 startTriangleHull;
    private boolean allCollinear = true;
    private Triangle2 firstT;
    private Triangle2 lastT;
    private Point2 firstP;
    private Point2 lastP;

    public final void insertSite(Point2 p) {
        ++this.nPoints;
        this.SiteList.append(p);
        Triangle2 t = this.insertSiteSimple(p);
        if (t == null) {
            return;
        }
        Triangle2 tt = t;
        do {
            this.flip(tt);
        } while ((tt = tt.canext) != t && !tt.halfplane);
    }

    private Triangle2 insertSiteSimple(Point2 p) {
        if (!this.allCollinear) {
            Triangle2 t = this.startTriangle.find(p);
            this.startTriangle = t.halfplane ? this.extendOutside(t, p) : this.extendInside(t, p);
            return this.startTriangle;
        }
        if (this.nPoints == 1) {
            this.firstP = p;
            return null;
        }
        if (this.nPoints == 2) {
            this.startTriangulation(this.firstP, p);
            return null;
        }
        switch (p.pointLineTest(this.firstP, this.lastP)) {
            case 1: {
                this.startTriangle = this.extendOutside(this.firstT.abnext, p);
                this.allCollinear = false;
                break;
            }
            case 2: {
                this.startTriangle = this.extendOutside(this.firstT, p);
                this.allCollinear = false;
                break;
            }
            case 0: {
                this.insertCollinear(p, 0);
                break;
            }
            case 3: {
                this.insertCollinear(p, 3);
                break;
            }
            case 4: {
                this.insertCollinear(p, 4);
            }
        }
        return null;
    }

    private void insertCollinear(Point2 p, int res) {
        switch (res) {
            default: {
                break;
            }
            case 3: {
                Triangle2 tp;
                Triangle2 t = new Triangle2(this.firstP, p);
                t.abnext = tp = new Triangle2(p, this.firstP);
                tp.abnext = t;
                t.bcnext = tp;
                tp.canext = t;
                t.canext = this.firstT;
                this.firstT.bcnext = t;
                tp.bcnext = this.firstT.abnext;
                this.firstT.abnext.canext = tp;
                this.firstT = t;
                this.firstP = p;
                break;
            }
            case 4: {
                Triangle2 tp;
                Triangle2 t = new Triangle2(p, this.lastP);
                t.abnext = tp = new Triangle2(this.lastP, p);
                tp.abnext = t;
                t.bcnext = this.lastT;
                this.lastT.canext = t;
                t.canext = tp;
                tp.bcnext = t;
                tp.canext = this.lastT.abnext;
                this.lastT.abnext.bcnext = tp;
                this.lastT = t;
                this.lastP = p;
                break;
            }
            case 0: {
                Triangle2 u = this.firstT;
                while (p.isGreater(u.a)) {
                    u = u.canext;
                }
                Triangle2 t = new Triangle2(p, u.b);
                Triangle2 tp = new Triangle2(u.b, p);
                u.b = p;
                u.abnext.a = p;
                t.abnext = tp;
                tp.abnext = t;
                t.bcnext = u.bcnext;
                u.bcnext.canext = t;
                t.canext = u;
                u.bcnext = t;
                tp.canext = u.abnext.canext;
                u.abnext.canext.bcnext = tp;
                tp.bcnext = u.abnext;
                u.abnext.canext = tp;
                if (this.firstT != u) break;
                this.firstT = t;
            }
        }
    }

    private void startTriangulation(Point2 p1, Point2 p2) {
        Triangle2 t;
        Point2 pb;
        Point2 ps;
        if (p1.isLess(p2)) {
            ps = p1;
            pb = p2;
        } else {
            ps = p2;
            pb = p1;
        }
        this.lastT = this.firstT = new Triangle2(pb, ps);
        this.firstT.abnext = t = new Triangle2(ps, pb);
        t.abnext = this.firstT;
        this.firstT.bcnext = t;
        t.canext = this.firstT;
        this.firstT.canext = t;
        t.bcnext = this.firstT;
        this.firstP = this.firstT.b;
        this.lastP = this.lastT.a;
        this.startTriangleHull = this.firstT;
    }

    public final Triangle2 extendInside(Triangle2 t, Point2 p) {
        Triangle2 h1 = this.treatDegeneracyInside(t, p);
        if (h1 != null) {
            return h1;
        }
        h1 = new Triangle2(t.c, t.a, p);
        Triangle2 h2 = new Triangle2(t.b, t.c, p);
        t.c = p;
        t.circumcircle();
        h1.abnext = t.canext;
        h1.bcnext = t;
        h1.canext = h2;
        h2.abnext = t.bcnext;
        h2.bcnext = h1;
        h2.canext = t;
        h1.abnext.switchNeighbors(t, h1);
        h2.abnext.switchNeighbors(t, h2);
        t.bcnext = h2;
        t.canext = h1;
        return t;
    }

    public final Triangle2 treatDegeneracyInside(Triangle2 t, Point2 p) {
        if (t.abnext.halfplane && p.pointLineTest(t.b, t.a) == 0) {
            return this.extendOutside(t.abnext, p);
        }
        if (t.bcnext.halfplane && p.pointLineTest(t.c, t.b) == 0) {
            return this.extendOutside(t.bcnext, p);
        }
        if (t.canext.halfplane && p.pointLineTest(t.a, t.c) == 0) {
            return this.extendOutside(t.canext, p);
        }
        return null;
    }

    private Triangle2 extendOutside(Triangle2 t, Point2 p) {
        Triangle2 cT;
        if (p.pointLineTest(t.a, t.b) == 0) {
            Triangle2 dg = new Triangle2(t.a, t.b, p);
            Triangle2 hp = new Triangle2(p, t.b);
            t.b = p;
            dg.abnext = t.abnext;
            dg.abnext.switchNeighbors(t, dg);
            dg.bcnext = hp;
            hp.abnext = dg;
            dg.canext = t;
            t.abnext = dg;
            hp.bcnext = t.bcnext;
            hp.bcnext.canext = hp;
            hp.canext = t;
            t.bcnext = hp;
            return dg;
        }
        Triangle2 ccT = this.extendcounterclock(t, p);
        ccT.bcnext = cT = this.extendclock(t, p);
        cT.canext = ccT;
        this.startTriangleHull = cT;
        return cT.abnext;
    }

    private Triangle2 extendcounterclock(Triangle2 t, Point2 p) {
        t.halfplane = false;
        t.c = p;
        t.circumcircle();
        Triangle2 tca = t.canext;
        if (p.pointLineTest(tca.a, tca.b) >= 2) {
            Triangle2 nT = new Triangle2(t.a, p);
            nT.abnext = t;
            t.canext = nT;
            nT.canext = tca;
            tca.bcnext = nT;
            return nT;
        }
        return this.extendcounterclock(tca, p);
    }

    private Triangle2 extendclock(Triangle2 t, Point2 p) {
        t.halfplane = false;
        t.c = p;
        t.circumcircle();
        Triangle2 tbc = t.bcnext;
        if (p.pointLineTest(tbc.a, tbc.b) >= 2) {
            Triangle2 nT = new Triangle2(p, t.b);
            nT.abnext = t;
            t.bcnext = nT;
            nT.bcnext = tbc;
            tbc.canext = nT;
            return nT;
        }
        return this.extendclock(tbc, p);
    }

    /*
     * WARNING - void declaration
     */
    public final void flip(Triangle2 t) {
        void var3_3;
        Triangle2 v;
        Triangle2 u = t.abnext;
        if (u.halfplane || !u.circumcircle_contains(t.c)) {
            return;
        }
        if (t.a == u.a) {
            v = new Triangle2(u.b, t.b, t.c);
            v.abnext = u.bcnext;
            t.abnext = u.abnext;
        } else if (t.a == u.b) {
            v = new Triangle2(u.c, t.b, t.c);
            v.abnext = u.canext;
            t.abnext = u.bcnext;
        } else if (t.a == u.c) {
            v = new Triangle2(u.a, t.b, t.c);
            v.abnext = u.abnext;
            t.abnext = u.canext;
        } else {
            System.out.println("Error in flip.");
            return;
        }
        var3_3.bcnext = t.bcnext;
        var3_3.abnext.switchNeighbors(u, (Triangle2)var3_3);
        var3_3.bcnext.switchNeighbors(t, (Triangle2)var3_3);
        t.bcnext = var3_3;
        var3_3.canext = t;
        t.b = var3_3.a;
        t.abnext.switchNeighbors(u, t);
        t.circumcircle();
        this.flip(t);
        this.flip((Triangle2)var3_3);
    }

    public final Vector getVoronoiRegions() {
        if (this.nPoints == 1) {
            return null;
        }
        return this.startTriangleHull.reportRegions();
    }
}

