/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.docking;

import de.grogra.docking.DockContainer;
import de.grogra.docking.DockManager;
import de.grogra.docking.Dockable;
import de.grogra.docking.DockableComponent;
import de.grogra.docking.DockableWrapper;
import de.grogra.docking.DragDockableContext;
import de.grogra.docking.DragSourceComponent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import javax.swing.Icon;
import javax.swing.JPanel;

public class DockablePanel
extends JPanel
implements Dockable,
DragSourceComponent {
    private String panelTitle;
    private String tabTitle;
    private Icon icon;
    private DockManager manager = null;
    private boolean closable;
    private Object[] listeners;

    public DockablePanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public void setManager(DockManager dockManager) {
        if (dockManager != this.manager) {
            this.manager = dockManager;
            DockManager.uninstallListeners(this.listeners);
            if (dockManager != null) {
                this.listeners = dockManager.installListeners((Component)this, (DragGestureListener)dockManager, this);
            }
        }
    }

    public DockContainer getDockParent() {
        return DockManager.getDockParent(this);
    }

    public Dockable getDockable() {
        return this;
    }

    public DockableComponent getComponent() {
        return this;
    }

    public void setWrapper(DockableWrapper dockableWrapper) {
        throw new UnsupportedOperationException();
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.firePropertyChange("icon", this.icon, this.icon);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setTabTitle(String string) {
        this.tabTitle = string;
        this.firePropertyChange("tabTitle", this.tabTitle, this.tabTitle);
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    public void setPanelTitle(String string) {
        this.panelTitle = string;
        this.firePropertyChange("panelTitle", this.panelTitle, this.panelTitle);
    }

    public String getPanelTitle() {
        return this.panelTitle;
    }

    public void setTitles(String string) {
        this.setPanelTitle(string);
        this.setTabTitle(string);
    }

    public void setClosable(boolean bl) {
        this.closable = bl;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void dockableClosed() {
        this.setManager(null);
    }

    public DragDockableContext createContext(DragGestureEvent dragGestureEvent) {
        return new DragDockableContext(this.manager, this);
    }

    public boolean needsWrapper() {
        return false;
    }

    public boolean isSelectable() {
        return true;
    }

    public void setSelected(boolean bl) {
    }

    public void checkClose(Runnable runnable) {
        runnable.run();
    }
}

