/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.pf.ui.Console;
import de.grogra.pf.ui.NameCompletion;
import de.grogra.pf.ui.swing.PanelSupport;
import de.grogra.pf.ui.swing.SwingPanel;
import de.grogra.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class JConsole
extends PanelSupport
implements Console,
KeyListener,
MouseListener,
ActionListener,
PropertyChangeListener {
    private static final String CUT = "Cut";
    private static final String COPY = "Copy";
    private static final String PASTE = "Paste";
    private static final String CLEAR = "Clear";
    private final CWriter out;
    private final CWriter err;
    private final Reader in;
    private PipedWriter inWriter;
    private int cmdStart = 0;
    private Vector history = new Vector();
    private String startedLine;
    private int histLine = 0;
    private JPopupMenu menu;
    private JTextPane text;
    private int maxBufferLength = 10000;
    private final Object lock = new Object();
    NameCompletion nameCompletion;
    final int SHOW_AMBIG_MAX = 10;
    private boolean gotUp = true;
    private Color curColor;
    private AttributeSet curAtts;

    public JConsole() {
        super(new SwingPanel(null));
        JScrollPane jScrollPane = new JScrollPane();
        this.text = new JTextPane(new DefaultStyledDocument()){

            public void cut() {
                if (JConsole.this.text.getCaretPosition() < JConsole.this.cmdStart) {
                    super.copy();
                } else {
                    super.cut();
                }
            }

            public void paste() {
                JConsole.this.forceCaretMoveToEnd();
                super.paste();
            }
        };
        Font font = new Font("Monospaced", 0, 12);
        this.text.setText("");
        this.text.setFont(font);
        this.text.setMargin(new Insets(7, 5, 7, 5));
        this.text.addKeyListener(this);
        jScrollPane.setViewportView(this.text);
        this.menu = new JPopupMenu("JConsole\tMenu");
        this.menu.add(new JMenuItem(CLEAR)).addActionListener(this);
        this.menu.add(new JMenuItem(CUT)).addActionListener(this);
        this.menu.add(new JMenuItem(COPY)).addActionListener(this);
        this.menu.add(new JMenuItem(PASTE)).addActionListener(this);
        this.text.addMouseListener(this);
        UIManager.addPropertyChangeListener(this);
        this.out = new CWriter(Color.BLACK);
        this.err = new CWriter(Color.RED);
        try {
            this.inWriter = new PipedWriter();
            this.in = new PipedReader(this.inWriter);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        ((SwingPanel)this.getComponent()).getContentPane().add(jScrollPane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeImpl() {
        super.disposeImpl();
        Object object = this.lock;
        synchronized (object) {
            try {
                this.inWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.inWriter = null;
        }
    }

    public Reader getIn() {
        return this.in;
    }

    public Console.ConsoleWriter getOut() {
        return this.out;
    }

    public Console.ConsoleWriter getErr() {
        return this.err;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.type(keyEvent);
        this.gotUp = false;
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.type(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.gotUp = true;
        this.type(keyEvent);
    }

    private synchronized void type(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if (keyEvent.getID() == 401 && this.gotUp) {
                    this.enter();
                }
                keyEvent.consume();
                this.text.repaint();
                break;
            }
            case 38: {
                if (keyEvent.getID() == 401) {
                    this.historyUp();
                }
                keyEvent.consume();
                break;
            }
            case 40: {
                if (keyEvent.getID() == 401) {
                    this.historyDown();
                }
                keyEvent.consume();
                break;
            }
            case 8: 
            case 37: {
                if (this.text.getCaretPosition() > this.cmdStart) break;
                keyEvent.consume();
                break;
            }
            case 127: {
                if (this.text.getCaretPosition() >= this.cmdStart) break;
                keyEvent.consume();
                break;
            }
            case 39: {
                this.forceCaretMoveToStart();
                break;
            }
            case 36: {
                this.text.setCaretPosition(this.cmdStart);
                keyEvent.consume();
                break;
            }
            case 85: {
                if ((keyEvent.getModifiers() & 2) <= 0) break;
                this.replaceRange("", this.cmdStart, this.textLength());
                this.histLine = 0;
                keyEvent.consume();
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 145: 
            case 154: 
            case 155: 
            case 157: {
                break;
            }
            case 67: {
                if (this.text.getSelectedText() != null) break;
                if ((keyEvent.getModifiers() & 2) > 0 && keyEvent.getID() == 401) {
                    this.append("^C");
                }
                keyEvent.consume();
                break;
            }
            case 9: {
                if (keyEvent.getID() == 402) {
                    String string = this.text.getText().substring(this.cmdStart);
                    this.doCommandCompletion(string);
                }
                keyEvent.consume();
                break;
            }
            default: {
                if ((keyEvent.getModifiers() & 0xE) == 0) {
                    this.forceCaretMoveToEnd();
                }
                if (keyEvent.paramString().indexOf("Backspace") == -1 && keyEvent.paramString().indexOf("R\u00fccktaste") == -1 || this.text.getCaretPosition() > this.cmdStart) break;
                keyEvent.consume();
            }
        }
    }

    void doCommandCompletion(String string) {
        int n;
        if (this.nameCompletion == null) {
            return;
        }
        for (n = string.length() - 1; n >= 0 && (Character.isJavaIdentifierPart(string.charAt(n)) || string.charAt(n) == '.'); --n) {
        }
        if ((string = string.substring(n + 1)).length() < 2) {
            return;
        }
        String[] stringArray = this.nameCompletion.completeName(string);
        if (stringArray.length == 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (stringArray.length == 1 && !stringArray.equals(string)) {
            String string2 = stringArray[0].substring(string.length());
            this.append(string2);
            return;
        }
        String string3 = this.text.getText();
        String string4 = string3.substring(this.cmdStart);
        for (n = this.cmdStart; string3.charAt(n) != '\n' && n > 0; --n) {
        }
        String string5 = string3.substring(n + 1, this.cmdStart);
        StringBuffer stringBuffer = new StringBuffer("\n");
        for (n = 0; n < stringArray.length && n < 10; ++n) {
            stringBuffer.append(stringArray[n] + "\n");
        }
        if (n == 10) {
            stringBuffer.append("...\n");
        }
        this.print(stringBuffer, Color.gray);
        this.print(string5);
        this.append(string4);
    }

    private void resetCommandStart() {
        this.cmdStart = this.textLength();
    }

    private void append(String string) {
        int n = this.textLength();
        this.text.select(n, n);
        this.text.replaceSelection(string);
    }

    void checkLimit() {
        int n = this.textLength();
        int n2 = n - this.maxBufferLength;
        if (n2 > 3) {
            this.replaceRange("...", 0, n2 + this.maxBufferLength / 10);
            n2 = this.textLength();
            this.text.select(n2, n2);
            this.cmdStart = Math.max(0, this.cmdStart + n2 - n);
        }
    }

    private String replaceRange(Object object, int n, int n2) {
        String string = object.toString();
        this.text.select(n, n2);
        this.text.replaceSelection(string);
        return string;
    }

    private void forceCaretMoveToEnd() {
        if (this.text.getCaretPosition() < this.cmdStart) {
            this.text.setCaretPosition(this.textLength());
        }
        this.text.repaint();
    }

    private void forceCaretMoveToStart() {
        if (this.text.getCaretPosition() < this.cmdStart) {
            // empty if block
        }
        this.text.repaint();
    }

    public void enter(final String string) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                String string2 = string.endsWith("\n") ? string : string + "\n";
                JConsole.this.append(string2);
                JConsole.this.enter0(string2);
            }
        });
    }

    public void clear() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JConsole.this.text.setText("");
                JConsole.this.resetCommandStart();
            }
        });
    }

    private void enter() {
        String string = this.getCmd();
        if (string.trim().length() > 0) {
            this.history.addElement(string);
        }
        string = string + "\n";
        this.append("\n");
        this.enter0(string);
    }

    private void enter0(String string) {
        this.histLine = 0;
        this.acceptLine(string);
        this.resetCommandStart();
        this.text.setCaretPosition(this.cmdStart);
        this.text.repaint();
    }

    private String getCmd() {
        String string = "";
        try {
            string = this.text.getText(this.cmdStart, this.textLength() - this.cmdStart);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return string;
    }

    private void historyUp() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.histLine == 0) {
            this.startedLine = this.getCmd();
        }
        if (this.histLine < this.history.size()) {
            ++this.histLine;
            this.showHistoryLine();
        }
    }

    private void historyDown() {
        if (this.histLine == 0) {
            return;
        }
        --this.histLine;
        this.showHistoryLine();
    }

    private void showHistoryLine() {
        String string = this.histLine == 0 ? this.startedLine : (String)this.history.elementAt(this.history.size() - this.histLine);
        this.replaceRange(string, this.cmdStart, this.textLength());
        this.text.setCaretPosition(this.textLength());
        this.text.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptLine(String string) {
        Object object = this.lock;
        synchronized (object) {
            if (this.inWriter != null) {
                try {
                    this.inWriter.write(string);
                    this.inWriter.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private void print(CharSequence charSequence) {
        this.append(charSequence == null ? "null" : ((Object)charSequence).toString());
        this.resetCommandStart();
        this.text.setCaretPosition(this.cmdStart);
    }

    void print(CharSequence charSequence, Color color) {
        AttributeSet attributeSet = this.getStyle();
        if (color != this.curColor) {
            this.curColor = color;
            this.curAtts = this.setStyle(color);
        } else {
            this.setStyle(this.curAtts);
        }
        this.print(charSequence);
        this.setStyle(attributeSet);
    }

    public synchronized void print(Icon icon) {
        if (icon == null) {
            return;
        }
        this.text.insertIcon(icon);
        this.resetCommandStart();
        this.text.setCaretPosition(this.cmdStart);
    }

    public AttributeSet setStyle(Font font) {
        return this.setStyle(font, null);
    }

    public AttributeSet setStyle(Color color) {
        return this.setStyle(null, color);
    }

    public AttributeSet setStyle(Font font, Color color) {
        if (font != null) {
            return this.setStyle(font.getFamily(), font.getSize(), color, font.isBold(), font.isItalic(), StyleConstants.isUnderline(this.getStyle()));
        }
        return this.setStyle(null, -1, color);
    }

    public synchronized AttributeSet setStyle(String string, int n, Color color) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        if (color != null) {
            StyleConstants.setForeground(simpleAttributeSet, color);
        }
        if (string != null) {
            StyleConstants.setFontFamily(simpleAttributeSet, string);
        }
        if (n != -1) {
            StyleConstants.setFontSize(simpleAttributeSet, n);
        }
        this.setStyle(simpleAttributeSet);
        return simpleAttributeSet;
    }

    public synchronized AttributeSet setStyle(String string, int n, Color color, boolean bl, boolean bl2, boolean bl3) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        if (color != null) {
            StyleConstants.setForeground(simpleAttributeSet, color);
        }
        if (string != null) {
            StyleConstants.setFontFamily(simpleAttributeSet, string);
        }
        if (n != -1) {
            StyleConstants.setFontSize(simpleAttributeSet, n);
        }
        StyleConstants.setBold(simpleAttributeSet, bl);
        StyleConstants.setItalic(simpleAttributeSet, bl2);
        StyleConstants.setUnderline(simpleAttributeSet, bl3);
        this.setStyle(simpleAttributeSet);
        return simpleAttributeSet;
    }

    public void setStyle(AttributeSet attributeSet) {
        this.setStyle(attributeSet, false);
    }

    public void setStyle(AttributeSet attributeSet, boolean bl) {
        this.text.setCharacterAttributes(attributeSet, bl);
    }

    public AttributeSet getStyle() {
        return this.text.getCharacterAttributes();
    }

    public void setFont(Font font) {
        this.text.setFont(font);
    }

    public String toString() {
        return "BeanShell console";
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.menu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.menu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
        this.text.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this.menu);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CUT)) {
            this.text.cut();
        } else if (string.equals(COPY)) {
            this.text.copy();
        } else if (string.equals(PASTE)) {
            this.text.paste();
        } else if (string.equals(CLEAR)) {
            this.text.setText("");
            this.resetCommandStart();
        }
    }

    public void setNameCompletion(NameCompletion nameCompletion) {
        this.nameCompletion = nameCompletion;
    }

    private int textLength() {
        return this.text.getDocument().getLength();
    }

    private class CWriter
    extends Console.ConsoleWriter {
        private final Color defColor;

        CWriter(Color color) {
            super((Writer)new ColorWriter(color), true);
            this.defColor = color;
        }

        public void print(Object object, int n) {
            this.flush();
            ((ColorWriter)this.out).color = Utils.getApproximateColor((int)n);
            this.print(object);
            this.flush();
            ((ColorWriter)this.out).color = this.defColor;
        }

        public void println(Object object, int n) {
            this.flush();
            ((ColorWriter)this.out).color = Utils.getApproximateColor((int)n);
            this.println(object);
            ((ColorWriter)this.out).color = this.defColor;
        }
    }

    private class ColorWriter
    extends Writer {
        Color color;
        private StringBuffer buffer = new StringBuffer();

        ColorWriter(Color color) {
            this.color = color;
        }

        public synchronized void write(char[] cArray, int n, int n2) {
            this.buffer.append(cArray, n, n2);
        }

        public synchronized void flush() {
            final String string = this.buffer.toString();
            final Color color = this.color;
            this.buffer.setLength(0);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JConsole.this.print(string, color);
                    JConsole.this.checkLimit();
                }
            });
        }

        public void close() {
        }
    }
}

