/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.pf.ui.swing.SwingToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class SimpleColorChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener {
    private JSlider red;
    private JSlider green;
    private JSlider blue;
    private JLabel redLabel;
    private JLabel greenLabel;
    private JLabel blueLabel;
    private boolean updating;

    SimpleColorChooserPanel() {
    }

    public String getDisplayName() {
        return SwingToolkit.I18N.getString("simplecolorchooser.Name");
    }

    public int getMnemonic() {
        return -1;
    }

    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    protected void buildChooser() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints3.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints3.gridy = 0;
        this.add((Component)new JLabel("R"), gridBagConstraints);
        this.red = new JSlider(0, 255);
        this.add((Component)this.red, gridBagConstraints2);
        this.redLabel = new JLabel();
        this.add((Component)this.redLabel, gridBagConstraints3);
        gridBagConstraints.gridy = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints3.gridy = 1;
        this.add((Component)new JLabel("G"), gridBagConstraints);
        this.green = new JSlider(0, 255);
        this.add((Component)this.green, gridBagConstraints2);
        this.greenLabel = new JLabel();
        this.add((Component)this.greenLabel, gridBagConstraints3);
        gridBagConstraints.gridy = 2;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints3.gridy = 2;
        this.add((Component)new JLabel("B"), gridBagConstraints);
        this.blue = new JSlider(0, 255);
        this.add((Component)this.blue, gridBagConstraints2);
        this.blueLabel = new JLabel();
        this.add((Component)this.blueLabel, gridBagConstraints3);
        this.red.addChangeListener(this);
        this.green.addChangeListener(this);
        this.blue.addChangeListener(this);
    }

    private static void setText(JLabel jLabel, int n) {
        String string = (n = n * 1000 / 255) == 0 ? "0%" : (n < 10 ? "0." + n + "%" : (n % 10 == 0 ? n / 10 + "%" : n / 10 + "." + n % 10 + "%"));
        jLabel.setText(string);
    }

    public void updateChooser() {
        if (!this.updating) {
            this.updating = true;
            Color color = this.getColorFromModel();
            int n = color.getRed();
            if (this.red.getValue() != n) {
                this.red.setValue(n);
            }
            SimpleColorChooserPanel.setText(this.redLabel, n);
            n = color.getGreen();
            if (this.green.getValue() != n) {
                this.green.setValue(n);
            }
            SimpleColorChooserPanel.setText(this.greenLabel, n);
            n = color.getBlue();
            if (this.blue.getValue() != n) {
                this.blue.setValue(n);
            }
            SimpleColorChooserPanel.setText(this.blueLabel, n);
            this.updating = false;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.updating) {
            this.getColorSelectionModel().setSelectedColor(new Color(this.red.getValue(), this.green.getValue(), this.blue.getValue()));
        }
    }
}

