/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.docking.LAFUpdateListener;
import de.grogra.icon.IconAdapter;
import de.grogra.icon.IconSource;
import de.grogra.persistence.Transaction;
import de.grogra.persistence.XAListener;
import de.grogra.pf.boot.Main;
import de.grogra.pf.io.IO;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Option;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.expr.Expression;
import de.grogra.pf.ui.ChartPanel;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Console;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.Synchronizer;
import de.grogra.pf.ui.TextEditor;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.Widget;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.awt.AWTSynchronizer;
import de.grogra.pf.ui.awt.AWTToolkitBase;
import de.grogra.pf.ui.awt.AWTTree;
import de.grogra.pf.ui.awt.AWTWidgetSupport;
import de.grogra.pf.ui.awt.ContentPaneContainer;
import de.grogra.pf.ui.edit.EnumerationEditor;
import de.grogra.pf.ui.swing.BooleanWidget;
import de.grogra.pf.ui.swing.ChartSupport;
import de.grogra.pf.ui.swing.ChoiceWidget;
import de.grogra.pf.ui.swing.ColorChooser;
import de.grogra.pf.ui.swing.ColorWidget;
import de.grogra.pf.ui.swing.ComponentMenu;
import de.grogra.pf.ui.swing.ISwingPanel;
import de.grogra.pf.ui.swing.JConsole;
import de.grogra.pf.ui.swing.LAF;
import de.grogra.pf.ui.swing.MenuChoiceWidget;
import de.grogra.pf.ui.swing.MenuModel;
import de.grogra.pf.ui.swing.PanelSupport;
import de.grogra.pf.ui.swing.PlainPanel;
import de.grogra.pf.ui.swing.RootPane;
import de.grogra.pf.ui.swing.SliderWidget;
import de.grogra.pf.ui.swing.StatusBar;
import de.grogra.pf.ui.swing.SwingDockable;
import de.grogra.pf.ui.swing.SwingPanel;
import de.grogra.pf.ui.swing.SwingTable;
import de.grogra.pf.ui.swing.SwingTree;
import de.grogra.pf.ui.swing.TextEditorSupport;
import de.grogra.pf.ui.swing.TextWidget;
import de.grogra.pf.ui.swing.ToolBar;
import de.grogra.pf.ui.swing.TreeChoiceWidget;
import de.grogra.pf.ui.swing.WindowSupport;
import de.grogra.pf.ui.tree.SyncMappedList;
import de.grogra.pf.ui.tree.UINodeHandler;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.pf.ui.util.ComponentWrapperImpl;
import de.grogra.pf.ui.util.LinearConversion;
import de.grogra.pf.ui.util.Numeric2String;
import de.grogra.pf.ui.util.WidgetConversion;
import de.grogra.pf.ui.util.WidgetList;
import de.grogra.reflect.BoundedType;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.Disposable;
import de.grogra.util.I18NBundle;
import de.grogra.util.Map;
import de.grogra.util.ModifiableMap;
import de.grogra.util.Quantity;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import de.grogra.vfs.FileSystem;
import de.grogra.xl.util.ObjectList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableModel;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class SwingToolkit
extends AWTToolkitBase
implements XAListener {
    public static final I18NBundle I18N = I18NBundle.getInstance(SwingToolkit.class);
    static final int TEXT = 1;
    static final int TOOLBAR_ICON = 2;
    static final int MENU_ICON = 4;
    static final IconAdapter MENU_ICON_DUMMY = new IconAdapter(null, null, SwingToolkit.MENU_ICON_SIZE.width, SwingToolkit.MENU_ICON_SIZE.height, true, 0);
    final StringMap lafInfos = new StringMap();
    private static final UIManager.LookAndFeelInfo[] lafsToCheck = new UIManager.LookAndFeelInfo[]{new UIManager.LookAndFeelInfo("GTK+", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel")};
    final Item config;
    String currentLaf;
    final Object lafLock = new Object();
    boolean lafUpdatePending;
    private final ObjectList frames = new ObjectList(5, false);
    static final String SOURCE = "de.grogra.pf.ui.swing.SOURCE";
    static final String EDITOR_PANE = "de.grogra.pf.ui.swing.EDITOR_PANE";
    private static final int[] ALIGNMENT = new int[]{131072, 65536, 262144};
    private static final int[] J_ALIGNMENT = new int[]{0, 10, 11};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwingToolkit(Item item) {
        DefaultListModel<String> defaultListModel;
        this.config = item;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        Item item2 = item.getItem((CharSequence)"lafs");
        item = Option.get((Item)item, (String)"laf");
        if (item != null && (item = (Item)item.getBranch()) instanceof EnumerationEditor) {
            String string;
            int n;
            for (n = 0; n < lookAndFeelInfoArray.length; ++n) {
                string = lookAndFeelInfoArray[n].getName();
                if (this.lafInfos.containsKey(string)) continue;
                this.lafInfos.put(string, (Object)lookAndFeelInfoArray[n]);
            }
            for (n = 0; n < lafsToCheck.length; ++n) {
                try {
                    Class.forName(lafsToCheck[n].getClassName(), false, this.getClass().getClassLoader());
                    string = lafsToCheck[n].getName();
                    if (this.lafInfos.containsKey(string)) continue;
                    this.lafInfos.put(string, (Object)lafsToCheck[n]);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (item2 != null) {
                for (Item item3 = (Item)item2.getBranch(); item3 != null; item3 = (Item)item3.getSuccessor()) {
                    if (!(item3 instanceof LAF) || this.lafInfos.containsKey(string = item3.getName())) continue;
                    this.lafInfos.put(string, (Object)item3);
                }
            }
            defaultListModel = new DefaultListModel<String>();
            for (int i = 0; i < this.lafInfos.size(); ++i) {
                defaultListModel.addElement(this.lafInfos.getKeyAt(i));
            }
            ((EnumerationEditor)item).setList(defaultListModel);
        }
        this.updateLaf();
        if (this.lafUpdatePending) {
            defaultListModel = this.lafLock;
            synchronized (defaultListModel) {
                try {
                    this.lafLock.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.config.getPersistenceManager().addXAListener((XAListener)this);
    }

    public void transactionApplied(Transaction.Data data, boolean bl) {
        this.updateLaf();
    }

    private void updateLaf() {
        int n;
        Boolean bl;
        String string = (String)this.config.get((Object)"laf", null);
        Boolean bl2 = (Boolean)this.config.get((Object)"windowDecorations", null);
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        Boolean bl3 = bl = bl2 == JFrame.isDefaultLookAndFeelDecorated() ? null : bl2;
        if (string != null && !string.equals(this.currentLaf)) {
            this.currentLaf = string;
            n = this.lafInfos.findIndex(string);
        } else {
            n = -1;
        }
        if (this.lafUpdatePending = bl != null || n >= 0) {
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object;
                    if (bl != null) {
                        JFrame.setDefaultLookAndFeelDecorated(bl);
                    }
                    try {
                        if (n >= 0) {
                            object = SwingToolkit.this.lafInfos.getValueAt(n);
                            if (object instanceof LAF) {
                                LAFUpdateListener.setLookAndFeel(((LAF)((Object)object)).getLAF());
                            } else {
                                LAFUpdateListener.setLookAndFeel(((UIManager.LookAndFeelInfo)object).getClassName());
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    object = SwingToolkit.this.lafLock;
                    synchronized (object) {
                        SwingToolkit.this.lafUpdatePending = false;
                        SwingToolkit.this.lafLock.notifyAll();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFrame(RootPane rootPane, Context context) {
        Frame frame = (Frame)rootPane.getParent();
        ModifiableMap modifiableMap = UI.getOptions((Context)context);
        modifiableMap.put((Object)"windowwidth", (Object)frame.getWidth());
        modifiableMap.put((Object)"windowheight", (Object)frame.getHeight());
        modifiableMap.put((Object)"windowmaximized", (Object)((frame.getExtendedState() & 6) != 0 ? 1 : 0));
        ObjectList objectList = this.frames;
        synchronized (objectList) {
            if (this.frames.size > 1) {
                this.frames.remove((Object)frame);
                frame.dispose();
            } else {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                frame.setRootPane(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showInFrame(RootPane rootPane, String string, Context context, Point point) {
        boolean bl;
        Frame frame = null;
        ObjectList objectList = this.frames;
        synchronized (objectList) {
            if (this.frames.size == 1 && (frame = (Frame)this.frames.get(0)).getRootPane() != null) {
                frame = null;
            }
            if (bl = frame == null) {
                frame = new Frame();
                frame.addWindowListener(this);
                this.frames.add((Object)frame);
            }
        }
        rootPane.frame = frame;
        frame.setTitle(string);
        frame.setCursor(null);
        frame.setRootPane(rootPane);
        if (bl) {
            frame.pack();
            objectList = UI.getOptions((Context)context);
            frame.setSize(Utils.getInt((Map)objectList, (Object)"windowwidth", (int)750), Utils.getInt((Map)objectList, (Object)"windowheight", (int)550));
            if (point != null) {
                frame.setLocation(point);
            }
            if (Utils.getBoolean((Map)objectList, (Object)"windowmaximized", (boolean)false)) {
                frame.setExtendedState(6);
            }
            frame.setVisible(true);
        }
        frame.invalidate();
        frame.validate();
        frame.repaint();
        frame.toFront();
    }

    protected Container getContentPane(Object object) {
        return object instanceof ContentPaneContainer ? ((ContentPaneContainer)object).getContentPane() : (object instanceof RootPaneContainer ? ((RootPaneContainer)object).getContentPane() : (Container)object);
    }

    static void initialize(JComponent jComponent, UITree uITree, Object object, int n) {
        KeyStroke keyStroke;
        Object object2;
        if (jComponent instanceof AbstractButton || jComponent instanceof JLabel) {
            boolean bl = true;
            if ((n & 6) != 0) {
                object2 = uITree.getDescription(object, "Icon");
                IconAdapter iconAdapter = null;
                if (object2 != null) {
                    iconAdapter = IconAdapter.create((IconSource)((IconSource)object2), (Dimension)((n & 2) != 0 ? TOOLBAR_ICON_SIZE : MENU_ICON_SIZE));
                    bl = false;
                }
                if (iconAdapter != null) {
                    if (jComponent instanceof AbstractButton) {
                        ((AbstractButton)jComponent).setIcon((Icon)iconAdapter);
                    } else {
                        ((JLabel)jComponent).setIcon((Icon)iconAdapter);
                    }
                }
            }
            if ((bl || (n & 1) != 0) && (object2 = uITree.getDescription(object, "Name")) != null) {
                if (jComponent instanceof AbstractButton) {
                    ((AbstractButton)jComponent).setText((String)object2);
                } else {
                    ((JLabel)jComponent).setText((String)object2);
                }
            }
        }
        if (jComponent instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            object2 = uITree.getDescription(object, "MnemonicKey");
            if (object2 instanceof Number) {
                abstractButton.setMnemonic(((Number)object2).intValue());
            } else if (object2 instanceof Character) {
                abstractButton.setMnemonic(((Character)object2).charValue());
            } else if (object2 instanceof String) {
                try {
                    abstractButton.setMnemonic(Integer.parseInt((String)object2));
                }
                catch (NumberFormatException numberFormatException) {
                    abstractButton.setMnemonic(((String)object2).charAt(0));
                }
            }
            SwingToolkit.setDisabledIcon(abstractButton);
        }
        if (jComponent instanceof JMenuItem && !(jComponent instanceof JMenu) && (keyStroke = SwingToolkit.getKeyStroke((UINodeHandler)uITree, object)) != null) {
            ((JMenuItem)jComponent).setAccelerator(keyStroke);
        }
        if ((object2 = uITree.getDescription(object, "ShortDescription")) != null) {
            jComponent.setToolTipText(object2.toString());
        }
    }

    static KeyStroke getKeyStroke(UINodeHandler uINodeHandler, Object object) {
        Object object2 = uINodeHandler.getDescription(object, "AcceleratorKey");
        if (object2 instanceof String) {
            return KeyStroke.getKeyStroke((String)object2);
        }
        if (object2 instanceof KeyStroke) {
            return (KeyStroke)object2;
        }
        return null;
    }

    static void setDisabledIcon(AbstractButton abstractButton) {
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            return;
        }
        if (icon instanceof IconAdapter) {
            abstractButton.setDisabledIcon((Icon)((IconAdapter)icon).toState(1));
        }
    }

    static Object getSource(Object object) {
        return ((JComponent)object).getClientProperty(SOURCE);
    }

    static JEditorPane getEditorPane(JComponent jComponent) {
        return jComponent instanceof JEditorPane ? (JEditorPane)jComponent : (JEditorPane)jComponent.getClientProperty(EDITOR_PANE);
    }

    static void setEditorPage(JEditorPane jEditorPane, URL uRL) throws IOException {
        jEditorPane.setPage(uRL);
    }

    static void checkEditorKit(JEditorPane jEditorPane) {
        if (jEditorPane.getEditorKit() instanceof HTMLEditorKit) {
            ((HTMLEditorKit)jEditorPane.getEditorKit()).setDefaultCursor(null);
        }
    }

    public Object getParent(Object object) {
        JRootPane jRootPane;
        Container container = ((Component)object).getParent();
        if (container instanceof JComponent && (jRootPane = ((JComponent)container).getRootPane()) != null && jRootPane.getContentPane() == container) {
            return jRootPane.getParent();
        }
        return container;
    }

    public Widget createNumericWidget(Type type, Quantity quantity, Map map) {
        AWTWidgetSupport aWTWidgetSupport = (AWTWidgetSupport)this.createStringWidget(map);
        ((JTextField)aWTWidgetSupport.getComponent()).setHorizontalAlignment(4);
        aWTWidgetSupport.setConversion((WidgetConversion)new Numeric2String(type, quantity));
        if (type instanceof BoundedType || Utils.getBoolean((Map)map, (Object)"slider", (boolean)false)) {
            BoundedType boundedType = type instanceof BoundedType ? (BoundedType)type : null;
            JSlider jSlider = new JSlider();
            SliderWidget sliderWidget = new SliderWidget();
            if (Reflection.isIntegral((Type)type)) {
                if (boundedType != null) {
                    jSlider.setMinimum(boundedType.getMin().intValue());
                    jSlider.setMaximum(boundedType.getMax().intValue());
                } else {
                    jSlider.setMinimum(Utils.getInt((Map)map, (Object)"min", (int)0));
                    jSlider.setMaximum(Utils.getInt((Map)map, (Object)"max", (int)100));
                }
            } else {
                double d;
                double d2;
                jSlider.setMinimum(0);
                jSlider.setMaximum(1000);
                if (boundedType != null) {
                    d2 = boundedType.getMin().doubleValue();
                    d = boundedType.getMax().doubleValue();
                } else {
                    d2 = Utils.getDouble((Map)map, (Object)"min", (double)0.0);
                    d = Utils.getDouble((Map)map, (Object)"max", (double)1.0);
                }
                sliderWidget.setConversion((WidgetConversion)new LinearConversion(1000.0 / (d - d2), -1000.0 * d2 / (d - d2)));
            }
            sliderWidget.setComponent(jSlider);
            Container container = (Container)this.createContainer(new float[]{0.4f, 0.6f}, 1);
            container.add((Component)aWTWidgetSupport.getComponent());
            container.add(jSlider);
            return new WidgetList((Object)container, new Widget[]{aWTWidgetSupport, sliderWidget});
        }
        return aWTWidgetSupport;
    }

    public Widget createStringWidget(Map map) {
        JTextField jTextField = new JTextField();
        TextWidget textWidget = new TextWidget();
        textWidget.setComponent(jTextField);
        return textWidget;
    }

    public Widget createColorWidget(Map map) {
        ColorWidget colorWidget = new ColorWidget();
        colorWidget.setComponent(new ColorChooser());
        return colorWidget;
    }

    public Widget createTreeChoiceWidget(UITree uITree) {
        return new TreeChoiceWidget(uITree);
    }

    public Widget createChoiceWidget(ListModel listModel, boolean bl) {
        class Model
        extends SyncMappedList
        implements ComboBoxModel {
            private Object selected;

            Model(ListModel listModel) {
                super(listModel, (Synchronizer)new AWTSynchronizer(null));
            }

            public Object getSelectedItem() {
                return this.selected;
            }

            public void setSelectedItem(Object object) {
                this.selected = object;
                this.fireContentsChanged(-1, -1);
            }
        }
        JComponent jComponent;
        AWTWidgetSupport aWTWidgetSupport;
        if (bl) {
            JMenu jMenu = new JMenu("XXX");
            ButtonGroup buttonGroup = new ButtonGroup();
            for (int i = 0; i < listModel.getSize(); ++i) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(String.valueOf(listModel.getElementAt(i)));
                buttonGroup.add(jRadioButtonMenuItem);
                jMenu.add(jRadioButtonMenuItem);
            }
            aWTWidgetSupport = new MenuChoiceWidget(buttonGroup, new Model(listModel));
            jComponent = jMenu;
        } else {
            aWTWidgetSupport = new ChoiceWidget();
            jComponent = new JComboBox(new Model(listModel));
        }
        aWTWidgetSupport.setComponent(jComponent);
        return aWTWidgetSupport;
    }

    public Widget createBooleanWidget(boolean bl, Map map) {
        AbstractButton abstractButton;
        if (bl) {
            abstractButton = new JCheckBoxMenuItem();
        } else {
            abstractButton = new JCheckBox();
            abstractButton.setOpaque(false);
        }
        BooleanWidget booleanWidget = new BooleanWidget();
        booleanWidget.setComponent(abstractButton);
        return booleanWidget;
    }

    public ChartPanel createChartPanel(Context context, Map map) {
        ChartSupport chartSupport = new ChartSupport();
        chartSupport.initialize((WindowSupport)context.getWindow(), map);
        return chartSupport;
    }

    public Window createWindow(Command command, Map map) {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        return new WindowSupport(this, command, map);
    }

    public Panel createPanel(Context context, Disposable disposable, Map map) {
        JComponent jComponent = Boolean.TRUE.equals(map.get((Object)"plain", (Object)Boolean.FALSE)) ? new PlainPanel((LayoutManager)new GridLayout(1, 1), disposable) : new SwingPanel(disposable);
        return new PanelSupport((SwingDockable)((Object)jComponent)).initialize((WindowSupport)context.getWindow(), map);
    }

    public Console createConsole(Context context, Map map) {
        return (JConsole)new JConsole().initialize((WindowSupport)context.getWindow(), map);
    }

    public TextEditor createTextEditor(Context context, Map map) {
        Item item = this.config.getItem((CharSequence)"texteditors");
        PanelSupport panelSupport = null;
        ModifiableMap modifiableMap = UI.getOptions((Context)Workbench.current());
        boolean bl = Utils.getBoolean((Map)modifiableMap, (Object)"useIntegratedTextEditor", (boolean)false);
        if (!bl && item != null) {
            Item item2 = null;
            for (Item item3 = (Item)item.getBranch(); item3 != null; item3 = (Item)item3.getSuccessor()) {
                item2 = item3;
            }
            if (item2 instanceof Expression) {
                panelSupport = (PanelSupport)((Expression)item2).evaluate((RegistryContext)context.getWorkbench(), UI.getArgs((Context)context, (Map)map));
            }
        }
        if (panelSupport == null) {
            panelSupport = new TextEditorSupport();
        }
        panelSupport.initialize((WindowSupport)context.getWindow(), map);
        return panelSupport;
    }

    protected Container createContainer(LayoutManager layoutManager) {
        return new JPanel(layoutManager);
    }

    public Object createSplitContainer(int n) {
        JSplitPane jSplitPane = new JSplitPane(n);
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setDividerLocation(-1);
        return jSplitPane;
    }

    public Object setBorder(Object object, int n) {
        JComponent jComponent;
        if (object instanceof JComponent) {
            jComponent = (JComponent)object;
        } else {
            jComponent = new JPanel(new GridLayout(1, 1, 0, 0));
            jComponent.add((Component)object);
        }
        jComponent.setBorder(new EmptyBorder(n, n, n, n));
        return jComponent;
    }

    public ComponentWrapper createTree(UITree uITree) {
        return new SwingTree(uITree);
    }

    public ComponentWrapper createTreeInSplit(UITree uITree, Object object) {
        SwingTree swingTree = (SwingTree)this.createTree(uITree);
        final JSplitPane jSplitPane = (JSplitPane)object;
        swingTree.addComponentListener(new ComponentListener(){
            int setCount = 0;

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                JTree jTree = (JTree)componentEvent.getSource();
                if (this.setCount < 4) {
                    jTree.doLayout();
                    Dimension dimension = jTree.getPreferredSize();
                    Dimension dimension2 = jSplitPane.getSize();
                    int n = dimension.width + 50;
                    if (dimension2.width / 2 < n) {
                        n = dimension2.width / 2;
                    }
                    jSplitPane.setDividerLocation(n);
                    ++this.setCount;
                }
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        return swingTree;
    }

    public ComponentWrapper createTable(TableModel tableModel, Context context) {
        SwingTable swingTable = new SwingTable(tableModel, context);
        return new ComponentWrapperImpl(this.createScrollPane(swingTable), (Disposable)swingTable);
    }

    public TableModel getTable(ComponentWrapper componentWrapper) {
        if (!(componentWrapper instanceof ComponentWrapperImpl)) {
            return null;
        }
        Disposable disposable = ((ComponentWrapperImpl)componentWrapper).toDispose;
        if (!(disposable instanceof SwingTable)) {
            return null;
        }
        return ((SwingTable)disposable).srcTable;
    }

    public int getSelectedRow(ComponentWrapper componentWrapper) {
        return ((SwingTable)((ComponentWrapperImpl)componentWrapper).toDispose).getSelectedRow();
    }

    public Object createTextViewer(URL uRL, String string, String string2, final Command command, boolean bl) {
        JEditorPane jEditorPane;
        try {
            if (string != null && string2 != null) {
                jEditorPane = new JEditorPane(string, string2);
                if (uRL != null) {
                    jEditorPane.getDocument().putProperty("stream", uRL);
                }
            } else {
                jEditorPane = new JEditorPane();
                if (uRL != null) {
                    SwingToolkit.setEditorPage(jEditorPane, uRL);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        jEditorPane.setEditable(false);
        if (command != null) {
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && !(hyperlinkEvent instanceof HTMLFrameHyperlinkEvent)) {
                        PanelSupport panelSupport = PanelSupport.get(jEditorPane);
                        panelSupport.getWorkbench().getJobManager().runLater(command, (Object)(hyperlinkEvent.getURL() != null ? hyperlinkEvent.getURL().toString() : hyperlinkEvent.getDescription()), (Context)panelSupport, 70536);
                    }
                }
            });
        }
        if (!bl) {
            return jEditorPane;
        }
        ViewerHistory viewerHistory = new ViewerHistory(jEditorPane);
        Container container = (Container)this.createScrollPane(jEditorPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)viewerHistory.back, gridBagConstraints);
        jPanel.add((Component)viewerHistory.forward, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)viewerHistory.title, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 0;
        jPanel.add((Component)container, gridBagConstraints);
        if (uRL != null && jEditorPane.getDocument() instanceof HTMLDocument) {
            ((HTMLDocument)jEditorPane.getDocument()).setBase(uRL);
        }
        if (uRL != null) {
            viewerHistory.currentIndex = 0;
            viewerHistory.add(uRL);
        }
        SwingToolkit.checkEditorKit(jEditorPane);
        jEditorPane.addHyperlinkListener(viewerHistory);
        jEditorPane.addPropertyChangeListener(viewerHistory);
        viewerHistory.back.addActionListener(viewerHistory);
        viewerHistory.forward.addActionListener(viewerHistory);
        viewerHistory.update();
        jPanel.putClientProperty(EDITOR_PANE, jEditorPane);
        return jPanel;
    }

    public void setContent(final Object object, final String string, final String string2) {
        AWTSynchronizer.invokeInEventQueue(new Runnable(){
            private boolean scroll = false;

            public void run() {
                JEditorPane jEditorPane = SwingToolkit.getEditorPane((JComponent)object);
                if (this.scroll) {
                    jEditorPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                } else {
                    jEditorPane.setContentType(string);
                    jEditorPane.setDocument(jEditorPane.getEditorKit().createDefaultDocument());
                    jEditorPane.setText(string2);
                    this.scroll = true;
                    EventQueue.invokeLater(this);
                }
            }
        });
    }

    public void setContent(final Object object, final URL uRL) {
        AWTSynchronizer.invokeInEventQueue(new Runnable(){

            public void run() {
                try {
                    JEditorPane jEditorPane = SwingToolkit.getEditorPane((JComponent)object);
                    ViewerHistory viewerHistory = (ViewerHistory)jEditorPane.getClientProperty("de.grogra.pf.ui.swing.VIEWER_HISTORY");
                    if (viewerHistory != null) {
                        viewerHistory.setPage(uRL);
                    } else {
                        SwingToolkit.setEditorPage(jEditorPane, uRL);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    public Panel createViewerPanel(Context context, URL uRL, Map map) {
        JComponent jComponent = (JComponent)this.createTextViewer(uRL, null, null, null, true);
        if (jComponent == null) {
            return null;
        }
        map = UI.configureViewerParams((Map)map, (URL)uRL, (String)IO.getMimeType((String)uRL.getFile()).getMediaType(), (RegistryContext)context.getWorkbench());
        final PanelSupport panelSupport = (PanelSupport)this.createPanel(context, null, map);
        panelSupport.textViewer = jComponent;
        panelSupport.setContent((ComponentWrapper)new ComponentWrapperImpl((Object)jComponent, null));
        final JEditorPane jEditorPane = SwingToolkit.getEditorPane(jComponent);
        panelSupport.mapProducer = new ModifiableMap.Producer(){

            public void addMappings(ModifiableMap modifiableMap) {
                modifiableMap.put((Object)"mimeType", (Object)jEditorPane.getContentType());
                URL uRL = jEditorPane.getPage();
                if (uRL != null) {
                    modifiableMap.put((Object)"systemId", (Object)IO.toSystemId((FileSystem)UI.getRegistry((Context)panelSupport).getFileSystem(), (URL)uRL));
                }
            }
        };
        return panelSupport;
    }

    public Object getTextViewerComponent(Panel panel) {
        return ((PanelSupport)panel.resolve()).textViewer;
    }

    public ComponentWrapper createComponentTree(UITree uITree) {
        TreeRoot treeRoot = new TreeRoot();
        AWTTree aWTTree = new AWTTree(uITree, (Disposable)uITree, treeRoot);
        aWTTree.map(true);
        treeRoot.tree = aWTTree;
        return aWTTree;
    }

    public ComponentWrapper createComponentMenu(UITree uITree) {
        ComponentMenu componentMenu = new ComponentMenu(uITree, (Disposable)uITree);
        componentMenu.map(true);
        return componentMenu;
    }

    public Panel createToolBar(Context context, Map map) {
        return new PanelSupport(new ToolBar()).initialize((WindowSupport)context.getWindow(), map);
    }

    public Panel createStatusBar(Context context, Map map) {
        return new PanelSupport(new StatusBar()).initialize((WindowSupport)context.getWindow(), map);
    }

    protected Component createLabel(String string, Icon icon, int n) {
        if (string != null && string.indexOf(10) >= 0 && string.indexOf("<html>") < 0) {
            string = "<html><pre>" + string + "</pre></html>";
        }
        JLabel jLabel = new JLabel(string, icon, SwingToolkit.getFirstMatching((int)n, (int[])ALIGNMENT, (int[])J_ALIGNMENT, (int)10));
        jLabel.setVerticalAlignment(1);
        return jLabel;
    }

    protected void updateLabel(Component component, String string, Icon icon) {
        JLabel jLabel = (JLabel)component;
        if (!jLabel.getText().equals(string)) {
            ((JLabel)component).setText(string);
        }
        if (jLabel.getIcon() != icon) {
            jLabel.setIcon(icon);
        }
    }

    public Object createButton(String string, IconSource iconSource, Dimension dimension, int n, final Command command, final Context context) {
        IconAdapter iconAdapter = IconAdapter.create((IconSource)iconSource, (Dimension)dimension);
        AbstractButton abstractButton = (n & 0x100000) != 0 ? new JMenuItem(string, (Icon)iconAdapter) : new JButton(string, (Icon)iconAdapter);
        abstractButton.setHorizontalAlignment(SwingToolkit.getFirstMatching((int)n, (int[])ALIGNMENT, (int[])J_ALIGNMENT, (int)10));
        abstractButton.setVerticalAlignment(1);
        Font font = this.getFont(n);
        if (font != null) {
            abstractButton.setFont(font);
        }
        if (command != null) {
            abstractButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UI.getJobManager((Context)context).runLater(command, (Object)actionEvent, context, 10000);
                }
            });
        }
        return abstractButton;
    }

    public void showPopupMenu(UITree uITree, Object object, int n, int n2) {
        this.showPopupMenu(uITree, object, n, n2, null);
    }

    void showPopupMenu(UITree uITree, Object object, final int n, final int n2, ActionListener actionListener) {
        if (uITree == null) {
            return;
        }
        final Component component = (Component)(object == null ? uITree.getContext().getComponent() : object);
        final MenuModel menuModel = new MenuModel(uITree, actionListener, true);
        menuModel.map(false);
        final JPopupMenu jPopupMenu = (JPopupMenu)menuModel.getRoot();
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){
            boolean disposed = false;

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                if (this.disposed) {
                    return;
                }
                this.disposed = true;
                Context context = menuModel.getSourceTree().getContext();
                UI.getJobManager((Context)context).runLater(Command.DISPOSE, (Object)menuModel, context, 70536);
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                this.popupMenuCanceled(popupMenuEvent);
            }
        });
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                jPopupMenu.show(component, n, n2);
            }
        });
    }

    public void windowClosing(WindowEvent windowEvent) {
        PanelSupport panelSupport;
        JRootPane jRootPane;
        java.awt.Window window = windowEvent.getWindow();
        if (window instanceof RootPaneContainer && (jRootPane = ((RootPaneContainer)((Object)window)).getRootPane()) instanceof ISwingPanel && (panelSupport = ((ISwingPanel)((Object)jRootPane)).getSupport()) instanceof WindowSupport) {
            ((WindowSupport)panelSupport).closeRequested();
        }
    }

    public Object createScrollPane(Object object) {
        return new JScrollPane((Component)object);
    }

    public Object createTabbedPane(String[] stringArray, Object[] objectArray) {
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        for (int i = 0; i < stringArray.length; ++i) {
            jTabbedPane.addTab(stringArray[i], (Component)objectArray[i]);
        }
        return jTabbedPane;
    }

    private static class TreeRoot
    extends JComponent {
        AWTTree tree;

        TreeRoot() {
            this.setOpaque(false);
            this.enableEvents(56L);
            this.updateUI();
        }

        public void updateUI() {
            LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
        }

        protected void paintComponent(Graphics graphics) {
            if (this.tree != null) {
                this.tree.paint(graphics);
            }
        }
    }

    private class ViewerHistory
    extends ObjectList
    implements HyperlinkListener,
    ActionListener,
    PropertyChangeListener {
        static final String KEY = "de.grogra.pf.ui.swing.VIEWER_HISTORY";
        JButton back;
        JButton forward;
        JLabel title;
        JEditorPane editor;
        int currentIndex;

        ViewerHistory(JEditorPane jEditorPane) {
            this.back = (JButton)SwingToolkit.this.createButton(UI.I18N, "browser.back", UIToolkit.MEDIUM_ICON_SIZE, 0, null, null);
            this.forward = (JButton)SwingToolkit.this.createButton(UI.I18N, "browser.forward", UIToolkit.MEDIUM_ICON_SIZE, 0, null, null);
            this.title = new JLabel();
            this.currentIndex = -1;
            this.editor = jEditorPane;
            jEditorPane.putClientProperty(KEY, this);
            this.title.setFont(SwingToolkit.this.getFont(17426));
            this.title.setBorder(new EmptyBorder(2, 4, 2, 4));
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    ((HTMLDocument)this.editor.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)hyperlinkEvent);
                } else if (hyperlinkEvent.getURL() != null) {
                    this.setPage(hyperlinkEvent.getURL());
                } else {
                    this.editor.setCursor(null);
                    UI.executeHyperlinkURL((String)hyperlinkEvent.getDescription(), (Context)PanelSupport.get(this.editor));
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == this.back && this.currentIndex > 0) {
                    SwingToolkit.setEditorPage(this.editor, (URL)this.get(--this.currentIndex));
                } else if (actionEvent.getSource() == this.forward && this.currentIndex + 1 < this.size) {
                    SwingToolkit.setEditorPage(this.editor, (URL)this.get(++this.currentIndex));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("page".equals(propertyChangeEvent.getPropertyName())) {
                this.update();
            } else if ("editorKit".equals(propertyChangeEvent.getPropertyName())) {
                SwingToolkit.checkEditorKit(this.editor);
            }
        }

        void update() {
            this.back.setEnabled(this.currentIndex > 0);
            this.forward.setEnabled(this.currentIndex + 1 < this.size);
            Object object = this.editor.getDocument().getProperty("title");
            if (object == null) {
                object = this.editor.getPage();
            }
            this.title.setText(object != null ? object.toString() : null);
        }

        void setPage(URL uRL) {
            try {
                this.setSize(++this.currentIndex);
                this.add(uRL);
                SwingToolkit.setEditorPage(this.editor, uRL);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static final class Frame
    extends JFrame {
        Frame() {
            this.setDefaultCloseOperation(0);
            try {
                String string = Main.getProperty((String)"boot");
                BufferedImage bufferedImage = ImageIO.read(new File(string + "/groimp.png"));
                this.setIconImage(bufferedImage);
            }
            catch (Exception exception) {
                Main.logWarning((Throwable)exception);
            }
            new LAFUpdateListener(this);
        }

        void setRootPane(RootPane rootPane) {
            if (rootPane != null && !Utils.equal((Object)rootPane.currentLAF, (Object)UIManager.getLookAndFeel())) {
                SwingUtilities.updateComponentTreeUI(rootPane);
            }
            super.setRootPane(rootPane);
        }
    }
}

