/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.awt.ButtonSupport;
import de.grogra.pf.ui.awt.ContentPaneContainer;
import de.grogra.pf.ui.edit.Selectable;
import de.grogra.pf.ui.edit.Selection;
import de.grogra.pf.ui.swing.MenuModelBase;
import de.grogra.pf.ui.swing.SwingButtonSupport;
import de.grogra.pf.ui.swing.SwingToolkit;
import de.grogra.pf.ui.swing.ToolBar;
import de.grogra.pf.ui.tree.UINodeHandler;
import de.grogra.pf.ui.tree.UITree;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

class ToolBarModel
extends MenuModelBase {
    static final String POPUP_PARENT = "de.grogra.pf.ui.swing.ToolBarModel.popupParent";
    static final String KEYSTROKE = "de.grogra.pf.ui.swing.ToolBarModel.keyStroke";
    private ToolBar toolBar;

    ToolBarModel(UITree uITree, ToolBar toolBar) {
        super(uITree);
        this.toolBar = toolBar;
    }

    public Object run(int n, int n2, Object object, Object object2) {
        object2 = super.run(n, n2, object, object2);
        if (object instanceof ItemGroupButton) {
            ((ItemGroupButton)object).updateLayout();
        }
        return object2;
    }

    public Object createNode(Object object, Object object2) {
        JComponent jComponent;
        if (this.isSourceRoot(object)) {
            jComponent = this.toolBar;
        } else {
            Object object3;
            Component component;
            Object object4;
            boolean bl = false;
            int n = this.sourceTree.getType(object);
            int n2 = 2;
            switch (n) {
                case 2: {
                    jComponent = object2 == this.toolBar ? new JButton() : new JMenuItem();
                    bl = true;
                    object4 = SwingToolkit.getKeyStroke((UINodeHandler)this.sourceTree, object);
                    if (object4 == null) break;
                    jComponent.putClientProperty(KEYSTROKE, object4);
                    this.toolBar.getInputMap(2).put((KeyStroke)object4, jComponent);
                    this.toolBar.getActionMap().put(jComponent, new AbstractAction(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ButtonSupport buttonSupport = ButtonSupport.get(jComponent);
                            if (buttonSupport != null) {
                                buttonSupport.actionPerformed(new ActionEvent(jComponent, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
                            }
                        }
                    });
                    break;
                }
                case 3: {
                    jComponent = new JButton();
                    bl = true;
                    break;
                }
                case 5: {
                    jComponent = new JToggleButton();
                    bl = true;
                    break;
                }
                case 6: {
                    jComponent = new JCheckBox();
                    bl = true;
                    break;
                }
                case 1: {
                    component = new JToolBar.Separator(null);
                    ((JSeparator)component).setOrientation(this.toolBar.getOrientation() == 1 ? 0 : 1);
                    jComponent = component;
                    break;
                }
                case 18: {
                    jComponent = new ItemGroupButton();
                    break;
                }
                case 16: 
                case 17: {
                    jComponent = new JMenu();
                    n2 = 1;
                    break;
                }
                case 9: {
                    Selection selection;
                    object3 = (Selectable)this.sourceTree.invoke(object, "getSelectable", null);
                    if (object3 != null && (selection = object3.toSelection(this.sourceTree.getContext())) != null) {
                        ComponentWrapper componentWrapper = selection.createPropertyEditorMenu();
                        JMenu jMenu = (JMenu)componentWrapper.getComponent();
                        jComponent = (JComponent)jMenu.getMenuComponent(1);
                        jMenu.remove(jComponent);
                        jComponent.putClientProperty("de.grogra.pf.ui.swing.WRAPPER", componentWrapper);
                        break;
                    }
                    jComponent = new JLabel();
                    break;
                }
                default: {
                    jComponent = new JLabel();
                }
            }
            if (jComponent instanceof AbstractButton) {
                // empty if block
            }
            SwingToolkit.initialize(jComponent, this.sourceTree, object, n2);
            if (bl) {
                object4 = new SwingButtonSupport(this.sourceTree, object, (AbstractButton)jComponent, n);
                component = (Component)object2;
                while (component != this.toolBar) {
                    if (component instanceof ItemGroupButton) {
                        object3 = (ItemGroupButton)component;
                        ((ButtonSupport)object4).setActionListener((ActionListener)object3);
                        if (((ItemGroupButton)object3).button != null) break;
                        ((ItemGroupButton)object3).setButton((AbstractButton)jComponent);
                        break;
                    }
                    component = component instanceof JPopupMenu ? (Component)((JPopupMenu)component).getClientProperty(POPUP_PARENT) : component.getParent();
                }
            }
        }
        jComponent.putClientProperty("de.grogra.pf.ui.swing.SOURCE", object);
        return jComponent;
    }

    public void disposeNode(Object object) {
        KeyStroke keyStroke = (KeyStroke)((JComponent)object).getClientProperty(KEYSTROKE);
        if (keyStroke != null) {
            this.toolBar.getInputMap(2).remove(keyStroke);
            this.toolBar.getActionMap().remove(object);
            ((JComponent)object).putClientProperty(KEYSTROKE, null);
        }
        super.disposeNode(object);
    }

    private static class ItemGroupButton
    extends JButton
    implements ContentPaneContainer,
    ActionListener {
        private JPopupMenu popup = new JPopupMenu();
        AbstractButton button;

        ItemGroupButton() {
            this.popup.putClientProperty(ToolBarModel.POPUP_PARENT, this);
            this.addActionListener(this);
            this.popup.setLayout(new GridLayout(2, 2));
        }

        public Container getContentPane() {
            return this.popup;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = this.getWidth() - 11;
            int n2 = this.getHeight() - 8;
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.fillRect(n, n2, 9, 6);
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n + 1, ++n2, n + 7, n2);
            graphics.drawLine(n + 2, ++n2, n + 6, n2);
            graphics.drawLine(n + 3, ++n2, n + 5, n2);
            graphics.drawLine(n + 4, ++n2, n + 4, n2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this) {
                MouseEvent mouseEvent;
                AWTEvent aWTEvent = EventQueue.getCurrentEvent();
                if (aWTEvent instanceof MouseEvent && (mouseEvent = (MouseEvent)aWTEvent).getX() > this.getWidth() - 12) {
                    this.popup.show(this, this.getWidth() - 6, this.getHeight() - 3);
                    return;
                }
            } else {
                this.popup.setVisible(false);
                this.setButton((AbstractButton)actionEvent.getSource());
            }
            if (this.button != null) {
                ButtonSupport.get(this.button).postAction(actionEvent);
            }
        }

        void setButton(AbstractButton abstractButton) {
            this.button = abstractButton;
            this.setText(abstractButton.getText());
            this.setMnemonic(abstractButton.getMnemonic());
            this.setIcon(abstractButton.getIcon());
            this.revalidate();
        }

        void updateLayout() {
            int n;
            GridLayout gridLayout = (GridLayout)this.popup.getLayout();
            int n2 = this.popup.getComponentCount();
            int n3 = Math.max(1, (int)Math.sqrt(n2));
            while (true) {
                if (n3 * n3 >= n2) {
                    n = n3;
                    break;
                }
                if (n3 * (n3 + 1) >= n2) {
                    n = n3 + 1;
                    break;
                }
                ++n3;
            }
            gridLayout.setColumns(n);
            gridLayout.setRows(n3);
        }
    }
}

