/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.labels.StandardXYSeriesLabelGenerator;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class MultipleXYSeriesLabelGenerator
implements XYSeriesLabelGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 138976236941898560L;
    public static final String DEFAULT_LABEL_FORMAT = "{0}";
    private String formatPattern;
    private String additionalFormatPattern;
    private Map seriesLabelLists;

    public MultipleXYSeriesLabelGenerator() {
        this(DEFAULT_LABEL_FORMAT);
    }

    public MultipleXYSeriesLabelGenerator(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'format' argument.");
        }
        this.formatPattern = string;
        this.additionalFormatPattern = "\n{0}";
        this.seriesLabelLists = new HashMap();
    }

    public void addSeriesLabel(int n, String string) {
        Integer n2 = new Integer(n);
        ArrayList<String> arrayList = (ArrayList<String>)this.seriesLabelLists.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.seriesLabelLists.put(n2, arrayList);
        }
        arrayList.add(string);
    }

    public void clearSeriesLabels(int n) {
        Integer n2 = new Integer(n);
        this.seriesLabelLists.put(n2, null);
    }

    public String generateLabel(XYDataset xYDataset, int n) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MessageFormat.format(this.formatPattern, this.createItemArray(xYDataset, n)));
        Integer n2 = new Integer(n);
        List list = (List)this.seriesLabelLists.get(n2);
        if (list != null) {
            Object[] objectArray = new Object[1];
            for (int i = 0; i < list.size(); ++i) {
                objectArray[0] = list.get(i);
                String string = MessageFormat.format(this.additionalFormatPattern, objectArray);
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    protected Object[] createItemArray(XYDataset xYDataset, int n) {
        Object[] objectArray = new Object[]{xYDataset.getSeriesKey(n).toString()};
        return objectArray;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardXYSeriesLabelGenerator)) {
            return false;
        }
        return super.equals(object);
    }
}

