/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.needle;

import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.needle.MeterNeedle;

public class PlumNeedle
extends MeterNeedle
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3082660488660600718L;

    protected void drawNeedle(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, double d) {
        Arc2D.Double double_ = new Arc2D.Double(2);
        double d2 = rectangle2D.getHeight();
        double d3 = rectangle2D.getWidth() / 2.0;
        double d4 = 2.0 * d2;
        double_.setFrame(rectangle2D.getMinX() + d3 - d2, rectangle2D.getMinY() - d2, d4, d4);
        d2 = Math.toDegrees(Math.asin(d3 / d2));
        ((Arc2D)double_).setAngleStart(270.0 - d2);
        ((Arc2D)double_).setAngleExtent(2.0 * d2);
        Area area = new Area(double_);
        if (point2D != null && d != 0.0) {
            this.getTransform().setToRotation(d, point2D.getX(), point2D.getY());
            area.transform(this.getTransform());
        }
        this.defaultDisplay(graphics2D, area);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PlumNeedle)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

