/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PieLabelDistributor;
import org.jfree.chart.plot.PieLabelRecord;
import org.jfree.chart.plot.PiePlotState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBox;
import org.jfree.text.TextMeasurer;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintList;
import org.jfree.util.PaintUtilities;
import org.jfree.util.Rotation;
import org.jfree.util.ShapeUtilities;
import org.jfree.util.StrokeList;

public class PiePlot
extends Plot
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -795612466005590431L;
    public static final double DEFAULT_INTERIOR_GAP = 0.25;
    public static final double MAX_INTERIOR_GAP = 0.4;
    public static final double DEFAULT_START_ANGLE = 90.0;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_LABEL_PAINT = Color.black;
    public static final Paint DEFAULT_LABEL_BACKGROUND_PAINT = new Color(255, 255, 192);
    public static final Paint DEFAULT_LABEL_OUTLINE_PAINT = Color.black;
    public static final Stroke DEFAULT_LABEL_OUTLINE_STROKE = new BasicStroke(0.5f);
    public static final Paint DEFAULT_LABEL_SHADOW_PAINT = Color.lightGray;
    public static final double DEFAULT_MINIMUM_ARC_ANGLE_TO_DRAW = 1.0E-5;
    private PieDataset dataset;
    private int pieIndex;
    private double interiorGap;
    private boolean circular;
    private double startAngle;
    private Rotation direction;
    private transient Paint sectionPaint;
    private PaintList sectionPaintList;
    private transient Paint baseSectionPaint;
    private boolean sectionOutlinesVisible;
    private transient Paint sectionOutlinePaint;
    private PaintList sectionOutlinePaintList;
    private transient Paint baseSectionOutlinePaint;
    private transient Stroke sectionOutlineStroke;
    private StrokeList sectionOutlineStrokeList;
    private transient Stroke baseSectionOutlineStroke;
    private transient Paint shadowPaint = Color.gray;
    private double shadowXOffset = 4.0;
    private double shadowYOffset = 4.0;
    private ObjectList explodePercentages;
    private PieSectionLabelGenerator labelGenerator;
    private Font labelFont;
    private transient Paint labelPaint;
    private transient Paint labelBackgroundPaint;
    private transient Paint labelOutlinePaint;
    private transient Stroke labelOutlineStroke;
    private transient Paint labelShadowPaint;
    private double maximumLabelWidth = 0.2;
    private double labelGap = 0.05;
    private boolean labelLinksVisible;
    private double labelLinkMargin = 0.05;
    private transient Paint labelLinkPaint = Color.black;
    private transient Stroke labelLinkStroke = new BasicStroke(0.5f);
    private PieToolTipGenerator toolTipGenerator;
    private PieURLGenerator urlGenerator;
    private PieSectionLabelGenerator legendLabelGenerator;
    private PieSectionLabelGenerator legendLabelToolTipGenerator;
    private boolean ignoreNullValues;
    private boolean ignoreZeroValues;
    private transient Shape legendItemShape;
    private double minimumArcAngleToDraw;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public PiePlot() {
        this(null);
    }

    public PiePlot(PieDataset pieDataset) {
        this.dataset = pieDataset;
        if (pieDataset != null) {
            pieDataset.addChangeListener((DatasetChangeListener)this);
        }
        this.pieIndex = 0;
        this.interiorGap = 0.25;
        this.circular = true;
        this.startAngle = 90.0;
        this.direction = Rotation.CLOCKWISE;
        this.minimumArcAngleToDraw = 1.0E-5;
        this.sectionPaint = null;
        this.sectionPaintList = new PaintList();
        this.baseSectionPaint = null;
        this.sectionOutlinesVisible = true;
        this.sectionOutlinePaint = null;
        this.sectionOutlinePaintList = new PaintList();
        this.baseSectionOutlinePaint = DEFAULT_OUTLINE_PAINT;
        this.sectionOutlineStroke = null;
        this.sectionOutlineStrokeList = new StrokeList();
        this.baseSectionOutlineStroke = DEFAULT_OUTLINE_STROKE;
        this.explodePercentages = new ObjectList();
        this.labelGenerator = new StandardPieSectionLabelGenerator();
        this.labelFont = DEFAULT_LABEL_FONT;
        this.labelPaint = DEFAULT_LABEL_PAINT;
        this.labelBackgroundPaint = DEFAULT_LABEL_BACKGROUND_PAINT;
        this.labelOutlinePaint = DEFAULT_LABEL_OUTLINE_PAINT;
        this.labelOutlineStroke = DEFAULT_LABEL_OUTLINE_STROKE;
        this.labelShadowPaint = DEFAULT_LABEL_SHADOW_PAINT;
        this.labelLinksVisible = true;
        this.toolTipGenerator = null;
        this.urlGenerator = null;
        this.legendLabelGenerator = new StandardPieSectionLabelGenerator();
        this.legendLabelToolTipGenerator = null;
        this.legendItemShape = Plot.DEFAULT_LEGEND_ITEM_CIRCLE;
        this.ignoreNullValues = false;
        this.ignoreZeroValues = false;
    }

    public PieDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(PieDataset pieDataset) {
        PieDataset pieDataset2 = this.dataset;
        if (pieDataset2 != null) {
            pieDataset2.removeChangeListener((DatasetChangeListener)this);
        }
        this.dataset = pieDataset;
        if (pieDataset != null) {
            this.setDatasetGroup(pieDataset.getGroup());
            pieDataset.addChangeListener((DatasetChangeListener)this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent((Object)this, (Dataset)pieDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getPieIndex() {
        return this.pieIndex;
    }

    public void setPieIndex(int n) {
        this.pieIndex = n;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Rotation getDirection() {
        return this.direction;
    }

    public void setDirection(Rotation rotation) {
        if (rotation == null) {
            throw new IllegalArgumentException("Null 'direction' argument.");
        }
        this.direction = rotation;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(double d) {
        if (d < 0.0 || d > 0.4) {
            throw new IllegalArgumentException("Invalid 'percent' (" + d + ") argument.");
        }
        if (this.interiorGap != d) {
            this.interiorGap = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean bl) {
        this.setCircular(bl, true);
    }

    public void setCircular(boolean bl, boolean bl2) {
        this.circular = bl;
        if (bl2) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean getIgnoreNullValues() {
        return this.ignoreNullValues;
    }

    public void setIgnoreNullValues(boolean bl) {
        this.ignoreNullValues = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getIgnoreZeroValues() {
        return this.ignoreZeroValues;
    }

    public void setIgnoreZeroValues(boolean bl) {
        this.ignoreZeroValues = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSectionPaint() {
        return this.sectionPaint;
    }

    public void setSectionPaint(Paint paint) {
        this.sectionPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSectionPaint(int n) {
        if (this.sectionPaint != null) {
            return this.sectionPaint;
        }
        Paint paint = this.sectionPaintList.getPaint(n);
        if (paint == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                Paint paint2 = drawingSupplier.getNextPaint();
                this.sectionPaintList.setPaint(n, paint2);
                paint = paint2;
            } else {
                paint = this.baseSectionPaint;
            }
        }
        return paint;
    }

    public void setSectionPaint(int n, Paint paint) {
        this.sectionPaintList.setPaint(n, paint);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getBaseSectionPaint() {
        return this.baseSectionPaint;
    }

    public void setBaseSectionPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSectionPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getSectionOutlinesVisible() {
        return this.sectionOutlinesVisible;
    }

    public void setSectionOutlinesVisible(boolean bl) {
        this.sectionOutlinesVisible = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSectionOutlinePaint() {
        return this.sectionOutlinePaint;
    }

    public void setSectionOutlinePaint(Paint paint) {
        this.sectionOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSectionOutlinePaint(int n) {
        if (this.sectionOutlinePaint != null) {
            return this.sectionOutlinePaint;
        }
        Paint paint = this.sectionOutlinePaintList.getPaint(n);
        if (paint == null) {
            paint = this.baseSectionOutlinePaint;
        }
        return paint;
    }

    public void setSectionOutlinePaint(int n, Paint paint) {
        this.sectionOutlinePaintList.setPaint(n, paint);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getBaseSectionOutlinePaint() {
        return this.baseSectionOutlinePaint;
    }

    public void setBaseSectionOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSectionOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSectionOutlineStroke() {
        return this.sectionOutlineStroke;
    }

    public void setSectionOutlineStroke(Stroke stroke) {
        this.sectionOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSectionOutlineStroke(int n) {
        if (this.sectionOutlineStroke != null) {
            return this.sectionOutlineStroke;
        }
        Stroke stroke = this.sectionOutlineStrokeList.getStroke(n);
        if (stroke == null) {
            stroke = this.baseSectionOutlineStroke;
        }
        return stroke;
    }

    public void setSectionOutlineStroke(int n, Stroke stroke) {
        this.sectionOutlineStrokeList.setStroke(n, stroke);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getBaseSectionOutlineStroke() {
        return this.baseSectionOutlineStroke;
    }

    public void setBaseSectionOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.baseSectionOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        this.shadowPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double d) {
        this.shadowXOffset = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double d) {
        this.shadowYOffset = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getExplodePercent(int n) {
        Number number;
        double d = 0.0;
        if (this.explodePercentages != null && (number = (Number)this.explodePercentages.get(n)) != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public void setExplodePercent(int n, double d) {
        if (this.explodePercentages == null) {
            this.explodePercentages = new ObjectList();
        }
        this.explodePercentages.set(n, (Object)new Double(d));
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getMaximumExplodePercent() {
        double d = 0.0;
        for (int i = 0; i < this.explodePercentages.size(); ++i) {
            Number number = (Number)this.explodePercentages.get(i);
            if (number == null) continue;
            d = Math.max(d, number.doubleValue());
        }
        return d;
    }

    public PieSectionLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(PieSectionLabelGenerator pieSectionLabelGenerator) {
        this.labelGenerator = pieSectionLabelGenerator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getLabelGap() {
        return this.labelGap;
    }

    public void setLabelGap(double d) {
        this.labelGap = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getMaximumLabelWidth() {
        return this.maximumLabelWidth;
    }

    public void setMaximumLabelWidth(double d) {
        this.maximumLabelWidth = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getLabelLinksVisible() {
        return this.labelLinksVisible;
    }

    public void setLabelLinksVisible(boolean bl) {
        this.labelLinksVisible = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getLabelLinkMargin() {
        return this.labelLinkMargin;
    }

    public void setLabelLinkMargin(double d) {
        this.labelLinkMargin = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelLinkPaint() {
        return this.labelLinkPaint;
    }

    public void setLabelLinkPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelLinkPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getLabelLinkStroke() {
        return this.labelLinkStroke;
    }

    public void setLabelLinkStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.labelLinkStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.labelFont = font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelBackgroundPaint() {
        return this.labelBackgroundPaint;
    }

    public void setLabelBackgroundPaint(Paint paint) {
        this.labelBackgroundPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelOutlinePaint() {
        return this.labelOutlinePaint;
    }

    public void setLabelOutlinePaint(Paint paint) {
        this.labelOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getLabelOutlineStroke() {
        return this.labelOutlineStroke;
    }

    public void setLabelOutlineStroke(Stroke stroke) {
        this.labelOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelShadowPaint() {
        return this.labelShadowPaint;
    }

    public void setLabelShadowPaint(Paint paint) {
        this.labelShadowPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public PieToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(PieToolTipGenerator pieToolTipGenerator) {
        this.toolTipGenerator = pieToolTipGenerator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public PieURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(PieURLGenerator pieURLGenerator) {
        this.urlGenerator = pieURLGenerator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getMinimumArcAngleToDraw() {
        return this.minimumArcAngleToDraw;
    }

    public void setMinimumArcAngleToDraw(double d) {
        this.minimumArcAngleToDraw = d;
    }

    public Shape getLegendItemShape() {
        return this.legendItemShape;
    }

    public void setLegendItemShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.legendItemShape = shape;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public PieSectionLabelGenerator getLegendLabelToolTipGenerator() {
        return this.legendLabelToolTipGenerator;
    }

    public void setLegendLabelToolTipGenerator(PieSectionLabelGenerator pieSectionLabelGenerator) {
        this.legendLabelToolTipGenerator = pieSectionLabelGenerator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public PieSectionLabelGenerator getLegendLabelGenerator() {
        return this.legendLabelGenerator;
    }

    public void setLegendLabelGenerator(PieSectionLabelGenerator pieSectionLabelGenerator) {
        if (pieSectionLabelGenerator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.legendLabelGenerator = pieSectionLabelGenerator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public PiePlotState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, PiePlot piePlot, Integer n, PlotRenderingInfo plotRenderingInfo) {
        PiePlotState piePlotState = new PiePlotState(plotRenderingInfo);
        piePlotState.setPassesRequired(2);
        piePlotState.setTotal(DatasetUtilities.calculatePieDatasetTotal((PieDataset)piePlot.getDataset()));
        piePlotState.setLatestAngle(piePlot.getStartAngle());
        return piePlotState;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
            plotRenderingInfo.setDataArea(rectangle2D);
        }
        this.drawBackground(graphics2D, rectangle2D);
        this.drawOutline(graphics2D, rectangle2D);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        if (!DatasetUtilities.isEmptyOrNull((PieDataset)this.dataset)) {
            this.drawPie(graphics2D, rectangle2D, plotRenderingInfo);
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D);
    }

    protected void drawPie(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        PiePlotState piePlotState = this.initialise(graphics2D, rectangle2D, this, null, plotRenderingInfo);
        double d = 0.0;
        if (this.labelGenerator != null) {
            d = this.labelGap + this.maximumLabelWidth + this.labelLinkMargin;
        }
        double d2 = rectangle2D.getWidth() * (this.interiorGap + d);
        double d3 = rectangle2D.getHeight() * this.interiorGap;
        double d4 = rectangle2D.getX() + d2 / 2.0;
        double d5 = rectangle2D.getY() + d3 / 2.0;
        double d6 = rectangle2D.getWidth() - d2;
        double d7 = rectangle2D.getHeight() - d3;
        if (this.circular) {
            double d8 = Math.min(d6, d7) / 2.0;
            d4 = (d4 + d4 + d6) / 2.0 - d8;
            d5 = (d5 + d5 + d7) / 2.0 - d8;
            d6 = 2.0 * d8;
            d7 = 2.0 * d8;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, d6, d7);
        piePlotState.setLinkArea(double_);
        double d9 = ((RectangularShape)double_).getWidth() * this.labelLinkMargin;
        double d10 = ((RectangularShape)double_).getHeight() * this.labelLinkMargin;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d4 + d9 / 2.0, d5 + d10 / 2.0, d6 - d9, d7 - d10);
        piePlotState.setExplodedPieArea(double_2);
        double d11 = this.getMaximumExplodePercent();
        double d12 = d11 / (1.0 + d11);
        double d13 = ((RectangularShape)double_2).getWidth() * d12;
        double d14 = ((RectangularShape)double_2).getHeight() * d12;
        Rectangle2D.Double double_3 = new Rectangle2D.Double(((RectangularShape)double_2).getX() + d13 / 2.0, ((RectangularShape)double_2).getY() + d14 / 2.0, ((RectangularShape)double_2).getWidth() - d13, ((RectangularShape)double_2).getHeight() - d14);
        piePlotState.setPieArea(double_3);
        piePlotState.setPieCenterX(double_3.getCenterX());
        piePlotState.setPieCenterY(double_3.getCenterY());
        piePlotState.setPieWRadius(((RectangularShape)double_3).getWidth() / 2.0);
        piePlotState.setPieHRadius(((RectangularShape)double_3).getHeight() / 2.0);
        if (this.dataset != null && this.dataset.getKeys().size() > 0) {
            List list = this.dataset.getKeys();
            double d15 = DatasetUtilities.calculatePieDatasetTotal((PieDataset)this.dataset);
            int n = piePlotState.getPassesRequired();
            for (int i = 0; i < n; ++i) {
                double d16 = 0.0;
                for (int j = 0; j < list.size(); ++j) {
                    double d17;
                    Number number = this.dataset.getValue(j);
                    if (number == null || !((d17 = number.doubleValue()) > 0.0)) continue;
                    d16 += d17;
                    this.drawItem(graphics2D, j, double_2, piePlotState, i);
                }
            }
            this.drawLabels(graphics2D, list, d15, rectangle2D, double_, piePlotState);
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
    }

    protected void drawItem(Graphics2D graphics2D, int n, Rectangle2D rectangle2D, PiePlotState piePlotState, int n2) {
        Number number = this.dataset.getValue(n);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.direction == Rotation.CLOCKWISE) {
            d2 = piePlotState.getLatestAngle();
            d3 = d2 - d / piePlotState.getTotal() * 360.0;
        } else if (this.direction == Rotation.ANTICLOCKWISE) {
            d2 = piePlotState.getLatestAngle();
            d3 = d2 + d / piePlotState.getTotal() * 360.0;
        } else {
            throw new IllegalStateException("Rotation type not recognised.");
        }
        double d4 = d3 - d2;
        if (Math.abs(d4) > this.getMinimumArcAngleToDraw()) {
            double d5 = 0.0;
            double d6 = this.getMaximumExplodePercent();
            if (d6 > 0.0) {
                d5 = this.getExplodePercent(n) / d6;
            }
            Rectangle2D rectangle2D2 = this.getArcBounds(piePlotState.getPieArea(), piePlotState.getExplodedPieArea(), d2, d4, d5);
            Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, d2, d4, 2);
            if (n2 == 0) {
                if (this.shadowPaint != null) {
                    Shape shape = ShapeUtilities.createTranslatedShape((Shape)double_, (double)((float)this.shadowXOffset), (double)((float)this.shadowYOffset));
                    graphics2D.setPaint(this.shadowPaint);
                    graphics2D.fill(shape);
                }
            } else if (n2 == 1) {
                EntityCollection entityCollection;
                Paint paint = this.getSectionPaint(n);
                graphics2D.setPaint(paint);
                graphics2D.fill(double_);
                Paint paint2 = this.getSectionOutlinePaint(n);
                Stroke stroke = this.getSectionOutlineStroke(n);
                if (this.sectionOutlinesVisible) {
                    graphics2D.setPaint(paint2);
                    graphics2D.setStroke(stroke);
                    graphics2D.draw(double_);
                }
                if (piePlotState.getInfo() != null && (entityCollection = piePlotState.getEntityCollection()) != null) {
                    Comparable comparable = this.dataset.getKey(n);
                    String string = null;
                    if (this.toolTipGenerator != null) {
                        string = this.toolTipGenerator.generateToolTip(this.dataset, comparable);
                    }
                    String string2 = null;
                    if (this.urlGenerator != null) {
                        string2 = this.urlGenerator.generateURL(this.dataset, comparable, this.pieIndex);
                    }
                    PieSectionEntity pieSectionEntity = new PieSectionEntity(double_, this.dataset, this.pieIndex, n, comparable, string, string2);
                    entityCollection.add(pieSectionEntity);
                }
            }
        }
        piePlotState.setLatestAngle(d3);
    }

    protected void drawLabels(Graphics2D graphics2D, List list, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PiePlotState piePlotState) {
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        DefaultKeyedValues defaultKeyedValues2 = new DefaultKeyedValues();
        double d2 = 0.0;
        for (Comparable comparable : list) {
            Number number = this.dataset.getValue(comparable);
            if (number == null) continue;
            double d3 = number.doubleValue();
            if (!(this.ignoreZeroValues ? d3 > 0.0 : d3 >= 0.0)) continue;
            double d4 = this.startAngle + this.direction.getFactor() * (((d2 += d3) - d3 / 2.0) * 360.0) / d;
            if (Math.cos(Math.toRadians(d4)) < 0.0) {
                defaultKeyedValues.addValue(comparable, (Number)new Double(d4));
                continue;
            }
            defaultKeyedValues2.addValue(comparable, (Number)new Double(d4));
        }
        graphics2D.setFont(this.getLabelFont());
        float f = (float)(this.getMaximumLabelWidth() * rectangle2D.getWidth());
        if (this.labelGenerator != null) {
            this.drawLeftLabels((KeyedValues)defaultKeyedValues, graphics2D, rectangle2D, rectangle2D2, f, piePlotState);
            this.drawRightLabels((KeyedValues)defaultKeyedValues2, graphics2D, rectangle2D, rectangle2D2, f, piePlotState);
        }
        graphics2D.setComposite(composite);
    }

    protected void drawLeftLabels(KeyedValues keyedValues, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, float f, PiePlotState piePlotState) {
        int n;
        PieLabelDistributor pieLabelDistributor = new PieLabelDistributor(keyedValues.getItemCount());
        double d = rectangle2D.getWidth() * this.labelGap;
        double d2 = piePlotState.getLinkArea().getHeight() / 2.0;
        for (n = 0; n < keyedValues.getItemCount(); ++n) {
            String string = this.labelGenerator.generateSectionLabel(this.dataset, keyedValues.getKey(n));
            if (string == null) continue;
            TextBlock textBlock = TextUtilities.createTextBlock((String)string, (Font)this.labelFont, (Paint)this.labelPaint, (float)f, (TextMeasurer)new G2TextMeasurer(graphics2D));
            TextBox textBox = new TextBox(textBlock);
            textBox.setBackgroundPaint(this.labelBackgroundPaint);
            textBox.setOutlinePaint(this.labelOutlinePaint);
            textBox.setOutlineStroke(this.labelOutlineStroke);
            textBox.setShadowPaint(this.labelShadowPaint);
            double d3 = Math.toRadians(keyedValues.getValue(n).doubleValue());
            double d4 = piePlotState.getPieCenterY() - Math.sin(d3) * d2;
            double d5 = textBox.getHeight(graphics2D);
            pieLabelDistributor.addPieLabelRecord(new PieLabelRecord(keyedValues.getKey(n), d3, d4, textBox, d5, d / 2.0 + d / 2.0 * -Math.cos(d3), 0.9 + this.getExplodePercent(this.dataset.getIndex(keyedValues.getKey(n)))));
        }
        pieLabelDistributor.distributeLabels(rectangle2D.getMinY(), rectangle2D.getHeight());
        for (n = 0; n < pieLabelDistributor.getItemCount(); ++n) {
            this.drawLeftLabel(graphics2D, piePlotState, pieLabelDistributor.getPieLabelRecord(n));
        }
    }

    protected void drawRightLabels(KeyedValues keyedValues, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, float f, PiePlotState piePlotState) {
        int n;
        PieLabelDistributor pieLabelDistributor = new PieLabelDistributor(keyedValues.getItemCount());
        double d = rectangle2D.getWidth() * this.labelGap;
        double d2 = piePlotState.getLinkArea().getHeight() / 2.0;
        for (n = 0; n < keyedValues.getItemCount(); ++n) {
            String string = this.labelGenerator.generateSectionLabel(this.dataset, keyedValues.getKey(n));
            if (string == null) continue;
            TextBlock textBlock = TextUtilities.createTextBlock((String)string, (Font)this.labelFont, (Paint)this.labelPaint, (float)f, (TextMeasurer)new G2TextMeasurer(graphics2D));
            TextBox textBox = new TextBox(textBlock);
            textBox.setBackgroundPaint(this.labelBackgroundPaint);
            textBox.setOutlinePaint(this.labelOutlinePaint);
            textBox.setOutlineStroke(this.labelOutlineStroke);
            textBox.setShadowPaint(this.labelShadowPaint);
            double d3 = Math.toRadians(keyedValues.getValue(n).doubleValue());
            double d4 = piePlotState.getPieCenterY() - Math.sin(d3) * d2;
            double d5 = textBox.getHeight(graphics2D);
            pieLabelDistributor.addPieLabelRecord(new PieLabelRecord(keyedValues.getKey(n), d3, d4, textBox, d5, d / 2.0 + d / 2.0 * Math.cos(d3), 0.9 + this.getExplodePercent(this.dataset.getIndex(keyedValues.getKey(n)))));
        }
        pieLabelDistributor.distributeLabels(rectangle2D2.getMinY(), rectangle2D2.getHeight());
        for (n = 0; n < pieLabelDistributor.getItemCount(); ++n) {
            this.drawRightLabel(graphics2D, piePlotState, pieLabelDistributor.getPieLabelRecord(n));
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.dataset == null) {
            return legendItemCollection;
        }
        List list = this.dataset.getKeys();
        int n = 0;
        Shape shape = this.getLegendItemShape();
        for (Comparable comparable : list) {
            String string;
            Number number = this.dataset.getValue(comparable);
            boolean bl = true;
            if (number == null) {
                bl = !this.ignoreNullValues;
            } else {
                double d = number.doubleValue();
                if (d == 0.0) {
                    bl = !this.ignoreZeroValues;
                } else {
                    boolean bl2 = bl = d > 0.0;
                }
            }
            if (!bl) continue;
            String string2 = string = this.legendLabelGenerator.generateSectionLabel(this.dataset, comparable);
            String string3 = null;
            if (this.legendLabelToolTipGenerator != null) {
                string3 = this.legendLabelToolTipGenerator.generateSectionLabel(this.dataset, comparable);
            }
            String string4 = null;
            Paint paint = this.getSectionPaint(n);
            Paint paint2 = this.getSectionOutlinePaint(n);
            Stroke stroke = this.getSectionOutlineStroke(n);
            LegendItem legendItem = new LegendItem(string, string2, string3, string4, true, shape, true, paint, true, paint2, stroke, false, (Shape)new Line2D.Float(), (Stroke)new BasicStroke(), (Paint)Color.black);
            legendItemCollection.add(legendItem);
            ++n;
        }
        return legendItemCollection;
    }

    public String getPlotType() {
        return localizationResources.getString("Pie_Plot");
    }

    public void zoom(double d) {
    }

    protected Rectangle2D getArcBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d, double d2, double d3) {
        if (d3 == 0.0) {
            return rectangle2D;
        }
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D, d, d2 / 2.0, 0);
        Point2D point2D = double_.getEndPoint();
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D2, d, d2 / 2.0, 0);
        Point2D point2D2 = double_2.getEndPoint();
        double d4 = (point2D.getX() - point2D2.getX()) * d3;
        double d5 = (point2D.getY() - point2D2.getY()) * d3;
        return new Rectangle2D.Double(rectangle2D.getX() - d4, rectangle2D.getY() - d5, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected void drawLeftLabel(Graphics2D graphics2D, PiePlotState piePlotState, PieLabelRecord pieLabelRecord) {
        double d = piePlotState.getLinkArea().getMinX();
        double d2 = d - pieLabelRecord.getGap();
        double d3 = pieLabelRecord.getAllocatedY();
        if (this.labelLinksVisible) {
            double d4;
            double d5 = pieLabelRecord.getAngle();
            double d6 = piePlotState.getPieCenterX() + Math.cos(d5) * piePlotState.getPieWRadius() * pieLabelRecord.getLinkPercent();
            double d7 = piePlotState.getPieCenterY() - Math.sin(d5) * piePlotState.getPieHRadius() * pieLabelRecord.getLinkPercent();
            double d8 = piePlotState.getPieCenterX() + Math.cos(d5) * piePlotState.getLinkArea().getWidth() / 2.0;
            double d9 = d4 = piePlotState.getPieCenterY() - Math.sin(d5) * piePlotState.getLinkArea().getHeight() / 2.0;
            graphics2D.setPaint(this.labelLinkPaint);
            graphics2D.setStroke(this.labelLinkStroke);
            graphics2D.draw(new Line2D.Double(d6, d7, d8, d4));
            graphics2D.draw(new Line2D.Double(d, d9, d8, d4));
            graphics2D.draw(new Line2D.Double(d, d9, d2, d3));
        }
        TextBox textBox = pieLabelRecord.getLabel();
        textBox.draw(graphics2D, (float)d2, (float)d3, RectangleAnchor.RIGHT);
    }

    protected void drawRightLabel(Graphics2D graphics2D, PiePlotState piePlotState, PieLabelRecord pieLabelRecord) {
        double d = piePlotState.getLinkArea().getMaxX();
        double d2 = d + pieLabelRecord.getGap();
        double d3 = pieLabelRecord.getAllocatedY();
        if (this.labelLinksVisible) {
            double d4;
            double d5 = pieLabelRecord.getAngle();
            double d6 = piePlotState.getPieCenterX() + Math.cos(d5) * piePlotState.getPieWRadius() * pieLabelRecord.getLinkPercent();
            double d7 = piePlotState.getPieCenterY() - Math.sin(d5) * piePlotState.getPieHRadius() * pieLabelRecord.getLinkPercent();
            double d8 = piePlotState.getPieCenterX() + Math.cos(d5) * piePlotState.getLinkArea().getWidth() / 2.0;
            double d9 = d4 = piePlotState.getPieCenterY() - Math.sin(d5) * piePlotState.getLinkArea().getHeight() / 2.0;
            graphics2D.setPaint(this.labelLinkPaint);
            graphics2D.setStroke(this.labelLinkStroke);
            graphics2D.draw(new Line2D.Double(d6, d7, d8, d4));
            graphics2D.draw(new Line2D.Double(d, d9, d8, d4));
            graphics2D.draw(new Line2D.Double(d, d9, d2, d3));
        }
        TextBox textBox = pieLabelRecord.getLabel();
        textBox.draw(graphics2D, (float)d2, (float)d3, RectangleAnchor.LEFT);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PiePlot)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        PiePlot piePlot = (PiePlot)object;
        if (this.pieIndex != piePlot.pieIndex) {
            return false;
        }
        if (this.interiorGap != piePlot.interiorGap) {
            return false;
        }
        if (this.circular != piePlot.circular) {
            return false;
        }
        if (this.startAngle != piePlot.startAngle) {
            return false;
        }
        if (this.direction != piePlot.direction) {
            return false;
        }
        if (this.ignoreZeroValues != piePlot.ignoreZeroValues) {
            return false;
        }
        if (this.ignoreNullValues != piePlot.ignoreNullValues) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.sectionPaint, (Paint)piePlot.sectionPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.sectionPaintList, (Object)piePlot.sectionPaintList)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.baseSectionPaint, (Paint)piePlot.baseSectionPaint)) {
            return false;
        }
        if (this.sectionOutlinesVisible != piePlot.sectionOutlinesVisible) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.sectionOutlinePaint, (Paint)piePlot.sectionOutlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.sectionOutlinePaintList, (Object)piePlot.sectionOutlinePaintList)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.baseSectionOutlinePaint, (Paint)piePlot.baseSectionOutlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.sectionOutlineStroke, (Object)piePlot.sectionOutlineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.sectionOutlineStrokeList, (Object)piePlot.sectionOutlineStrokeList)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.baseSectionOutlineStroke, (Object)piePlot.baseSectionOutlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.shadowPaint, (Paint)piePlot.shadowPaint)) {
            return false;
        }
        if (this.shadowXOffset != piePlot.shadowXOffset) {
            return false;
        }
        if (this.shadowYOffset != piePlot.shadowYOffset) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.explodePercentages, (Object)piePlot.explodePercentages)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.labelGenerator, (Object)piePlot.labelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.labelFont, (Object)piePlot.labelFont)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.labelPaint, (Paint)piePlot.labelPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.labelBackgroundPaint, (Paint)piePlot.labelBackgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.labelOutlinePaint, (Paint)piePlot.labelOutlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.labelOutlineStroke, (Object)piePlot.labelOutlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.labelShadowPaint, (Paint)piePlot.labelShadowPaint)) {
            return false;
        }
        if (this.maximumLabelWidth != piePlot.maximumLabelWidth) {
            return false;
        }
        if (this.labelGap != piePlot.labelGap) {
            return false;
        }
        if (this.labelLinkMargin != piePlot.labelLinkMargin) {
            return false;
        }
        if (this.labelLinksVisible != piePlot.labelLinksVisible) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.labelLinkPaint, (Paint)piePlot.labelLinkPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.labelLinkStroke, (Object)piePlot.labelLinkStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.toolTipGenerator, (Object)piePlot.toolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.urlGenerator, (Object)piePlot.urlGenerator)) {
            return false;
        }
        if (this.minimumArcAngleToDraw != piePlot.minimumArcAngleToDraw) {
            return false;
        }
        return ShapeUtilities.equal((Shape)this.legendItemShape, (Shape)piePlot.legendItemShape);
    }

    public Object clone() throws CloneNotSupportedException {
        PiePlot piePlot = (PiePlot)super.clone();
        if (piePlot.dataset != null) {
            piePlot.dataset.addChangeListener((DatasetChangeListener)piePlot);
        }
        return piePlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.sectionPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.baseSectionPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.sectionOutlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.baseSectionOutlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.sectionOutlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.baseSectionOutlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.shadowPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.labelPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.labelBackgroundPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.labelOutlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.labelOutlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.labelShadowPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.labelLinkPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.labelLinkStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeShape((Shape)this.legendItemShape, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.sectionPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.baseSectionPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.sectionOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.baseSectionOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.sectionOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.baseSectionOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.shadowPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.labelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.labelBackgroundPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.labelOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.labelOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.labelShadowPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.labelLinkPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.labelLinkStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.legendItemShape = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
    }

    public void dispose() {
        this.setDataset(null);
    }
}

