/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Stack;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class StackedXYAreaRenderer
extends XYAreaRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 5217394318178570889L;
    private transient Paint shapePaint = null;
    private transient Stroke shapeStroke = null;

    public StackedXYAreaRenderer() {
        this(4);
    }

    public StackedXYAreaRenderer(int n) {
        this(n, null, null);
    }

    public StackedXYAreaRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(n, xYToolTipGenerator, xYURLGenerator);
    }

    public Paint getShapePaint() {
        return this.shapePaint;
    }

    public Stroke getShapeStroke() {
        return this.shapeStroke;
    }

    public void setShapePaint(Paint paint) {
        this.shapePaint = paint;
    }

    public void setShapeStroke(Stroke stroke) {
        this.shapeStroke = stroke;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        return new StackedXYAreaRendererState(plotRenderingInfo);
    }

    public int getPassCount() {
        return 2;
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset != null) {
            return DatasetUtilities.findStackedRangeBounds((TableXYDataset)((TableXYDataset)xYDataset));
        }
        return null;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        StackedXYAreaRendererState stackedXYAreaRendererState = (StackedXYAreaRendererState)xYItemRendererState;
        TableXYDataset tableXYDataset = (TableXYDataset)xYDataset;
        int n4 = tableXYDataset.getItemCount();
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        boolean bl = false;
        if (Double.isNaN(d2)) {
            d2 = 0.0;
            bl = true;
        }
        double d3 = this.getPreviousHeight(tableXYDataset, n, n2);
        double d4 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        double d5 = valueAxis2.valueToJava2D(d2 + d3, rectangle2D, xYPlot.getRangeAxisEdge());
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        if (n3 == 0) {
            if (n2 == 0) {
                stackedXYAreaRendererState.setSeriesArea(new Polygon());
                stackedXYAreaRendererState.setLastSeriesPoints(stackedXYAreaRendererState.getCurrentSeriesPoints());
                stackedXYAreaRendererState.setCurrentSeriesPoints(new Stack());
                double d6 = valueAxis2.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    stackedXYAreaRendererState.getSeriesArea().addPoint((int)d4, (int)d6);
                } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    stackedXYAreaRendererState.getSeriesArea().addPoint((int)d6, (int)d4);
                }
            }
            if (plotOrientation == PlotOrientation.VERTICAL) {
                Point point = new Point((int)d4, (int)d5);
                stackedXYAreaRendererState.getSeriesArea().addPoint((int)point.getX(), (int)point.getY());
                stackedXYAreaRendererState.getCurrentSeriesPoints().push(point);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                stackedXYAreaRendererState.getSeriesArea().addPoint((int)d5, (int)d4);
            }
            if (this.getPlotLines() && n2 > 0) {
                double d7 = xYDataset.getXValue(n, n2 - 1);
                double d8 = xYDataset.getYValue(n, n2 - 1);
                double d9 = this.getPreviousHeight(tableXYDataset, n, n2 - 1);
                double d10 = valueAxis.valueToJava2D(d7, rectangle2D, xYPlot.getDomainAxisEdge());
                double d11 = valueAxis2.valueToJava2D(d8 + d9, rectangle2D, xYPlot.getRangeAxisEdge());
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    stackedXYAreaRendererState.getLine().setLine(d10, d11, d4, d5);
                } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    stackedXYAreaRendererState.getLine().setLine(d11, d10, d5, d4);
                }
                graphics2D.draw(stackedXYAreaRendererState.getLine());
            }
            if (this.getPlotArea() && n2 > 0 && n2 == n4 - 1) {
                double d12 = valueAxis2.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    stackedXYAreaRendererState.getSeriesArea().addPoint((int)d4, (int)d12);
                } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    stackedXYAreaRendererState.getSeriesArea().addPoint((int)d12, (int)d4);
                }
                if (n != 0) {
                    Stack stack = stackedXYAreaRendererState.getLastSeriesPoints();
                    while (!stack.empty()) {
                        Point point = (Point)stack.pop();
                        stackedXYAreaRendererState.getSeriesArea().addPoint((int)point.getX(), (int)point.getY());
                    }
                }
                graphics2D.setPaint(paint);
                graphics2D.setStroke(stroke);
                graphics2D.fill(stackedXYAreaRendererState.getSeriesArea());
                if (this.isOutline()) {
                    graphics2D.setStroke(this.getSeriesOutlineStroke(n));
                    graphics2D.setPaint(this.getSeriesOutlinePaint(n));
                    graphics2D.draw(stackedXYAreaRendererState.getSeriesArea());
                }
            }
            this.updateCrosshairValues(crosshairState, d, d2, d4, d5, plotOrientation);
        } else if (n3 == 1) {
            EntityCollection entityCollection;
            Shape shape = null;
            if (this.getPlotShapes()) {
                shape = this.getItemShape(n, n2);
                if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                    shape = ShapeUtilities.createTranslatedShape((Shape)shape, (double)d4, (double)d5);
                } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    shape = ShapeUtilities.createTranslatedShape((Shape)shape, (double)d5, (double)d4);
                }
                if (!bl) {
                    if (this.getShapePaint() != null) {
                        graphics2D.setPaint(this.getShapePaint());
                    } else {
                        graphics2D.setPaint(paint);
                    }
                    if (this.getShapeStroke() != null) {
                        graphics2D.setStroke(this.getShapeStroke());
                    } else {
                        graphics2D.setStroke(stroke);
                    }
                    graphics2D.draw(shape);
                }
            } else if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                shape = new Rectangle2D.Double(d4 - 3.0, d5 - 3.0, 6.0, 6.0);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                shape = new Rectangle2D.Double(d5 - 3.0, d4 - 3.0, 6.0, 6.0);
            }
            if (xYItemRendererState.getInfo() != null && (entityCollection = xYItemRendererState.getEntityCollection()) != null && shape != null && !bl) {
                String string = null;
                XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
                if (xYToolTipGenerator != null) {
                    string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
                }
                XYItemEntity xYItemEntity = new XYItemEntity(shape, xYDataset, n, n2, string, string2);
                entityCollection.add(xYItemEntity);
            }
        }
    }

    protected double getPreviousHeight(TableXYDataset tableXYDataset, int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = tableXYDataset.getYValue(i, n2);
            if (Double.isNaN(d2)) continue;
            d += d2;
        }
        return d;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedXYAreaRenderer) || !super.equals(object)) {
            return false;
        }
        StackedXYAreaRenderer stackedXYAreaRenderer = (StackedXYAreaRenderer)object;
        if (!PaintUtilities.equal((Paint)this.shapePaint, (Paint)stackedXYAreaRenderer.shapePaint)) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.shapeStroke, (Object)stackedXYAreaRenderer.shapeStroke);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.shapePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.shapeStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.shapePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.shapeStroke, (ObjectOutputStream)objectOutputStream);
    }

    static class StackedXYAreaRendererState
    extends XYItemRendererState {
        private Polygon seriesArea = null;
        private Line2D line = null;
        private Stack lastSeriesPoints = new Stack();
        private Stack currentSeriesPoints = new Stack();

        public StackedXYAreaRendererState(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }

        public Polygon getSeriesArea() {
            return this.seriesArea;
        }

        public void setSeriesArea(Polygon polygon) {
            this.seriesArea = polygon;
        }

        public Line2D getLine() {
            return this.line;
        }

        public Stack getCurrentSeriesPoints() {
            return this.currentSeriesPoints;
        }

        public void setCurrentSeriesPoints(Stack stack) {
            this.currentSeriesPoints = stack;
        }

        public Stack getLastSeriesPoints() {
            return this.lastSeriesPoints;
        }

        public void setLastSeriesPoints(Stack stack) {
            this.lastSeriesPoints = stack;
        }
    }
}

