/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.jocl;

import de.grogra.gpuflux.FluxSettings;
import de.grogra.gpuflux.jocl.JOCLDevice;
import de.grogra.gpuflux.jocl.JOCLDeviceFilter;
import java.util.AbstractList;
import java.util.ArrayList;
import org.jocl.cl_device_id;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOCLSingleDeviceFilter
implements JOCLDeviceFilter {
    private boolean GPU = FluxSettings.getOCLGPU();
    private cl_device_id device_id;

    @Override
    public void init() {
        this.device_id = null;
    }

    @Override
    public void filter(cl_device_id cl_device_id2) {
        if (cl_device_id2 == null) {
            return;
        }
        long l = JOCLDevice.getDeviceType(cl_device_id2);
        if ((l & 0xCL) != 0L && !this.GPU) {
            return;
        }
        if (this.device_id == null) {
            this.device_id = cl_device_id2;
            return;
        }
        long l2 = JOCLDevice.getDeviceType(this.device_id);
        if ((l & 0xCL) != 0L) {
            if ((l2 & 2L) != 0L) {
                this.device_id = cl_device_id2;
                return;
            }
            if ((l & 1L) != 0L) {
                this.device_id = cl_device_id2;
                return;
            }
        }
    }

    @Override
    public AbstractList<cl_device_id> getDevices() {
        if (this.device_id == null) {
            return null;
        }
        ArrayList<cl_device_id> arrayList = new ArrayList<cl_device_id>(1);
        arrayList.add(this.device_id);
        return arrayList;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JOCLSingleDeviceFilter)) {
            return false;
        }
        JOCLSingleDeviceFilter jOCLSingleDeviceFilter = (JOCLSingleDeviceFilter)object;
        return jOCLSingleDeviceFilter.GPU == this.GPU;
    }
}

