/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.jocl.compute;

import de.grogra.gpuflux.utils.ByteArray;
import java.io.IOException;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;

public class ComputeByteBuffer {
    private ComputeByteArray littleEndianBuffer;
    private ComputeByteArray bigEndianBuffer;

    public ByteArray getLittleEndianBuffer() {
        return this.littleEndianBuffer;
    }

    public ByteArray getBigEndianBuffer() {
        return this.bigEndianBuffer;
    }

    public ComputeByteBuffer(boolean bl, boolean bl2) {
        if (bl) {
            this.littleEndianBuffer = new ComputeByteArray(){

                public void writeInt(int n) throws IOException {
                    this.allign(4);
                    this.write(this.getByte(n, 0));
                    this.write(this.getByte(n, 1));
                    this.write(this.getByte(n, 2));
                    this.write(this.getByte(n, 3));
                }

                public void writeLong(long l) throws IOException {
                    this.allign(8);
                    this.writeInt(this.getInt(l, 0));
                    this.writeInt(this.getInt(l, 1));
                }

                public void writeShort(int n) throws IOException {
                    this.allign(2);
                    this.write(this.getByte(n, 0));
                    this.write(this.getByte(n, 1));
                }
            };
        }
        if (bl2) {
            this.bigEndianBuffer = new ComputeByteArray(){

                public void writeInt(int n) throws IOException {
                    this.allign(4);
                    this.write(this.getByte(n, 3));
                    this.write(this.getByte(n, 2));
                    this.write(this.getByte(n, 1));
                    this.write(this.getByte(n, 0));
                }

                public void writeLong(long l) throws IOException {
                    this.allign(8);
                    this.writeInt(this.getInt(l, 1));
                    this.writeInt(this.getInt(l, 0));
                }

                public void writeShort(int n) throws IOException {
                    this.allign(2);
                    this.write(this.getByte(n, 1));
                    this.write(this.getByte(n, 0));
                }
            };
        }
    }

    public void reset() {
        if (this.littleEndianBuffer != null) {
            this.littleEndianBuffer.reset();
        }
        if (this.bigEndianBuffer != null) {
            this.bigEndianBuffer.reset();
        }
    }

    public void writeDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        this.writeLong(l);
    }

    public void writeFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        this.writeInt(n);
    }

    public void writeFloat(double d) throws IOException {
        int n = Float.floatToIntBits((float)d);
        this.writeInt(n);
    }

    public void writeInt(int n) throws IOException {
        if (this.littleEndianBuffer != null) {
            this.littleEndianBuffer.writeInt(n);
        }
        if (this.bigEndianBuffer != null) {
            this.bigEndianBuffer.writeInt(n);
        }
    }

    public void writeLong(long l) throws IOException {
        if (this.littleEndianBuffer != null) {
            this.littleEndianBuffer.writeLong(l);
        }
        if (this.bigEndianBuffer != null) {
            this.bigEndianBuffer.writeLong(l);
        }
    }

    public void writeShort(int n) throws IOException {
        if (this.littleEndianBuffer != null) {
            this.littleEndianBuffer.writeShort(n);
        }
        if (this.bigEndianBuffer != null) {
            this.bigEndianBuffer.writeShort(n);
        }
    }

    public int size() {
        if (this.littleEndianBuffer != null) {
            return this.littleEndianBuffer.size();
        }
        if (this.bigEndianBuffer != null) {
            return this.bigEndianBuffer.size();
        }
        return 0;
    }

    public void write(byte[] byArray) throws IOException {
        if (this.littleEndianBuffer != null) {
            this.littleEndianBuffer.write(byArray);
        }
        if (this.bigEndianBuffer != null) {
            this.bigEndianBuffer.write(byArray);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.littleEndianBuffer != null) {
            this.littleEndianBuffer.write(byArray, n, n2);
        }
        if (this.bigEndianBuffer != null) {
            this.bigEndianBuffer.write(byArray, n, n2);
        }
    }

    public void write(byte by) throws IOException {
        if (this.littleEndianBuffer != null) {
            this.littleEndianBuffer.write(by);
        }
        if (this.bigEndianBuffer != null) {
            this.bigEndianBuffer.write(by);
        }
    }

    public void write(Tuple2f tuple2f) throws IOException {
        this.writeFloat(tuple2f.x);
        this.writeFloat(tuple2f.y);
    }

    public void write(Tuple3f tuple3f) throws IOException {
        this.writeFloat(tuple3f.x);
        this.writeFloat(tuple3f.y);
        this.writeFloat(tuple3f.z);
    }

    public void write(Tuple3d tuple3d) throws IOException {
        this.writeFloat((float)tuple3d.x);
        this.writeFloat((float)tuple3d.y);
        this.writeFloat((float)tuple3d.z);
    }

    public void write(Tuple4d tuple4d) throws IOException {
        this.writeFloat((float)tuple4d.x);
        this.writeFloat((float)tuple4d.y);
        this.writeFloat((float)tuple4d.z);
    }

    public void write(Matrix3f matrix3f) throws IOException {
        this.writeFloat(matrix3f.m00);
        this.writeFloat(matrix3f.m01);
        this.writeFloat(matrix3f.m02);
        this.writeFloat(matrix3f.m10);
        this.writeFloat(matrix3f.m11);
        this.writeFloat(matrix3f.m12);
        this.writeFloat(matrix3f.m20);
        this.writeFloat(matrix3f.m21);
        this.writeFloat(matrix3f.m22);
    }

    public void write(Matrix4f matrix4f) throws IOException {
        this.writeFloat(matrix4f.m00);
        this.writeFloat(matrix4f.m01);
        this.writeFloat(matrix4f.m02);
        this.writeFloat(matrix4f.m10);
        this.writeFloat(matrix4f.m11);
        this.writeFloat(matrix4f.m12);
        this.writeFloat(matrix4f.m20);
        this.writeFloat(matrix4f.m21);
        this.writeFloat(matrix4f.m22);
        this.writeFloat(matrix4f.m03);
        this.writeFloat(matrix4f.m13);
        this.writeFloat(matrix4f.m23);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.writeInt(bl ? -1 : 0);
    }

    public void write(int[] nArray) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            this.writeInt(nArray[i]);
        }
    }

    public ByteArray getBuffer(boolean bl) {
        if (bl) {
            return this.getLittleEndianBuffer();
        }
        return this.getBigEndianBuffer();
    }

    private abstract class ComputeByteArray
    extends ByteArray {
        private int written = 0;

        private ComputeByteArray() {
        }

        public int size() {
            return this.written;
        }

        public void reset() {
            super.reset();
            this.written = 0;
        }

        public void allign(int n) throws IOException {
            int n2 = this.written % n;
            if (n2 != 0) {
                throw new IOException("Non-alligned write in JOCL stream");
            }
        }

        public void write(byte[] byArray) throws IOException {
            super.write(byArray);
            this.written += byArray.length;
        }

        public void write(byte[] byArray, int n, int n2) {
            super.write(byArray, n, n2);
            this.written += byArray.length;
        }

        public void write(byte by) throws IOException {
            super.write(by);
            ++this.written;
        }

        protected byte getByte(int n, int n2) {
            return (byte)(n >> 8 * n2);
        }

        protected int getInt(long l, int n) {
            return (int)(l >> 32 * n);
        }

        public abstract void writeInt(int var1) throws IOException;

        public abstract void writeLong(long var1) throws IOException;

        public abstract void writeShort(int var1) throws IOException;
    }
}

