/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.BVH;

import de.grogra.vecmath.BoundingBox3d;

public class BVHNode {
    public int axis;
    public int idx;
    public int pcount;
    public BoundingBox3d bb;
    public BVHNode left;
    public BVHNode right;
    public int nidx;

    public BVHNode(int n, int n2, int n3, BoundingBox3d boundingBox3d, BVHNode bVHNode, BVHNode bVHNode2) {
        assert (!(bVHNode == null ^ bVHNode2 == null));
        this.axis = n;
        this.idx = n2;
        this.pcount = n3;
        this.bb = boundingBox3d.clone();
        this.left = bVHNode;
        this.right = bVHNode2;
    }

    public boolean isLeaf() {
        return this.left == null;
    }

    public double computeSAH(double d) {
        double d2 = this.bb.area();
        double d3 = this.bb.area() / d;
        double d4 = 1.0;
        if (this.isLeaf()) {
            d4 += d3 * (double)this.pcount * 10.0;
        } else {
            if (this.left != null) {
                d4 += d3 * this.left.computeSAH(d2);
            }
            if (this.right != null) {
                d4 += d3 * this.right.computeSAH(d2);
            }
        }
        return d4;
    }

    static BVHNode pruneEmptyNodes(BVHNode bVHNode) {
        if (bVHNode.isLeaf()) {
            if (bVHNode.pcount == 0) {
                return null;
            }
            return bVHNode;
        }
        bVHNode.left = BVHNode.pruneEmptyNodes(bVHNode.left);
        bVHNode.right = BVHNode.pruneEmptyNodes(bVHNode.right);
        if (bVHNode.left == null) {
            return bVHNode.right;
        }
        if (bVHNode.right == null) {
            return bVHNode.left;
        }
        return bVHNode;
    }

    void set(BVHNode bVHNode) {
        this.axis = bVHNode.axis;
        this.idx = bVHNode.idx;
        this.pcount = bVHNode.pcount;
        this.bb = bVHNode.bb;
        this.left = bVHNode.left;
        this.right = bVHNode.right;
        this.nidx = bVHNode.nidx;
    }
}

