/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene;

import de.grogra.gpuflux.scene.filter.ObjectFilter;
import de.grogra.gpuflux.scene.light.FluxLightBuilder;
import de.grogra.gpuflux.scene.shading.FluxShader;
import de.grogra.gpuflux.scene.shading.FluxShaderBuilder;
import de.grogra.gpuflux.scene.shading.channel.FluxChannelMap;
import de.grogra.gpuflux.scene.volume.FluxPrimitive;
import de.grogra.gpuflux.scene.volume.FluxSensor;
import de.grogra.gpuflux.scene.volume.FluxVolumeBuilder;
import de.grogra.graph.ArrayPath;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.Instantiator;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.DisplayVisitor;
import de.grogra.imp3d.IMP3D;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.ViewConfig3D;
import de.grogra.imp3d.Visitor3D;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.LightNode;
import de.grogra.imp3d.objects.SensorNode;
import de.grogra.imp3d.objects.Sky;
import de.grogra.imp3d.shading.AlgorithmSwitchShader;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.ShaderRef;
import de.grogra.math.Pool;
import de.grogra.ray.physics.Interior;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.ray2.ProgressMonitor;
import de.grogra.vecmath.geom.SensorDisc;
import de.grogra.vecmath.geom.TransformableVolume;
import de.grogra.vecmath.geom.Variables;
import de.grogra.xl.util.LongToIntHashMap;
import de.grogra.xl.util.ObjectList;
import java.util.Stack;
import java.util.Vector;
import javax.vecmath.Matrix4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluxSceneVisitor
extends DisplayVisitor {
    private ProgressMonitor monitor;
    private ObjectFilter measureFilter;
    private Graph graph;
    private boolean enableSensors;
    private String log = new String();
    private transient LongToIntHashMap nodeToGroup;
    private transient int grouping;
    private transient int nextGroupIndex;
    private transient int currentGroupIndex;
    private Renderable currentRenderable = null;
    private Shader currentShader = null;
    private float currentIOR = 1.0f;
    private Object currentObject = null;
    private Interior currentInterior = null;
    private long nextProgressTime = 0L;
    private FluxLightBuilder lightBuilder = null;
    private FluxVolumeBuilder volumeBuilder = null;
    private FluxShaderBuilder shaderBuilder = null;
    private ObjectList<Interior> interiorStack = new ObjectList();
    private Vector<FluxPrimitive> primitives = new Vector();
    private Vector<FluxPrimitive> infPrimitives = new Vector();
    private Vector<LightNode> lights = new Vector();
    private Vector<FluxSensor> sensors = new Vector();
    private boolean[] visibleLayers;

    public Vector<FluxPrimitive> getPrimitives() {
        return this.primitives;
    }

    public Vector<FluxSensor> getSensors() {
        return this.sensors;
    }

    public Vector<LightNode> getLights() {
        return this.lights;
    }

    public Vector<FluxPrimitive> getInfPrimitives() {
        return this.infPrimitives;
    }

    public LongToIntHashMap getNodeToGroup() {
        return this.nodeToGroup;
    }

    protected Shader resolveShader(Shader shader) {
        return shader instanceof AlgorithmSwitchShader ? ((AlgorithmSwitchShader)shader).getRaytracerShader() : (shader instanceof ShaderRef ? ((ShaderRef)shader).resolve() : shader);
    }

    protected boolean isInVisibleLayer(Object object, boolean bl) {
        if (this.visibleLayers == null) {
            return super.isInVisibleLayer(object, bl);
        }
        int n = this.state.getIntDefault(object, bl, Attributes.LAYER, 0);
        return n < 0 || n >= this.visibleLayers.length || this.visibleLayers[n];
    }

    public void visitScene(Graph graph, ViewConfig3D viewConfig3D, ObjectFilter objectFilter, boolean bl, boolean bl2, ProgressMonitor progressMonitor, float f, boolean[] blArray) {
        this.measureFilter = objectFilter;
        this.graph = graph;
        this.visibleLayers = blArray;
        this.monitor = progressMonitor;
        this.enableSensors = bl;
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        this.init(GraphState.current((Graph)graph), matrix4d, viewConfig3D, viewConfig3D != null);
        this.volumeBuilder = new FluxVolumeBuilder(this.state, f){
            private Pool pool;
            {
                this.pool = new Pool();
            }

            @Override
            protected void addPrimitive(FluxPrimitive fluxPrimitive) {
                FluxSceneVisitor.this.addPrimitive(fluxPrimitive);
            }

            @Override
            protected void addInfinitePrimitive(FluxPrimitive fluxPrimitive) {
                FluxSceneVisitor.this.addInfinitePrimitive(fluxPrimitive);
            }

            protected Matrix4d getCurrentTransformation() {
                return FluxSceneVisitor.this.getCurrentTransformation();
            }

            @Override
            public Shader getCurrentShader() {
                return FluxSceneVisitor.this.getCurrentShader();
            }

            @Override
            public GraphState getRenderGraphState() {
                return FluxSceneVisitor.this.getGraphState();
            }

            @Override
            public Pool getPool() {
                return this.pool;
            }

            @Override
            protected void addPrimitives(Vector<FluxPrimitive> vector) {
                FluxSceneVisitor.this.addPrimitives(vector);
            }
        };
        this.shaderBuilder = new FluxShaderBuilder(){

            protected void warning(String string) {
                FluxSceneVisitor.this.warning(string);
            }
        };
        this.lightBuilder = new FluxLightBuilder();
        this.nodeToGroup = new LongToIntHashMap();
        this.grouping = 0;
        this.nextGroupIndex = 1;
        this.currentGroupIndex = -1;
        long l = System.currentTimeMillis();
        graph.accept(null, (Visitor)this, null);
        this.volumeBuilder.finish();
        this.lightBuilder.finnish(bl2, viewConfig3D);
        l = System.currentTimeMillis() - l;
        Variables variables = new Variables();
        for (FluxPrimitive fluxVolume : this.primitives) {
            fluxVolume.computeExtent(variables);
        }
        for (FluxPrimitive fluxPrimitive : this.infPrimitives) {
            fluxPrimitive.computeExtent(variables);
        }
        for (FluxSensor fluxSensor : this.sensors) {
            fluxSensor.computeExtent(variables);
        }
    }

    private void addPrimitives(Vector<FluxPrimitive> vector) {
        if (vector.size() > 0) {
            int n = -1;
            if (this.measureFilter == null || this.measureFilter.filter(this.currentObject)) {
                this.addNodeToGroup(this.currentObject);
                n = this.currentGroupIndex;
            }
            this.primitives.addAll(vector);
            FluxShader fluxShader = this.shaderBuilder.buildShader(this.currentShader);
            for (int i = 0; i < vector.size(); ++i) {
                vector.get(i).setGroupIndex(n);
                vector.get(i).setOwner(this.currentRenderable);
                vector.get(i).setFluxShader(fluxShader);
                vector.get(i).setIOR(this.currentIOR);
            }
        }
    }

    private void setupPrimitive(FluxPrimitive fluxPrimitive) {
        int n = -1;
        if (this.measureFilter == null || this.measureFilter.filter(this.currentObject)) {
            this.addNodeToGroup(this.currentObject);
            n = this.currentGroupIndex;
        }
        fluxPrimitive.setGroupIndex(n);
        fluxPrimitive.setOwner(this.currentRenderable);
        fluxPrimitive.setFluxShader(this.shaderBuilder.buildShader(this.currentShader));
        fluxPrimitive.setIOR(this.currentIOR);
    }

    private void addPrimitive(FluxPrimitive fluxPrimitive) {
        long l;
        if (this.primitives.size() % 50 == 0 && (l = System.currentTimeMillis()) >= this.nextProgressTime) {
            this.nextProgressTime = l + 200L;
            this.monitor.setProgress(IMP3D.I18N.msg("ray.constructing-geometry", (Object)this.primitives.size()), -1.0f);
        }
        this.primitives.add(fluxPrimitive);
        this.setupPrimitive(fluxPrimitive);
    }

    private void addInfinitePrimitive(FluxPrimitive fluxPrimitive) {
        this.infPrimitives.add(fluxPrimitive);
        this.setupPrimitive(fluxPrimitive);
    }

    private void addNodeToGroup(Object object) {
        assert (this.lastEnteredIsNode);
        if (this.grouping == 0) {
            this.currentGroupIndex = this.nextGroupIndex++;
            this.nodeToGroup.put(((Node)object).getId(), this.currentGroupIndex);
        }
    }

    private void warning(String string) {
        this.log = this.log + "Warning, " + string + "\n";
    }

    private void log(String string) {
        this.log = this.log + "Log, " + string + "\n";
    }

    protected void visitImpl(Object object, boolean bl, Shader shader, Path path) {
        SensorNode sensorNode;
        Object object2;
        Interior interior = (Interior)this.state.getObjectDefault(object, bl, Attributes.INTERIOR, (Object)this.currentInterior);
        if (interior != null) {
            this.currentInterior = interior;
        } else {
            interior = this.currentInterior;
        }
        int n = this.getCurrentShader().getAverageColor();
        this.currentIOR = this.currentInterior != null ? this.currentInterior.getIndexOfRefraction((Spectrum)new Spectrum3d((double)((float)(n >> 16 & 0xFF) / 255.0f), (double)((float)(n >> 8 & 0xFF) / 255.0f), (double)((float)(n & 0xFF) / 255.0f))) : 1.0f;
        int n2 = this.state.getIntDefault(object, bl, Attributes.CSG_OPERATION, -1);
        if (n2 != -1) {
            this.warning("GPUFlux does not support CSG");
        }
        if ((object2 = this.state.getObjectDefault(object, bl, Attributes.SHAPE, null)) instanceof SensorNode) {
            double d;
            if (this.enableSensors && Math.abs(d = (double)(sensorNode = (SensorNode)object2).getRadius()) > (double)this.volumeBuilder.epsilon) {
                Matrix4d matrix4d = this.getCurrentTransformation();
                SensorDisc sensorDisc = new SensorDisc();
                this.volumeBuilder.setInvTransformation((TransformableVolume)sensorDisc, matrix4d, 0.0);
                d = 1.0 / d;
                sensorDisc.scale(d, d, d);
                int n3 = -1;
                this.addNodeToGroup(object);
                n3 = this.currentGroupIndex;
                this.sensors.add(new FluxSensor(sensorNode, sensorDisc, n3));
            }
        } else if (object2 instanceof Renderable && !(object2 instanceof Sky)) {
            this.currentRenderable = (Renderable)object2;
            this.currentObject = object;
            this.currentShader = shader;
            this.currentRenderable.draw(object, bl, (RenderState)this.volumeBuilder);
        }
        if (bl && object instanceof LightNode) {
            sensorNode = this.getCurrentTransformation();
            LightNode lightNode = (LightNode)object;
            this.lightBuilder.buildLight(lightNode.getLight(), (Matrix4d)sensorNode);
        }
        if (object2 instanceof Sky) {
            sensorNode = this.getCurrentTransformation();
            LightNode lightNode = new LightNode();
            lightNode.setLight((Light)((Sky)object2));
            lightNode.setTransform((Matrix4d)sensorNode);
            this.lightBuilder.buildLight(lightNode.getLight(), (Matrix4d)sensorNode);
        }
    }

    protected void visitEnterImpl(Object object, boolean bl, Path path) {
        if (this.measureFilter == null) {
            this.measureFilter.enter(object);
        }
        this.interiorStack.push((Object)this.currentInterior);
        super.visitEnterImpl(object, bl, path);
    }

    public Object visitInstanceEnter() {
        assert (this.lastEnteredIsNode);
        if (this.grouping == 0) {
            this.currentGroupIndex = this.nodeToGroup.get(((Node)this.lastEntered).getId());
            if (this.currentGroupIndex == 0) {
                this.currentGroupIndex = this.nextGroupIndex++;
                this.nodeToGroup.put(((Node)this.lastEntered).getId(), this.currentGroupIndex);
            }
        }
        ++this.grouping;
        return super.visitInstanceEnter();
    }

    public boolean visitInstanceLeave(Object object) {
        if (this.measureFilter == null) {
            this.measureFilter.leave(object);
        }
        if (--this.grouping < 0) {
            throw new IllegalStateException();
        }
        return super.visitInstanceLeave(object);
    }

    protected void visitLeaveImpl(Object object, boolean bl, Path path) {
        super.visitLeaveImpl(object, bl, path);
        this.currentInterior = (Interior)this.interiorStack.pop();
    }

    public int getGroupCount() {
        return this.currentGroupIndex + 1;
    }

    public Vector<FluxChannelMap> getChannels() {
        return this.shaderBuilder.getChannelBuilder().getChannels();
    }

    public Vector<FluxShader> getShaders() {
        return this.shaderBuilder.getShaders();
    }

    public String getLog() {
        return this.log;
    }

    public FluxLightBuilder getLightBuilder() {
        return this.lightBuilder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransformVisitor3D
    extends Visitor3D {
        TransformVisitor3D() {
        }

        protected void init(GraphState graphState) {
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.setIdentity();
            this.init(graphState, graphState.getGraph().getTreePattern(), matrix4d);
        }

        protected void visitEnterImpl(Object object, boolean bl, Path path) {
        }

        protected void visitLeaveImpl(Object object, boolean bl, Path path) {
        }

        public Matrix4d getGlobalTransformation(Node node) {
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.setIdentity();
            if (node == null) {
                return matrix4d;
            }
            Stack<Node> stack = new Stack<Node>();
            while (node != null) {
                stack.push(node);
                node = node.getSource();
            }
            Node node2 = (Node)stack.pop();
            ArrayPath arrayPath = new ArrayPath(FluxSceneVisitor.this.graph);
            return this.getGlobalTransformation(node2, stack, arrayPath);
        }

        private Matrix4d getGlobalTransformation(Node node, Stack<Node> stack, ArrayPath arrayPath) {
            Matrix4d matrix4d;
            arrayPath.pushNode((Object)node, node.getId() >= 0L ? node.getId() : (long)node.hashCode());
            this.visitEnter((Path)arrayPath, true);
            Instantiator instantiator = node.getInstantiator();
            if (instantiator != null) {
                this.state.beginInstancing((Object)node, arrayPath.getObjectId(-1));
                instantiator.instantiate(arrayPath, (Visitor)this);
            }
            if (!stack.empty()) {
                Node node2 = stack.pop();
                arrayPath.pushEdgeSet((Object)node.getEdgeTo(node2), -1L, false);
                matrix4d = this.getGlobalTransformation(node2, stack, arrayPath);
                arrayPath.popEdgeSet();
            } else {
                matrix4d = (Matrix4d)this.getCurrentTransformation().clone();
            }
            instantiator = node.getInstantiator();
            if (instantiator != null) {
                this.state.endInstancing();
            }
            this.visitLeave(node, (Path)arrayPath, true);
            arrayPath.popNode();
            return matrix4d;
        }
    }
}

