/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.light;

import de.grogra.gpuflux.FluxSettings;
import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.light.FluxLight;
import de.grogra.gpuflux.scene.shading.FluxShader;
import de.grogra.imp3d.objects.LightDistribution;
import de.grogra.imp3d.objects.Sky;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.SunSkyLight;
import de.grogra.math.RGBColor;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import java.io.IOException;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class FluxSkyLight
extends FluxLight {
    private Sky light;
    private FluxShader fluxShader;
    private Spectrum3d[][] spectrum_distribution;
    private double[][] pdf;
    private LightDistribution lightDistribution;

    public FluxSkyLight(Sky sky, FluxShader fluxShader) {
        super((Light)sky);
        this.light = sky;
        this.fluxShader = fluxShader;
    }

    private void discritizeSky() {
        int n = FluxSettings.getSkyResolution();
        Environment environment = new Environment();
        environment.point.set(0.0f, 0.0f, 0.0f);
        environment.localPoint.set(0.0f, 0.0f, 0.0f);
        environment.normal.set(0.0f, 0.0f, 1.0f);
        environment.dpdu.set(1.0f, 0.0f, 0.0f);
        environment.dpdv.set(0.0f, 1.0f, 0.0f);
        environment.solid = false;
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, -1.0f);
        Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, 1.0f);
        Spectrum3d spectrum3d = new Spectrum3d();
        this.spectrum_distribution = new Spectrum3d[n][n];
        this.pdf = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.spectrum_distribution[i][j] = new Spectrum3d();
                float f = (float)j / (float)n;
                float f2 = (float)i / (float)n;
                environment.uv.set(1.5f - f2, -f);
                LightDistribution.map2cartesian((Tuple3f)vector3f, f, f2);
                vector3f2.negate((Tuple3f)vector3f);
                environment.normal.set((Tuple3f)vector3f2);
                environment.localPoint.set((Tuple3f)vector3f);
                environment.userVector.set(1.0f, 1.0f, 1.0f);
                this.light.computeExitance(environment, (Spectrum)spectrum3d);
                this.light.computeBSDF(environment, vector3f, (Spectrum)spectrum3d, vector3f2, false, (Spectrum)this.spectrum_distribution[i][j]);
                this.pdf[i][j] = this.spectrum_distribution[i][j].integrate() / 3.0;
            }
        }
        this.lightDistribution = new LightDistribution(this.pdf);
    }

    public void serializeSkyRadiance(ComputeByteBuffer computeByteBuffer) throws IOException {
        double d = this.lightDistribution.getPower();
        computeByteBuffer.writeInt(this.spectrum_distribution.length);
        computeByteBuffer.writeInt(this.spectrum_distribution[0].length);
        for (int i = 0; i < this.spectrum_distribution.length; ++i) {
            for (int j = 0; j < this.spectrum_distribution[i].length; ++j) {
                computeByteBuffer.writeFloat((float)(this.spectrum_distribution[i][j].x / d));
                computeByteBuffer.writeFloat((float)(this.spectrum_distribution[i][j].y / d));
                computeByteBuffer.writeFloat((float)(this.spectrum_distribution[i][j].z / d));
            }
        }
    }

    public void serializeSky(ComputeByteBuffer computeByteBuffer) throws IOException {
        int n;
        double[][] dArray = this.lightDistribution.getDistribution();
        double[] dArray2 = this.lightDistribution.getLinearCDF();
        computeByteBuffer.writeInt(this.lightDistribution.getWidth());
        computeByteBuffer.writeInt(this.lightDistribution.getHeight());
        for (n = 0; n < this.lightDistribution.getHeight(); ++n) {
            for (int i = 0; i < this.lightDistribution.getWidth(); ++i) {
                computeByteBuffer.writeFloat((float)dArray[n][i]);
            }
        }
        for (n = 0; n < dArray2.length; ++n) {
            computeByteBuffer.writeFloat((float)dArray2[n]);
        }
    }

    public void serialize(ComputeByteBuffer computeByteBuffer) throws IOException {
        this.discritizeSky();
        double d = this.light.getPowerDensity();
        this.serializeLightBase(computeByteBuffer, 5, (Tuple3f)new RGBColor((float)d, (float)d, (float)d), null);
        if (this.fluxShader == null) {
            computeByteBuffer.writeInt(0);
        } else {
            computeByteBuffer.writeInt(this.fluxShader.getOffset());
        }
        computeByteBuffer.writeInt((2 + 2 * this.lightDistribution.getHeight() * this.lightDistribution.getWidth()) * 4);
        this.serializeSky(computeByteBuffer);
        this.serializeSkyRadiance(computeByteBuffer);
    }

    public int getSampleCount() {
        SunSkyLight sunSkyLight;
        Shader shader = this.light.getShader();
        if (shader instanceof SunSkyLight && (sunSkyLight = (SunSkyLight)shader).isDisableLight()) {
            return 0;
        }
        return 32;
    }
}

