/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.scene.light;

import de.grogra.gpuflux.jocl.compute.ComputeByteBuffer;
import de.grogra.gpuflux.scene.light.FluxPointLight;
import de.grogra.imp3d.objects.PointLight;
import de.grogra.imp3d.objects.SpotLight;
import de.grogra.math.RGBColor;
import java.io.IOException;
import javax.vecmath.Tuple3f;

public class FluxSpotLight
extends FluxPointLight {
    private SpotLight light;

    public FluxSpotLight(SpotLight spotLight) {
        super((PointLight)spotLight);
        this.light = spotLight;
    }

    public void serialize(ComputeByteBuffer computeByteBuffer) throws IOException {
        RGBColor rGBColor = (RGBColor)this.pointLight.getColor().clone();
        rGBColor.scale(3.0f * this.pointLight.getPower() / (rGBColor.x + rGBColor.y + rGBColor.z));
        this.serializeLightBase(computeByteBuffer, 2, (Tuple3f)rGBColor, null);
        computeByteBuffer.writeFloat(this.light.getInnerAngle());
        computeByteBuffer.writeFloat(this.light.getOuterAngle());
    }
}

