/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.tracer;

import de.grogra.gpuflux.FluxSettings;
import de.grogra.gpuflux.GPUFluxInit;
import de.grogra.gpuflux.jocl.JOCLBuffer;
import de.grogra.gpuflux.jocl.JOCLEvent;
import de.grogra.gpuflux.jocl.compute.Buffer;
import de.grogra.gpuflux.jocl.compute.ComputeContext;
import de.grogra.gpuflux.jocl.compute.Device;
import de.grogra.gpuflux.jocl.compute.Kernel;
import de.grogra.gpuflux.scene.FluxJOCLScene;
import de.grogra.gpuflux.scene.FluxScene;
import de.grogra.gpuflux.scene.FluxSceneSerializer;
import de.grogra.gpuflux.scene.filter.NoneFilter;
import de.grogra.gpuflux.tracer.FluxTracer;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.ViewConfig3D;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.AbstractList;
import java.util.Random;
import org.jocl.cl_event;

public class FluxLightTracer
extends FluxTracer {
    boolean terminate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void trace() throws IOException {
        DeviceMonitor[] deviceMonitorArray;
        long l;
        long l2;
        long l3;
        long l4;
        StringBuffer stringBuffer;
        block27: {
            block26: {
                stringBuffer = new StringBuffer("<html><pre>");
                stringBuffer.append("<B>GPUFlux Light Tracer</B>\n\n");
                l4 = 0L;
                l3 = 0L;
                l2 = 0L;
                l = 0L;
                deviceMonitorArray = null;
                try {
                    Object object;
                    int n;
                    this.setProgress("Build scene", -1.0f);
                    l4 = System.currentTimeMillis();
                    FluxScene fluxScene = new FluxScene();
                    fluxScene.buildSceneFromGraph(this.view.getGraph(), (ViewConfig3D)((View3D)this.view), new NoneFilter(), false, this, false, FluxSettings.getModelFlatness());
                    l4 = System.currentTimeMillis() - l4;
                    stringBuffer.append(fluxScene.getLog());
                    stringBuffer.append(fluxScene.getSceneStats());
                    this.setProgress("Init compute context", -1.0f);
                    ComputeContext computeContext = GPUFluxInit.initComputeContext(true, null);
                    stringBuffer.append(computeContext.aquireLog());
                    if (!computeContext.valid()) {
                        Object var43_9 = null;
                        stringBuffer.append("\n<B>Profile Summary</B>\n");
                        break block26;
                    }
                    AbstractList<Device> abstractList = computeContext.getDeviceList();
                    this.setProgress("Serialize scene", -1.0f);
                    l3 = System.currentTimeMillis();
                    FluxSceneSerializer fluxSceneSerializer = new FluxSceneSerializer();
                    FluxJOCLScene fluxJOCLScene = new FluxJOCLScene(fluxSceneSerializer, computeContext);
                    fluxSceneSerializer.serializeScene(fluxScene);
                    fluxJOCLScene.setupOCLBounds();
                    fluxJOCLScene.setupOCLScene(this.useBih);
                    fluxJOCLScene.setupOCLCamera(this.width, this.height);
                    fluxJOCLScene.setupOCLLights();
                    l3 = System.currentTimeMillis() - l3;
                    this.setProgress("Load kernel", -1.0f);
                    Kernel kernel = computeContext.createKernel("kernel/lt_kernel.cl", "computeImage", this.getKernelCompilationArguments(true, true));
                    int n2 = FluxSettings.getRenderDepth();
                    double d = FluxSettings.getOCLPreferredDuration();
                    float f = FluxSettings.getRenderMinPower();
                    int n3 = FluxSettings.getOCLInitialSampleCount();
                    int n4 = n = FluxSettings.getOCLMaximumSampleCount();
                    int n5 = Math.min(n3, this.width * this.height);
                    deviceMonitorArray = new DeviceMonitor[abstractList.size()];
                    for (int i = 0; i < abstractList.size(); ++i) {
                        object = abstractList.get(i);
                        DeviceMonitor deviceMonitor = new DeviceMonitor();
                        deviceMonitor.smlprun = n5;
                        deviceMonitor.totalsml = 0L;
                        deviceMonitor.device = object;
                        deviceMonitor.total_time = 0.0;
                        deviceMonitor.image = ((Device)object).createBuffer(16 * this.width * this.height, 1L);
                        deviceMonitor.image.clear();
                        deviceMonitorArray[i] = deviceMonitor;
                    }
                    stringBuffer.append(computeContext.getLog());
                    stringBuffer.append("<B>Settings</B>\n");
                    stringBuffer.append(FluxSettings.getTracerLog());
                    stringBuffer.append("        Image size:   " + this.width + " x " + this.height + "\n");
                    stringBuffer.append("        Total pixels: " + this.width * this.height + "\n");
                    stringBuffer.append("\n");
                    this.terminate = false;
                    Thread thread = new Thread(){

                        public void run() {
                            new FluxTracer.MsgBox(FluxLightTracer.this, null, "Progressive rendering in progress...");
                            FluxLightTracer.this.terminate = true;
                        }
                    };
                    thread.start();
                    object = new Random(0L);
                    stringBuffer.append("<B>Render Profile</B>\n");
                    long l5 = 0L;
                    while (!this.terminate) {
                        int n6;
                        DeviceMonitor deviceMonitor;
                        this.setProgress("Execute kernels", -1.0f);
                        if (BATCH_LOGGING_ENABLED) {
                            stringBuffer.append("<i><b>Itteration</b></i>\n");
                        }
                        long l6 = System.currentTimeMillis();
                        DeviceMonitor[] deviceMonitorArray2 = deviceMonitorArray;
                        int n7 = deviceMonitorArray2.length;
                        for (n6 = 0; n6 < n7; l5 += (long)deviceMonitor.smlprun, ++n6) {
                            deviceMonitor = deviceMonitorArray2[n6];
                            deviceMonitor.device.setKernelArgMemBuffer(kernel, 1, deviceMonitor.image);
                            deviceMonitor.device.setKernelArgInt(kernel, 2, deviceMonitor.smlprun);
                            deviceMonitor.device.setKernelArgInt(kernel, 3, (int)l5);
                            fluxJOCLScene.setKernelArgScene(deviceMonitor.device, kernel, 4);
                            fluxJOCLScene.setKernelArgCamera(deviceMonitor.device, kernel, 17);
                            fluxJOCLScene.setKernelArgBounds(deviceMonitor.device, kernel, 18);
                            deviceMonitor.device.setKernelArgInt(kernel, 19, ((Random)object).nextInt());
                            deviceMonitor.device.setKernelArgInt(kernel, 20, n2);
                            deviceMonitor.device.setKernelArgFloat(kernel, 21, f);
                            deviceMonitor.device.executeKernel(kernel, deviceMonitor.smlprun, deviceMonitor.event);
                        }
                        computeContext.finish();
                        long l7 = System.currentTimeMillis() - l6;
                        l2 += l7;
                        deviceMonitorArray2 = deviceMonitorArray;
                        n7 = deviceMonitorArray2.length;
                        for (n6 = 0; n6 < n7; deviceMonitor.totalsml += (long)deviceMonitor.smlprun, l += (long)deviceMonitor.smlprun, ++n6) {
                            deviceMonitor = deviceMonitorArray2[n6];
                            double d2 = JOCLEvent.getEndTime(deviceMonitor.event) - JOCLEvent.getStartTime(deviceMonitor.event);
                            double d3 = 0.0;
                            deviceMonitor.total_time += d2;
                            if (d2 > 0.0) {
                                d3 = (double)deviceMonitor.smlprun / d2;
                            }
                            if (BATCH_LOGGING_ENABLED) {
                                stringBuffer.append("<i>");
                                stringBuffer.append("Sample batch\n");
                                stringBuffer.append("    Device:      " + deviceMonitor.device.getName() + "\n");
                                stringBuffer.append("    Batch size:  " + deviceMonitor.smlprun + "\n");
                                stringBuffer.append("    Render time: " + d2 * 1000.0 + "ms\n");
                                stringBuffer.append("    Performance: " + d3 / 1000000.0 + " MSmpl\n");
                                stringBuffer.append("\n");
                                stringBuffer.append("</i>");
                            }
                            int n8 = Math.min(n4, (int)(d3 * d));
                            deviceMonitor.smlprun = (int)(BATCH_BALANCE_SMOOTH * (double)n8 + (1.0 - BATCH_BALANCE_SMOOTH) * (double)deviceMonitor.smlprun);
                        }
                        this.displayImage(deviceMonitorArray);
                    }
                    for (DeviceMonitor deviceMonitor : deviceMonitorArray) {
                        stringBuffer.append("Device: " + deviceMonitor.device.getName() + "\n");
                        stringBuffer.append("\tTotal samples:     " + deviceMonitor.totalsml + "\n");
                        stringBuffer.append("\tSamples per batch: " + deviceMonitor.smlprun + "\n");
                        stringBuffer.append("\tTotal trace time:  " + (int)(deviceMonitor.total_time * 1000.0) + " ms\n");
                        stringBuffer.append("\tSamples per second: " + (double)deviceMonitor.totalsml / 1000000.0 / deviceMonitor.total_time + " MSmpl/s\n");
                    }
                    break block27;
                }
                catch (Throwable throwable) {
                    Object var43_11 = null;
                    stringBuffer.append("\n<B>Profile Summary</B>\n");
                    stringBuffer.append("    Construction time: " + l4 + " ms\n");
                    stringBuffer.append("    Serialize time:    " + l3 + " ms\n");
                    stringBuffer.append("    Render time:       " + l2 + " ms\n");
                    if (l2 > 0L) {
                        stringBuffer.append("    Performance:       " + (double)(l / l2) / 1000.0 + " MSmpl/s\n");
                    }
                    if (deviceMonitorArray != null) {
                        long l8 = 0L;
                        for (void var49_30 : deviceMonitorArray) {
                            if (var49_30 == null) continue;
                            l8 += var49_30.totalsml;
                        }
                        if (l8 > 0L) {
                            for (void var49_32 : deviceMonitorArray) {
                                if (var49_32 == null) continue;
                                stringBuffer.append("        " + var49_32.totalsml * 100L / l8 + "%: \t" + var49_32.device.getName() + "\n");
                            }
                        }
                    }
                    stringBuffer.append("    Device Memory:     " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
                    this.setProgress("Done", 2.0f);
                    this.view.getWorkbench().logGUIInfo(stringBuffer.append("</pre></html>").toString());
                    throw throwable;
                }
            }
            stringBuffer.append("    Construction time: " + l4 + " ms\n");
            stringBuffer.append("    Serialize time:    " + l3 + " ms\n");
            stringBuffer.append("    Render time:       " + l2 + " ms\n");
            if (l2 > 0L) {
                stringBuffer.append("    Performance:       " + (double)(l / l2) / 1000.0 + " MSmpl/s\n");
            }
            if (deviceMonitorArray != null) {
                long l9 = 0L;
                for (void var49_24 : deviceMonitorArray) {
                    if (var49_24 == null) continue;
                    l9 += var49_24.totalsml;
                }
                if (l9 > 0L) {
                    for (DeviceMonitor deviceMonitor : deviceMonitorArray) {
                        if (deviceMonitor == null) continue;
                        stringBuffer.append("        " + deviceMonitor.totalsml * 100L / l9 + "%: \t" + deviceMonitor.device.getName() + "\n");
                    }
                }
            }
            stringBuffer.append("    Device Memory:     " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
            this.setProgress("Done", 2.0f);
            this.view.getWorkbench().logGUIInfo(stringBuffer.append("</pre></html>").toString());
            return;
        }
        Object var43_10 = null;
        stringBuffer.append("\n<B>Profile Summary</B>\n");
        stringBuffer.append("    Construction time: " + l4 + " ms\n");
        stringBuffer.append("    Serialize time:    " + l3 + " ms\n");
        stringBuffer.append("    Render time:       " + l2 + " ms\n");
        if (l2 > 0L) {
            stringBuffer.append("    Performance:       " + (double)(l / l2) / 1000.0 + " MSmpl/s\n");
        }
        if (deviceMonitorArray != null) {
            long l10 = 0L;
            for (DeviceMonitor deviceMonitor : deviceMonitorArray) {
                if (deviceMonitor == null) continue;
                l10 += deviceMonitor.totalsml;
            }
            if (l10 > 0L) {
                for (DeviceMonitor deviceMonitor : deviceMonitorArray) {
                    if (deviceMonitor == null) continue;
                    stringBuffer.append("        " + deviceMonitor.totalsml * 100L / l10 + "%: \t" + deviceMonitor.device.getName() + "\n");
                }
            }
        }
        stringBuffer.append("    Device Memory:     " + JOCLBuffer.getMemoryUsage() / 1024 + " KB\n");
        this.setProgress("Done", 2.0f);
        this.view.getWorkbench().logGUIInfo(stringBuffer.append("</pre></html>").toString());
    }

    protected void displayImage(DeviceMonitor[] deviceMonitorArray) {
        this.setProgress("Display image", -1.0f);
        byte[] byArray = new byte[this.width * this.height * 16];
        FloatBuffer floatBuffer = ByteBuffer.wrap(byArray).asFloatBuffer();
        for (DeviceMonitor deviceMonitor : deviceMonitorArray) {
            byte[] byArray2 = new byte[this.width * this.height * 16];
            deviceMonitor.image.readBuffer(byArray2);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            byteBuffer.order(deviceMonitor.device.getByteOrder());
            FloatBuffer floatBuffer2 = byteBuffer.asFloatBuffer();
            for (int i = 0; i < this.width * this.height * 4; ++i) {
                floatBuffer.put(i, floatBuffer.get(i) + floatBuffer2.get(i));
            }
        }
        this.displayImage(floatBuffer);
    }

    class DeviceMonitor {
        Buffer image;
        cl_event event = new cl_event();
        int smlprun;
        long totalsml;
        double total_time;
        public Device device;

        DeviceMonitor() {
        }
    }
}

