/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.gpuflux.tracer;

import de.grogra.gpuflux.FluxSettings;
import de.grogra.gpuflux.jocl.compute.Buffer;
import de.grogra.gpuflux.scene.shading.FluxSpectrum;
import de.grogra.imp.View;
import de.grogra.imp3d.spectral.ConstantSpectralCurve;
import de.grogra.ray2.Options;
import de.grogra.ray2.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FluxTracer
implements ProgressMonitor {
    protected static final int DEFAULT_TRACE_DEPTH = 5;
    public static final int DEFAULT_PREFERRED_DURATION = 500;
    protected static final float DEFAULT_MIN_POWER = 0.01f;
    public static final int INITIAL_SAMPLE_COUNT = 10000000;
    public static final int MAXIMUM_SAMPLE_COUNT = 1000000000;
    public static final int INITIAL_SPECTRAL_RESOLUTION = 1;
    private static final int SPECTRUM_VISIBLE_MIN = 380;
    private static final int SPECTRUM_VISIBLE_MAX = 720;
    public static boolean BATCH_LOGGING_ENABLED = false;
    public static double BATCH_BALANCE_SMOOTH = 0.9;
    protected int width;
    protected int height;
    protected ArrayList<ImageObserver> observers;
    protected View view;
    protected Options options;
    protected boolean useBih;
    protected BufferedImage image;
    float[][] hdrPixels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(View view, int n, int n2, ArrayList<ImageObserver> arrayList, Options options) throws IOException {
        this.view = view;
        this.width = n;
        this.height = n2;
        this.observers = arrayList;
        this.options = options;
        view.getWorkbench().beginStatus((Object)this);
        try {
            this.hdrPixels = new float[4][n * n2];
            DataBufferFloat dataBufferFloat = new DataBufferFloat(this.hdrPixels, this.hdrPixels[0].length);
            BandedSampleModel bandedSampleModel = new BandedSampleModel(dataBufferFloat.getDataType(), n, n2, 4);
            WritableRaster writableRaster = Raster.createWritableRaster(bandedSampleModel, dataBufferFloat, null);
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, true, false, 3, dataBufferFloat.getDataType());
            this.image = new BufferedImage(componentColorModel, writableRaster, false, null);
            int n3 = FluxSettings.getModelSpectralLambdaStep();
            this.useBih = false;
            FluxSpectrum.setDiscretization(new FluxSpectrum.SpectralDiscretization(380, 720, n3));
            FluxSpectrum.setImportance(new ConstantSpectralCurve(1.0f));
            this.trace();
            Object var13_12 = null;
            this.setProgress("Done", 2.0f);
            Runtime.getRuntime().gc();
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.setProgress("Done", 2.0f);
            Runtime.getRuntime().gc();
            throw throwable;
        }
    }

    protected abstract void trace() throws IOException;

    protected void displayImage(Buffer buffer, ByteOrder byteOrder) {
        this.setProgress("Display image", -1.0f);
        byte[] byArray = new byte[this.width * this.height * 16];
        buffer.readBuffer(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(byteOrder);
        this.displayImage(byteBuffer.asFloatBuffer());
    }

    protected void displayImage(FloatBuffer floatBuffer) {
        this.tonemap(floatBuffer);
        for (int i = 0; i < this.width * this.height; ++i) {
            float f = floatBuffer.get(i * 4 + 0);
            float f2 = floatBuffer.get(i * 4 + 1);
            float f3 = floatBuffer.get(i * 4 + 2);
            this.hdrPixels[0][i] = f;
            this.hdrPixels[1][i] = f2;
            this.hdrPixels[2][i] = f3;
            this.hdrPixels[3][i] = 1.0f;
        }
        this.showImage(this.image);
    }

    private void tonemap(FloatBuffer floatBuffer) {
        int n = 0;
        double d = 0.0;
        int n2 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.width * this.height; ++i) {
            float f;
            float f2;
            float f3 = floatBuffer.get(i * 4 + 0);
            float f4 = f3 + (f2 = floatBuffer.get(i * 4 + 1)) + (f = floatBuffer.get(i * 4 + 2));
            if (f4 > 0.0f && f4 < Float.MAX_VALUE && !Float.isInfinite(f4) && !Float.isNaN(f4)) {
                d += (double)f4;
                ++n;
                double d5 = (double)f4 - d2;
                d3 += d5 * ((double)f4 - (d2 += d5 / (double)(++n2)));
            }
            d4 = Math.max(d4, (double)f4);
        }
        d4 /= 3.0;
        double d6 = d3 / (double)(n2 - 1);
        double d7 = Math.sqrt(d6) / 3.0;
        double d8 = d / (double)n / 3.0;
        for (int i = 0; i < this.width * this.height; ++i) {
            float f = floatBuffer.get(i * 4 + 0);
            float f5 = floatBuffer.get(i * 4 + 1);
            float f6 = floatBuffer.get(i * 4 + 2);
            float f7 = floatBuffer.get(i * 4 + 3);
            double d9 = (double)f / d8 * 0.5;
            double d10 = (double)f5 / d8 * 0.5;
            double d11 = (double)f6 / d8 * 0.5;
            double d12 = Math.max(0.0, d9 / (1.0 + d9));
            double d13 = Math.max(0.0, d10 / (1.0 + d10));
            double d14 = Math.max(0.0, d11 / (1.0 + d11));
            floatBuffer.put(i * 4 + 0, (float)d12);
            floatBuffer.put(i * 4 + 1, (float)d13);
            floatBuffer.put(i * 4 + 2, (float)d14);
            floatBuffer.put(i * 4 + 3, f7);
        }
    }

    private static int toByte(float f) {
        int n = (int)(f * 256.0f);
        return n < 0 ? 0 : (n > 255 ? 255 : n);
    }

    protected static int toIntColor(float f, float f2, float f3, float f4) {
        return (FluxTracer.toByte(f4) << 24) + (FluxTracer.toByte(f) << 16) + (FluxTracer.toByte(f2) << 8) + FluxTracer.toByte(f3);
    }

    protected void showImage(BufferedImage bufferedImage) {
        for (ImageObserver imageObserver : this.observers) {
            imageObserver.imageUpdate(bufferedImage, 32, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
    }

    public void dispose() {
    }

    public void setProgress(String string, float f) {
        this.view.getWorkbench().setStatus((Object)this, string);
        if (f < 0.0f) {
            this.view.getWorkbench().setIndeterminateProgress((Object)this);
        } else if (f == 2.0f) {
            this.view.getWorkbench().clearProgress((Object)this);
        } else {
            this.view.getWorkbench().setProgress((Object)this, f);
        }
    }

    public void showMessage(String string) {
        this.view.getWorkbench().logGUIInfo(string);
    }

    protected String getKernelCompilationArguments(boolean bl, boolean bl2) {
        boolean bl3 = FluxSettings.getRenderSpectral();
        boolean bl4 = FluxSettings.getRenderDispersion();
        String string = "";
        if (bl3 && bl) {
            string = string + " -D SPECTRAL";
            if (bl4 && bl2) {
                string = string + " -D SPECTRUM_DISPERSION";
            }
        }
        FluxSpectrum.SpectralDiscretization spectralDiscretization = FluxSpectrum.getDiscretization();
        string = string + " -D SPECTRAL_WAVELENGTH_MIN=" + spectralDiscretization.getLambdaMin();
        string = string + " -D SPECTRAL_WAVELENGTH_MAX=" + spectralDiscretization.getLambdaMax();
        string = string + " -D SPECTRAL_WAVELENGTH_BINS=" + spectralDiscretization.getLambdaBins();
        string = this.useBih ? string + " -D BIH" : string + " -D BVH";
        return string;
    }

    protected class MsgBox
    extends Dialog
    implements ActionListener {
        private Button ok;

        MsgBox(Frame frame, String string) {
            super(frame, "Message", true);
            this.setLayout(new BorderLayout());
            this.add("Center", new Label(string));
            this.addOKPanel();
            this.createFrame();
            this.pack();
            this.setVisible(true);
        }

        void addOKPanel() {
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout());
            this.createOKButton(panel);
            this.add("South", panel);
        }

        void createOKButton(Panel panel) {
            this.ok = new Button("Terminate");
            panel.add(this.ok);
            this.ok.addActionListener(this);
        }

        void createFrame() {
            Dimension dimension = this.getToolkit().getScreenSize();
            this.setLocation(dimension.width / 3, dimension.height / 3);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent != null && actionEvent.getSource() == this.ok) {
                this.setVisible(false);
            }
        }
    }
}

