/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.io;

import de.grogra.imp3d.shading.SPD;
import de.grogra.imp3d.shading.SPDResource;
import de.grogra.imp3d.spectral.IrregularSpectralCurve;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ReaderSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SPDFilter
extends FilterBase
implements ObjectSource {
    public static final IOFlavor FLAVOR = IOFlavor.valueOf(SPD.class);

    public SPDFilter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(FLAVOR);
    }

    public Object getObject() throws IOException {
        Object object;
        Reader reader = ((ReaderSource)this.source).getReader();
        BufferedReader bufferedReader = new BufferedReader(reader);
        Vector<LambdaPower> vector = new Vector<LambdaPower>();
        String string = bufferedReader.readLine();
        while (string != null) {
            object = new StringTokenizer(string);
            try {
                int n = Integer.parseInt(((StringTokenizer)object).nextToken());
                float f = Float.parseFloat(((StringTokenizer)object).nextToken());
                vector.add(new LambdaPower(n, f));
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IOException("Illegal string for wavelength-power tuple: " + string);
            }
            string = bufferedReader.readLine();
        }
        object = new float[vector.size()];
        float[] fArray = new float[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            object[i] = ((LambdaPower)vector.get((int)i)).lambda;
            fArray[i] = ((LambdaPower)vector.get((int)i)).power;
        }
        return new SPDResource(new IrregularSpectralCurve((float[])object, fArray));
    }

    class LambdaPower {
        float lambda;
        float power;

        public LambdaPower(float f, float f2) {
            this.lambda = f;
            this.power = f2;
        }
    }
}

