/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.ShareableBase;
import de.grogra.reflect.ClassAdapter;
import de.grogra.vecmath.Math2;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;

public class LightDistribution
extends ShareableBase {
    private static final double CONSERVATIVE_IMPORTANCE = 0.1;
    private int width = 1;
    private int height = 1;
    private double[][] lipdf = new double[][]{{1.0}};
    private double[] licdf = new double[]{1.0};
    public static final Type $TYPE = new Type(LightDistribution.class);
    public static final SCOType.Field width$FIELD = Type._addManagedField($TYPE, "width", 0x200002, de.grogra.reflect.Type.INT, null, 0);
    public static final SCOType.Field height$FIELD = Type._addManagedField($TYPE, "height", 0x200002, de.grogra.reflect.Type.INT, null, 1);
    public static final SCOType.Field lipdf$FIELD = Type._addManagedField($TYPE, "lipdf", 0x200002, (de.grogra.reflect.Type)ClassAdapter.wrap(double[][].class), null, 2);
    public static final SCOType.Field licdf$FIELD = Type._addManagedField($TYPE, "licdf", 0x200002, (de.grogra.reflect.Type)ClassAdapter.wrap(double[].class), null, 3);
    private double power;

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double[][] getDistribution() {
        return this.lipdf;
    }

    public double[] getLinearCDF() {
        return this.licdf;
    }

    public LightDistribution() {
    }

    public LightDistribution(double[][] dArray) {
        this.setDistribution(dArray);
    }

    public void setDistribution(double[][] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        this.lipdf = dArray;
        this.height = dArray.length;
        this.width = dArray[0].length;
        double[][] dArray2 = new double[this.height][this.width];
        double[][] dArray3 = new double[this.height][this.width];
        double d = 0.0;
        double d2 = 0.0;
        for (n4 = 0; n4 < this.height; ++n4) {
            for (n3 = 0; n3 < this.width; ++n3) {
                double d3;
                double d4 = 0.0;
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        int n5 = Math.min(n3 + j, this.width - 1);
                        int n6 = Math.min(n4 + i, this.height - 1);
                        d4 = Math.max(d4, dArray[n6][n5]);
                    }
                }
                dArray2[n4][n3] = d4;
                float f = (float)n3 / (float)this.width * Math2.M_PI;
                float f2 = (float)n4 / (float)this.height * 2.0f * Math2.M_PI - Math2.M_PI;
                float f3 = (float)(n3 + 1) / (float)this.width * Math2.M_PI;
                float f4 = (float)(n4 + 1) / (float)this.height * 2.0f * Math2.M_PI - Math2.M_PI;
                dArray3[n4][n3] = d3 = (double)(f4 - f2) * (Math.cos(f) - Math.cos(f3));
                if (dArray2[n4][n3] > 0.0) {
                    d += d3;
                }
                this.power += d3 * dArray[n4][n3];
                d2 += d3 * dArray2[n4][n3];
            }
        }
        this.licdf = new double[this.width * this.height];
        for (n4 = 0; n4 < this.height; ++n4) {
            for (n3 = 0; n3 < this.width; ++n3) {
                this.licdf[n4 * this.width + n3] = 0.0;
                if (!(dArray2[n4][n3] > 0.0)) continue;
                this.licdf[n4 * this.width + n3] = 0.1 * d2 * (dArray3[n4][n3] / d);
                int n7 = n4 * this.width + n3;
                this.licdf[n7] = this.licdf[n7] + 0.9 * dArray2[n4][n3] * dArray3[n4][n3];
            }
        }
        double d5 = 0.0;
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                this.licdf[n2 * this.width + n] = d5 += this.licdf[n2 * this.width + n];
            }
        }
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                double[] dArray4 = dArray[n2];
                int n8 = n;
                dArray4[n8] = dArray4[n8] / this.power;
                int n9 = n2 * this.width + n;
                this.licdf[n9] = this.licdf[n9] / d5;
            }
        }
    }

    public void setDistributionEx(double[][] dArray) {
        int n;
        int n2;
        int n3;
        this.lipdf = dArray;
        this.height = dArray.length;
        this.width = dArray[0].length;
        double[][] dArray2 = new double[this.height][this.width];
        this.licdf = new double[this.width * this.height];
        float f = 0.0f;
        this.power = 0.0;
        for (n3 = 0; n3 < this.height; ++n3) {
            for (n2 = 0; n2 < this.width; ++n2) {
                float f2 = (float)n2 / (float)this.width * Math2.M_PI;
                float f3 = (float)n3 / (float)this.height * 2.0f * Math2.M_PI - Math2.M_PI;
                float f4 = (float)(n2 + 1) / (float)this.width * Math2.M_PI;
                float f5 = (float)(n3 + 1) / (float)this.height * 2.0f * Math2.M_PI - Math2.M_PI;
                double d = (double)(f5 - f3) * (Math.cos(f2) - Math.cos(f4));
                double d2 = d * dArray[n3][n2];
                f = (float)((double)f + d);
                this.power += d2;
                dArray2[n3][n2] = d2;
            }
        }
        for (n3 = 0; n3 < this.height; ++n3) {
            for (n2 = 0; n2 < this.width; ++n2) {
                double d = 0.0;
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        int n4 = Math.min(n2 + j, this.width - 1);
                        int n5 = Math.min(n3 + i, this.height - 1);
                        d += dArray2[n5][n4];
                    }
                }
                this.licdf[n3 * this.width + n2] = d / 4.0;
            }
        }
        double d = 0.0;
        for (n = 0; n < this.height; ++n) {
            for (int i = 0; i < this.width; ++i) {
                this.licdf[n * this.width + i] = d += this.licdf[n * this.width + i];
            }
        }
        for (n = 0; n < this.height; ++n) {
            for (int i = 0; i < this.width; ++i) {
                double[] dArray3 = dArray[n];
                int n6 = i;
                dArray3[n6] = dArray3[n6] / this.power;
                int n7 = n * this.width + i;
                this.licdf[n7] = this.licdf[n7] / d;
            }
        }
    }

    static double interpolate(double d, double d2, double d3, double d4, double d5, double d6) {
        return d * (1.0 - d5) * (1.0 - d6) + d2 * (1.0 - d5) * d6 + d3 * d5 * (1.0 - d6) + d4 * d5 * d6;
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double d) {
        this.power = d;
    }

    public double getDensityAt(Vector3f vector3f) {
        double d = 0.0;
        Vector2f vector2f = LightDistribution.cartesian2map(vector3f);
        float f = vector2f.x * (float)this.width;
        float f2 = vector2f.y * (float)this.height;
        int n = Math.max(0, Math.min(this.width - 1, (int)f));
        int n2 = Math.min(this.width - 1, n + 1);
        int n3 = Math.max(0, Math.min(this.height - 1, (int)f2));
        int n4 = Math.min(this.height - 1, n3 + 1);
        double d2 = this.lipdf[n3][n];
        double d3 = this.lipdf[n3][n2];
        double d4 = this.lipdf[n4][n];
        double d5 = this.lipdf[n4][n2];
        d = LightDistribution.interpolate(d2, d4, d3, d5, (double)f - Math.floor(f), (double)f2 - Math.floor(f2));
        return d;
    }

    public double map2direction(Vector3f vector3f, Tuple2d tuple2d) {
        double d;
        int n;
        double d2 = tuple2d.x;
        int n2 = 0;
        int n3 = this.width * this.height;
        d2 *= this.licdf[n3 - 1];
        while (n2 + 1 < n3) {
            n = n2 + n3 >> 1;
            d = this.licdf[n - 1];
            if (d >= d2) {
                n3 = n;
                continue;
            }
            n2 = n;
        }
        n = n2;
        d = n == 0 ? 0.0 : this.licdf[n - 1];
        double d3 = this.licdf[n];
        double d4 = d3 - d;
        double d5 = (tuple2d.x - d) / d4;
        double d6 = tuple2d.y;
        float f = (float)(n % this.width) + (float)d5;
        float f2 = (float)(n / this.width) + (float)d6;
        float f3 = f / (float)this.width;
        float f4 = f2 / (float)this.height;
        float f5 = f3 * Math2.M_PI;
        float f6 = f4 * 2.0f * Math2.M_PI - Math2.M_PI;
        float f7 = (float)Math.sin(f5);
        float f8 = (float)Math.cos(f5);
        vector3f.set((float)Math.cos(f6) * f7, (float)Math.sin(f6) * f7, f8);
        vector3f.set((Tuple3f)LightDistribution.map2cartesian(f3, f4));
        return d4 * (double)(this.width * this.height) / (double)(2.0f * Math2.M_PI * Math2.M_PI * f7);
    }

    public static Vector3f map2cartesian(float f, float f2) {
        float f3 = f * Math2.M_PI;
        float f4 = f2 * 2.0f * Math2.M_PI - Math2.M_PI;
        float f5 = (float)Math.sin(f3);
        float f6 = (float)Math.cos(f3);
        return new Vector3f((float)Math.cos(f4) * f5, (float)Math.sin(f4) * f5, f6);
    }

    public static void map2cartesian(Tuple3f tuple3f, float f, float f2) {
        float f3 = f * Math2.M_PI;
        float f4 = f2 * 2.0f * Math2.M_PI - Math2.M_PI;
        float f5 = (float)Math.sin(f3);
        float f6 = (float)Math.cos(f3);
        tuple3f.set((float)Math.cos(f4) * f5, (float)Math.sin(f4) * f5, f6);
    }

    public static Vector2f cartesian2map(Vector3f vector3f) {
        float f = (float)Math.atan2(Math.sqrt(vector3f.x * vector3f.x + vector3f.y * vector3f.y), vector3f.z);
        float f2 = (float)Math.atan2(vector3f.y, vector3f.x);
        float f3 = f * Math2.M_1_PI;
        float f4 = (f2 + Math2.M_PI) / Math2.M_2PI;
        return new Vector2f(f3, f4);
    }

    static /* synthetic */ double[][] access$202(LightDistribution lightDistribution, double[][] dArray) {
        lightDistribution.lipdf = dArray;
        return dArray;
    }

    static /* synthetic */ double[] access$302(LightDistribution lightDistribution, double[] dArray) {
        lightDistribution.licdf = dArray;
        return dArray;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 4;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(LightDistribution lightDistribution, SCOType sCOType) {
            super((Object)lightDistribution, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 0: {
                    ((LightDistribution)((Object)object)).width = n2;
                    return;
                }
                case 1: {
                    ((LightDistribution)((Object)object)).height = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((LightDistribution)((Object)object)).width;
                }
                case 1: {
                    return ((LightDistribution)((Object)object)).height;
                }
            }
            return super.getInt(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 2: {
                    LightDistribution.access$202((LightDistribution)((Object)object), (double[][])object2);
                    return;
                }
                case 3: {
                    LightDistribution.access$302((LightDistribution)((Object)object), (double[])object2);
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((LightDistribution)((Object)object)).lipdf;
                }
                case 3: {
                    return ((LightDistribution)((Object)object)).licdf;
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new LightDistribution();
        }
    }
}

