/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.gpuflux.FluxSettings;
import de.grogra.icon.Icon;
import de.grogra.icon.IconSource;
import de.grogra.imp3d.objects.SpectralLightMap;
import de.grogra.imp3d.shading.ConstantSPD;
import de.grogra.imp3d.shading.SPD;
import de.grogra.imp3d.shading.SPDCurve;
import de.grogra.imp3d.spectral.ConstantSpectralCurve;
import de.grogra.imp3d.spectral.SpectralCurve;
import de.grogra.math.ChannelData;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.ShareableBase;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.RenderedIcon;
import de.grogra.reflect.ClassAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.sunflow.image.RGBSpace;
import org.sunflow.image.XYZColor;

public class SpectralLightMapNode
extends ShareableBase
implements SpectralLightMap,
IconSource,
Icon,
RenderedIcon {
    private static final int MIN_WAVELENGTH = 380;
    private static final int MAX_WAVELENGTH = 720;
    SPD spectraldistribution = new ConstantSPD();
    public static final Type $TYPE = new Type(SpectralLightMapNode.class);
    public static final SCOType.Field spectraldistribution$FIELD = Type._addManagedField($TYPE, "spectraldistribution", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(SPD.class), null, 0);
    private transient Color awtColor;
    private transient Point3f whitecolor;
    private float maxIntensity;

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public SPD getSpectraldistribution() {
        return this.spectraldistribution;
    }

    public void setSpectraldistribution(SPD sPD) {
        spectraldistribution$FIELD.setObject((Object)this, (Object)sPD);
    }

    public Point3f getColor() {
        SpectralCurve spectralCurve = this.getSpectralCurve();
        XYZColor xYZColor = spectralCurve.toXYZ();
        Point3f point3f = new Point3f();
        RGBSpace.CIE.convertXYZtoRGB(xYZColor, (Tuple3f)point3f);
        point3f.x /= this.whitecolor.x;
        point3f.y /= this.whitecolor.y;
        point3f.z /= this.whitecolor.z;
        return point3f;
    }

    public SpectralLightMapNode(SpectralCurve spectralCurve) {
        this();
        this.setSpectraldistribution(new SPDCurve(spectralCurve));
    }

    public SpectralLightMapNode() {
        XYZColor xYZColor = new ConstantSpectralCurve(1.0f).toXYZ();
        this.whitecolor = new Point3f();
        RGBSpace.CIE.convertXYZtoRGB(xYZColor, (Tuple3f)this.whitecolor);
    }

    public int getAverageColor() {
        Point3f point3f = this.getColor();
        int n = Math.min(Math.max(0, (int)(point3f.x * 255.0f)), 0);
        int n2 = Math.min(Math.max(0, (int)(point3f.y * 255.0f)), 0);
        int n3 = Math.min(Math.max(0, (int)(point3f.z * 255.0f)), 0);
        int n4 = n | n2 << 8 | n3 << 16 | 0xFF000000;
        return n4;
    }

    public float getFloatValue(ChannelData channelData, int n) {
        if (n >= 8 && n <= 14) {
            return 0.0f;
        }
        Point3f point3f = this.getColor();
        switch (n & 3) {
            case 0: {
                return point3f.x;
            }
            case 1: {
                return point3f.y;
            }
            case 2: {
                return point3f.z;
            }
            case 3: {
                return 1.0f;
            }
        }
        throw new AssertionError();
    }

    public Object getObjectValue(ChannelData channelData, int n) {
        return channelData.forwardGetObjectValue(channelData.getData(null));
    }

    public Icon getIcon(Dimension dimension, int n) {
        return this;
    }

    public Dimension getPreferredIconSize(boolean bl) {
        return null;
    }

    public void paintIcon(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
        int n6 = this.getAverageColor();
        if (this.awtColor == null || n6 != this.awtColor.getRGB()) {
            this.awtColor = new Color(n6, true);
        }
        graphics2D.setColor(this.awtColor);
        graphics2D.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics2D.setColor(color);
    }

    public IconSource getIconSource() {
        return this;
    }

    public void prepareIcon() {
    }

    public boolean isMutable() {
        return true;
    }

    public Image getImage() {
        return null;
    }

    public Image getImage(int n, int n2) {
        return null;
    }

    public URL getImageSource() {
        return null;
    }

    public Rectangle getIconBounds() {
        return null;
    }

    public float getSizeRatio() {
        return 2.0f;
    }

    public int renderImage(JobManager jobManager, BufferedImage bufferedImage, int n) {
        long l = System.currentTimeMillis() + 500L;
        if (n == 0) {
            SpectralCurve spectralCurve = this.getSpectralCurve();
            this.maxIntensity = 0.0f;
            for (int i = 380; i < 720; ++i) {
                this.maxIntensity = Math.max(this.maxIntensity, spectralCurve.sample(i));
            }
        }
        do {
            for (int i = 3; i > 0; --i) {
                if (n == bufferedImage.getHeight()) {
                    return n;
                }
                this.renderLine(n, bufferedImage);
                if (++n != bufferedImage.getHeight()) continue;
                return n;
            }
        } while (System.currentTimeMillis() < l && !jobManager.hasJobQueued(jobManager.getThreadContext().getPriority() + 1));
        return n;
    }

    SpectralCurve getSpectralCurve() {
        SpectralCurve spectralCurve = null;
        if (this.spectraldistribution != null) {
            spectralCurve = this.spectraldistribution.getSpectralDistribution();
        }
        if (spectralCurve == null) {
            spectralCurve = new ConstantSpectralCurve(1.0f);
        }
        return spectralCurve;
    }

    private void renderLine(int n, BufferedImage bufferedImage) {
        SpectralCurve spectralCurve = this.getSpectralCurve();
        bufferedImage.setRGB(0, n, -16777216);
        bufferedImage.setRGB(1, n, -1);
        bufferedImage.setRGB(bufferedImage.getWidth() - 2, n, -1);
        bufferedImage.setRGB(bufferedImage.getWidth() - 1, n, -16777216);
        int n2 = FluxSettings.getModelSpectralLambdaStep();
        float f = 340.0f / (float)(bufferedImage.getWidth() - 4);
        int n3 = 0;
        for (int i = 2; i < bufferedImage.getWidth() - 2; ++i) {
            int n4;
            float f2;
            float f3 = (float)(i - 2) * f + 380.0f;
            XYZColor xYZColor = SpectralCurve.toXYZ(f3, 1.0f);
            org.sunflow.image.Color color = RGBSpace.CIE.convertXYZtoRGB(xYZColor);
            int n5 = color.toRGB() | 0xFF000000;
            if (f < (float)n2) {
                f2 = spectralCurve.sample(f3);
            } else {
                n4 = 1;
                f2 = spectralCurve.sample(n3);
                while ((float)n3 < f3) {
                    f2 += spectralCurve.sample(n3);
                    ++n3;
                    ++n4;
                }
                f2 /= (float)n4;
            }
            n4 = (int)(f2 *= (float)bufferedImage.getHeight() / this.maxIntensity);
            int n6 = bufferedImage.getHeight() - n;
            if (spectralCurve != null && n6 >= n4) {
                n5 = n6 == n4 ? -1 : (n6 == n4 + 1 ? -16777216 : -1);
            }
            bufferedImage.setRGB(i, n, n5);
        }
    }

    public SpectralCurve getSpectralDistribution() {
        return this.spectraldistribution.getSpectralDistribution();
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 1;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(SpectralLightMapNode spectralLightMapNode, SCOType sCOType) {
            super((Object)spectralLightMapNode, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    ((SpectralLightMapNode)object).spectraldistribution = (SPD)((Object)object2);
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((SpectralLightMapNode)object).getSpectraldistribution();
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new SpectralLightMapNode();
        }
    }
}

