/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.spectral;

import de.grogra.imp3d.spectral.SpectralCurve;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;

public class RGBSpectralCurve
extends SpectralCurve {
    private float r;
    private float g;
    private float b;
    public static final Type $TYPE = new Type(RGBSpectralCurve.class);
    public static final SCOType.Field r$FIELD = Type._addManagedField($TYPE, "r", 0x200002, de.grogra.reflect.Type.FLOAT, null, 0);
    public static final SCOType.Field g$FIELD = Type._addManagedField($TYPE, "g", 0x200002, de.grogra.reflect.Type.FLOAT, null, 1);
    public static final SCOType.Field b$FIELD = Type._addManagedField($TYPE, "b", 0x200002, de.grogra.reflect.Type.FLOAT, null, 2);
    private static final int SMITS_WHITE_BASE_FUNC = 0;
    private static final int SMITS_CYAN_BASE_FUNC = 1;
    private static final int SMITS_MAGENTA_BASE_FUNC = 2;
    private static final int SMITS_YELLOW_BASE_FUNC = 3;
    private static final int SMITS_RED_BASE_FUNC = 4;
    private static final int SMITS_GREEN_BASE_FUNC = 5;
    private static final int SMITS_BLUE_BASE_FUNC = 6;
    private static final float SMITS_MAX_LAMBDA = 720.0f;
    private static final float SMITS_MIN_LAMBDA = 380.0f;
    private static final int SMITS_BINS = 10;
    private static final float SMITS_SCALE = 1.0f;
    private static final float[][] smits_lut;
    static final int[] complement_lut;
    static final int[] primary_lut;

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public RGBSpectralCurve() {
    }

    public RGBSpectralCurve(float f, float f2, float f3) {
        this.r = f;
        this.g = f2;
        this.b = f3;
    }

    private int SampleSpectralIntervals1(float f, float f2, float f3, int n) {
        int n2 = (int)((f - f2) / (f3 - f2) * (float)n);
        n2 = Math.min(n2, n - 1);
        n2 = Math.max(n2, 0);
        return n2;
    }

    private int v3dominis() {
        return Math.abs(this.r) <= Math.abs(this.g) ? (Math.abs(this.r) <= Math.abs(this.b) ? 0 : 2) : (Math.abs(this.g) <= Math.abs(this.b) ? 1 : 2);
    }

    private float getChannel(int n) {
        switch (n) {
            case 0: {
                return this.r;
            }
            case 1: {
                return this.g;
            }
            case 2: {
                return this.b;
            }
        }
        return 0.0f;
    }

    public float sample(float f) {
        int n = this.SampleSpectralIntervals1(f, 380.0f, 720.0f, 10);
        int n2 = this.v3dominis();
        float f2 = this.getChannel(n2) * smits_lut[0][n] * 1.0f;
        int n3 = (n2 + 1) % 3;
        int n4 = (n2 + 2) % 3;
        if (this.getChannel(n3) > this.getChannel(n4)) {
            int n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        f2 += (this.getChannel(n3) - this.getChannel(n2)) * smits_lut[complement_lut[n2]][n] * 1.0f;
        return f2 += (this.getChannel(n4) - this.getChannel(n3)) * smits_lut[primary_lut[n4]][n] * 1.0f;
    }

    static {
        $TYPE.validate();
        smits_lut = new float[][]{{1.0f, 1.0f, 0.9999f, 0.9993f, 0.9992f, 0.9998f, 1.0f, 1.0f, 1.0f, 1.0f}, {0.971f, 0.9426f, 1.0007f, 1.0007f, 1.0007f, 1.0007f, 0.1564f, 0.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 0.9685f, 0.2229f, 0.0f, 0.0458f, 0.8369f, 1.0f, 1.0f, 0.9959f}, {1.0E-4f, 0.0f, 0.1088f, 0.6651f, 1.0f, 1.0f, 0.9996f, 0.9586f, 0.9685f, 0.984f}, {0.1012f, 0.0515f, 0.0f, 0.0f, 0.0f, 0.0f, 0.8325f, 1.0149f, 1.0149f, 1.0149f}, {0.0f, 0.0f, 0.0273f, 0.7937f, 1.0f, 0.9418f, 0.1719f, 0.0f, 0.0f, 0.0025f}, {1.0f, 1.0f, 0.8916f, 0.3323f, 0.0f, 0.0f, 3.0E-4f, 0.0369f, 0.0483f, 0.0496f}};
        complement_lut = new int[]{1, 2, 3};
        primary_lut = new int[]{4, 5, 6};
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 3;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(RGBSpectralCurve rGBSpectralCurve, SCOType sCOType) {
            super((Object)rGBSpectralCurve, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 0: {
                    ((RGBSpectralCurve)((Object)object)).r = f;
                    return;
                }
                case 1: {
                    ((RGBSpectralCurve)((Object)object)).g = f;
                    return;
                }
                case 2: {
                    ((RGBSpectralCurve)((Object)object)).b = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((RGBSpectralCurve)((Object)object)).r;
                }
                case 1: {
                    return ((RGBSpectralCurve)((Object)object)).g;
                }
                case 2: {
                    return ((RGBSpectralCurve)((Object)object)).b;
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new RGBSpectralCurve();
        }
    }
}

