/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.TonicDragGestureRecognizer;
import com.digitprop.tonic.TonicDropTargetListener;
import com.digitprop.tonic.TonicTransferable;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableUI
extends BasicTableUI {
    private static final TableDragGestureRecognizer defaultDragRecognizer = new TableDragGestureRecognizer();
    private static DropTargetListener defaultDropTargetListener = null;
    private static final TransferHandler defaultTransferHandler = new TableTransferHandler();
    protected CellRendererPane rendererPane;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    private PropertyChangeListener propertyChangeListener;

    protected KeyListener createKeyListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public static ComponentUI createUI(JComponent component) {
        return new TableUI();
    }

    public void installUI(JComponent c) {
        this.table = (JTable)c;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        LookAndFeel.installBorder(this.table, "Table.border");
    }

    protected void installDefaults() {
        DropTarget dropTarget;
        TransferHandler th;
        Container parent;
        Color gridColor;
        Color sfg;
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        this.table.setIntercellSpacing(new Dimension(0, 0));
        Color sbg = this.table.getSelectionBackground();
        if (sbg == null || sbg instanceof UIResource) {
            this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        }
        if ((sfg = this.table.getSelectionForeground()) == null || sfg instanceof UIResource) {
            this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        }
        if ((gridColor = this.table.getGridColor()) == null || gridColor instanceof UIResource) {
            this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        }
        if ((parent = this.table.getParent()) != null && (parent = parent.getParent()) != null && parent instanceof JScrollPane) {
            LookAndFeel.installBorder((JScrollPane)parent, "Table.scrollPaneBorder");
        }
        if ((th = this.table.getTransferHandler()) == null || th instanceof UIResource) {
            this.table.setTransferHandler(defaultTransferHandler);
        }
        if ((dropTarget = this.table.getDropTarget()) instanceof UIResource) {
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TableDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.keyListener = this.createKeyListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.table.addFocusListener(this.focusListener);
        this.table.addKeyListener(this.keyListener);
        this.table.addMouseListener(defaultDragRecognizer);
        this.table.addMouseMotionListener(defaultDragRecognizer);
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
        this.table.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installKeyboardActions() {
        ActionMap map = this.getMyActionMap();
        SwingUtilities.replaceUIActionMap(this.table, map);
        InputMap inputMap = this.getMyInputMap(1);
        SwingUtilities.replaceUIInputMap(this.table, 1, inputMap);
    }

    InputMap getMyInputMap(int condition) {
        if (condition == 1) {
            InputMap rtlKeyMap;
            InputMap keyMap = (InputMap)UIManager.get("Table.ancestorInputMap");
            if (this.table.getComponentOrientation().isLeftToRight() || (rtlKeyMap = (InputMap)UIManager.get("Table.ancestorInputMap.RightToLeft")) == null) {
                return keyMap;
            }
            rtlKeyMap.setParent(keyMap);
            return rtlKeyMap;
        }
        return null;
    }

    ActionMap getMyActionMap() {
        ActionMap map = (ActionMap)UIManager.get("Table.actionMap");
        if (map == null && (map = this.createMyActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Table.actionMap", map);
        }
        return map;
    }

    ActionMap createMyActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("selectNextColumn", new NavigationalAction(1, 0, false, false, false));
        map.put("selectPreviousColumn", new NavigationalAction(-1, 0, false, false, false));
        map.put("selectNextRow", new NavigationalAction(0, 1, false, false, false));
        map.put("selectPreviousRow", new NavigationalAction(0, -1, false, false, false));
        map.put("selectNextColumnExtendSelection", new NavigationalAction(1, 0, false, true, false));
        map.put("selectPreviousColumnExtendSelection", new NavigationalAction(-1, 0, false, true, false));
        map.put("selectNextRowExtendSelection", new NavigationalAction(0, 1, false, true, false));
        map.put("selectPreviousRowExtendSelection", new NavigationalAction(0, -1, false, true, false));
        map.put("scrollUpChangeSelection", new PagingAction(false, false, true, false));
        map.put("scrollDownChangeSelection", new PagingAction(false, true, true, false));
        map.put("selectFirstColumn", new PagingAction(false, false, false, true));
        map.put("selectLastColumn", new PagingAction(false, true, false, true));
        map.put("scrollUpExtendSelection", new PagingAction(true, false, true, false));
        map.put("scrollDownExtendSelection", new PagingAction(true, true, true, false));
        map.put("selectFirstColumnExtendSelection", new PagingAction(true, false, false, true));
        map.put("selectLastColumnExtendSelection", new PagingAction(true, true, false, true));
        map.put("selectFirstRow", new PagingAction(false, false, true, true));
        map.put("selectLastRow", new PagingAction(false, true, true, true));
        map.put("selectFirstRowExtendSelection", new PagingAction(true, false, true, true));
        map.put("selectLastRowExtendSelection", new PagingAction(true, true, true, true));
        map.put("selectNextColumnCell", new NavigationalAction(1, 0, true, false, true));
        map.put("selectPreviousColumnCell", new NavigationalAction(-1, 0, true, false, true));
        map.put("selectNextRowCell", new NavigationalAction(0, 1, true, false, true));
        map.put("selectPreviousRowCell", new NavigationalAction(0, -1, true, false, true));
        map.put("selectAll", new SelectAllAction());
        map.put("cancel", new CancelEditingAction());
        map.put("startEditing", new StartEditingAction());
        map.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        map.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        map.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        if (this.table.getComponentOrientation().isLeftToRight()) {
            map.put("scrollLeftChangeSelection", new PagingAction(false, false, false, false));
            map.put("scrollRightChangeSelection", new PagingAction(false, true, false, false));
            map.put("scrollLeftExtendSelection", new PagingAction(true, false, false, false));
            map.put("scrollRightExtendSelection", new PagingAction(true, true, false, false));
        } else {
            map.put("scrollLeftChangeSelection", new PagingAction(false, true, false, false));
            map.put("scrollRightChangeSelection", new PagingAction(false, false, false, false));
            map.put("scrollLeftExtendSelection", new PagingAction(true, true, false, false));
            map.put("scrollRightExtendSelection", new PagingAction(true, false, false, false));
        }
        return map;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    protected void uninstallDefaults() {
        if (this.table.getTransferHandler() instanceof UIResource) {
            this.table.setTransferHandler(null);
        }
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(defaultDragRecognizer);
        this.table.removeMouseMotionListener(defaultDragRecognizer);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.table, 1, null);
        SwingUtilities.replaceUIActionMap(this.table, null);
    }

    private Dimension createTableSize(long width) {
        long tmp;
        int height = 0;
        int rowCount = this.table.getRowCount();
        if (rowCount > 0 && this.table.getColumnCount() > 0) {
            Rectangle r = this.table.getCellRect(rowCount - 1, 0, true);
            height = r.y + r.height;
        }
        if ((tmp = Math.abs(width)) > Integer.MAX_VALUE) {
            tmp = Integer.MAX_VALUE;
        }
        return new Dimension((int)tmp, height);
    }

    public Dimension getMinimumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        Dimension result = this.createTableSize(width);
        result.width += c.getInsets().left + c.getInsets().right;
        result.height += c.getInsets().top + c.getInsets().bottom;
        return result;
    }

    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        Dimension result = this.createTableSize(width);
        result.width += c.getInsets().left + c.getInsets().right;
        result.height += c.getInsets().top + c.getInsets().bottom;
        return result;
    }

    public Dimension getMaximumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMaxWidth();
        }
        Dimension result = this.createTableSize(width);
        result.width += c.getInsets().left + c.getInsets().right;
        result.height += c.getInsets().top + c.getInsets().bottom;
        return result;
    }

    public void paint(Graphics g, JComponent c) {
        boolean ltr;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Point upperLeft = clip.getLocation();
        upperLeft.x += c.getInsets().left;
        upperLeft.y += c.getInsets().top;
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        lowerRight.x += c.getInsets().left;
        lowerRight.y += c.getInsets().top;
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint((ltr = this.table.getComponentOrientation().isLeftToRight()) ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        boolean drawLastLine = false;
        if (c.getParent() != null && c.getParent() instanceof JViewport && c.getHeight() < ((JViewport)c.getParent()).getHeight()) {
            drawLastLine = true;
        }
        this.paintGrid(g, rMin, rMax, cMin, cMax, c.getInsets().left, c.getInsets().top, drawLastLine);
        this.paintCells(g, rMin, rMax, cMin, cMax, c.getInsets().left, c.getInsets().top);
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax, int dx, int dy, boolean drawLastLine) {
        g.setColor(this.table.getGridColor());
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        Rectangle damagedArea = minCell.union(maxCell);
        if (this.table.getShowHorizontalLines()) {
            int tableWidth = damagedArea.x + damagedArea.width;
            int y = damagedArea.y;
            int row = rMin;
            while (row <= rMax) {
                y += this.table.getRowHeight(row);
                if (row + 1 < this.table.getRowCount()) {
                    g.drawLine(damagedArea.x + dx, y - 1 + dy, tableWidth - 1 + dx, y - 1 + dy);
                }
                ++row;
            }
            if (drawLastLine) {
                g.drawLine(damagedArea.x + dx, y - 1 + dy, tableWidth - 1 + dx, y - 1 + dy);
            }
        }
        if (this.table.getShowVerticalLines()) {
            int x;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                x = damagedArea.x;
                int column = cMin;
                while (column <= cMax) {
                    int w = cm.getColumn(column).getWidth();
                    x += w;
                    if (column + 1 < this.table.getColumnCount()) {
                        g.drawLine(x - 1 + dx, 0 + dy, x - 1 + dx, tableHeight + dy);
                    }
                    ++column;
                }
            } else {
                x = damagedArea.x + damagedArea.width;
                int column = cMin;
                while (column < cMax) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x -= w) - 1 + dx, dy, x - 1 + dx, tableHeight + dy);
                    ++column;
                }
                g.drawLine((x -= cm.getColumn(cMax).getWidth()) + dx, dy, x + dx, tableHeight + dy);
            }
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        int column = 0;
        while (column < cm.getColumnCount()) {
            if (cm.getColumn(column) == aColumn) {
                return column;
            }
            ++column;
        }
        return -1;
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax, int dx, int dy) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            int row = rMin;
            while (row <= rMax) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                int column = cMin;
                while (column <= cMax) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, row, column, dx, dy);
                    }
                    cellRect.x += columnWidth;
                    ++column;
                }
                ++row;
            }
        } else {
            int row = rMin;
            while (row <= rMax) {
                int columnWidth;
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(g, cellRect, row, cMin, dx, dy);
                }
                int column = cMin + 1;
                while (column <= cMax) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, row, column, dx, dy);
                    }
                    ++column;
                }
                ++row;
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance(), dx, dy);
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance, int dx, int dy) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x + dx, vacatedColumnRect.y + dy, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x + dx, vacatedColumnRect.y + dy, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1 + dx, y1 + dy, x1 - 1 + dx, y2 + dy);
            g.drawLine(x2 + dx, y1 + dy, x2 + dx, y2 + dy);
        }
        int row = rMin;
        while (row <= rMax) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex, dx, dy);
            if (this.table.getShowHorizontalLines()) {
                g.setColor(this.table.getGridColor());
                Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
                rcr.x += distance;
                int x1 = rcr.x;
                int y1 = rcr.y;
                int x2 = x1 + rcr.width - 1;
                int y2 = y1 + rcr.height - 1;
                g.drawLine(x1 + dx, y2 + dy, x2 + dx, y2 + dy);
            }
            ++row;
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column, int dx, int dy) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x + dx, cellRect.y + dy, cellRect.width - 1, cellRect.height - 1, true);
        }
    }

    private static class NavigationalAction
    extends AbstractAction {
        protected int dx;
        protected int dy;
        protected boolean toggle;
        protected boolean extend;
        protected boolean inSelection;
        protected int anchorRow;
        protected int anchorColumn;
        protected int leadRow;
        protected int leadColumn;

        protected NavigationalAction(int dx, int dy, boolean toggle, boolean extend, boolean inSelection) {
            this.dx = dx;
            this.dy = dy;
            this.toggle = toggle;
            this.extend = extend;
            this.inSelection = inSelection;
        }

        private int clipToRange(int i, int a, int b) {
            return Math.min(Math.max(i, a), b - 1);
        }

        private void moveWithinTableRange(JTable table, int dx, int dy, boolean changeLead) {
            if (changeLead) {
                this.leadRow = this.clipToRange(this.leadRow + dy, 0, table.getRowCount());
                this.leadColumn = this.clipToRange(this.leadColumn + dx, 0, table.getColumnCount());
            } else {
                this.anchorRow = this.clipToRange(this.anchorRow + dy, 0, table.getRowCount());
                this.anchorColumn = this.clipToRange(this.anchorColumn + dx, 0, table.getColumnCount());
            }
        }

        private int selectionSpan(ListSelectionModel sm) {
            return sm.getMaxSelectionIndex() - sm.getMinSelectionIndex() + 1;
        }

        private int compare(int i, ListSelectionModel sm) {
            return this.compare(i, sm.getMinSelectionIndex(), sm.getMaxSelectionIndex() + 1);
        }

        private int compare(int i, int a, int b) {
            return i < a ? -1 : (i >= b ? 1 : 0);
        }

        private boolean moveWithinSelectedRange(JTable table, int dx, int dy, boolean ignoreCarry) {
            int colSgn;
            int rowSgn;
            int columnCount;
            boolean canStayInSelection;
            ListSelectionModel rsm = table.getSelectionModel();
            ListSelectionModel csm = table.getColumnModel().getSelectionModel();
            int newAnchorRow = this.anchorRow + dy;
            int newAnchorColumn = this.anchorColumn + dx;
            int rowCount = this.selectionSpan(rsm);
            boolean bl = canStayInSelection = rowCount * (columnCount = this.selectionSpan(csm)) > 1;
            if (canStayInSelection) {
                rowSgn = this.compare(newAnchorRow, rsm);
                colSgn = this.compare(newAnchorColumn, csm);
            } else {
                rowCount = table.getRowCount();
                columnCount = table.getColumnCount();
                rowSgn = this.compare(newAnchorRow, 0, rowCount);
                colSgn = this.compare(newAnchorColumn, 0, columnCount);
            }
            this.anchorRow = newAnchorRow - rowCount * rowSgn;
            this.anchorColumn = newAnchorColumn - columnCount * colSgn;
            if (!ignoreCarry) {
                return this.moveWithinSelectedRange(table, rowSgn, colSgn, true);
            }
            return canStayInSelection;
        }

        public void actionPerformed(ActionEvent e) {
            JTable table = (JTable)e.getSource();
            ListSelectionModel rsm = table.getSelectionModel();
            this.anchorRow = rsm.getAnchorSelectionIndex();
            this.leadRow = rsm.getLeadSelectionIndex();
            ListSelectionModel csm = table.getColumnModel().getSelectionModel();
            this.anchorColumn = csm.getAnchorSelectionIndex();
            this.leadColumn = csm.getLeadSelectionIndex();
            int oldAnchorRow = this.anchorRow;
            int oldAnchorColumn = this.anchorColumn;
            if (table.isEditing() && !table.getCellEditor().stopCellEditing()) {
                return;
            }
            if (!this.inSelection) {
                this.moveWithinTableRange(table, this.dx, this.dy, this.extend);
                if (!this.extend) {
                    table.changeSelection(this.anchorRow, this.anchorColumn, false, this.extend);
                } else {
                    table.changeSelection(this.leadRow, this.leadColumn, false, this.extend);
                }
            } else if (this.moveWithinSelectedRange(table, this.dx, this.dy, false)) {
                table.changeSelection(this.anchorRow, this.anchorColumn, true, true);
            } else {
                table.changeSelection(this.anchorRow, this.anchorColumn, false, false);
            }
        }
    }

    private static class PagingAction
    extends NavigationalAction {
        private boolean forwards;
        private boolean vertically;
        private boolean toLimit;

        PagingAction(boolean extend, boolean forwards, boolean vertically, boolean toLimit) {
            super(0, 0, false, extend, false);
            this.forwards = forwards;
            this.vertically = vertically;
            this.toLimit = toLimit;
        }

        public void actionPerformed(ActionEvent e) {
            JTable table = (JTable)e.getSource();
            if (this.toLimit) {
                if (this.vertically) {
                    int rowCount = table.getRowCount();
                    this.dx = 0;
                    this.dy = this.forwards ? rowCount : -rowCount;
                } else {
                    int colCount = table.getColumnCount();
                    this.dx = this.forwards ? colCount : -colCount;
                    this.dy = 0;
                }
            } else {
                int start;
                if (!(table.getParent().getParent() instanceof JScrollPane)) {
                    return;
                }
                Dimension delta = table.getParent().getSize();
                ListSelectionModel sm = this.vertically ? table.getSelectionModel() : table.getColumnModel().getSelectionModel();
                int n = start = this.extend ? sm.getLeadSelectionIndex() : sm.getAnchorSelectionIndex();
                if (this.vertically) {
                    Rectangle r = table.getCellRect(start, 0, true);
                    r.y = r.y + (this.forwards ? delta.height : -delta.height);
                    this.dx = 0;
                    int newRow = table.rowAtPoint(r.getLocation());
                    if (newRow == -1 && this.forwards) {
                        newRow = table.getRowCount();
                    }
                    this.dy = newRow - start;
                } else {
                    Rectangle r = table.getCellRect(0, start, true);
                    r.x = r.x + (this.forwards ? delta.width : -delta.width);
                    int newColumn = table.columnAtPoint(r.getLocation());
                    if (newColumn == -1 && this.forwards) {
                        newColumn = table.getColumnCount();
                    }
                    this.dx = newColumn - start;
                    this.dy = 0;
                }
            }
            super.actionPerformed(e);
        }
    }

    private static class SelectAllAction
    extends AbstractAction {
        SelectAllAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTable table = (JTable)e.getSource();
            table.selectAll();
        }
    }

    private static class CancelEditingAction
    extends AbstractAction {
        CancelEditingAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTable table = (JTable)e.getSource();
            table.removeEditor();
        }
    }

    private static class StartEditingAction
    extends AbstractAction {
        StartEditingAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTable table = (JTable)e.getSource();
            if (!table.hasFocus()) {
                TableCellEditor cellEditor = table.getCellEditor();
                if (cellEditor != null && !cellEditor.stopCellEditing()) {
                    return;
                }
                table.requestFocus();
                return;
            }
            ListSelectionModel rsm = table.getSelectionModel();
            int anchorRow = rsm.getAnchorSelectionIndex();
            ListSelectionModel csm = table.getColumnModel().getSelectionModel();
            int anchorColumn = csm.getAnchorSelectionIndex();
            table.editCellAt(anchorRow, anchorColumn);
            Component editorComp = table.getEditorComponent();
            if (editorComp != null) {
                editorComp.requestFocus();
            }
        }
    }

    public class KeyHandler
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke((int)e.getKeyChar(), e.getModifiers());
            InputMap map = TableUI.this.table.getInputMap(0);
            if (map != null && map.get(keyStroke) != null) {
                return;
            }
            map = TableUI.this.table.getInputMap(1);
            if (map != null && map.get(keyStroke) != null) {
                return;
            }
            keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            if (e.getKeyChar() == '\r') {
                return;
            }
            int anchorRow = TableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
            int anchorColumn = TableUI.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (anchorRow != -1 && anchorColumn != -1 && !TableUI.this.table.isEditing() && !TableUI.this.table.editCellAt(anchorRow, anchorColumn)) {
                return;
            }
            Component editorComp = TableUI.this.table.getEditorComponent();
            if (TableUI.this.table.isEditing() && editorComp != null && editorComp instanceof JComponent) {
                Object binding;
                JComponent component = (JComponent)editorComp;
                map = component.getInputMap(0);
                Object object = binding = map != null ? map.get(keyStroke) : null;
                if (binding == null) {
                    map = component.getInputMap(1);
                    Object object2 = binding = map != null ? map.get(keyStroke) : null;
                }
                if (binding != null) {
                    Action action;
                    ActionMap am = component.getActionMap();
                    Action action2 = action = am != null ? am.get(binding) : null;
                    if (action != null && SwingUtilities.notifyAction(action, keyStroke, e, component, e.getModifiers())) {
                        e.consume();
                    }
                }
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        private void repaintAnchorCell() {
            int rc = TableUI.this.table.getRowCount();
            int cc = TableUI.this.table.getColumnCount();
            int ar = TableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
            int ac = TableUI.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (ar < 0 || ar >= rc || ac < 0 || ac >= cc) {
                return;
            }
            Rectangle dirtyRect = TableUI.this.table.getCellRect(ar, ac, false);
            TableUI.this.table.repaint(dirtyRect);
        }

        public void focusGained(FocusEvent e) {
            this.repaintAnchorCell();
        }

        public void focusLost(FocusEvent e) {
            this.repaintAnchorCell();
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private Component dispatchComponent;
        private boolean selectedOnPress;

        public void mouseClicked(MouseEvent e) {
        }

        private void setDispatchComponent(MouseEvent e) {
            Component editorComponent = TableUI.this.table.getEditorComponent();
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(TableUI.this.table, p, editorComponent);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
        }

        private boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null || !TableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(TableUI.this.table, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        private void setValueIsAdjusting(boolean flag) {
            TableUI.this.table.getSelectionModel().setValueIsAdjusting(flag);
            TableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }

        private boolean shouldIgnore(MouseEvent e) {
            return e.isConsumed() || !SwingUtilities.isLeftMouseButton(e) || !TableUI.this.table.isEnabled();
        }

        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(e);
        }

        void adjustFocusAndSelection(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            Point p = e.getPoint();
            int row = TableUI.this.table.rowAtPoint(p);
            int column = TableUI.this.table.columnAtPoint(p);
            if (column == -1 || row == -1) {
                return;
            }
            if (TableUI.this.table.editCellAt(row, column, e)) {
                this.setDispatchComponent(e);
                this.repostEvent(e);
            } else if (TableUI.this.table.isRequestFocusEnabled()) {
                TableUI.this.table.requestFocus();
            }
            TableCellEditor editor = TableUI.this.table.getCellEditor();
            if (editor == null || editor.shouldSelectCell(e)) {
                boolean adjusting = e.getID() == 501;
                this.setValueIsAdjusting(adjusting);
                TableUI.this.table.changeSelection(row, column, e.isControlDown(), e.isShiftDown());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.selectedOnPress) {
                if (this.shouldIgnore(e)) {
                    return;
                }
                this.repostEvent(e);
                this.dispatchComponent = null;
                this.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            this.repostEvent(e);
            TableCellEditor editor = TableUI.this.table.getCellEditor();
            if (editor == null || editor.shouldSelectCell(e)) {
                Point p = e.getPoint();
                int row = TableUI.this.table.rowAtPoint(p);
                int column = TableUI.this.table.columnAtPoint(p);
                if (column == -1 || row == -1) {
                    return;
                }
                TableUI.this.table.changeSelection(row, column, false, true);
            }
        }
    }

    static class TableDragGestureRecognizer
    extends TonicDragGestureRecognizer {
        TableDragGestureRecognizer() {
        }

        protected boolean isDragPossible(MouseEvent e) {
            JTable table;
            if (super.isDragPossible(e) && (table = (JTable)this.getComponent(e)).getDragEnabled()) {
                Point p = e.getPoint();
                int row = table.rowAtPoint(p);
                int column = table.columnAtPoint(p);
                if (column != -1 && row != -1 && table.isCellSelected(row, column)) {
                    return true;
                }
            }
            return false;
        }
    }

    static class TableDropTargetListener
    extends TonicDropTargetListener {
        private int[] rows;
        private int[] cols;

        TableDropTargetListener() {
        }

        protected void saveComponentState(JComponent comp) {
            JTable table = (JTable)comp;
            this.rows = table.getSelectedRows();
            this.cols = table.getSelectedColumns();
        }

        protected void restoreComponentState(JComponent comp) {
            JTable table = (JTable)comp;
            table.clearSelection();
            int i = 0;
            while (i < this.rows.length) {
                table.addRowSelectionInterval(this.rows[i], this.rows[i]);
                ++i;
            }
            i = 0;
            while (i < this.cols.length) {
                table.addColumnSelectionInterval(this.cols[i], this.cols[i]);
                ++i;
            }
        }

        protected void updateInsertionLocation(JComponent comp, Point p) {
            JTable table = (JTable)comp;
            int row = table.rowAtPoint(p);
            int col = table.columnAtPoint(p);
            if (row != -1) {
                table.setRowSelectionInterval(row, row);
            }
            if (col != -1) {
                table.setColumnSelectionInterval(col, col);
            }
        }
    }

    static class TableTransferHandler
    extends TransferHandler
    implements UIResource {
        TableTransferHandler() {
        }

        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTable) {
                int[] cols;
                int counter;
                int[] rows;
                JTable table = (JTable)c;
                if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
                    return null;
                }
                if (!table.getRowSelectionAllowed()) {
                    int rowCount = table.getRowCount();
                    rows = new int[rowCount];
                    counter = 0;
                    while (counter < rowCount) {
                        rows[counter] = counter;
                        ++counter;
                    }
                } else {
                    rows = table.getSelectedRows();
                }
                if (!table.getColumnSelectionAllowed()) {
                    int colCount = table.getColumnCount();
                    cols = new int[colCount];
                    counter = 0;
                    while (counter < colCount) {
                        cols[counter] = counter;
                        ++counter;
                    }
                } else {
                    cols = table.getSelectedColumns();
                }
                if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
                    return null;
                }
                StringBuffer plainBuf = new StringBuffer();
                StringBuffer htmlBuf = new StringBuffer();
                htmlBuf.append("<html>\n<body>\n<table>\n");
                int row = 0;
                while (row < rows.length) {
                    htmlBuf.append("<tr>\n");
                    int col = 0;
                    while (col < cols.length) {
                        Object obj = table.getValueAt(rows[row], cols[col]);
                        String val = obj == null ? "" : obj.toString();
                        plainBuf.append(String.valueOf(val) + "\t");
                        htmlBuf.append("  <td>" + val + "</td>\n");
                        ++col;
                    }
                    plainBuf.deleteCharAt(plainBuf.length() - 1).append("\n");
                    htmlBuf.append("</tr>\n");
                    ++row;
                }
                plainBuf.deleteCharAt(plainBuf.length() - 1);
                htmlBuf.append("</table>\n</body>\n</html>");
                return new TonicTransferable(plainBuf.toString(), htmlBuf.toString());
            }
            return null;
        }

        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            DropTarget dropTarget;
            String changeName = event.getPropertyName();
            if (changeName.equals("componentOrientation")) {
                InputMap inputMap = TableUI.this.getMyInputMap(1);
                SwingUtilities.replaceUIInputMap(TableUI.this.table, 1, inputMap);
                UIManager.getLookAndFeelDefaults().put("Table.actionMap", (Object)null);
                ActionMap actionMap = TableUI.this.getMyActionMap();
                SwingUtilities.replaceUIActionMap(TableUI.this.table, actionMap);
                JTableHeader header = TableUI.this.table.getTableHeader();
                if (header != null) {
                    header.setComponentOrientation((ComponentOrientation)event.getNewValue());
                }
            } else if ("transferHandler".equals(changeName) && (dropTarget = TableUI.this.table.getDropTarget()) instanceof UIResource) {
                if (defaultDropTargetListener == null) {
                    defaultDropTargetListener = new TableDropTargetListener();
                }
                try {
                    dropTarget.addDropTargetListener(defaultDropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    // empty catch block
                }
            }
        }
    }
}

