/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.graph.GraphState;
import de.grogra.math.BSpline;
import de.grogra.math.BSplineCurve;
import de.grogra.math.VertexListImpl;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;

public class BSplineCurveImpl
extends VertexListImpl
implements BSplineCurve {
    int degree = 3;
    boolean periodic;
    boolean rational;
    public static final Type $TYPE = new Type(BSplineCurveImpl.class);
    public static final SCOType.Field degree$FIELD = Type._addManagedField($TYPE, "degree", 0x200000, de.grogra.reflect.Type.INT, null, 2);
    public static final SCOType.Field periodic$FIELD = Type._addManagedField($TYPE, "periodic", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 3);
    public static final SCOType.Field rational$FIELD = Type._addManagedField($TYPE, "rational", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 4);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    public void setPeriodic(boolean bl) {
        this.periodic = bl;
    }

    public boolean isRational() {
        return this.rational;
    }

    public void setRational(boolean bl) {
        this.rational = bl;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int n) {
        this.degree = n;
    }

    public BSplineCurveImpl() {
    }

    public BSplineCurveImpl(float[] fArray, int n, int n2, boolean bl, boolean bl2) {
        super(fArray, n);
        this.degree = n2;
        this.periodic = bl;
        this.rational = bl2;
    }

    public static BSplineCurveImpl create(float[] fArray, int n, int n2, boolean bl, boolean bl2) {
        BSplineCurveImpl bSplineCurveImpl = new BSplineCurveImpl(null, n, n2, bl2, false);
        int n3 = fArray.length;
        int n4 = n3 / n + (bl2 ? 2 : 1) * n2;
        bSplineCurveImpl.data = new float[n3 + n4 + 1];
        System.arraycopy(fArray, 0, bSplineCurveImpl.data, 0, n3);
        BSpline.makeDefaultKnotVector(bSplineCurveImpl.data, n3, n4 - n2, n2, !bl);
        return bSplineCurveImpl;
    }

    protected int getCount() {
        return (this.data.length - ((this.periodic ? 2 * this.degree : this.degree) + 1)) / (this.dimension + 1);
    }

    public int getVertex(float[] fArray, int n, GraphState graphState) {
        int n2 = this.getCount();
        return super.getVertex(fArray, n < n2 ? n : n - n2, graphState);
    }

    public int getSize(GraphState graphState) {
        return this.getCount() + (this.periodic ? this.degree : 0);
    }

    public int getDegree(GraphState graphState) {
        return this.degree;
    }

    public float getKnot(int n, int n2, GraphState graphState) {
        return this.data[this.getKnotIndex(n2)];
    }

    protected int getKnotIndex(int n) {
        return this.getCount() * this.dimension + n;
    }

    public boolean isRational(GraphState graphState) {
        return this.rational;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends VertexListImpl.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 5;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(BSplineCurveImpl bSplineCurveImpl, SCOType sCOType) {
            super(bSplineCurveImpl, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)VertexListImpl.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 3: {
                    ((BSplineCurveImpl)object).periodic = bl;
                    return;
                }
                case 4: {
                    ((BSplineCurveImpl)object).rational = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 3: {
                    return ((BSplineCurveImpl)object).isPeriodic();
                }
                case 4: {
                    return ((BSplineCurveImpl)object).isRational();
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 2: {
                    ((BSplineCurveImpl)object).degree = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((BSplineCurveImpl)object).getDegree();
                }
            }
            return super.getInt(object, n);
        }

        public Object newInstance() {
            return new BSplineCurveImpl();
        }
    }
}

