/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.math.Matrix3dType;
import de.grogra.math.TVector2d;
import de.grogra.math.Transform2D;
import de.grogra.persistence.Manageable;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.Transaction;
import de.grogra.vecmath.Math2;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple2d;

public final class TMatrix3d
extends Matrix3d
implements Transform2D {
    public static final ManageableType $TYPE = new Matrix3dType(new TMatrix3d(), (SCOType)Matrix3dType.$TYPE).validate();
    private transient int stamp = 0;

    public TMatrix3d() {
        this.setIdentity();
    }

    public TMatrix3d(Matrix3d matrix3d) {
        super(matrix3d);
    }

    public TMatrix3d(Tuple2d tuple2d) {
        this.setIdentity();
        this.m02 = tuple2d.x;
        this.m12 = tuple2d.y;
    }

    public Object clone() {
        return new TMatrix3d(this);
    }

    public void transform(Matrix3d matrix3d, Matrix3d matrix3d2) {
        Math2.mulAffine((Matrix3d)matrix3d2, (Matrix3d)matrix3d, (Matrix3d)this);
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public static Transform2D createTransform(Matrix3d matrix3d) {
        double d;
        double d2 = matrix3d.m00 - 1.0;
        double d3 = d2 * d2;
        d2 = matrix3d.m01;
        double d4 = d3 + d2 * d2;
        d2 = matrix3d.m10;
        double d5 = d4 + d2 * d2;
        d2 = matrix3d.m11 - 1.0;
        if (d5 + d * d2 < 1.0E-8) {
            double d6;
            d2 = matrix3d.m02;
            double d7 = d2 * d2;
            d2 = matrix3d.m12;
            if (d7 + d6 * d2 < 1.0E-16) {
                return null;
            }
            return new TVector2d(matrix3d.m02, matrix3d.m12);
        }
        return new TMatrix3d(matrix3d);
    }

    public void fieldModified(PersistenceField persistenceField, int[] nArray, Transaction transaction) {
        ++this.stamp;
    }

    public int getStamp() {
        return this.stamp;
    }

    public Manageable manageableReadResolve() {
        return this;
    }

    public Object manageableWriteReplace() {
        return this;
    }
}

