/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.base;

import de.grogra.xl.impl.base.EdgeIterator;
import de.grogra.xl.impl.base.NodeEdgePair;
import de.grogra.xl.impl.base.Operator;
import de.grogra.xl.impl.base.RuntimeModel;
import de.grogra.xl.lang.ObjectConsumer;
import de.grogra.xl.query.EdgeDirection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neighbors<N>
implements Operator<N> {
    protected final RuntimeModel model;
    protected final int mask;
    protected final int copy;
    protected final int add;
    protected final int addWhenMatching;
    protected final int addOrCopy;
    protected final boolean outgoing;

    public Neighbors(RuntimeModel runtimeModel, int n, int n2, int n3, int n4, boolean bl) {
        this.model = runtimeModel;
        this.mask = n;
        this.copy = n2;
        this.add = n3;
        this.addWhenMatching = n4;
        this.addOrCopy = RuntimeModel.edgeBitsUnion(n2, n3);
        this.outgoing = bl;
    }

    @Override
    public int match(N n, Operator<N> operator, NodeEdgePair<N> nodeEdgePair) {
        int n2;
        if (!RuntimeModel.testEdgeBits(nodeEdgePair.edgeBits, this.addOrCopy)) {
            return 0;
        }
        int n3 = n2 = this.outgoing ? this.model.getEdgeBits(nodeEdgePair.node, n) : this.model.getEdgeBits(n, nodeEdgePair.node);
        if (!RuntimeModel.testEdgeBits(n2, this.mask)) {
            return 255;
        }
        n2 = RuntimeModel.edgeBitsUnion(RuntimeModel.edgeBitsIntersection(n2, this.copy), this.add);
        int n4 = nodeEdgePair.edgeBits;
        if (operator instanceof Neighbors) {
            n2 = RuntimeModel.edgeBitsUnion(n2, this.addWhenMatching);
            n4 = RuntimeModel.edgeBitsUnion(n4, ((Neighbors)operator).addWhenMatching);
        }
        return (n2 = RuntimeModel.edgeBitsIntersection(n2, n4)) != 0 ? n2 : 255;
    }

    @Override
    public int getUnilateralEdgeBits(N n, NodeEdgePair<N> nodeEdgePair) {
        return nodeEdgePair.edgeBits;
    }

    public void evaluateObject(ObjectConsumer<? super NodeEdgePair<N>> objectConsumer, N n) {
        NodeEdgePair nodeEdgePair = new NodeEdgePair();
        nodeEdgePair.node = n;
        this.evaluate(objectConsumer, nodeEdgePair);
    }

    @Override
    public void evaluate(ObjectConsumer<? super NodeEdgePair<N>> objectConsumer, NodeEdgePair<N> nodeEdgePair) {
        Object n = nodeEdgePair.node;
        EdgeIterator edgeIterator = this.model.createEdgeIterator(n, (EdgeDirection)EdgeDirection.UNDIRECTED);
        while (edgeIterator.hasEdge()) {
            if (edgeIterator.source == n == this.outgoing && RuntimeModel.testEdgeBits(edgeIterator.edgeBits, this.mask)) {
                nodeEdgePair.node = this.outgoing ? edgeIterator.target : edgeIterator.source;
                nodeEdgePair.edgeBits = RuntimeModel.edgeBitsUnion(RuntimeModel.edgeBitsIntersection(edgeIterator.edgeBits, this.copy), this.add);
                objectConsumer.consume(nodeEdgePair);
            }
            edgeIterator.moveToNext();
        }
    }
}

