/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.dom;

import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.impl.base.EdgeIterator;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.util.ObjectList;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class RuntimeModel
extends de.grogra.xl.impl.base.RuntimeModel {
    public static final int SIBLING = 16384;
    public static final int ATTRIBUTE = 32768;
    static final int CHILD = 768;
    final ObjectList iterators = new ObjectList();
    static final int START = -1;
    static final int PARENT = 0;
    static final int PREV = 1;
    static final int NEXT = 2;
    static final int CHILDREN_ATTRIBUTES = 3;

    public Class getNodeType() {
        return Node.class;
    }

    public void addEdgeBits(Object object, Object object2, int n) {
        if (!RuntimeModel.addEdgeBits((Node)object, (Node)object2, n)) {
            System.out.println("Cannot make " + object + " and " + object2 + " siblings");
        }
    }

    static boolean addEdgeBits(Node node, Node node2, int n) {
        if ((n & 0x300) != 0) {
            node.appendChild(node2);
        } else if ((n & 0x4000) != 0) {
            Node node3 = node.getParentNode();
            if (node3 != null) {
                node3.insertBefore(node2, node.getNextSibling());
            } else {
                node3 = node2.getParentNode();
                if (node3 != null) {
                    node3.insertBefore(node, node2);
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    public int getEdgeBits(Object object, Object object2) {
        Node node = (Node)object;
        Node node2 = (Node)object2;
        Node node3 = node2.getParentNode();
        if (node3 != null && node.equals(node3)) {
            return 768;
        }
        node3 = node2.getPreviousSibling();
        if (node3 != null && node.equals(node3)) {
            return 16384;
        }
        if (node2.getNodeType() == 2 && node.getNodeType() == 1 && ((Element)node).getAttributeNode(node2.getLocalName()) == node2) {
            return 32768;
        }
        return 0;
    }

    public boolean isWrapperFor(Object object, Type type) {
        if (Reflection.equal((Type)type, (Type)Type.STRING)) {
            return ((Node)object).getNodeType() == 3;
        }
        return false;
    }

    public Object unwrapObject(Object object) {
        Node node = (Node)object;
        switch (node.getNodeType()) {
            case 3: {
                return ((Text)node).getData();
            }
        }
        return null;
    }

    public synchronized EdgeIterator createEdgeIterator(Object object, EdgeDirection edgeDirection) {
        Iterator iterator = this.iterators.isEmpty() ? new Iterator() : (Iterator)this.iterators.pop();
        iterator.node = (Node)object;
        iterator.state = -1;
        iterator.children = true;
        iterator.child = null;
        iterator.attribs = null;
        iterator.direction = edgeDirection;
        iterator.moveToNext();
        return iterator;
    }

    private final class Iterator
    extends EdgeIterator {
        Node node;
        private int state;
        private boolean children;
        private Node child;
        private NamedNodeMap attribs;
        private int attrIndex;
        private EdgeDirection direction;

        private Iterator() {
        }

        /*
         * Unable to fully structure code
         */
        public void moveToNext() {
            block5: while (true) {
                switch (++this.state) {
                    case 0: {
                        this.source = this.node.getParentNode();
                        if (this.source == null) continue block5;
                        this.target = this.node;
                        this.edgeBits = 768;
                        return;
                    }
                    case 1: {
                        this.source = this.node.getPreviousSibling();
                        if (this.source == null) continue block5;
                        this.target = this.node;
                        this.edgeBits = 16384;
                        return;
                    }
                    case 2: {
                        this.target = this.node.getNextSibling();
                        if (this.target != null) ** break;
                        continue block5;
                        this.source = this.node;
                        this.edgeBits = 16384;
                        return;
                    }
                }
                break;
            }
            if (this.children) {
                if (this.child == null) {
                    this.child = this.node.getFirstChild();
                    this.source = this.node;
                    this.edgeBits = 768;
                } else {
                    this.child = this.child.getNextSibling();
                }
                this.target = this.child;
                if (this.child != null) {
                    return;
                }
                this.children = false;
                if (this.direction.contains((EdgeDirection)EdgeDirection.FORWARD) && this.node.getNodeType() == 1) {
                    this.attribs = this.node.getAttributes();
                    this.source = this.node;
                    this.edgeBits = 32768;
                    this.attrIndex = 0;
                }
            }
            if (this.attribs != null) {
                if (this.attrIndex < this.attribs.getLength()) {
                    this.target = this.attribs.item(this.attrIndex++);
                } else {
                    this.attribs = null;
                }
            }
        }

        public boolean hasEdge() {
            return this.state < 3 || this.children || this.attribs != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            this.child = null;
            this.source = null;
            this.target = null;
            this.attribs = null;
            RuntimeModel runtimeModel = RuntimeModel.this;
            synchronized (runtimeModel) {
                this.node = null;
                RuntimeModel.this.iterators.push((Object)this);
            }
        }
    }
}

