/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.queues;

import de.grogra.xl.impl.queues.Queue;
import de.grogra.xl.impl.queues.QueueCollection;
import de.grogra.xl.util.ObjectList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueueDescriptor<Q extends Queue> {
    public static final QueueDescriptor[] DESCRIPTOR_0 = new QueueDescriptor[0];
    private static final ObjectList<QueueDescriptor<?>> order = new ObjectList();
    private static boolean orderValid = false;
    private final ObjectList<QueueDescriptor<?>> before = new ObjectList();

    public QueueDescriptor() {
        QueueDescriptor.add(this);
    }

    private static synchronized void add(QueueDescriptor queueDescriptor) {
        if (!order.contains((Object)queueDescriptor)) {
            order.add((Object)queueDescriptor);
            orderValid = false;
        }
    }

    public static synchronized void addOrder(List<? super QueueDescriptor<?>> list) {
        if (!orderValid) {
            QueueDescriptor[] queueDescriptorArray;
            do {
                Object[] objectArray;
                for (QueueDescriptor queueDescriptor : queueDescriptorArray = (QueueDescriptor[])order.toArray((Object[])new QueueDescriptor[order.size()])) {
                    queueDescriptor.before.clear();
                    objectArray = queueDescriptor.queuesToProcessBefore();
                    queueDescriptor.before.addAll(objectArray, 0, objectArray.length);
                }
                for (QueueDescriptor queueDescriptor : queueDescriptorArray) {
                    Object[] objectArray2 = objectArray = queueDescriptor.queuesToProcessAfter();
                    int n = objectArray2.length;
                    for (int i = 0; i < n; ++i) {
                        Object object = objectArray2[i];
                        ((QueueDescriptor)object).before.add((Object)queueDescriptor);
                    }
                }
            } while (order.size() > queueDescriptorArray.length);
            order.clear();
            int n = queueDescriptorArray.length;
            while (n > 0) {
                int n2 = 0;
                for (int i = 0; i < queueDescriptorArray.length; ++i) {
                    QueueDescriptor queueDescriptor;
                    queueDescriptor = queueDescriptorArray[i];
                    if (queueDescriptor == null || !queueDescriptor.before.isEmpty()) continue;
                    queueDescriptorArray[i] = null;
                    n2 = 1;
                    order.add((Object)queueDescriptor);
                    --n;
                    for (QueueDescriptor queueDescriptor2 : queueDescriptorArray) {
                        if (queueDescriptor2 == null) continue;
                        while (queueDescriptor2.before.remove((Object)queueDescriptor)) {
                        }
                    }
                }
                if (n2 != 0) continue;
                throw new Error("Circularity");
            }
            orderValid = true;
        }
        list.addAll((Collection<QueueDescriptor<?>>)order);
    }

    public final boolean equals(Object object) {
        return object == this || object != null && object.getClass() == this.getClass();
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    protected abstract QueueDescriptor[] queuesToProcessBefore();

    protected abstract QueueDescriptor[] queuesToProcessAfter();

    public abstract Q createQueue(QueueCollection var1);
}

