/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.billboard;

import de.grogra.billboard.Billboarder;
import de.grogra.billboard.RotationCamera;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Null;
import de.grogra.imp3d.objects.Parallelogram;
import de.grogra.imp3d.objects.ShadedNull;
import de.grogra.imp3d.shading.Light;
import de.grogra.math.TVector3d;
import de.grogra.util.MimeType;
import de.grogra.vecmath.geom.HalfSpace;
import de.grogra.vecmath.geom.Line;
import de.grogra.xl.util.ObjectList;
import java.io.File;
import java.io.IOException;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class CakeBillboarder
extends Billboarder {
    protected int visibleLayer = 0;
    protected int invisibleLayer = 15;
    protected float centerWidth = 0.01f;
    protected float centerHeight = 30.0f;

    public CakeBillboarder(File file, MimeType mimeType) {
        this.camera = new RotationCamera();
        this.view3d = this.camera.getView3D();
        try {
            super.setDestination(file, mimeType);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setCenterDim(float f, float f2) {
        this.centerWidth = f;
        this.centerHeight = f2;
    }

    public void setLayer(int n, int n2) {
        if (n < 16 && n >= 0) {
            this.visibleLayer = n;
        }
        if (n2 < 16 && n2 >= 0) {
            this.invisibleLayer = n2;
        }
    }

    public void billboarding() {
        this.cake();
        super.billboarding();
    }

    public void cake() {
        this.cake(this.currentSide);
    }

    public void cake(int n) {
        HalfSpace halfSpace = new HalfSpace();
        HalfSpace halfSpace2 = new HalfSpace();
        Line line = new Line((Tuple3d)new Point3d(), (Vector3d)new TVector3d(0.0, 0.0, 1.0), 0.0, (double)this.centerHeight);
        double d = Math.toRadians((float)(this.RotationAngle * (double)n - this.RotationAngle / 2.0));
        double d2 = Math.toRadians((float)(this.RotationAngle * (double)n + this.RotationAngle / 2.0));
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        TVector3d tVector3d = new TVector3d(Math.sin(d), Math.cos(d), 0.0);
        TVector3d tVector3d2 = new TVector3d(Math.sin(d2), Math.cos(d2), 0.0);
        halfSpace.setTransformation((Tuple3d)point3d, (Tuple3d)tVector3d);
        halfSpace2.setTransformation((Tuple3d)point3d, (Tuple3d)tVector3d2);
        ObjectList objectList = new ObjectList(100);
        objectList.push((Object)CakeBillboarder.graph().getRoot());
        Point3d point3d2 = new Point3d();
        while (!objectList.isEmpty()) {
            Node node = (Node)objectList.pop();
            if (node instanceof ShadedNull && (!(node instanceof Light) || node instanceof Parallelogram)) {
                point3d2 = CakeBillboarder.location((Node)((Null)node));
                if (halfSpace.contains((Tuple3d)point3d2, true) ^ halfSpace2.contains((Tuple3d)point3d2, true) || line.distance((Tuple3d)point3d2) < (double)this.centerWidth) {
                    ((Null)node).setLayer(this.visibleLayer);
                } else {
                    ((Null)node).setLayer(this.invisibleLayer);
                }
            }
            for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                Node node2 = edge.getTarget();
                if (node2 == node || !edge.testEdgeBits(768)) continue;
                objectList.push((Object)node2);
            }
        }
    }

    protected void setRunLater() {
        this.nextSide();
        this.cake();
        this.billboarding();
    }
}

