/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.imp.ViewEventHandler;
import de.grogra.imp3d.View3D;
import de.grogra.util.DisposableEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.EventObject;

public class Navigator3D
implements DisposableEventListener {
    protected final ViewEventHandler handler;
    protected int lastX;
    protected int lastY;
    protected final boolean wheel;

    public Navigator3D(ViewEventHandler viewEventHandler, EventObject eventObject) {
        this.handler = viewEventHandler;
        this.lastX = ((MouseEvent)eventObject).getX();
        this.lastY = ((MouseEvent)eventObject).getY();
        this.wheel = eventObject instanceof MouseWheelEvent;
    }

    public void dispose() {
    }

    public void eventOccured(EventObject eventObject) {
        if (!(eventObject instanceof MouseEvent)) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)eventObject;
        mouseEvent.consume();
        if (this.wheel) {
            if (!(mouseEvent instanceof MouseWheelEvent)) {
                this.handler.disposeNavigator((EventObject)mouseEvent);
                return;
            }
            ((View3D)this.handler.getView()).dollyOrZoom(0, ((MouseWheelEvent)mouseEvent).getWheelRotation() << 5);
            return;
        }
        switch (mouseEvent.getID()) {
            case 502: 
            case 503: {
                this.handler.disposeNavigator(null);
                return;
            }
            case 506: {
                int n = mouseEvent.getX() - this.lastX;
                int n2 = mouseEvent.getY() - this.lastY;
                if (n == 0 && n2 == 0) {
                    return;
                }
                this.lastX += n;
                this.lastY += n2;
                if (mouseEvent.isMetaDown()) {
                    ((View3D)this.handler.getView()).dollyOrZoom(n, n2);
                    break;
                }
                if (mouseEvent.isAltDown()) {
                    ((View3D)this.handler.getView()).move(n, n2);
                    break;
                }
                ((View3D)this.handler.getView()).rotate(n, n2);
            }
        }
    }
}

