/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.PolygonizationCache;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.VolumeBuilderBase;
import de.grogra.imp3d.shading.Shader;
import de.grogra.math.Pool;
import de.grogra.vecmath.geom.Volume;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public abstract class VolumeBuilder
extends VolumeBuilderBase
implements RenderState {
    private Graphics graphics;
    private View3D view;
    private Pool pool = new Pool();

    public VolumeBuilder(PolygonizationCache polygonizationCache, float f) {
        super(polygonizationCache, f);
    }

    protected abstract void addVolume(Volume var1, Matrix4d var2, Shader var3);

    private void createVolume(Volume volume, Matrix4d matrix4d, Shader shader) {
        if (volume != null) {
            this.addVolume(volume, matrix4d, shader);
        }
    }

    public Pool getPool() {
        return this.pool;
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.graphics.getFontMetrics(font);
    }

    public int getCurrentHighlight() {
        return 0;
    }

    public float estimateScaleAt(Tuple3f tuple3f) {
        return this.view != null ? this.view.estimateScaleAt(tuple3f, this.getCurrentTransformation()) : 1.0f / this.epsilon;
    }

    public void drawPoint(Tuple3f tuple3f, int n, Tuple3f tuple3f2, int n2, Matrix4d matrix4d) {
    }

    public void drawPointCloud(float[] fArray, float f, Tuple3f tuple3f, int n, Matrix4d matrix4d) {
    }

    public void drawLine(Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, int n, Matrix4d matrix4d) {
    }

    public void drawParallelogram(float f, Vector3f vector3f, float f2, float f3, Shader shader, int n, Matrix4d matrix4d) {
        matrix4d = this.getTransformation(matrix4d);
        this.createVolume((Volume)this.buildParallelogram(f, vector3f, f2, f3, matrix4d), matrix4d, shader);
    }

    public void drawPlane(Shader shader, int n, Matrix4d matrix4d) {
        matrix4d = this.getTransformation(matrix4d);
        this.createVolume((Volume)this.buildPlane(matrix4d), matrix4d, shader);
    }

    public void drawSphere(float f, Shader shader, int n, Matrix4d matrix4d) {
        matrix4d = this.getTransformation(matrix4d);
        this.createVolume((Volume)this.buildSphere(f, matrix4d), matrix4d, shader);
    }

    public void drawSupershape(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Shader shader, int n, Matrix4d matrix4d) {
        matrix4d = this.getTransformation(matrix4d);
        this.createVolume((Volume)this.buildSupershape(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, matrix4d), matrix4d, shader);
    }

    public void drawBox(float f, float f2, float f3, Shader shader, int n, Matrix4d matrix4d) {
        matrix4d = this.getTransformation(matrix4d);
        this.createVolume((Volume)this.buildBox(f, f2, f3, matrix4d), matrix4d, shader);
    }

    public void drawFrustum(float f, float f2, float f3, boolean bl, boolean bl2, float f4, Shader shader, int n, Matrix4d matrix4d) {
        matrix4d = this.getTransformation(matrix4d);
        this.createVolume((Volume)this.buildBaseFrustum(f, f2, f3, bl, bl2, f4, matrix4d), matrix4d, shader);
    }

    public void drawPolygons(Polygonizable polygonizable, Object object, boolean bl, Shader shader, int n, Matrix4d matrix4d) {
        matrix4d = this.getTransformation(matrix4d);
        this.createVolume((Volume)this.buildPolygons(polygonizable, object, bl, matrix4d), matrix4d, shader);
    }

    public boolean getWindowPos(Tuple3f tuple3f, Tuple2f tuple2f) {
        return false;
    }

    public void drawRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
    }

    public void fillRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
    }

    public void drawString(int n, int n2, String string, Font font, Tuple3f tuple3f) {
    }
}

