/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.gl20.GL20MeshServer;
import de.grogra.imp3d.gl20.GL20ResourceMeshMultiUser;
import de.grogra.imp3d.gl20.GL20ResourceShape;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import javax.vecmath.Matrix4d;

public class GL20ResourceShapeSphere
extends GL20ResourceShape {
    private static final String MESH_SPHERE_NAME = new String("SPHERE");
    private static final int RADIUS = 1;
    private int changeMask = -1;
    private float radius = 1.0f;
    private GL20ResourceMeshMultiUser mesh;

    private final PolygonArray createSpherePolygonArray(int n) {
        if (n < 3) {
            return null;
        }
        PolygonArray polygonArray = new PolygonArray();
        polygonArray.init(3);
        polygonArray.planar = true;
        polygonArray.edgeCount = 3;
        FloatList floatList = polygonArray.vertices;
        FloatList floatList2 = polygonArray.uv;
        IntList intList = polygonArray.polygons;
        int n2 = 0;
        double d = Math.PI / (double)n;
        int n3 = n;
        float f = (float)Math.sin(d);
        float f2 = (float)Math.cos(d);
        for (int i = 0; i <= n3; ++i) {
            float f3;
            float f4;
            float f5;
            int n4;
            if (i == 0) {
                polygonArray.setNormal(n2++, 0.0f, 0.0f, 1.0f);
                floatList2.add(0.0f);
                floatList2.add(0.0f);
                floatList.add(0.0f);
                floatList.add(0.0f);
                floatList.add(1.0f);
                continue;
            }
            if (i == n3) {
                polygonArray.setNormal(n2++, 0.0f, 0.0f, -1.0f);
                floatList2.add(0.0f);
                floatList2.add(1.0f);
                floatList.add(0.0f);
                floatList.add(0.0f);
                floatList.add(-1.0f);
                for (int j = 0; j <= n3; ++j) {
                    intList.add(n2 - 1);
                    intList.add(n2 - n3 - 1 + j);
                    intList.add(n2 - n3 - 2 + j);
                }
                continue;
            }
            float f6 = 1.0f / (float)n3;
            float f7 = f6 * (float)i;
            float f8 = (float)d * (float)i;
            f = (float)Math.sin(f8);
            f2 = (float)Math.cos(f8);
            if (i == 1) {
                for (n4 = 0; n4 <= n3; ++n4) {
                    f5 = 2.0f * (float)d * (float)n4;
                    f4 = (float)Math.cos(f5) * f;
                    f3 = (float)Math.sin(f5) * f;
                    polygonArray.setNormal(n2++, f4, f3, f2);
                    floatList2.add(f6 * (float)n4);
                    floatList2.add(f7);
                    floatList.add(f4);
                    floatList.add(f3);
                    floatList.add(f2);
                    if (n4 <= 0) continue;
                    intList.add(0);
                    intList.add(n2 - 2);
                    intList.add(n2 - 1);
                }
                continue;
            }
            for (n4 = 0; n4 <= n3; ++n4) {
                f5 = 2.0f * (float)d * (float)n4;
                f4 = (float)Math.cos(f5) * f;
                f3 = (float)Math.sin(f5) * f;
                polygonArray.setNormal(n2++, f4, f3, f2);
                floatList2.add(f6 * (float)n4);
                floatList2.add(f7);
                floatList.add(f4);
                floatList.add(f3);
                floatList.add(f2);
                if (n4 <= 0) continue;
                intList.add(n2 - 2);
                intList.add(n2 - 1);
                intList.add(n2 - n3 - 3);
                intList.add(n2 - n3 - 3);
                intList.add(n2 - 1);
                intList.add(n2 - n3 - 2);
            }
        }
        return polygonArray;
    }

    public GL20ResourceShapeSphere() {
        super(65544);
        GL20MeshServer gL20MeshServer = GL20MeshServer.getInstance();
        this.mesh = gL20MeshServer.getMultiUserMeshByName(MESH_SPHERE_NAME);
        if (this.mesh == null) {
            this.mesh = new GL20ResourceMeshMultiUser(MESH_SPHERE_NAME);
            this.mesh.setPolygonArray(this.createSpherePolygonArray(20));
        }
        this.mesh.registerUser(this);
    }

    public final void setRadius(float f) {
        if (this.radius != f) {
            this.radius = f;
            this.changeMask |= 1;
        }
    }

    public final float getRadius() {
        return this.radius;
    }

    public void applyGeometry() {
        super.applyGeometry();
        this.mesh.draw();
    }

    public boolean isUpToDate() {
        if (this.changeMask != 0) {
            return false;
        }
        return super.isUpToDate();
    }

    public void update() {
        if (this.changeMask != 0) {
            this.setShapeTransformationMatrix(new Matrix4d((double)this.radius, 0.0, 0.0, 0.0, 0.0, (double)this.radius, 0.0, 0.0, 0.0, 0.0, (double)this.radius, 0.0, 0.0, 0.0, 0.0, 1.0));
            this.changeMask = 0;
        }
        super.update();
    }

    public void destroy() {
        this.mesh.unregisterUser(this);
        this.mesh = null;
        super.destroy();
    }
}

