/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.GLUT;
import com.sun.opengl.util.Screenshot;
import com.sun.opengl.util.j2d.Overlay;
import com.sun.opengl.util.j2d.TextRenderer;
import de.grogra.graph.ArrayPath;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp.View;
import de.grogra.imp.awt.ViewComponentAdapter;
import de.grogra.imp.edit.Tool;
import de.grogra.imp.edit.ViewSelection;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.DisplayVisitor;
import de.grogra.imp3d.IMP3D;
import de.grogra.imp3d.LineArray;
import de.grogra.imp3d.LineSegmentizable;
import de.grogra.imp3d.LineSegmentizationCache;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.PolygonizationCache;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.glsl.CacheData;
import de.grogra.imp3d.glsl.DisplayListRenderable;
import de.grogra.imp3d.glsl.ImageCacheItem;
import de.grogra.imp3d.glsl.LightSource;
import de.grogra.imp3d.glsl.Texture;
import de.grogra.imp3d.glsl.TextureManager;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.DirectionalLight;
import de.grogra.imp3d.objects.LightBase;
import de.grogra.imp3d.objects.PointLight;
import de.grogra.imp3d.objects.SpotLight;
import de.grogra.imp3d.shading.ColorMapNode;
import de.grogra.imp3d.shading.ColorMapNodeProperty;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.Phong;
import de.grogra.imp3d.shading.Shader;
import de.grogra.math.ChannelMap;
import de.grogra.math.Pool;
import de.grogra.math.RGBColor;
import de.grogra.math.TMatrix4d;
import de.grogra.pf.boot.Main;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.edit.Selectable;
import de.grogra.reflect.Type;
import de.grogra.util.Debug;
import de.grogra.util.EnumerationType;
import de.grogra.util.EventListener;
import de.grogra.util.Lock;
import de.grogra.util.LockProtectedRunnable;
import de.grogra.util.Lockable;
import de.grogra.util.Utils;
import de.grogra.util.WrapException;
import de.grogra.vecmath.Math2;
import de.grogra.xl.lang.ObjectConsumer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLJPanel;
import javax.swing.JPanel;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLDisplay
extends ViewComponentAdapter
implements GLEventListener,
RenderState,
ImageObserver,
Selectable {
    private static final boolean DEBUG = Debug.debug((String)"GLDisplay");
    private static final String OPTION_NAME_SHOW_POINTS = "showPoints";
    private static final String OPTION_NAME_LIGHTING = "lighting";
    protected boolean optionShowPoints = false;
    private static final String OPTION_NAME_SHOW_GRID = "showGrid";
    protected boolean optionShowGrid = false;
    private static final String OPTION_NAME_GRID_DIMENSION = "gridDimension";
    protected int optionGridDimension = 1;
    private static final String OPTION_NAME_GRID_SPACING = "gridSpacing";
    protected float optionGridSpacing = 1.0f;
    private static final String OPTION_NAME_GRID_COLOR_R = "gridColorR";
    protected float optionGridColorR = 1.0f;
    private static final String OPTION_NAME_GRID_COLOR_G = "gridColorG";
    protected float optionGridColorG = 1.0f;
    private static final String OPTION_NAME_GRID_COLOR_B = "gridColorB";
    protected float optionGridColorB = 1.0f;
    private static final String OPTION_NAME_SHOW_AXES = "showAxes";
    protected boolean optionShowAxes = false;
    private static final String OPTION_NAME_SHOW_AXES_NAMES = "showAxesNames";
    private boolean optionShowAxesNames = false;
    private static final String OPTION_NAME_SHOW_DISPLAY_SIZE = "showDisplaySize";
    protected boolean optionShowDisplaySize = false;
    private static final boolean USE_GLJPANEL = true;
    boolean lightingOn = true;
    protected boolean supportsVBO = false;
    protected static final int LOD_LEVELS = 8;
    private int maxLights = 8;
    public final Pool pool = new Pool();
    final TextureManager textureManager = new TextureManager();
    JPanel wrapper;
    GLAutoDrawable canvas;
    volatile boolean canvasChanged = false;
    volatile boolean reshaped = true;
    private volatile int repaintFlags;
    protected GLVisitor visitor = new GLVisitor();
    protected PolygonizationCache polyCache;
    final Logger logger = Main.getLogger();
    final Object imageLock = new Object();
    Image img = null;
    boolean imgChanged = true;
    final Object callbackLock = new Object();
    volatile ObjectConsumer<? super RenderedImage> callback = null;
    int backgroundTexture;
    float backgroundWidth;
    float backgroundHeight;
    int oldStamp = -1;
    boolean checkLightSources = true;
    int lightCount = 0;
    boolean lightsChanged = false;
    int disableLighting = 0;
    final Hashtable<Light, LightSource> lights = new Hashtable();
    GLContext oldContext = null;
    final HashMap<Font, TextRenderer> textRenderers = new HashMap();
    final WeakHashMap<float[], FloatBuffer> cloudToBuffer = new WeakHashMap();
    private Lock retainedLock = null;
    private boolean disableRetain = false;
    private Object lockMutex = new Object();
    private double[] matrixArray = new double[16];
    protected int curHighlight = 0;
    static final int SCALE_MIN = 5;
    static final int SCALE_MAX = 45;
    private final Matrix4d xform = new TMatrix4d();
    final HashMap<Object, ImageCacheItem> imageCache = new HashMap();
    static final int CACHED_IMAGE_WIDTH = 512;
    static final int CACHED_IMAGE_HEIGHT = 512;
    static final float PLANE_SIZE = 100.0f;
    protected int dlSphere = 0;
    protected int dlSupershape = 0;
    public static final Type RENDER_MODE;
    private static final float[] red;
    private static final float[] green;
    private static final float[] blue;
    private static final float[] black;
    protected final int[] lineWidth = new int[1];
    protected final Color3f gridColor = new Color3f();
    protected final Point3f startPoint = new Point3f();
    protected final Point3f endPoint = new Point3f();
    private final GLUT glut = new GLUT();
    private final byte[] lightParams = new byte[1];
    private final float[] lightPositionAxes = new float[]{0.0f, 0.0f, 5.0f, 1.0f};
    private final float[] lightPositionAxesNames = new float[]{0.0f, 5.0f, 5.0f, 1.0f};
    private final AxisAngle4d rot = new AxisAngle4d();

    protected ImageObserver getObserverForRenderer() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0xC0) != 0) {
            return false;
        }
        Object object = this.imageLock;
        synchronized (object) {
            this.img = image;
            this.imgChanged = true;
            this.repaint(2048);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeSnapshot(ObjectConsumer<? super RenderedImage> objectConsumer) {
        Object object = this.callbackLock;
        synchronized (object) {
            this.callback = objectConsumer;
        }
        this.repaint(2048);
    }

    protected void initRender(int n) {
    }

    protected void invokeRender(final int n) {
        Utils.executeForcedlyAndUninterruptibly((Lockable)this.getView().getGraph(), (LockProtectedRunnable)new LockProtectedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(boolean bl, Lock lock) {
                boolean bl2 = false;
                Object object = GLDisplay.this.lockMutex;
                synchronized (object) {
                    GLDisplay.this.repaintFlags |= n;
                    if (!GLDisplay.this.disableRetain) {
                        lock.retain();
                        GLDisplay.this.retainedLock = lock;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    GLDisplay.this.canvas.display();
                }
            }
        }, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(GLAutoDrawable gLAutoDrawable) {
        Lock lock;
        Object object = this.lockMutex;
        synchronized (object) {
            lock = this.retainedLock;
            this.retainedLock = null;
            if (lock != null) {
                this.disableRetain = true;
            }
        }
        if (lock != null) {
            try {
                Workbench.setCurrent((Workbench)this.getView().getWorkbench());
                Utils.executeForcedlyAndUninterruptibly((Lockable)this.getView().getGraph(), (LockProtectedRunnable)new LockProtectedRunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(boolean bl, Lock lock) {
                        int n;
                        Object object = GLDisplay.this.lockMutex;
                        synchronized (object) {
                            GLDisplay.this.disableRetain = false;
                            n = GLDisplay.this.repaintFlags;
                            GLDisplay.this.repaintFlags = 0;
                        }
                        GLDisplay.this.invokeRenderSync(n);
                    }
                }, (Lock)lock);
            }
            finally {
                Workbench.setCurrent(null);
                object = this.lockMutex;
                synchronized (object) {
                    this.disableRetain = false;
                }
            }
        }
        this.repaint(this.reshaped ? 15 : 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Lock lock;
        Object object = this.lockMutex;
        synchronized (object) {
            lock = this.retainedLock;
            this.retainedLock = null;
            this.disableRetain = true;
        }
        if (lock != null) {
            this.getView().getGraph().execute(new LockProtectedRunnable(){

                public void run(boolean bl, Lock lock) {
                    GLDisplay.this.textRenderers.clear();
                }
            }, lock);
        }
        super.dispose();
    }

    public Object getComponent() {
        return this.wrapper;
    }

    public View3D getView3D() {
        return (View3D)this.getView();
    }

    public void initView(View view, EventListener eventListener) {
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(true);
        gLCapabilities.setHardwareAccelerated(true);
        this.canvas = new GLJPanel(gLCapabilities){

            public void addNotify() {
                super.addNotify();
                GLDisplay.this.installListeners(GLDisplay.this.wrapper);
            }

            public void removeNotify() {
                GLDisplay.this.uninstallListeners(GLDisplay.this.wrapper);
                super.removeNotify();
            }
        };
        this.wrapper = (GLJPanel)this.canvas;
        this.canvasChanged = true;
        this.canvas.addGLEventListener((GLEventListener)this);
        this.wrapper.setMinimumSize(new Dimension(0, 0));
        this.wrapper.setPreferredSize(new Dimension(640, 480));
        super.initView(view, eventListener);
        this.optionShowPoints = Boolean.TRUE.equals(this.getOption(OPTION_NAME_SHOW_POINTS, Boolean.TRUE));
        this.lightingOn = Boolean.TRUE.equals(this.getOption(OPTION_NAME_LIGHTING, Boolean.TRUE));
        this.optionShowGrid = Boolean.TRUE.equals(this.getOption(OPTION_NAME_SHOW_GRID, Boolean.FALSE));
        this.optionGridDimension = (Integer)this.getOption(OPTION_NAME_GRID_DIMENSION, 5);
        this.optionGridSpacing = ((Float)this.getOption(OPTION_NAME_GRID_SPACING, Float.valueOf(1.0f))).floatValue();
        this.optionGridColorR = ((Float)this.getOption(OPTION_NAME_GRID_COLOR_R, Float.valueOf(1.0f))).floatValue();
        this.optionGridColorG = ((Float)this.getOption(OPTION_NAME_GRID_COLOR_G, Float.valueOf(1.0f))).floatValue();
        this.optionGridColorB = ((Float)this.getOption(OPTION_NAME_GRID_COLOR_B, Float.valueOf(1.0f))).floatValue();
        this.optionShowAxes = Boolean.TRUE.equals(this.getOption(OPTION_NAME_SHOW_AXES, Boolean.FALSE));
        this.optionShowAxesNames = Boolean.TRUE.equals(this.getOption(OPTION_NAME_SHOW_AXES_NAMES, Boolean.FALSE));
        this.optionShowDisplaySize = Boolean.TRUE.equals(this.getOption(OPTION_NAME_SHOW_DISPLAY_SIZE, Boolean.FALSE));
    }

    double[] toGLMatrix(Matrix4d matrix4d) {
        this.matrixArray[0] = matrix4d.m00;
        this.matrixArray[1] = matrix4d.m10;
        this.matrixArray[2] = matrix4d.m20;
        this.matrixArray[3] = matrix4d.m30;
        this.matrixArray[4] = matrix4d.m01;
        this.matrixArray[5] = matrix4d.m11;
        this.matrixArray[6] = matrix4d.m21;
        this.matrixArray[7] = matrix4d.m31;
        this.matrixArray[8] = matrix4d.m02;
        this.matrixArray[9] = matrix4d.m12;
        this.matrixArray[10] = matrix4d.m22;
        this.matrixArray[11] = matrix4d.m32;
        this.matrixArray[12] = matrix4d.m03;
        this.matrixArray[13] = matrix4d.m13;
        this.matrixArray[14] = matrix4d.m23;
        this.matrixArray[15] = matrix4d.m33;
        return this.matrixArray;
    }

    static ByteBuffer newByteBuffer(int n) {
        return ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
    }

    void enableLighting(GL gL) {
        if (--this.disableLighting == 0) {
            gL.glEnable(2896);
        }
    }

    void disableLighting(GL gL) {
        ++this.disableLighting;
        gL.glDisable(2896);
    }

    void grabBackground(GL gL) {
        int n = this.img.getWidth(null);
        int n2 = this.img.getHeight(null);
        int n3 = Math2.roundUpNextPowerOfTwo((int)Math.max(n, n2));
        this.backgroundWidth = (float)n / (float)n3;
        this.backgroundHeight = (float)n2 / (float)n3;
        boolean bl = false;
        int[] nArray = new int[n3 * n3];
        PixelGrabber pixelGrabber = new PixelGrabber(this.img, 0, 0, n, n2, nArray, 0, n3);
        try {
            pixelGrabber.grabPixels();
            if ((pixelGrabber.getStatus() & 0x80) == 0) {
                bl = true;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (bl) {
            IntBuffer intBuffer = IntBuffer.wrap(nArray);
            gL.glBindTexture(3553, this.backgroundTexture);
            gL.glTexParameteri(3553, 10240, 9729);
            gL.glTexParameteri(3553, 10241, 9729);
            gL.glTexImage2D(3553, 0, 6407, n3, n3, 0, 32993, 5121, (Buffer)intBuffer);
            this.imgChanged = false;
        }
    }

    void drawBackground(GL gL) {
        gL.glDisable(2929);
        gL.glEnable(3553);
        gL.glColor3f(1.0f, 1.0f, 1.0f);
        gL.glBindTexture(3553, this.backgroundTexture);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        this.disableLighting(gL);
        gL.glBegin(7);
        gL.glTexCoord2f(0.0f, this.backgroundHeight);
        gL.glVertex3f(-1.0f, -1.0f, -1.0f);
        gL.glTexCoord2f(this.backgroundWidth, this.backgroundHeight);
        gL.glVertex3f(1.0f, -1.0f, -1.0f);
        gL.glTexCoord2f(this.backgroundWidth, 0.0f);
        gL.glVertex3f(1.0f, 1.0f, -1.0f);
        gL.glTexCoord2f(0.0f, 0.0f);
        gL.glVertex3f(-1.0f, 1.0f, -1.0f);
        gL.glEnd();
        this.enableLighting(gL);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glDisable(3553);
        gL.glEnable(2929);
    }

    LightSource[] checkLightSources(LightSource[] lightSourceArray) {
        if (lightSourceArray.length == 0) {
            lightSourceArray = this.generateDefaultLight();
        }
        if (lightSourceArray.length > this.maxLights) {
            this.logger.warning("too many lights in scene, will use the first " + this.maxLights + " lights");
        }
        return lightSourceArray;
    }

    void setupLights(GL gL, LightSource[] lightSourceArray) {
        gL.glPushMatrix();
        Matrix4d matrix4d = this.getView3D().getCamera().getWorldToViewTransformation();
        gL.glLoadMatrixd(this.toGLMatrix(matrix4d), 0);
        for (int i = 0; i < lightSourceArray.length && i < this.maxLights; ++i) {
            LightSource lightSource = lightSourceArray[i];
            gL.glLightfv(16384 + i, 4611, Math2.toFloatArray((Tuple4d)lightSource.lightPos), 0);
            gL.glLightfv(16384 + i, 4612, Math2.toFloatArray((Tuple3d)lightSource.lightDir), 0);
            gL.glLightfv(16384 + i, 4608, Math2.toFloatArray((Tuple4f)lightSource.ambientColor), 0);
            gL.glLightfv(16384 + i, 4609, Math2.toFloatArray((Tuple4f)lightSource.diffuseColor), 0);
            gL.glLightfv(16384 + i, 4610, Math2.toFloatArray((Tuple4f)lightSource.specularColor), 0);
            gL.glLightf(16384 + i, 4613, lightSource.spotExponent);
            gL.glLightf(16384 + i, 4614, lightSource.spotCutoff);
            gL.glLightf(16384 + i, 4615, lightSource.constantAttenuation);
            gL.glLightf(16384 + i, 4616, lightSource.linearAttenuation);
            gL.glLightf(16384 + i, 4617, lightSource.quadraticAttenuation);
            gL.glEnable(16384 + i);
        }
        gL.glPopMatrix();
    }

    LightSource[] getLightSources() {
        return this.lights.values().toArray(new LightSource[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void render(int n) throws InterruptedException {
        GLContext gLContext;
        ObjectConsumer<? super RenderedImage> objectConsumer;
        Object object = this.callbackLock;
        synchronized (object) {
            objectConsumer = this.callback;
            this.callback = null;
        }
        this.reshaped = false;
        this.getView3D().setExtent(null, Float.NaN);
        object = this.canvas.getGL();
        if (this.canvasChanged) {
            this.canvasChanged = false;
            this.dlSphere = 0;
            this.lights.clear();
            this.checkLightSources = true;
            this.supportsVBO = object.isExtensionAvailable("GL_ARB_vertex_buffer_object");
            if (DEBUG) {
                System.err.println("supportsVBO = " + this.supportsVBO);
            }
            this.supportsVBO = false;
        }
        if ((gLContext = this.canvas.getContext()) != this.oldContext) {
            this.textureManager.deleteTextures((GL)object);
            object.glGetError();
            this.oldContext = gLContext;
        }
        object.glClearColor(0.75f, 0.75f, 0.75f, 0.0f);
        int n2 = this.canvas.getWidth();
        int n3 = this.canvas.getHeight();
        ((View3D)this.getView()).getCanvasCamera().setDimension(n2, n3);
        object.glClear(16384);
        Object object2 = this.imageLock;
        synchronized (object2) {
            if (this.img != null) {
                if (this.imgChanged) {
                    this.grabBackground((GL)object);
                }
                this.drawBackground((GL)object);
                if (objectConsumer != null) {
                    objectConsumer.consume((Object)GLDisplay.convert(this.img));
                }
                if ((n & 9) == 9) {
                    this.img = null;
                } else {
                    return;
                }
            }
        }
        this.disableLighting = 0;
        object.glEnable(2896);
        if (!this.lightingOn) {
            this.disableLighting((GL)object);
        }
        object.glClear(256);
        object.glMatrixMode(5889);
        object2 = ((View3D)this.getView()).getCamera();
        Matrix4d matrix4d = new Matrix4d();
        ((Camera)object2).getViewToClipTransformation(matrix4d);
        double d = (double)n2 / (double)n3;
        matrix4d.mul(new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, d, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0));
        object.glLoadMatrixd(this.toGLMatrix(matrix4d), 0);
        object.glMatrixMode(5888);
        int n4 = this.getView().getGraph().getStamp();
        if (n4 != this.oldStamp) {
            this.checkLightSources = true;
            this.oldStamp = n4;
        }
        LightSource[] lightSourceArray = this.getLightSources();
        lightSourceArray = this.checkLightSources(lightSourceArray);
        this.setupLights((GL)object, lightSourceArray);
        this.lightCount = 0;
        this.lightsChanged = false;
        this.curHighlight = 0;
        this.visitor.init(this.getRenderGraphState(), ((Camera)object2).getWorldToViewTransformation(), 0, true);
        if (this.optionShowGrid) {
            this.drawGrid((GL)object);
        }
        try {
            LightSource lightSource;
            ArrayPath arrayPath;
            this.getView().getGraph().accept(null, (Visitor)this.visitor, null);
            this.checkLightSources = false;
            if (this.lightsChanged || this.lightCount != 0 && lightSourceArray.length != this.lightCount) {
                int n5;
                arrayPath = this.lights.keySet().toArray();
                for (n5 = 0; n5 < ((ArrayPath)arrayPath).length; ++n5) {
                    ArrayPath arrayPath2 = arrayPath[n5];
                    lightSource = this.lights.get(arrayPath2);
                    if (lightSource.stamp == this.oldStamp) continue;
                    this.lights.remove(arrayPath2);
                }
                if (lightSourceArray.length > this.lightCount) {
                    for (n5 = this.lightCount; n5 < this.maxLights && n5 < lightSourceArray.length; ++n5) {
                        object.glDisable(16384 + n5);
                    }
                }
                lightSourceArray = this.getLightSources();
                lightSourceArray = this.checkLightSources(lightSourceArray);
                this.setupLights((GL)object, lightSourceArray);
                object.glClear(256);
                this.getView().getGraph().accept(null, (Visitor)this.visitor, null);
            }
            arrayPath = new ArrayPath(this.getView().getGraph());
            ViewSelection.Entry[] entryArray = ViewSelection.get((Context)this.getView()).getAll(-1);
            for (int i = 0; i < entryArray.length; ++i) {
                lightSource = entryArray[i].getPath();
                this.curHighlight = entryArray[i].getValue();
                this.visitor.init(this.getRenderGraphState(), ((Camera)object2).getWorldToViewTransformation(), lightSource.getNodeAndEdgeCount(), true);
                GraphUtils.acceptPath((Path)lightSource, (Visitor)this.visitor, (ArrayPath)arrayPath);
            }
            this.disableLighting((GL)object);
            object.glDisable(2929);
            Tool tool = this.getView().getActiveTool();
            if (tool != null) {
                this.curHighlight = 0;
                this.visitor.init(GraphManager.STATIC_STATE, ((Camera)object2).getWorldToViewTransformation(), 0, false);
                arrayPath.clear((Graph)GraphManager.STATIC);
                for (int i = 0; i < tool.getToolCount(); ++i) {
                    GraphManager.acceptGraph((Node)tool.getRoot(i), (Visitor)this.visitor, (ArrayPath)arrayPath);
                }
            }
            this.enableLighting((GL)object);
            object.glEnable(2929);
            if (this.optionShowAxes) {
                this.drawAxes((GL)object, (Camera)object2);
            }
            if (this.optionShowDisplaySize) {
                this.drawDisplaySize((GL)object, (Camera)object2);
            }
        }
        catch (WrapException wrapException) {
            if (wrapException.getCause() instanceof InterruptedException) {
                throw (InterruptedException)wrapException.getCause();
            }
            throw wrapException;
        }
        finally {
            object.glFlush();
        }
        if (objectConsumer != null) {
            objectConsumer.consume((Object)Screenshot.readToBufferedImage((int)n2, (int)n3));
        }
    }

    static LightSource convertLightToLightSource(Light light, Matrix4d matrix4d) {
        LightSource lightSource = new LightSource();
        Point4d point4d = new Point4d(0.0, 0.0, 0.0, 1.0);
        matrix4d.transform((Tuple4d)point4d);
        lightSource.lightPos = point4d;
        lightSource.lightDir = new Vector3d(matrix4d.m02, matrix4d.m12, matrix4d.m22);
        if (light instanceof LightBase) {
            LightBase lightBase = (LightBase)light;
            RGBColor rGBColor = lightBase.getColor();
            lightSource.diffuseColor = new Color4f(rGBColor.x, rGBColor.y, rGBColor.z, 1.0f);
            lightSource.specularColor = new Color4f(rGBColor.x, rGBColor.y, rGBColor.z, 1.0f);
            if (light instanceof PointLight) {
                lightSource.lightType = 1;
            }
            if (light instanceof SpotLight) {
                lightSource.lightType = 2;
                SpotLight spotLight = (SpotLight)light;
                float f = spotLight.getOuterAngle();
                lightSource.spotCutoff = (float)((double)(f * 180.0f) / Math.PI);
                lightSource.spotExponent = 8.0f;
            }
            if (light instanceof DirectionalLight) {
                lightSource.lightType = 3;
                lightSource.lightPos.x = -lightSource.lightDir.x;
                lightSource.lightPos.y = -lightSource.lightDir.y;
                lightSource.lightPos.z = -lightSource.lightDir.z;
                lightSource.lightPos.w = 0.0;
            }
        }
        return lightSource;
    }

    LightSource[] generateDefaultLight() {
        Matrix4d matrix4d = new Matrix4d();
        Light light = this.getView3D().getDefaultLight(matrix4d);
        LightSource[] lightSourceArray = new LightSource[]{GLDisplay.convertLightToLightSource(light, matrix4d)};
        return lightSourceArray;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        int[] nArray = new int[10];
        gL.glGetIntegerv(3379, nArray, 0);
        this.logger.info("GL_MAX_TEXTURE_SIZE = " + nArray[0]);
        gL.glGetIntegerv(3414, nArray, 0);
        this.logger.info("GL_DEPTH_BITS = " + nArray[0]);
        if (nArray[0] <= 16) {
            this.logger.warning("depth buffer precision is too low and may result in visible artifacts");
        }
        gL.glGetIntegerv(3410, nArray, 0);
        this.logger.info("GL_RED_BITS = " + nArray[0]);
        gL.glGetIntegerv(3411, nArray, 0);
        this.logger.info("GL_GREEN_BITS = " + nArray[0]);
        gL.glGetIntegerv(3412, nArray, 0);
        this.logger.info("GL_BLUE_BITS = " + nArray[0]);
        gL.glGetIntegerv(3413, nArray, 0);
        this.logger.info("GL_ALPHA_BITS = " + nArray[0]);
        gL.glGetIntegerv(3414, nArray, 0);
        this.logger.info("GL_DEPTH_BITS = " + nArray[0]);
        gL.glGetIntegerv(3415, nArray, 0);
        this.logger.info("GL_STENCIL_BITS = " + nArray[0]);
        gL.glGetIntegerv(3416, nArray, 0);
        this.logger.info("GL_ACCUM_RED_BITS = " + nArray[0]);
        gL.glGetIntegerv(3417, nArray, 0);
        this.logger.info("GL_ACCUM_GREEN_BITS = " + nArray[0]);
        gL.glGetIntegerv(3418, nArray, 0);
        this.logger.info("GL_ACCUM_BLUE_BITS = " + nArray[0]);
        gL.glGetIntegerv(3419, nArray, 0);
        this.logger.info("GL_ACCUM_ALPHA_BITS = " + nArray[0]);
        gL.glGetIntegerv(3377, nArray, 0);
        this.logger.info("GL_ACCUM_ALPHA_BITS = " + nArray[0]);
        this.maxLights = nArray[0];
        gL.glEnable(2929);
        gL.glShadeModel(7425);
        gL.glDisable(3553);
        gL.glMatrixMode(5888);
        gL.glColorMaterial(1032, 5634);
        gL.glEnable(2903);
        gL.glEnable(2884);
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.1f);
        int[] nArray2 = new int[1];
        gL.glGenTextures(1, nArray2, 0);
        this.backgroundTexture = nArray2[0];
        gL.glEnable(2977);
        this.dlSphere = 0;
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.reshaped = true;
        this.textRenderers.clear();
        GL gL = gLAutoDrawable.getGL();
        this.textureManager.deleteTextures(gL);
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    @Override
    public Shader getCurrentShader() {
        return this.visitor.getCurrentShader();
    }

    @Override
    public int getCurrentHighlight() {
        return this.curHighlight;
    }

    @Override
    public float estimateScaleAt(Tuple3f tuple3f) {
        return this.estimateScaleAt(tuple3f, this.visitor.getCurrentTransformation());
    }

    public float estimateScaleAt(Tuple3f tuple3f, Matrix4d matrix4d) {
        return this.getView3D().estimateScaleAt(tuple3f, matrix4d);
    }

    protected float getLOD(Matrix4d matrix4d, float f) {
        int n = this.getGlobalLOD();
        float f2 = (float)(n - View.LOD_MIN) / (float)(View.LOD_MAX - View.LOD_MIN);
        f2 = Math.min(1.0f, Math.max(0.0f, f2));
        float f3 = this.estimateScaleAt((Tuple3f)new Point3f(), matrix4d);
        f2 *= ((f3 *= f) - 5.0f) / 40.0f;
        f2 = Math.min(1.0f, Math.max(0.0f, f2));
        return f2;
    }

    @Override
    public boolean getWindowPos(Tuple3f tuple3f, Tuple2f tuple2f) {
        Matrix4d matrix4d = this.visitor.getCurrentTransformation();
        return this.getView3D().getCanvasCamera().projectView((float)((double)tuple3f.x * matrix4d.m00 + (double)tuple3f.y * matrix4d.m01 + (double)tuple3f.z * matrix4d.m02 + matrix4d.m03), (float)((double)tuple3f.x * matrix4d.m10 + (double)tuple3f.y * matrix4d.m11 + (double)tuple3f.z * matrix4d.m12 + matrix4d.m13), (float)((double)tuple3f.x * matrix4d.m20 + (double)tuple3f.y * matrix4d.m21 + (double)tuple3f.z * matrix4d.m22 + matrix4d.m23), tuple2f, true) == 1;
    }

    protected Shader getShader(Shader shader) {
        if (shader == null) {
            shader = this.visitor.getCurrentShader();
        }
        return shader;
    }

    protected Matrix4d getTransformation(Matrix4d matrix4d) {
        if (matrix4d == null) {
            matrix4d = this.visitor.getCurrentTransformation();
        } else {
            Math2.mulAffine((Matrix4d)this.xform, (Matrix4d)this.visitor.getCurrentTransformation(), (Matrix4d)matrix4d);
            matrix4d = this.xform;
        }
        return matrix4d;
    }

    static void glVertex(GL gL, Tuple3f tuple3f, Tuple3f tuple3f2) {
        gL.glNormal3f(tuple3f2.x, tuple3f2.y, tuple3f2.z);
        gL.glVertex3f(tuple3f.x, tuple3f.y, tuple3f.z);
    }

    void drawBoxImpl(GL gL, float f, float f2, float f3, float f4, float f5, float f6) {
        gL.glBegin(7);
        gL.glNormal3f(-1.0f, 0.0f, 0.0f);
        gL.glTexCoord2f(0.0f, 0.33333334f);
        gL.glVertex3f(f, f2, f3);
        gL.glTexCoord2f(0.25f, 0.33333334f);
        gL.glVertex3f(f, f2, f6);
        gL.glTexCoord2f(0.25f, 0.6666667f);
        gL.glVertex3f(f, f5, f6);
        gL.glTexCoord2f(0.0f, 0.6666667f);
        gL.glVertex3f(f, f5, f3);
        gL.glNormal3f(1.0f, 0.0f, 0.0f);
        gL.glTexCoord2f(0.75f, 0.33333334f);
        gL.glVertex3f(f4, f2, f3);
        gL.glTexCoord2f(0.75f, 0.6666667f);
        gL.glVertex3f(f4, f5, f3);
        gL.glTexCoord2f(0.5f, 0.6666667f);
        gL.glVertex3f(f4, f5, f6);
        gL.glTexCoord2f(0.5f, 0.33333334f);
        gL.glVertex3f(f4, f2, f6);
        gL.glNormal3f(0.0f, -1.0f, 0.0f);
        gL.glTexCoord2f(0.25f, 0.0f);
        gL.glVertex3f(f, f2, f3);
        gL.glTexCoord2f(0.5f, 0.0f);
        gL.glVertex3f(f4, f2, f3);
        gL.glTexCoord2f(0.5f, 0.33333334f);
        gL.glVertex3f(f4, f2, f6);
        gL.glTexCoord2f(0.25f, 0.33333334f);
        gL.glVertex3f(f, f2, f6);
        gL.glNormal3f(0.0f, 1.0f, 0.0f);
        gL.glTexCoord2f(0.25f, 1.0f);
        gL.glVertex3f(f, f5, f3);
        gL.glTexCoord2f(0.25f, 0.6666667f);
        gL.glVertex3f(f, f5, f6);
        gL.glTexCoord2f(0.5f, 0.6666667f);
        gL.glVertex3f(f4, f5, f6);
        gL.glTexCoord2f(0.5f, 1.0f);
        gL.glVertex3f(f4, f5, f3);
        gL.glNormal3f(0.0f, 0.0f, -1.0f);
        gL.glTexCoord2f(1.0f, 0.33333334f);
        gL.glVertex3f(f, f2, f3);
        gL.glTexCoord2f(1.0f, 0.6666667f);
        gL.glVertex3f(f, f5, f3);
        gL.glTexCoord2f(0.75f, 0.6666667f);
        gL.glVertex3f(f4, f5, f3);
        gL.glTexCoord2f(0.75f, 0.33333334f);
        gL.glVertex3f(f4, f2, f3);
        gL.glNormal3f(0.0f, 0.0f, 1.0f);
        gL.glTexCoord2f(0.25f, 0.33333334f);
        gL.glVertex3f(f, f2, f6);
        gL.glTexCoord2f(0.5f, 0.33333334f);
        gL.glVertex3f(f4, f2, f6);
        gL.glTexCoord2f(0.5f, 0.6666667f);
        gL.glVertex3f(f4, f5, f6);
        gL.glTexCoord2f(0.25f, 0.6666667f);
        gL.glVertex3f(f, f5, f6);
        gL.glEnd();
    }

    Texture prologue(GL gL, Shader shader, int n) {
        Texture texture = this.setupTexture(gL, shader);
        int n2 = shader.getAverageColor();
        if (texture != null) {
            n2 = -1;
        }
        byte by = (byte)(n2 >> 16 & 0xFF);
        byte by2 = (byte)(n2 >> 8 & 0xFF);
        byte by3 = (byte)(n2 >> 0 & 0xFF);
        byte by4 = (byte)(n2 >> 24 & 0xFF);
        this.highlightPrologue(n, gL, by, by2, by3, by4);
        return texture;
    }

    void epilogue(GL gL, Shader shader, Texture texture, int n) {
        this.cleanupTexture(gL, shader, texture);
        this.highlightEpilogue(n, gL);
    }

    @Override
    public void drawBox(float f, float f2, float f3, Shader shader, int n, Matrix4d matrix4d) {
        shader = this.getShader(shader);
        matrix4d = this.getTransformation(matrix4d);
        GL gL = this.canvas.getGL();
        gL.glPushMatrix();
        gL.glLoadMatrixd(this.toGLMatrix(matrix4d), 0);
        Texture texture = this.prologue(gL, shader, n);
        this.drawBoxImpl(gL, -f, -f2, 0.0f, f, f2, f3);
        this.epilogue(gL, shader, texture, n);
        gL.glPopMatrix();
    }

    @Override
    public void drawPoint(Tuple3f tuple3f, int n, Tuple3f tuple3f2, int n2, Matrix4d matrix4d) {
        if (this.optionShowPoints) {
            matrix4d = this.getTransformation(matrix4d);
            GL gL = this.canvas.getGL();
            float f = (float)n / this.estimateScaleAt(tuple3f);
            Matrix4d matrix4d2 = new Matrix4d();
            matrix4d2.set((double)f, new Vector3d(tuple3f));
            matrix4d2.mul(matrix4d, matrix4d2);
            gL.glPushMatrix();
            gL.glLoadMatrixd(this.toGLMatrix(matrix4d2), 0);
            gL.glColor3f(tuple3f2.x, tuple3f2.y, tuple3f2.z);
            this.disableLighting(gL);
            this.drawSphereImpl(gL, 8, 8);
            this.enableLighting(gL);
            gL.glPopMatrix();
        }
    }

    @Override
    public void drawPointCloud(float[] fArray, float f, Tuple3f tuple3f, int n, Matrix4d matrix4d) {
        GL gL = this.canvas.getGL();
        int n2 = fArray.length / 3;
        if (n2 == 0) {
            return;
        }
        FloatBuffer floatBuffer = this.cloudToBuffer.get(fArray);
        if (floatBuffer == null) {
            floatBuffer = BufferUtil.newFloatBuffer((int)fArray.length);
            floatBuffer.put(fArray);
            floatBuffer.rewind();
            this.cloudToBuffer.put(fArray, floatBuffer);
        }
        matrix4d = this.getTransformation(matrix4d);
        gL.glPushMatrix();
        gL.glLoadMatrixd(this.toGLMatrix(matrix4d), 0);
        if (n == -1) {
            n = this.curHighlight;
        }
        if (n != 0) {
            gL.glDisable(2929);
            tuple3f = GLDisplay.calculateHighlightColor(tuple3f);
        }
        gL.glColor3f(tuple3f.x, tuple3f.y, tuple3f.z);
        this.disableLighting(gL);
        gL.glEnableClientState(32884);
        gL.glVertexPointer(3, 5126, 0, (Buffer)floatBuffer);
        gL.glPointSize(f <= 0.0f ? 3.0f : f);
        gL.glDrawArrays(0, 0, n2);
        gL.glPointSize(1.0f);
        gL.glDisableClientState(32884);
        this.enableLighting(gL);
        if (n != 0) {
            gL.glEnable(2929);
        }
        gL.glPopMatrix();
    }

    @Override
    public void drawLine(Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, int n, Matrix4d matrix4d) {
        matrix4d = this.getTransformation(matrix4d);
        GL gL = this.canvas.getGL();
        gL.glPushMatrix();
        gL.glLoadMatrixd(this.toGLMatrix(matrix4d), 0);
        gL.glColor3f(tuple3f3.x, tuple3f3.y, tuple3f3.z);
        this.disableLighting(gL);
        gL.glBegin(1);
        gL.glVertex3f(tuple3f.x, tuple3f.y, tuple3f.z);
        gL.glVertex3f(tuple3f2.x, tuple3f2.y, tuple3f2.z);
        gL.glEnd();
        this.enableLighting(gL);
        gL.glPopMatrix();
    }

    Texture setupTexture(GL gL, Shader shader) {
        Object object = null;
        if (shader instanceof Phong || shader instanceof ColorMapNodeProperty) {
            ColorMapNode colorMapNode;
            Object object2;
            ChannelMap channelMap;
            Object object3;
            if (shader instanceof Phong) {
                object3 = (Phong)shader;
                channelMap = ((Phong)object3).getDiffuse();
            } else {
                object3 = (ColorMapNodeProperty)((Object)shader);
                channelMap = object3.getImageChannel();
            }
            object3 = null;
            if (channelMap instanceof ColorMapNode) {
                object2 = this.imageCache.get(channelMap);
                if (object2 == null || channelMap.getStamp() != ((ImageCacheItem)object2).stamp) {
                    if (object2 == null) {
                        object2 = new ImageCacheItem();
                    } else {
                        this.textureManager.deleteTexture(gL, ((ImageCacheItem)object2).image);
                    }
                    ((ImageCacheItem)object2).stamp = channelMap.getStamp();
                    colorMapNode = (ColorMapNode)channelMap;
                    BufferedImage bufferedImage = new BufferedImage(512, 512, 2);
                    colorMapNode.drawImage(bufferedImage, 1, true);
                    ((ImageCacheItem)object2).image = bufferedImage;
                    this.imageCache.put(channelMap, (ImageCacheItem)object2);
                }
                object3 = ((ImageCacheItem)object2).image;
            }
            if (object3 != null) {
                object2 = this.textureManager.getTexture(gL, (Image)object3);
                if (object2 != null) {
                    gL.glEnable(3553);
                    gL.glBindTexture(3553, ((Texture)object2).index);
                    gL.glTexEnvf(8960, 8704, 34160.0f);
                    gL.glTexEnvf(8960, 34161, 8448.0f);
                    gL.glTexEnvf(8960, 34176, 5890.0f);
                    gL.glTexEnvf(8960, 34192, 768.0f);
                    gL.glTexEnvf(8960, 34177, 34168.0f);
                    gL.glTexEnvf(8960, 34193, 768.0f);
                    gL.glTexEnvf(8960, 34162, 7681.0f);
                    gL.glTexEnvf(8960, 34184, 5890.0f);
                    gL.glTexEnvf(8960, 34200, 770.0f);
                    gL.glMatrixMode(5890);
                    gL.glPushMatrix();
                    colorMapNode = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
                    gL.glLoadMatrixd(this.toGLMatrix((Matrix4d)colorMapNode), 0);
                    gL.glMatrixMode(5888);
                }
                object = object2;
            }
        }
        return object;
    }

    void cleanupTexture(GL gL, Shader shader, Texture texture) {
        if (texture != null) {
            gL.glMatrixMode(5890);
            gL.glPopMatrix();
            gL.glMatrixMode(5888);
            gL.glDisable(3553);
        }
    }

    @Override
    public void drawParallelogram(float f, Vector3f vector3f, float f2, float f3, Shader shader, int n, Matrix4d matrix4d) {
        shader = this.getShader(shader);
        matrix4d = this.getTransformation(matrix4d);
        GL gL = this.canvas.getGL();
        gL.glPushMatrix();
        gL.glLoadMatrixd(this.toGLMatrix(matrix4d), 0);
        Texture texture = this.prologue(gL, shader, n);
        Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, f);
        vector3f2.cross(vector3f, vector3f2);
        gL.glDisable(2884);
        gL.glLightModeli(2898, 1);
        gL.glBegin(7);
        gL.glNormal3f(vector3f2.x, vector3f2.y, vector3f2.z);
        gL.glTexCoord2f(0.0f, 0.0f);
        gL.glVertex3f(-vector3f.x, -vector3f.y, -vector3f.z);
        gL.glTexCoord2f(f2, 0.0f);
        gL.glVertex3f(vector3f.x, vector3f.y, vector3f.z);
        gL.glTexCoord2f(f2, f3);
        gL.glVertex3f(vector3f.x, vector3f.y, f + vector3f.z);
        gL.glTexCoord2f(0.0f, f3);
        gL.glVertex3f(-vector3f.x, -vector3f.y, f - vector3f.z);
        gL.glEnd();
        gL.glEnable(2884);
        gL.glLightModeli(2898, 0);
        this.epilogue(gL, shader, texture, n);
        gL.glPopMatrix();
    }

    void drawPlaneImpl(GL gL, int n, int n2, int n3) {
        gL.glBegin(8);
        gL.glNormal3f(0.0f, 0.0f, 1.0f);
        for (int i = 0; i < n3; ++i) {
            float f = (float)n * ((float)i / (float)n3 - 0.5f);
            float f2 = (float)n * ((float)(i + 1) / (float)n3 - 0.5f);
            for (int j = 0; j <= n2; ++j) {
                float f3 = (float)n * ((float)j / (float)n2 - 0.5f);
                gL.glTexCoord2f((float)j, (float)(i + 1));
                gL.glVertex3f(f3, f2, 0.0f);
                gL.glTexCoord2f((float)j, (float)i);
                gL.glVertex3f(f3, f, 0.0f);
            }
        }
        gL.glEnd();
    }

    @Override
    public void drawPlane(Shader shader, int n, Matrix4d matrix4d) {
        shader = this.getShader(shader);
        matrix4d = this.getTransformation(matrix4d);
        GL gL = this.canvas.getGL();
        gL.glPushMatrix();
        gL.glLoadMatrixd(this.toGLMatrix(matrix4d), 0);
        Texture texture = this.prologue(gL, shader, n);
        this.drawPlaneImpl(gL, 100, 10, 10);
        this.epilogue(gL, shader, texture, n);
        gL.glPopMatrix();
    }

    private Vector3f genVertexSphere(float f, float f2) {
        float f3 = (float)Math.cos(f);
        float f4 = (float)Math.sin(f);
        float f5 = (float)Math.cos(f2);
        float f6 = (float)Math.sin(f2);
        float f7 = f3 * f5;
        float f8 = f4 * f5;
        float f9 = f6;
        return new Vector3f(f7, f8, f9);
    }

    void drawSphereImpl(GL gL, int n, int n2) {
        for (int i = -n2; i < n2; i += 2) {
            float f = (float)(Math.PI * (double)(i + 2) / (double)n2 / 2.0);
            float f2 = (float)(Math.PI * (double)i / (double)n2 / 2.0);
            gL.glBegin(8);
            for (int j = 0; j <= n; ++j) {
                float f3 = (float)(Math.PI * 2 * (double)j / (double)n);
                Vector3f vector3f = this.genVertexSphere(f3, f);
                Vector3f vector3f2 = this.genVertexSphere(f3, f2);
                gL.glNormal3f(vector3f.x, vector3f.y, vector3f.z);
                gL.glTexCoord2f((float)j / (float)n, 0.5f + (float)(i + 2) / (float)n2 / 2.0f);
                gL.glVertex3f(vector3f.x, vector3f.y, vector3f.z);
                gL.glNormal3f(vector3f2.x, vector3f2.y, vector3f2.z);
                gL.glTexCoord2f((float)j / (float)n, 0.5f + (float)i / (float)n2 / 2.0f);
                gL.glVertex3f(vector3f2.x, vector3f2.y, vector3f2.z);
            }
            gL.glEnd();
        }
    }

    @Override
    public void drawSphere(float f, Shader shader, int n, Matrix4d matrix4d) {
        shader = this.getShader(shader);
        matrix4d = this.getTransformation(matrix4d);
        float f2 = this.getLOD(matrix4d, f);
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.set((double)f);
        matrix4d2.mul(matrix4d, matrix4d2);
        GL gL = this.canvas.getGL();
        gL.glPushMatrix();
        gL.glLoadMatrixd(this.toGLMatrix(matrix4d2), 0);
        Texture texture = this.prologue(gL, shader, n);
        this.dlSphere = this.drawWithDisplayList(this.dlSphere, gL, new SphereDisplayListRenderable(gL), 8, f2);
        this.epilogue(gL, shader, texture, n);
        gL.glPopMatrix();
    }

    private Vector3f genVertexSupershape(Vector3f vector3f, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        float f13 = (float)(Math.pow(Math.abs(Math.cos((double)(f5 * f) / 4.0) / (double)f3), f7) + Math.pow(Math.abs(Math.sin((double)(f5 * f) / 4.0) / (double)f4), f8));
        float f14 = (float)(Math.pow(Math.abs(Math.cos((double)(f9 * f2) / 4.0) / (double)f3), f11) + Math.pow(Math.abs(Math.sin((double)(f9 * f2) / 4.0) / (double)f4), f12));
        float f15 = (float)Math.pow(Math.abs(f13), -1.0f / f6);
        float f16 = (float)Math.pow(Math.abs(f14), -1.0f / f10);
        float f17 = (float)((double)f15 * Math.cos(f) * (double)f16 * Math.cos(f2));
        float f18 = (float)((double)f15 * Math.sin(f) * (double)f16 * Math.cos(f2));
        float f19 = (float)((double)f16 * Math.sin(f2));
        vector3f.set(f17, f18, f19);
        return vector3f;
    }

    private void drawSupershapeImpl(GL gL, int n, int n2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        for (int i = -n2; i < n2; i += 2) {
            float f11 = (float)(Math.PI * (double)(i + 2) / (double)n2 / 2.0);
            float f12 = (float)(Math.PI * (double)i / (double)n2 / 2.0);
            gL.glBegin(8);
            for (int j = 0; j <= n; ++j) {
                float f13 = (float)(Math.PI * 2 * (double)j / (double)n);
                this.genVertexSupershape(vector3f, f13, f11, f, f2, f3, f4, f5, f6, f7, f8, f9, f10);
                this.genVertexSupershape(vector3f2, f13, f12, f, f2, f3, f4, f5, f6, f7, f8, f9, f10);
                gL.glNormal3f(vector3f.x, vector3f.y, vector3f.z);
                gL.glTexCoord2f((float)j / (float)n, 0.5f + (float)(i + 2) / (float)n2 / 2.0f);
                gL.glVertex3f(vector3f.x, vector3f.y, vector3f.z);
                gL.glNormal3f(vector3f2.x, vector3f2.y, vector3f2.z);
                gL.glTexCoord2f((float)j / (float)n, 0.5f + (float)i / (float)n2 / 2.0f);
                gL.glVertex3f(vector3f2.x, vector3f2.y, vector3f2.z);
            }
            gL.glEnd();
        }
    }

    @Override
    public void drawSupershape(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Shader shader, int n, Matrix4d matrix4d) {
        shader = this.getShader(shader);
        matrix4d = this.getTransformation(matrix4d);
        float f11 = this.getLOD(matrix4d, Math.max(f, f2));
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.m00 = 1.0f;
        matrix3f.m11 = Math.max(f, f2) > 0.0f ? 1.0f : -1.0f;
        matrix3f.m22 = Math.max(f, f2);
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.set(matrix3f);
        matrix4d2.mul(matrix4d, matrix4d2);
        GL gL = this.canvas.getGL();
        gL.glPushMatrix();
        gL.glLoadMatrixd(this.toGLMatrix(matrix4d2), 0);
        Texture texture = this.prologue(gL, shader, n);
        this.dlSupershape = this.drawWithDisplayList(this.dlSupershape, gL, new SupershapeDisplayListRenderable(gL, f, f2, f3, f4, f5, f6, f7, f8, f9, f10), 8, f11);
        this.epilogue(gL, shader, texture, n);
        gL.glPopMatrix();
    }

    void drawFrustumImpl(GL gL, int n, boolean bl, float f, boolean bl2, float f2) {
        this.drawFrustumImpl(gL, n, bl, f, bl2, f2, 1.0f);
    }

    void drawFrustumImpl(GL gL, int n, boolean bl, float f, boolean bl2, float f2, float f3) {
        float f4;
        float f5;
        float f6;
        int n2;
        gL.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f6 = (float)(Math.PI * 2 * (double)n2 / (double)n);
            f5 = (float)Math.cos(f6);
            f4 = (float)Math.sin(f6);
            gL.glNormal3f(f5, f4, 0.0f);
            gL.glTexCoord2f(f6 / ((float)Math.PI * 2), f3);
            gL.glVertex3f(f * f5, f * f4, 1.0f);
            gL.glTexCoord2f(f6 / ((float)Math.PI * 2), 0.0f);
            gL.glVertex3f(f2 * f5, f2 * f4, 0.0f);
        }
        gL.glEnd();
        if (bl2) {
            gL.glBegin(6);
            gL.glNormal3f(0.0f, 0.0f, -1.0f);
            gL.glTexCoord2f(0.5f, 0.5f);
            gL.glVertex3f(0.0f, 0.0f, 0.0f);
            for (n2 = 0; n2 <= n; ++n2) {
                f6 = (float)(Math.PI * 2 * (double)(-n2) / (double)n);
                f5 = (float)Math.cos(f6);
                f4 = (float)Math.sin(f6);
                gL.glTexCoord2f(f5 / 2.0f + 0.5f, f4 / 2.0f + 0.5f);
                gL.glVertex3f(f2 * f5, f2 * f4, 0.0f);
            }
            gL.glEnd();
        }
        if (bl) {
            gL.glBegin(6);
            gL.glNormal3f(0.0f, 0.0f, 1.0f);
            gL.glTexCoord2f(0.5f, 0.5f);
            gL.glVertex3f(0.0f, 0.0f, 1.0f);
            for (n2 = 0; n2 <= n; ++n2) {
                f6 = (float)(Math.PI * 2 * (double)n2 / (double)n);
                f5 = (float)Math.cos(f6);
                f4 = (float)Math.sin(f6);
                gL.glTexCoord2f(f5 / 2.0f + 0.5f, f4 / 2.0f + 0.5f);
                gL.glVertex3f(f * f5, f * f4, 1.0f);
            }
            gL.glEnd();
        }
    }

    @Override
    public void drawFrustum(float f, float f2, float f3, boolean bl, boolean bl2, float f4, Shader shader, int n, Matrix4d matrix4d) {
        shader = this.getShader(shader);
        matrix4d = this.getTransformation(matrix4d);
        float f5 = this.getLOD(matrix4d, Math.max(f2, f3));
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.m00 = 1.0f;
        matrix3f.m11 = f > 0.0f ? 1.0f : -1.0f;
        matrix3f.m22 = f;
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.set(matrix3f);
        matrix4d2.mul(matrix4d, matrix4d2);
        GL gL = this.canvas.getGL();
        gL.glPushMatrix();
        gL.glLoadMatrixd(this.toGLMatrix(matrix4d2), 0);
        int n2 = 5 + (int)(25.0f * f5);
        Texture texture = this.prologue(gL, shader, n);
        this.drawFrustumImpl(gL, n2, bl2, f3, bl, f2, f4);
        this.epilogue(gL, shader, texture, n);
        gL.glPopMatrix();
    }

    public int drawWithDisplayList(int n, GL gL, DisplayListRenderable displayListRenderable, int n2, float f) {
        if (n == 0) {
            n = gL.glGenLists(n2);
            if (n == 0) {
                Logger logger = this.getView().getWorkbench().getLogger();
                logger.warning("failed to allocate display list indices");
            } else {
                for (int i = 0; i < n2; ++i) {
                    gL.glNewList(n + i, 4864);
                    displayListRenderable.render((float)i / (float)n2);
                    gL.glEndList();
                }
            }
        }
        if (n != 0) {
            int n3 = n + (int)Math.min((float)(n2 - 1), f * (float)n2);
            gL.glCallList(n3);
        } else {
            displayListRenderable.render(f /= 2.0f);
        }
        return n;
    }

    @Override
    public void drawPolygons(Polygonizable polygonizable, Object object, boolean bl, Shader shader, int n, Matrix4d matrix4d) {
        GL gL;
        CacheData cacheData;
        if (this.polyCache != null && this.polyCache.getGraphState() != this.getRenderGraphState()) {
            this.polyCache.clear();
            this.polyCache = null;
        }
        if (this.polyCache == null) {
            this.polyCache = new PolygonizationCache(this.getRenderGraphState(), 3, 10.0f, true);
        }
        shader = this.getShader(shader);
        matrix4d = this.getTransformation(matrix4d);
        PolygonArray polygonArray = this.polyCache.get(object, bl, polygonizable);
        if (polygonArray.wasCleared() || !(polygonArray.userObject instanceof CacheData)) {
            cacheData = new CacheData();
            cacheData.polygonSize = polygonArray.polygons.size;
            if (cacheData.polygonSize > 0) {
                if (this.supportsVBO) {
                    gL = this.canvas.getGL();
                    cacheData.id = new int[1];
                    gL.glGenBuffersARB(1, cacheData.id, 0);
                    gL.glBindBufferARB(34962, cacheData.id[0]);
                    int n2 = 0;
                    cacheData.vsize = polygonArray.vertices.size * 4;
                    n2 += cacheData.vsize;
                    cacheData.nsize = polygonArray.normals.size * 1;
                    n2 += cacheData.nsize;
                    cacheData.tsize = polygonArray.uv.size * 4;
                    gL.glBufferDataARB(34962, n2 += cacheData.tsize, null, 35044);
                    ByteBuffer byteBuffer = gL.glMapBufferARB(34962, 35001);
                    byteBuffer.position(byteBuffer.asFloatBuffer().put(polygonArray.vertices.elements, 0, polygonArray.vertices.size).put(polygonArray.uv.elements, 0, polygonArray.uv.size).position() * 4);
                    byteBuffer.put(polygonArray.normals.elements, 0, polygonArray.normals.size);
                    gL.glUnmapBufferARB(34962);
                    gL.glBindBufferARB(34962, 0);
                    cacheData.ib = GLDisplay.newByteBuffer(polygonArray.polygons.size * 4).asIntBuffer();
                    polygonArray.polygons.writeTo(cacheData.ib);
                } else {
                    cacheData.ib = GLDisplay.newByteBuffer(polygonArray.polygons.size * 4).asIntBuffer();
                    polygonArray.polygons.writeTo(cacheData.ib);
                    cacheData.vb = GLDisplay.newByteBuffer(polygonArray.vertices.size * 4).asFloatBuffer();
                    polygonArray.vertices.writeTo(cacheData.vb);
                    cacheData.nb = GLDisplay.newByteBuffer(polygonArray.normals.size);
                    polygonArray.normals.writeTo(cacheData.nb);
                    cacheData.uvb = GLDisplay.newByteBuffer(polygonArray.uv.size * 4).asFloatBuffer();
                    polygonArray.uv.writeTo(cacheData.uvb);
                }
            }
            polygonArray.userObject = cacheData;
        } else {
            cacheData = (CacheData)polygonArray.userObject;
        }
        if (cacheData.polygonSize > 0) {
            if (this.supportsVBO) {
                cacheData.ib.rewind();
            } else {
                cacheData.ib.rewind();
                cacheData.vb.rewind();
                cacheData.nb.rewind();
                cacheData.uvb.rewind();
            }
            gL = this.canvas.getGL();
            switch (polygonArray.visibleSides) {
                case 1: {
                    gL.glCullFace(1028);
                    gL.glLightModeli(2898, 1);
                    break;
                }
                case 2: {
                    gL.glDisable(2884);
                    gL.glLightModeli(2898, 1);
                }
            }
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            gL.glLoadMatrixd(this.toGLMatrix(matrix4d), 0);
            Texture texture = this.prologue(gL, shader, n);
            gL.glEnableClientState(32884);
            gL.glEnableClientState(32885);
            gL.glEnableClientState(32888);
            if (this.supportsVBO) {
                gL.glBindBufferARB(34962, cacheData.id[0]);
                int n3 = 0;
                gL.glVertexPointer(polygonArray.dimension, 5126, 0, (long)n3);
                gL.glTexCoordPointer(2, 5126, 0, (long)(n3 += cacheData.vsize));
                gL.glNormalPointer(5120, 0, (long)(n3 += cacheData.tsize));
                n3 += cacheData.nsize;
                gL.glDrawElements(polygonArray.edgeCount == 3 ? 4 : 7, cacheData.polygonSize, 5125, (Buffer)cacheData.ib);
                gL.glBindBufferARB(34962, 0);
            } else {
                gL.glVertexPointer(polygonArray.dimension, 5126, 0, (Buffer)cacheData.vb);
                gL.glNormalPointer(5120, 0, (Buffer)cacheData.nb);
                gL.glTexCoordPointer(2, 5126, 0, (Buffer)cacheData.uvb);
                gL.glDrawElements(polygonArray.edgeCount == 3 ? 4 : 7, cacheData.polygonSize, 5125, (Buffer)cacheData.ib);
            }
            gL.glDisableClientState(32884);
            gL.glDisableClientState(32885);
            gL.glDisableClientState(32888);
            this.epilogue(gL, shader, texture, n);
            switch (polygonArray.visibleSides) {
                case 1: {
                    gL.glCullFace(1029);
                    gL.glLightModeli(2898, 0);
                    break;
                }
                case 2: {
                    gL.glEnable(2884);
                    gL.glLightModeli(2898, 0);
                }
            }
            gL.glMatrixMode(5888);
            gL.glPopMatrix();
        }
    }

    @Override
    public void drawRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
        Overlay overlay = new Overlay((GLDrawable)this.canvas);
        Graphics2D graphics2D = overlay.createGraphics();
        graphics2D.setColor(new Color(tuple3f.x, tuple3f.y, tuple3f.z));
        graphics2D.drawRect(n, n2, n3, n4);
        overlay.beginRendering();
        overlay.draw(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        overlay.endRendering();
    }

    @Override
    public void fillRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
        Overlay overlay = new Overlay((GLDrawable)this.canvas);
        Graphics2D graphics2D = overlay.createGraphics();
        graphics2D.setColor(new Color(tuple3f.x, tuple3f.y, tuple3f.z));
        graphics2D.fillRect(n, n2, n3, n4);
        overlay.beginRendering();
        overlay.draw(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        overlay.endRendering();
    }

    @Override
    public void drawString(int n, int n2, String string, Font font, Tuple3f tuple3f) {
        TextRenderer textRenderer = this.textRenderers.get(font);
        if (textRenderer == null) {
            textRenderer = new TextRenderer(font, true, true);
            this.textRenderers.put(font, textRenderer);
        }
        int n3 = this.canvas.getWidth();
        int n4 = this.canvas.getHeight();
        textRenderer.beginRendering(n3, n4);
        textRenderer.setColor(tuple3f.x, tuple3f.y, tuple3f.z, 1.0f);
        textRenderer.draw(string, n, n4 - n2);
        textRenderer.endRendering();
    }

    protected void optionValueChanged(String string, Object object) {
        if (OPTION_NAME_SHOW_POINTS.equals(string)) {
            this.optionShowPoints = Boolean.TRUE.equals(object);
            this.repaint(7);
        } else if (OPTION_NAME_LIGHTING.equals(string)) {
            this.lightingOn = Boolean.TRUE.equals(object);
            this.repaint(7);
        } else if (OPTION_NAME_SHOW_GRID.equals(string)) {
            this.optionShowGrid = Boolean.TRUE.equals(object);
            this.repaint(7);
        } else if (OPTION_NAME_GRID_DIMENSION.equals(string)) {
            this.optionGridDimension = (Integer)object;
            this.repaint(7);
        } else if (OPTION_NAME_GRID_SPACING.equals(string)) {
            this.optionGridSpacing = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_GRID_COLOR_R.equals(string)) {
            this.optionGridColorR = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_GRID_COLOR_G.equals(string)) {
            this.optionGridColorG = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_GRID_COLOR_B.equals(string)) {
            this.optionGridColorB = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_SHOW_AXES.equals(string)) {
            this.optionShowAxes = Boolean.TRUE.equals(object);
            this.repaint(7);
        } else if (OPTION_NAME_SHOW_AXES_NAMES.equals(string)) {
            this.optionShowAxesNames = Boolean.TRUE.equals(object);
            this.repaint(7);
        } else if (OPTION_NAME_SHOW_DISPLAY_SIZE.equals(string)) {
            this.optionShowDisplaySize = Boolean.TRUE.equals(object);
            this.repaint(7);
        } else {
            super.optionValueChanged(string, object);
        }
    }

    void highlightPrologue(int n, GL gL, byte by, byte by2, byte by3, byte by4) {
        if (n == -1) {
            n = this.curHighlight;
        }
        if (n != 0) {
            gL.glPolygonMode(1032, 6913);
            gL.glDisable(2929);
            gL.glColor4ub((byte)(207 - by), (byte)(207 - by2), (byte)(207 - by3), by4);
        } else {
            gL.glColor4ub(by, by2, by3, by4);
        }
    }

    void highlightEpilogue(int n, GL gL) {
        if (n == -1) {
            n = this.curHighlight;
        }
        if (n != 0) {
            gL.glPolygonMode(1032, 6914);
            gL.glEnable(2929);
        }
    }

    public static boolean isExtensionSupported(GL gL, String string) {
        int n;
        String string2;
        int n2;
        boolean bl = false;
        if (!(string.indexOf(32) >= 0 || (n2 = (string2 = gL.glGetString(7939)).indexOf(string)) < 0 || n2 != 0 && string2.charAt(n2 - 1) != ' ' || (n = n2 + string.length()) < string2.length() && string2.charAt(n) != ' ')) {
            bl = true;
        }
        return bl;
    }

    static BufferedImage convert(Image image) {
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    void drawGrid(GL gL) {
        this.gridColor.set(this.optionGridColorR, this.optionGridColorG, this.optionGridColorB);
        float f = (float)this.optionGridDimension * this.optionGridSpacing;
        for (float f2 = -f; f2 <= f; f2 += this.optionGridSpacing) {
            for (float f3 = -f; f3 <= f; f3 += this.optionGridSpacing) {
                this.startPoint.set(f2, f3, 0.0f);
                this.endPoint.set(-f2, f3, 0.0f);
                this.drawLine((Tuple3f)this.startPoint, (Tuple3f)this.endPoint, (Tuple3f)this.gridColor, 0, null);
                this.startPoint.set(f2, f3, 0.0f);
                this.endPoint.set(f2, -f3, 0.0f);
                this.drawLine((Tuple3f)this.startPoint, (Tuple3f)this.endPoint, (Tuple3f)this.gridColor, 0, null);
            }
        }
        gL.glGetIntegerv(2849, this.lineWidth, 0);
        gL.glLineWidth(3.0f);
        this.startPoint.set(f, 0.0f, 0.0f);
        this.endPoint.set(-f, 0.0f, 0.0f);
        this.drawLine((Tuple3f)this.startPoint, (Tuple3f)this.endPoint, (Tuple3f)this.gridColor, 0, null);
        this.startPoint.set(0.0f, f, 0.0f);
        this.endPoint.set(0.0f, -f, 0.0f);
        this.drawLine((Tuple3f)this.startPoint, (Tuple3f)this.endPoint, (Tuple3f)this.gridColor, 0, null);
        gL.glLineWidth((float)this.lineWidth[0]);
    }

    protected void drawAxes(GL gL, Camera camera) {
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        gL.glOrtho(-5.0, 5.0, -5.0, 5.0, -100.0, 100.0);
        gL.glViewport(0, 0, 100, 100);
        gL.glMatrixMode(5888);
        gL.glDisable(2903);
        gL.glClear(256);
        gL.glGetBooleanv(2896, this.lightParams, 0);
        gL.glEnable(2896);
        gL.glPushMatrix();
        gL.glLightfv(16384, 4611, this.lightPositionAxes, 0);
        gL.glLightf(16384, 4614, 180.0f);
        camera = ((View3D)this.getView()).getCamera();
        this.rot.set(camera.getWorldToViewTransformation());
        gL.glRotated(this.rot.angle * 180.0 / Math.PI, this.rot.x, this.rot.y, this.rot.z);
        gL.glPushMatrix();
        gL.glMaterialfv(1028, 5634, red, 0);
        gL.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        gL.glPushMatrix();
        gL.glScalef(1.0f, 1.0f, 2.5f);
        this.drawFrustumImpl(gL, 16, true, 0.1f, true, 0.1f);
        gL.glPopMatrix();
        gL.glTranslatef(0.0f, 0.0f, 2.5f);
        this.drawFrustumImpl(gL, 16, true, 0.0f, true, 0.5f);
        gL.glPopMatrix();
        gL.glPushMatrix();
        gL.glMaterialfv(1028, 5634, blue, 0);
        gL.glRotatef(-90.0f, 1.0f, 0.0f, 0.0f);
        gL.glPushMatrix();
        gL.glScalef(1.0f, 1.0f, 2.5f);
        this.drawFrustumImpl(gL, 16, true, 0.1f, true, 0.1f);
        gL.glPopMatrix();
        gL.glTranslatef(0.0f, 0.0f, 2.5f);
        this.drawFrustumImpl(gL, 16, true, 0.0f, true, 0.5f);
        gL.glPopMatrix();
        gL.glPushMatrix();
        gL.glMaterialfv(1028, 5634, green, 0);
        gL.glPushMatrix();
        gL.glScalef(1.0f, 1.0f, 2.5f);
        this.drawFrustumImpl(gL, 16, true, 0.1f, true, 0.1f);
        gL.glPopMatrix();
        gL.glTranslatef(0.0f, 0.0f, 2.5f);
        this.drawFrustumImpl(gL, 16, true, 0.0f, true, 0.5f);
        gL.glPopMatrix();
        if (this.optionShowAxesNames) {
            gL.glLightfv(16384, 4611, this.lightPositionAxesNames, 0);
            gL.glPushMatrix();
            gL.glMaterialfv(1028, 5634, red, 0);
            gL.glTranslatef(4.0f, 0.0f, -0.3f);
            gL.glRasterPos3d(0.0, 0.0, 0.0);
            this.glut.glutBitmapString(7, "x");
            gL.glPopMatrix();
            gL.glPushMatrix();
            gL.glMaterialfv(1028, 5634, blue, 0);
            gL.glTranslatef(0.0f, 4.0f, -0.3f);
            gL.glRasterPos3d(0.0, 0.0, 0.0);
            this.glut.glutBitmapString(7, "y");
            gL.glPopMatrix();
            gL.glPushMatrix();
            gL.glMaterialfv(1028, 5634, green, 0);
            gL.glTranslatef(0.0f, 0.0f, 4.0f);
            gL.glRasterPos3d(0.0, 0.0, 0.0);
            this.glut.glutBitmapString(7, "z");
            gL.glPopMatrix();
        }
        gL.glEnable(2903);
        gL.glPopMatrix();
        if (this.lightParams[0] == 0) {
            gL.glDisable(2896);
        } else {
            gL.glEnable(2896);
        }
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        gL.glViewport(0, 0, this.getView().getSize().width, this.getView().getSize().height);
        float f = (float)this.getView().getSize().height / (float)this.getView().getSize().width;
        gL.glFrustum(-1.0, 1.0, (double)(-f), (double)f, 5.0, 600.0);
        gL.glMatrixMode(5888);
    }

    protected void drawDisplaySize(GL gL, Camera camera) {
        int n = this.getView().getSize().width;
        int n2 = this.getView().getSize().height;
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        gL.glOrtho(-5.0, 5.0, -5.0, 5.0, 0.0, 100.0);
        gL.glViewport(0, n2 - 30, 100, 30);
        gL.glMatrixMode(5888);
        gL.glDisable(2903);
        gL.glClear(256);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glMaterialfv(1028, 5634, black, 0);
        gL.glRasterPos3d(-4.0, 0.0, 0.0);
        this.glut.glutBitmapString(7, n + " x " + n2);
        gL.glEnable(2903);
        gL.glPopMatrix();
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        gL.glViewport(0, 0, n, n2);
        float f = (float)n2 / (float)n;
        gL.glFrustum(-1.0, 1.0, (double)(-f), (double)f, 5.0, 600.0);
        gL.glMatrixMode(5888);
    }

    private static Tuple3f calculateHighlightColor(Tuple3f tuple3f) {
        int n = (int)((double)(255.0f * tuple3f.x) + 0.5);
        int n2 = (int)((double)(255.0f * tuple3f.y) + 0.5);
        int n3 = (int)((double)(255.0f * tuple3f.z) + 0.5);
        return new Color3f((float)((n ^= 0xFFFFFFFF) & 0xFF) / 255.0f, (float)((n2 ^= 0xFFFFFFFF) & 0xFF) / 255.0f, (float)((n3 ^= 0xFFFFFFFF) & 0xFF) / 255.0f);
    }

    static {
        new GLCanvas();
        RENDER_MODE = new EnumerationType("gl.rendermode", IMP3D.I18N, 3);
        red = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
        green = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
        blue = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
        black = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    }

    class SupershapeDisplayListRenderable
    extends DisplayListRenderable {
        GL gl;
        float a;
        float b;
        float m1;
        float n11;
        float n12;
        float n13;
        float m2;
        float n21;
        float n22;
        float n23;

        SupershapeDisplayListRenderable(GL gL, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
            this.gl = gL;
            this.a = f;
            this.b = f2;
            this.m1 = f3;
            this.n11 = f4;
            this.n12 = f5;
            this.n13 = f6;
            this.m2 = f7;
            this.n21 = f8;
            this.n22 = f9;
            this.n23 = f10;
        }

        void render(float f) {
            float f2 = (this.m1 + this.m2) / 2.0f;
            int n = (int)(f2 + f2 * 3.0f * f);
            GLDisplay.this.drawSupershapeImpl(this.gl, n, n, this.a, this.b, this.m1, this.n11, this.n12, this.n13, this.m2, this.n21, this.n22, this.n23);
        }
    }

    class SphereDisplayListRenderable
    extends DisplayListRenderable {
        GL gl;

        SphereDisplayListRenderable(GL gL) {
            this.gl = gL;
        }

        void render(float f) {
            int n;
            int n2 = n = 8 + (int)(24.0f * f);
            GLDisplay.this.drawSphereImpl(this.gl, n, n2);
        }
    }

    public class GLVisitor
    extends DisplayVisitor {
        private int minPathLength;
        private LineSegmentizationCache lineCache;
        Matrix4d worldToViewInv = new Matrix4d();

        public void init(GraphState graphState, Matrix4d matrix4d, int n, boolean bl) {
            this.init(graphState, matrix4d, GLDisplay.this.getView3D(), bl);
            Matrix4d matrix4d2 = GLDisplay.this.getView3D().getCamera().getWorldToViewTransformation();
            this.worldToViewInv.invert(matrix4d2);
            this.minPathLength = n;
            if (this.lineCache == null) {
                this.lineCache = new LineSegmentizationCache(graphState, 1.0f);
            }
        }

        protected void visitImpl(Object object, boolean bl, Shader shader, Path path) {
            int n;
            Object object2;
            Object object3;
            Object object4;
            if (this.minPathLength > 0 && path.getNodeAndEdgeCount() - (bl ? 0 : 1) < this.minPathLength) {
                return;
            }
            Object object5 = this.state.getObjectDefault(object, bl, Attributes.SHAPE, null);
            Color3f color3f = new Color3f(Color.WHITE);
            Object object6 = this.state.getObjectDefault(object, bl, Attributes.COLOR, (Object)this);
            color3f = object6 != null && object6 != this ? (Color3f)object6 : new Color3f(new Color(shader.getAverageColor()));
            if (object5 != null) {
                if (object5 instanceof Renderable) {
                    ((Renderable)object5).draw(object, bl, GLDisplay.this);
                } else if (object5 instanceof LineSegmentizable) {
                    object4 = this.lineCache.get(object, bl, (LineSegmentizable)object5);
                    object3 = ((LineArray)object4).lines.elements;
                    float[] fArray = ((LineArray)object4).vertices.elements;
                    int n2 = ((LineArray)object4).dimension;
                    int n3 = ((LineArray)object4).lines.size();
                    object2 = new Point3f();
                    Point3f point3f = new Point3f();
                    boolean bl2 = true;
                    for (int i = 0; i < n3; ++i) {
                        int n4 = object3[i];
                        if (n4 < 0) {
                            bl2 = true;
                            continue;
                        }
                        if (bl2) {
                            object2.set(n2 > 0 ? fArray[n2 * n4 + 0] : 0.0f, n2 > 1 ? fArray[n2 * n4 + 1] : 0.0f, n2 > 2 ? fArray[n2 * n4 + 2] : 0.0f);
                            bl2 = false;
                            continue;
                        }
                        point3f.set(n2 > 0 ? fArray[n2 * n4 + 0] : 0.0f, n2 > 1 ? fArray[n2 * n4 + 1] : 0.0f, n2 > 2 ? fArray[n2 * n4 + 2] : 0.0f);
                        GLDisplay.this.drawLine((Tuple3f)object2, (Tuple3f)point3f, (Tuple3f)color3f, 0, null);
                        object2.set((Tuple3f)point3f);
                    }
                }
            }
            if (GLDisplay.this.checkLightSources && (object4 = this.state.getObjectDefault(object, bl, Attributes.LIGHT, null)) instanceof Light && (n = (object3 = (Object)((Light)object4)).getLightType()) != 0 && n != 4) {
                ++GLDisplay.this.lightCount;
                Matrix4d matrix4d = new Matrix4d();
                matrix4d.mul(this.worldToViewInv, this.getCurrentTransformation());
                LightSource lightSource = GLDisplay.convertLightToLightSource((Light)object3, matrix4d);
                object2 = GLDisplay.this.lights.get(object3);
                if (!lightSource.equals(object2)) {
                    GLDisplay.this.lightsChanged = true;
                    lightSource.stamp = GLDisplay.this.oldStamp;
                    GLDisplay.this.lights.put((Light)object3, lightSource);
                } else {
                    object2.stamp = GLDisplay.this.oldStamp;
                }
            }
        }
    }
}

