/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.utility.FrameBufferObject;
import de.grogra.imp3d.glsl.utility.RenderBuffer;
import de.grogra.imp3d.glsl.utility.TextureRenderTarget;

public class GLSLFBOManager {
    FrameBufferObject deferredShadingFBO = new FrameBufferObject();
    FrameBufferObject HDRFBO = new FrameBufferObject();
    FrameBufferObject alphaFBO = new FrameBufferObject();
    FrameBufferObject shadowFBO = new FrameBufferObject();
    FrameBufferObject cubeFBO = new FrameBufferObject();
    FrameBufferObject dualDepthFBO = new FrameBufferObject();
    RenderBuffer depthRB = new RenderBuffer();
    TextureRenderTarget peelingFarDepthTRT = new TextureRenderTarget();
    RenderBuffer peelingRB = new RenderBuffer();
    TextureRenderTarget[] textureRenderTargets = null;
    TextureRenderTarget peelingNearDepthTRT = new TextureRenderTarget();

    protected void setupFBO(OpenGLState openGLState) {
        int n;
        this.cubeFBO.create(openGLState);
        this.deferredShadingFBO.create(openGLState);
        switch (GLSLDisplay.getDepthStencilSetup()) {
            case 3: {
                this.depthRB.create(openGLState, 35056);
                this.deferredShadingFBO.attachDepthStencil(openGLState, this.depthRB);
                break;
            }
            default: {
                this.depthRB.create(openGLState, 33190);
                this.deferredShadingFBO.attachDepthOnly(openGLState, this.depthRB);
            }
        }
        openGLState.setFBO(0);
        this.peelingFarDepthTRT.create(openGLState, 2, 3553);
        this.dualDepthFBO.create(openGLState);
        switch (GLSLDisplay.getDepthStencilSetup()) {
            case 3: {
                this.peelingRB.create(openGLState, 35056);
                this.dualDepthFBO.attachDepthStencil(openGLState, this.peelingRB);
                break;
            }
            default: {
                this.peelingRB.create(openGLState, 33190);
                this.dualDepthFBO.attachDepthOnly(openGLState, this.peelingRB);
            }
        }
        if (this.peelingNearDepthTRT == null) {
            this.peelingNearDepthTRT = new TextureRenderTarget();
        }
        this.peelingNearDepthTRT.create(openGLState, 2, 3553);
        this.dualDepthFBO.isComplete(openGLState);
        openGLState.setFBO(0);
        this.HDRFBO.create(openGLState);
        switch (GLSLDisplay.getDepthStencilSetup()) {
            case 3: {
                this.HDRFBO.attachDepthStencil(openGLState, this.depthRB);
                break;
            }
            default: {
                this.HDRFBO.attachDepthOnly(openGLState, this.depthRB);
            }
        }
        this.alphaFBO.create(openGLState);
        switch (GLSLDisplay.getDepthStencilSetup()) {
            case 3: {
                this.alphaFBO.attachDepthStencil(openGLState, this.depthRB);
                break;
            }
            default: {
                this.alphaFBO.attachDepthOnly(openGLState, this.depthRB);
            }
        }
        this.shadowFBO.create(openGLState);
        openGLState.setFBO(0);
        if (this.textureRenderTargets == null) {
            this.textureRenderTargets = new TextureRenderTarget[7];
        }
        for (n = 0; n < 6; ++n) {
            this.textureRenderTargets[n] = new TextureRenderTarget();
            this.textureRenderTargets[n].create(openGLState, n < 4 ? 0 : 0);
        }
        this.textureRenderTargets[6] = new TextureRenderTarget();
        this.textureRenderTargets[6].create(openGLState, 1);
        for (n = 0; n < 4; ++n) {
            this.deferredShadingFBO.attachDrawBuffer(openGLState, this.textureRenderTargets[n], n);
        }
        GLSLDisplay.printDebugInfo("DeferredFBO ");
        this.deferredShadingFBO.isComplete(openGLState);
        for (n = 0; n < 2; ++n) {
            this.HDRFBO.attachDrawBuffer(openGLState, this.textureRenderTargets[4 + n], n);
        }
        GLSLDisplay.printDebugInfo("HDRFBO ");
        this.HDRFBO.isComplete(openGLState);
        this.alphaFBO.attachDrawBuffer(openGLState, this.textureRenderTargets[6], 0);
        GLSLDisplay.printDebugInfo("AlphaFBO ");
        this.alphaFBO.isComplete(openGLState);
        openGLState.setFBO(0);
    }

    public void resize(GLSLDisplay gLSLDisplay, OpenGLState openGLState) {
        GLSLDisplay.printDebugInfoN("Resizing FBO:");
        openGLState.initSize(gLSLDisplay.getView().getSize().width, gLSLDisplay.getView().getSize().height);
        this.peelingFarDepthTRT.resize(openGLState);
        this.peelingNearDepthTRT.resize(openGLState);
        this.depthRB.resize(openGLState);
        this.peelingRB.resize(openGLState);
        switch (GLSLDisplay.getDepthStencilSetup()) {
            case 3: {
                this.dualDepthFBO.attachDepthStencil(openGLState, this.peelingRB);
                break;
            }
            default: {
                this.dualDepthFBO.attachDepthOnly(openGLState, this.peelingRB);
            }
        }
        this.dualDepthFBO.isComplete(openGLState);
        this.deferredShadingFBO.resizeAttachments(openGLState);
        switch (GLSLDisplay.getDepthStencilSetup()) {
            case 3: {
                this.deferredShadingFBO.attachDepthStencil(openGLState, this.depthRB);
                break;
            }
            default: {
                this.deferredShadingFBO.attachDepthOnly(openGLState, this.depthRB);
            }
        }
        this.deferredShadingFBO.isComplete(openGLState);
        this.HDRFBO.resizeAttachments(openGLState);
        switch (GLSLDisplay.getDepthStencilSetup()) {
            case 3: {
                this.HDRFBO.attachDepthStencil(openGLState, this.depthRB);
                break;
            }
            default: {
                this.HDRFBO.attachDepthOnly(openGLState, this.depthRB);
            }
        }
        this.HDRFBO.isComplete(openGLState);
        this.alphaFBO.resizeAttachments(openGLState);
        switch (GLSLDisplay.getDepthStencilSetup()) {
            case 3: {
                this.alphaFBO.attachDepthStencil(openGLState, this.depthRB);
                break;
            }
            default: {
                this.alphaFBO.attachDepthOnly(openGLState, this.depthRB);
            }
        }
        this.alphaFBO.isComplete(openGLState);
    }

    public void deleteAll(OpenGLState openGLState, boolean bl) {
        GLSLDisplay.printDebugInfoN("Deleting FBO:");
        this.deferredShadingFBO.deleteAttachments(openGLState, bl);
        this.deferredShadingFBO.delete(openGLState, bl);
        this.HDRFBO.deleteAttachments(openGLState, bl);
        this.HDRFBO.delete(openGLState, bl);
        this.alphaFBO.deleteAttachments(openGLState, bl);
        this.alphaFBO.delete(openGLState, bl);
        this.shadowFBO.deleteAttachments(openGLState, bl);
        this.shadowFBO.delete(openGLState, bl);
        this.dualDepthFBO.deleteAttachments(openGLState, bl);
        this.dualDepthFBO.delete(openGLState, bl);
        this.peelingNearDepthTRT.delete(openGLState, bl);
        this.peelingFarDepthTRT.delete(openGLState, bl);
        this.peelingRB.delete(openGLState, bl);
        this.depthRB.delete(openGLState, bl);
        this.cubeFBO.delete(openGLState, bl);
    }
}

