/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.light.GLSLDirectionalLight;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.light.SunSkyToDirectionalLightWrapper;
import de.grogra.imp3d.glsl.light.shadow.SunSkyMock;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import de.grogra.imp3d.shading.SunSkyLight;
import de.grogra.ray.physics.Spectrum3f;
import javax.media.opengl.GL;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class GLSLSkyLight
extends GLSLDirectionalLight {
    SunSkyToDirectionalLightWrapper mock = new SunSkyToDirectionalLightWrapper();
    LightPos mockPos = new LightPos(this.mock);
    SunSkyMock m = new SunSkyMock();

    public Class instanceFor() {
        return SunSkyLight.class;
    }

    public void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, Object object, int n) {
        LightPos lightPos = null;
        assert (object instanceof LightPos);
        lightPos = (LightPos)object;
        assert (lightPos.getLight() instanceof SunSkyLight);
        SunSkyLight sunSkyLight = (SunSkyLight)lightPos.getLight();
        this.m.dir.normalize(sunSkyLight.getSun());
        this.m.turb = sunSkyLight.getTurbidity();
        this.mockPos.setLightTransform(lightPos.getLightTransform());
        this.mockPos.setLightDir(lightPos.getLightDir());
        if (this.m.getSunColor() == null || gLSLDisplay.getCurrentGLState().hasGraphChanged()) {
            this.m.initSunColor(sunSkyLight);
        }
        Spectrum3f spectrum3f = new Spectrum3f();
        spectrum3f.set((Tuple3f)this.m.getSunColor());
        spectrum3f.mul((Tuple3f)this.m.invIrradiance);
        GLSLSkyLight gLSLSkyLight = this;
        spectrum3f.scale(gLSLSkyLight.m.getSunsolidangle() / (double)this.m.sunFraction);
        this.mock.setPowerDensity((float)(32.0 * spectrum3f.integrate()));
        Vector3f vector3f = new Vector3f((Tuple3f)this.m.getSunColor());
        this.mock.setCurcol(vector3f);
        super.setupDynamicUniforms(gL, gLSLDisplay, this.mockPos, n);
    }

    public GLSLShader getInstance() {
        return new GLSLSkyLight();
    }
}

