/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light.shadow;

import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.light.shadow.GLSLShadowCube;
import de.grogra.imp3d.glsl.light.shadow.GLSLShadowMap;
import de.grogra.imp3d.glsl.light.shadow.GLSLShadowParallel;
import de.grogra.imp3d.glsl.light.shadow.GLSLShadowPerspective;
import de.grogra.imp3d.objects.DirectionalLight;
import de.grogra.imp3d.objects.PointLight;
import de.grogra.imp3d.objects.SpotLight;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.SunSkyLight;
import java.util.HashMap;
import java.util.Iterator;

public class ShadowMapCollection {
    HashMap<Class, GLSLShadowMap> shadowMapTypes = new HashMap();
    HashMap<Light, GLSLShadowMap> shadowMaps = new HashMap();

    public ShadowMapCollection() {
        this.initMap();
    }

    public void initMap() {
        this.addNewShadowMapType(SpotLight.class, new GLSLShadowPerspective());
        this.addNewShadowMapType(PointLight.class, new GLSLShadowCube());
        GLSLShadowParallel gLSLShadowParallel = new GLSLShadowParallel();
        this.addNewShadowMapType(DirectionalLight.class, gLSLShadowParallel);
        this.addNewShadowMapType(SunSkyLight.class, gLSLShadowParallel);
    }

    public int getShadowMapMemoryConsumption() {
        int n = 0;
        Iterator<GLSLShadowMap> iterator = this.shadowMaps.values().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().estimateSizeInByte();
        }
        return n;
    }

    public void addNewShadowMapType(Class clazz, GLSLShadowMap gLSLShadowMap) {
        this.shadowMapTypes.put(clazz, gLSLShadowMap);
    }

    public void cleanUp(OpenGLState openGLState, boolean bl) {
        Iterator<GLSLShadowMap> iterator = this.shadowMaps.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().delete(openGLState, bl);
        }
    }

    public void removeUnused(OpenGLState openGLState) {
        Iterator<GLSLShadowMap> iterator = this.shadowMaps.values().iterator();
        while (iterator.hasNext()) {
            GLSLShadowMap gLSLShadowMap = iterator.next();
            if (gLSLShadowMap.GRAPH_STAMP >= openGLState.getGraphStamp()) continue;
            gLSLShadowMap.delete(openGLState, false);
            iterator.remove();
        }
    }

    public GLSLShadowMap getDefaultCachedMap(Light light) {
        GLSLShadowMap gLSLShadowMap = this.shadowMaps.get(light);
        if (gLSLShadowMap == null) {
            gLSLShadowMap = this.shadowMapTypes.get(light.getClass());
            if ((gLSLShadowMap = gLSLShadowMap.getInstance()) == null) {
                System.err.println("No default ShadowMap found for Light: " + light);
                return null;
            }
            this.shadowMaps.put(light, gLSLShadowMap);
        }
        return gLSLShadowMap;
    }
}

