/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.material.channel;

import de.grogra.imp3d.glsl.material.MaterialConfiguration;
import de.grogra.imp3d.glsl.material.channel.GLSLChannelMap;
import de.grogra.imp3d.glsl.material.channel.GLSLChannelMapNode;
import de.grogra.imp3d.glsl.material.channel.Result;
import de.grogra.imp3d.shading.AffineUVTransformation;
import de.grogra.math.ChannelMap;
import javax.vecmath.Matrix3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLSLAffineUVTransformation
extends GLSLChannelMapNode {
    Matrix3f generateTransMatrix(AffineUVTransformation affineUVTransformation) {
        Matrix3f matrix3f = new Matrix3f();
        Matrix3f matrix3f2 = new Matrix3f();
        matrix3f.setIdentity();
        matrix3f2.setIdentity();
        float f = affineUVTransformation.getAngle();
        float f2 = affineUVTransformation.getShear();
        float f3 = affineUVTransformation.getScaleU();
        float f4 = affineUVTransformation.getScaleV();
        float f5 = affineUVTransformation.getOffsetU();
        float f6 = affineUVTransformation.getOffsetV();
        matrix3f.setIdentity();
        matrix3f2.setIdentity();
        matrix3f.m02 = -f5;
        matrix3f.m12 = -f6;
        matrix3f2.rotZ(-f);
        matrix3f2.mul(matrix3f);
        matrix3f.m00 = f3;
        matrix3f.m11 = f4;
        matrix3f.m01 = -f2 * f4;
        matrix3f.m02 = 0.0f;
        matrix3f.m12 = 0.0f;
        matrix3f.mul(matrix3f2);
        return matrix3f;
    }

    @Override
    public Result generate(ChannelMap channelMap, MaterialConfiguration materialConfiguration, GLSLChannelMap gLSLChannelMap, int n) {
        assert (channelMap instanceof AffineUVTransformation);
        AffineUVTransformation affineUVTransformation = (AffineUVTransformation)channelMap;
        Matrix3f matrix3f = this.generateTransMatrix(affineUVTransformation);
        String string = GLSLAffineUVTransformation.generateResultWithChannelDefault(affineUVTransformation.getInput(), materialConfiguration, gLSLChannelMap, 16).convert(1);
        String string2 = "(" + string + ").s";
        String string3 = "(" + string + ").t";
        return new Result("vec2(" + matrix3f.m00 + " * " + string2 + " + " + matrix3f.m01 + " * " + string3 + " + " + matrix3f.m02 + ", " + matrix3f.m10 + " * " + string2 + " + " + matrix3f.m11 + " * " + string3 + " + " + matrix3f.m12 + ")", 1);
    }

    @Override
    public Class<AffineUVTransformation> instanceFor() {
        return AffineUVTransformation.class;
    }
}

