/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderpass;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.renderpass.RenderPass;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import javax.media.opengl.GL;

public class PresentScenePass
extends RenderPass {
    GLSLShader presentScene = null;

    protected int getID() {
        return 6;
    }

    protected void epilogue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        PresentScenePass.deactivateTextures(gL, 1);
        openGLState.setDepthMask(true);
        PresentScenePass.ViewPerspective(openGLState);
        gL.glPopAttrib();
        openGLState.disable('\u0001');
        openGLState.enable('\u0002');
    }

    protected void prologue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        assert (object instanceof Integer);
        openGLState.enable('\u0002');
        openGLState.setActiveProgram(0);
        this.renderVector(gLSLDisplay, openGLState.getWorldToView(), false, openGLState.deferredLabelRenderable);
        GL gL = openGLState.getGL();
        openGLState.setFBO(0);
        gL.glPushAttrib(2048);
        gL.glClearColor(0.5f, 0.5f, 0.5f, 0.0f);
        gL.glClear(16384);
        gL.glBlendFunc(1, 0);
        if (this.presentScene == null) {
            this.presentScene = new PresentSceneShader(openGLState);
        }
        this.presentScene.activateShader(openGLState, gLSLDisplay, gLSLDisplay);
        PresentScenePass.ViewOrtho(openGLState);
        openGLState.setDepthMask(false);
        GLSLDisplay.printDebugInfoN("Presenting: " + (4 + openGLState.getFloatRT()));
        openGLState.getHDRFBO().bindAttachmentAsTexture(openGLState, openGLState.getFloatRT(), 0);
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        Camera camera = gLSLDisplay.getView3D().getCamera();
        PresentScenePass.drawPrjQuad(openGLState, camera);
    }

    class PresentSceneShader
    extends GLSLShader {
        final String[] sceneF;

        public PresentSceneShader(OpenGLState openGLState) {
            super(openGLState);
            this.sceneF = new String[]{"#version 110\n", "#extension GL_ARB_texture_rectangle : enable\n", "uniform sampler2DRect inputTex;", "void main() {", " vec4 color = texture2DRect(inputTex, gl_FragCoord.st);", "  gl_FragColor = clamp(vec4(color.rgb, 1.0), 0.0, 1.0);", "}"};
        }

        protected String[] getFragmentShader(Object object) {
            return this.sceneF;
        }

        protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "inputTex");
            gL.glUniform1i(n, 0);
        }
    }
}

