/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderpass;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.ParallelProjection;
import de.grogra.imp3d.PerspectiveProjection;
import de.grogra.imp3d.Projection;
import de.grogra.imp3d.glsl.GLDisplay;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.GLSLUpdateCache;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.utility.Drawable;
import java.util.Vector;
import javax.media.opengl.GL;
import javax.vecmath.Matrix4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RenderPass {
    protected GLSLUpdateCache newVisit = null;

    protected int getID() {
        return -1;
    }

    public void postDrawCallback(Drawable drawable, OpenGLState openGLState, GLSLDisplay gLSLDisplay) {
    }

    public void renderVector(GLSLDisplay gLSLDisplay, Matrix4d matrix4d, boolean bl, Vector<Drawable> vector) {
        GLDisplay.GLVisitor gLVisitor = gLSLDisplay.getVisitor();
        OpenGLState openGLState = gLSLDisplay.getCurrentGLState();
        if (this.newVisit == null) {
            this.newVisit = new GLSLUpdateCache(gLSLDisplay);
        }
        this.newVisit.init(gLSLDisplay.getRenderGraphState(), matrix4d, 0);
        gLSLDisplay.setVisitor(this.newVisit);
        for (Drawable drawable : vector) {
            this.postDrawCallback(drawable, openGLState, gLSLDisplay);
            drawable.draw(gLSLDisplay, this.newVisit, matrix4d, bl);
        }
        gLSLDisplay.setVisitor(gLVisitor);
    }

    public void renderAndUpdateVector(GLSLDisplay gLSLDisplay, Matrix4d matrix4d, Vector<Drawable> vector) {
        GLDisplay.GLVisitor gLVisitor = gLSLDisplay.getVisitor();
        OpenGLState openGLState = gLSLDisplay.getCurrentGLState();
        if (this.newVisit == null) {
            this.newVisit = new GLSLUpdateCache(gLSLDisplay);
        }
        this.newVisit.init(gLSLDisplay.getRenderGraphState(), matrix4d, 0);
        gLSLDisplay.setVisitor(this.newVisit);
        for (Drawable drawable : vector) {
            this.postDrawCallback(drawable, openGLState, gLSLDisplay);
            drawable.drawAndUpdate(gLSLDisplay, this.newVisit, matrix4d);
        }
        gLSLDisplay.setVisitor(gLVisitor);
    }

    public static void deactivateTextures(GL gL, int n) {
        RenderPass.deactivateTextures(gL, n, 3553);
    }

    public static void deactivateTextures(GL gL, int n, int n2) {
        for (int i = n - 1; i >= 0; --i) {
            gL.glActiveTexture(33984 + i);
            gL.glBindTexture(n2, 0);
        }
    }

    public static void activateTextures(GL gL, int[] nArray, int n) {
        RenderPass.activateTextures(gL, nArray, n, 3553);
    }

    public static void activateTextures(GL gL, int[] nArray, int n, int n2) {
        n = nArray.length > n ? nArray.length : n;
        for (int i = 0; i < n; ++i) {
            gL.glActiveTexture(33984 + i);
            gL.glBindTexture(n2, nArray[i]);
        }
    }

    public void setMatrix(OpenGLState openGLState, int n, Matrix4d matrix4d) {
        openGLState.getGL().glActiveTexture(33984 + n);
        openGLState.loadMatrixd(matrix4d);
    }

    public void resetMatrix(OpenGLState openGLState, int n) {
        for (int i = n - 1; i >= 0; --i) {
            openGLState.getGL().glActiveTexture(33984 + i);
            openGLState.getGL().glLoadIdentity();
        }
    }

    public static void ViewOrtho(OpenGLState openGLState) {
        RenderPass.ViewOrtho(openGLState, openGLState.width, openGLState.height);
    }

    public static void ViewOrtho(OpenGLState openGLState, int n, int n2) {
        GL gL = openGLState.getGL();
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glOrtho(0.0, (double)n, (double)n2, 0.0, -1.0, 1.0);
    }

    public static void ViewPerspective(OpenGLState openGLState) {
        GL gL = openGLState.getGL();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
    }

    public static void drawPrjQuad(OpenGLState openGLState, Camera camera) {
        RenderPass.drawPrjQuad(openGLState, camera, 0.0f, 0.0f, openGLState.width, openGLState.height);
    }

    public static void drawPrjQuad(OpenGLState openGLState, Camera camera, float f, float f2, float f3, float f4) {
        double d = 1.0471975511965976;
        Projection projection = camera.getProjection();
        if (projection instanceof PerspectiveProjection) {
            d = PerspectiveProjection.clampFieldOfView(((PerspectiveProjection)projection).getFieldOfView());
            RenderPass.drawPrjQuad(openGLState, camera, f, f2, f3, f4, d);
        } else if (projection instanceof ParallelProjection) {
            d = ((ParallelProjection)projection).getWidth();
            RenderPass.drawPrjQuadParallel(openGLState, camera, f, f2, f3, f4, d);
        } else {
            RenderPass.drawPrjQuad(openGLState, camera, f, f2, f3, f4, d);
        }
    }

    public static void drawPrjQuad(OpenGLState openGLState, Camera camera, float f, float f2, float f3, float f4, double d) {
        GL gL = openGLState.getGL();
        double d2 = (double)f4 / (double)f3;
        double d3 = d / 2.0;
        double d4 = Math.tan(d3);
        double d5 = d4 * d2 * (double)camera.getProjection().getAspect();
        float f5 = (float)d4;
        float f6 = (float)d5;
        gL.glBegin(5);
        gL.glMultiTexCoord2f(33984, 0.0f, 1.0f);
        gL.glMultiTexCoord2f(33985, -f5, f6);
        gL.glVertex2f(f, f2);
        gL.glMultiTexCoord2f(33984, 0.0f, 0.0f);
        gL.glMultiTexCoord2f(33985, -f5, -f6);
        gL.glVertex2f(f, f2 + f4);
        gL.glMultiTexCoord2f(33984, 1.0f, 1.0f);
        gL.glMultiTexCoord2f(33985, f5, f6);
        gL.glVertex2f(f + f3, f2);
        gL.glMultiTexCoord2f(33984, 1.0f, 0.0f);
        gL.glMultiTexCoord2f(33985, f5, -f6);
        gL.glVertex2f(f + f3, f2 + f4);
        gL.glEnd();
    }

    public static void drawPrjQuadParallel(OpenGLState openGLState, Camera camera, float f, float f2, float f3, float f4, double d) {
        GL gL = openGLState.getGL();
        double d2 = (double)f4 / (double)f3;
        double d3 = d * 0.5;
        double d4 = d3 * d2;
        float f5 = (float)d3;
        float f6 = (float)d4;
        gL.glBegin(5);
        gL.glMultiTexCoord2f(33984, 0.0f, 1.0f);
        gL.glMultiTexCoord2f(33985, -f5, f6);
        gL.glVertex2f(f, f2);
        gL.glMultiTexCoord2f(33984, 0.0f, 0.0f);
        gL.glMultiTexCoord2f(33985, -f5, -f6);
        gL.glVertex2f(f, f2 + f4);
        gL.glMultiTexCoord2f(33984, 1.0f, 1.0f);
        gL.glMultiTexCoord2f(33985, f5, f6);
        gL.glVertex2f(f + f3, f2);
        gL.glMultiTexCoord2f(33984, 1.0f, 0.0f);
        gL.glMultiTexCoord2f(33985, f5, -f6);
        gL.glVertex2f(f + f3, f2 + f4);
        gL.glEnd();
    }

    protected abstract void prologue(GLSLDisplay var1, OpenGLState var2, Object var3);

    protected abstract void render(GLSLDisplay var1, OpenGLState var2, Object var3);

    protected abstract void epilogue(GLSLDisplay var1, OpenGLState var2, Object var3);

    public void process(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GLSLDisplay.printDebugInfoN(">>>>> " + this.getClass().getSimpleName() + "/" + this.hashCode() + " *****");
        this.prologue(gLSLDisplay, openGLState, object);
        this.render(gLSLDisplay, openGLState, object);
        this.epilogue(gLSLDisplay, openGLState, object);
        GLSLDisplay.printDebugInfoN("<<<<< " + this.getClass().getSimpleName() + "/" + this.hashCode() + " *****");
    }
}

