/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.utility;

import de.grogra.imp3d.glsl.material.GLSLMaterial;
import de.grogra.imp3d.glsl.renderable.GLSLRenderable;
import de.grogra.imp3d.glsl.utility.Drawable;
import de.grogra.imp3d.shading.Shader;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.vecmath.Matrix4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawableContainer
extends Vector<Drawable> {
    private static final long serialVersionUID = -4000295999794471113L;
    private int elements = 0;

    public void add(GLSLRenderable gLSLRenderable, Shader shader, GLSLMaterial gLSLMaterial, boolean bl, int n, Matrix4d matrix4d, Matrix4d matrix4d2) {
        ++this.elements;
        if (this.elements - 1 >= this.elementCount) {
            super.add(new Drawable(gLSLRenderable, shader, gLSLMaterial, bl, n, matrix4d, matrix4d2));
        } else {
            Drawable drawable = (Drawable)this.get(this.elements - 1);
            drawable.init(gLSLRenderable, shader, gLSLMaterial, bl, n, matrix4d, matrix4d2);
        }
    }

    @Override
    public synchronized int size() {
        return this.elements;
    }

    @Override
    public synchronized Drawable lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return (Drawable)this.elementData[this.elements - 1];
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elements == 0;
    }

    public void init() {
        this.elements = 0;
    }

    public void cleanup() {
        this.setSize(this.elements);
    }

    @Override
    public synchronized String toString() {
        return super.toString() + "#:" + this.size() + "[" + "]";
    }
}

