/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.utility;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.utility.FBOAttachment;
import de.grogra.imp3d.glsl.utility.TextureRenderTarget;
import javax.media.opengl.GL;

public class FrameBufferObject {
    int[] glFBONumber = new int[]{0};
    FBOAttachment[] attachments = new FBOAttachment[6];
    private final int[] nothingActive = new int[]{-1, -1, -1, -1};
    int[] activeRenderTargets = new int[4];
    int activeRenderTarget = -1;
    static final int[] all = new int[]{36064, 36065, 36066, 36067};

    public FBOAttachment getAttachment(int n) {
        return this.attachments[n];
    }

    public void bind(OpenGLState openGLState) {
        openGLState.setFBO(this.glFBONumber[0]);
    }

    public void delete(OpenGLState openGLState, boolean bl) {
        this.glFBONumber[0] = 0;
        for (int i = 0; i < 6; ++i) {
            this.attachments[i] = null;
        }
        if (!bl) {
            openGLState.getGL().glDeleteFramebuffersEXT(1, this.glFBONumber, 0);
        }
    }

    public void create(OpenGLState openGLState) {
        GL gL = openGLState.getGL();
        gL.glGenFramebuffersEXT(1, this.glFBONumber, 0);
    }

    public void attachDrawBuffer(OpenGLState openGLState, FBOAttachment fBOAttachment, int n) {
        this.bind(openGLState);
        fBOAttachment.attachToFbo(openGLState, 36064 + n);
        GLSLDisplay.printDebugInfoN("Attached " + fBOAttachment + " to " + this.glFBONumber[0] + " at " + n);
        this.attachments[n] = fBOAttachment;
    }

    public void attachDepthOnly(OpenGLState openGLState, FBOAttachment fBOAttachment) {
        this.bind(openGLState);
        this.attachments[4] = fBOAttachment;
        fBOAttachment.attachToFbo(openGLState, 36096);
    }

    public void attachStencilOnly(OpenGLState openGLState, FBOAttachment fBOAttachment) {
        this.bind(openGLState);
        this.attachments[5] = fBOAttachment;
        fBOAttachment.attachToFbo(openGLState, 36128);
    }

    public void attachDepthStencil(OpenGLState openGLState, FBOAttachment fBOAttachment) {
        this.bind(openGLState);
        this.attachments[4] = fBOAttachment;
        this.attachments[5] = fBOAttachment;
        fBOAttachment.attachToFbo(openGLState, 36096);
        fBOAttachment.attachToFbo(openGLState, 36128);
    }

    public void drawBuffer(OpenGLState openGLState, int n) {
        this.bind(openGLState);
        openGLState.getGL().glDrawBuffer(36064 + n);
        this.activeRenderTarget = n;
    }

    public void drawBuffers(OpenGLState openGLState, int n, int n2) {
        this.bind(openGLState);
        openGLState.getGL().glDrawBuffers(n, all, n2);
        this.activeRenderTarget = -1;
    }

    public void drawBuffers(OpenGLState openGLState, int n) {
        this.drawBuffers(openGLState, n, 0);
    }

    public void bindAttachmentAsTexture(OpenGLState openGLState, int n, int n2) {
        assert (this.attachments[n] instanceof TextureRenderTarget);
        ((TextureRenderTarget)this.attachments[n]).bindTo(openGLState.getGL(), 33984 + n2);
    }

    public void bindAllAttachmentsAsTextures(OpenGLState openGLState, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            ((TextureRenderTarget)this.attachments[i + n2]).bindTo(openGLState.getGL(), 33984 + i);
        }
    }

    public void bindAllAttachmentsAsTextures(OpenGLState openGLState, int n) {
        this.bindAllAttachmentsAsTextures(openGLState, n, 0);
    }

    public void bindAllAttachmentsAsTextures(OpenGLState openGLState) {
        this.bindAllAttachmentsAsTextures(openGLState, 4, 0);
    }

    public void resizeAttachments(OpenGLState openGLState) {
        for (int i = 0; i < 4; ++i) {
            if (this.attachments[i] == null) continue;
            this.attachments[i].resize(openGLState);
            this.attachDrawBuffer(openGLState, this.attachments[i], i);
        }
    }

    public void deleteAttachments(OpenGLState openGLState, boolean bl) {
        for (int i = 0; i < 4; ++i) {
            if (this.attachments[i] == null) continue;
            this.attachments[i].delete(openGLState, bl);
            this.attachments[i] = null;
        }
    }

    public boolean isComplete(OpenGLState openGLState) {
        boolean bl = false;
        GLSLDisplay.printDebugInfo(this + ":");
        switch (openGLState.getGL().glCheckFramebufferStatusEXT(36160)) {
            case 36053: {
                GLSLDisplay.printDebugInfoN("Framebuffer complete");
                bl = true;
                break;
            }
            case 36058: {
                GLSLDisplay.printDebugInfoN("Framebuffer incomplete format");
                break;
            }
            case 36054: {
                GLSLDisplay.printDebugInfoN("Framebuffer incomplete attachment");
                break;
            }
            case 36057: {
                GLSLDisplay.printDebugInfoN("Framebuffer incomplete dimensions");
                break;
            }
            case 36059: {
                GLSLDisplay.printDebugInfoN("Framebuffer incomplete draw buffer");
                break;
            }
            case 36056: {
                GLSLDisplay.printDebugInfoN("Framebuffer incomplete duplicate attachment");
                break;
            }
            case 36055: {
                GLSLDisplay.printDebugInfoN("Framebuffer incomplete missing attachment");
                break;
            }
            case 36182: {
                GLSLDisplay.printDebugInfoN("Framebuffer incomplete multisample");
                break;
            }
            case 36060: {
                GLSLDisplay.printDebugInfoN("Framebuffer incomplete missing attachment");
                break;
            }
            case 36265: {
                GLSLDisplay.printDebugInfoN("Framebuffer incomplete layer count");
                break;
            }
            case 36264: {
                GLSLDisplay.printDebugInfoN("Framebuffer incomplete layer targets");
                break;
            }
            case 36061: {
                GLSLDisplay.printDebugInfoN("Framebuffer unsupported");
                break;
            }
            default: {
                GLSLDisplay.printDebugInfoN("ERROR!!!!");
            }
        }
        return bl;
    }

    public String toString() {
        String string = "FBO[I:" + this.glFBONumber[0] + ",ATT:[";
        for (int i = 0; i < 6; ++i) {
            if (this.attachments[i] == null) continue;
            string = string + this.attachments[i] + ",";
        }
        string = string + "]]";
        return string;
    }

    public int estimateSizeInByteForColor() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.attachments[i] == null) continue;
            n += this.attachments[i].estimateSizeInByte();
        }
        return n;
    }
}

