/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.utility;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.Texture;
import de.grogra.imp3d.glsl.utility.GLSLManagedShader;
import de.grogra.imp3d.glsl.utility.GLSLQueuedTexture;
import java.awt.Image;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.media.opengl.GL;

public abstract class ShaderConfiguration {
    public static final byte USE_UV = 1;
    public static final byte USE_LOCAL_POS = 2;
    public static final byte USE_GLOBAL_POS = 4;
    public static final byte USE_DERIVATES = 8;
    private byte BIT_SET = 0;
    public static final int T_FLOAT = 0;
    public static final int T_VEC2 = 1;
    public static final int T_VEC3 = 2;
    public static final int T_VEC4 = 3;
    public static final int T_BOOL = 4;
    public static final int T_SAMPLER2D = 5;
    public static final int T_SAMPLER2DRECT = 6;
    public static final int T_SAMPLER2DSHADOW = 7;
    public static final int T_SAMPLERCUBE = 8;
    public static final int T_MAT3 = 9;
    static final String[] typeDef = new String[]{"float", "vec2", "vec3", "vec4", "bool", "sampler2D", "sampler2DRect", "sampler2DShadow", "samplerCube", "mat3"};
    protected transient Vector<String> var = new Vector();
    transient int currentTmpVar = 0;
    protected transient Vector<String> constVar = new Vector();
    transient int currentConstVar = 0;
    protected transient Vector<String> uniform = new Vector();
    transient int currentUniform = 0;
    protected transient LinkedHashMap<String, String> funcMap = new LinkedHashMap();
    protected final transient Vector<String> sampler = new Vector();
    final transient Vector<Image> textureRequest = new Vector();
    transient int currentTexture = 0;
    protected final transient Vector<String> customSampler = new Vector();
    final transient Vector<GLSLQueuedTexture> customTextureRequest = new Vector();
    transient int currentCustomTexture = 0;
    protected Object referenceKey = null;
    protected int version = 110;

    private void clearBits() {
        this.BIT_SET = 0;
    }

    public void setBit(byte by) {
        this.BIT_SET = (byte)(this.BIT_SET | by);
    }

    public boolean getBit(byte by) {
        return (this.BIT_SET & by) > 0;
    }

    public void clearTmpVariables() {
        this.currentTmpVar = 0;
        this.var.clear();
        this.currentConstVar = 0;
        this.constVar.clear();
        this.currentTexture = 0;
        this.sampler.clear();
        this.textureRequest.clear();
        this.currentCustomTexture = 0;
        this.customSampler.clear();
        this.customTextureRequest.clear();
        this.funcMap.clear();
        this.uniform.clear();
        this.clearBits();
    }

    public void setupTextures(GL gL, GLSLDisplay gLSLDisplay, int n, int n2) {
        int n3;
        int n4;
        for (n4 = 0; n4 < this.textureRequest.size(); ++n4) {
            n3 = gL.glGetUniformLocation(n, "tex" + n4);
            gL.glUniform1i(n3, n4 + n2);
            gL.glActiveTexture(33984 + n4 + n2);
        }
        for (n4 = 0; n4 < this.customTextureRequest.size(); ++n4) {
            n3 = gL.glGetUniformLocation(n, "customTex" + n4);
            gL.glUniform1i(n3, n4 + n2 + this.currentTexture + 1);
        }
    }

    public void bindTextures(GL gL, GLSLDisplay gLSLDisplay, int n, int n2) {
        Object object;
        int n3;
        for (n3 = 0; n3 < this.textureRequest.size(); ++n3) {
            object = this.textureRequest.elementAt(n3);
            if (object == null) continue;
            Texture texture = gLSLDisplay.getTextureManager().getTexture(gL, (Image)object);
            gL.glActiveTexture(33984 + n3 + n2);
            gL.glBindTexture(3553, texture.index);
        }
        for (n3 = 0; n3 < this.customTextureRequest.size(); ++n3) {
            object = this.customTextureRequest.elementAt(n3);
            if (object == null) continue;
            gL.glActiveTexture(33984 + n3 + this.currentTexture + 1 + n2);
            gL.glBindTexture(3553, ((GLSLQueuedTexture)object).getIndex(gL));
        }
    }

    public void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, int n) {
        this.bindTextures(gL, gLSLDisplay, n, 0);
    }

    public void setupShader(GL gL, GLSLDisplay gLSLDisplay, int n) {
        this.setupTextures(gL, gLSLDisplay, n, 0);
    }

    public String registerTexture(Image image) {
        String string = "tex" + this.currentTexture;
        ++this.currentTexture;
        this.sampler.add("uniform sampler2D " + string + ";\n");
        this.textureRequest.add(image);
        return string;
    }

    public String registerCustomTexture(GLSLQueuedTexture gLSLQueuedTexture) {
        String string = "customTex" + this.currentCustomTexture;
        ++this.currentCustomTexture;
        this.customSampler.add("uniform sampler2D " + string + ";\n");
        this.customTextureRequest.add(gLSLQueuedTexture);
        return string;
    }

    public String registerNewTmpVar(int n, String string) {
        String string2 = "tmp" + this.currentTmpVar;
        this.var.add(typeDef[n] + " " + string2 + " = " + string + ";\n");
        ++this.currentTmpVar;
        return string2;
    }

    public String registerGlobalConst(int n, String string) {
        String string2 = "const" + this.currentConstVar;
        this.constVar.add("const " + typeDef[n] + " " + string2 + " = " + string + ";\n");
        ++this.currentConstVar;
        return string2;
    }

    public String registerNewUniform(int n) {
        String string = "uni" + this.currentUniform;
        this.uniform.add("uniform " + typeDef[n] + " " + string + ";\n");
        ++this.currentUniform;
        return string;
    }

    public void registerFunc(String string, String string2) {
        String string3 = string + "{\n" + string2 + "\n}\n";
        this.funcMap.put(string, string3);
    }

    public void cleanUp(GL gL, boolean bl) {
        for (int i = 0; i < this.customTextureRequest.size(); ++i) {
            this.customTextureRequest.elementAt(i).delete(gL, bl);
        }
    }

    public void set(Object object) {
        this.referenceKey = object;
    }

    public void set(OpenGLState openGLState, GLSLDisplay gLSLDisplay, Object object) {
        this.set(object);
    }

    protected Object getReferenceKeyValue() {
        return this.perInstance() ? this.referenceKey.getClass() : this.referenceKey;
    }

    protected boolean perInstance() {
        return true;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.referenceKey == null ? 0 : this.getReferenceKeyValue().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ShaderConfiguration shaderConfiguration = (ShaderConfiguration)object;
        return !(this.referenceKey == null ? shaderConfiguration.referenceKey != null : !this.getReferenceKeyValue().equals(shaderConfiguration.getReferenceKeyValue()));
    }

    protected void setThisToOther(ShaderConfiguration shaderConfiguration) {
        this.referenceKey = shaderConfiguration.referenceKey;
    }

    public abstract ShaderConfiguration clone();

    public abstract GLSLManagedShader getShaderByDefaultCollection(GLSLDisplay var1, Object var2);

    public void setVersion(int n) {
        this.version = this.version < n ? n : this.version;
    }
}

