/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.msml;

import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.imp3d.msml.Appearance;
import de.grogra.imp3d.msml.MSMLWriter;
import de.grogra.imp3d.msml.Transform;
import de.grogra.imp3d.msml.X3DMSMLDatatype;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.Axis;
import de.grogra.imp3d.objects.Box;
import de.grogra.imp3d.objects.Cone;
import de.grogra.imp3d.objects.Cylinder;
import de.grogra.imp3d.objects.Frustum;
import de.grogra.imp3d.objects.ShadedNull;
import de.grogra.imp3d.objects.Sphere;
import de.grogra.pf.registry.Registry;
import java.net.URL;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Shape
extends X3DMSMLDatatype {
    public void export(Object object, Document document, Element element, de.grogra.graph.impl.Node node) {
        Element element2 = document.createElementNS("http://grogra.de/msml/datatypes/groimp", "g:Shape");
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        Object object2 = graphState.getObjectDefault((Object)node, true, Attributes.SHAPE, null);
        if (object2 instanceof Cylinder) {
            Element element3 = document.createElementNS("http://www.web3d.org/specifications", "x3d:Cylinder");
            element3.setAttribute("radius", String.valueOf(graphState.getFloat((Object)node, true, Attributes.RADIUS)));
            element3.setAttribute("height", String.valueOf(graphState.getDouble((Object)node, true, Attributes.LENGTH)));
            element3.setAttribute("top", String.valueOf(!graphState.getBoolean((Object)node, true, Attributes.TOP_OPEN)));
            element3.setAttribute("bottom", String.valueOf(!graphState.getBoolean((Object)node, true, Attributes.BASE_OPEN)));
            element2.setAttribute("startpos", String.valueOf(graphState.getFloatDefault((Object)node, true, Attributes.START_POSITION, 0.0f)));
            element2.setAttribute("endpos", String.valueOf(graphState.getFloatDefault((Object)node, true, Attributes.END_POSITION, 1.0f)));
            element2.appendChild(element3);
            element.appendChild(element2);
            new Transform().export(object, document, element, node);
            new Appearance().export(object, document, element, node);
        } else if (object2 instanceof Cone) {
            Element element4 = document.createElementNS("http://www.web3d.org/specifications", "x3d:Cone");
            element4.setAttribute("bottomRadius", String.valueOf(graphState.getFloat((Object)node, true, Attributes.RADIUS)));
            element4.setAttribute("height", String.valueOf(graphState.getDouble((Object)node, true, Attributes.LENGTH)));
            element4.setAttribute("bottom", String.valueOf(!graphState.getBoolean((Object)node, true, Attributes.BASE_OPEN)));
            element2.setAttribute("startpos", String.valueOf(graphState.getFloatDefault((Object)node, true, Attributes.START_POSITION, 0.0f)));
            element2.setAttribute("endpos", String.valueOf(graphState.getFloatDefault((Object)node, true, Attributes.END_POSITION, 1.0f)));
            element2.appendChild(element4);
            element.appendChild(element2);
            new Transform().export(object, document, element, node);
            new Appearance().export(object, document, element, node);
        } else if (object2 instanceof Sphere) {
            Element element5 = document.createElementNS("http://www.web3d.org/specifications", "x3d:Sphere");
            element5.setAttribute("radius", String.valueOf(graphState.getFloat((Object)node, true, Attributes.RADIUS)));
            element2.appendChild(element5);
            element.appendChild(element2);
            new Transform().export(object, document, element, node);
            new Appearance().export(object, document, element, node);
        } else if (object2 instanceof Box) {
            Element element6 = document.createElementNS("http://www.web3d.org/specifications", "x3d:Box");
            element6.setAttribute("size", Shape.getStringFromVector3d(new Vector3d(graphState.getDouble((Object)node, true, Attributes.WIDTH), graphState.getDouble((Object)node, true, Attributes.LENGTH), graphState.getDouble((Object)node, true, Attributes.HEIGHT))));
            element2.setAttribute("startpos", String.valueOf(graphState.getFloatDefault((Object)node, true, Attributes.START_POSITION, 0.0f)));
            element2.setAttribute("endpos", String.valueOf(graphState.getFloatDefault((Object)node, true, Attributes.END_POSITION, 1.0f)));
            element2.appendChild(element6);
            element.appendChild(element2);
            new Transform().export(object, document, element, node);
            new Appearance().export(object, document, element, node);
        } else if (object2 instanceof Frustum) {
            Element element7 = document.createElementNS("http://www.web3d.org/specifications", "x3d:Extrusion");
            element7.setAttribute("height", String.valueOf(graphState.getDouble((Object)node, true, Attributes.LENGTH)));
            element7.setAttribute("endCap", String.valueOf(!graphState.getBoolean((Object)node, true, Attributes.TOP_OPEN)));
            element7.setAttribute("beginCap", String.valueOf(!graphState.getBoolean((Object)node, true, Attributes.BASE_OPEN)));
            element7.setAttribute("solid", "false");
            element7.setAttribute("creaseAngle", "90");
            element7.setAttribute("crossSection", "1 0 0.866 0.5 0.5 0.866 0 1 -0.5 0.866 -0.866 0.5 -1 0 -0.866 -0.5 -0.5 -0.866 0 -1 0.5 -0.866 0.866 -0.5 1 0");
            element7.setAttribute("spine", "0 0 0 " + Shape.getStringFromVector3d(MSMLWriter.COORD.transform(new Vector3d(0.0, 0.0, graphState.getDouble((Object)node, true, Attributes.LENGTH)))));
            element7.setAttribute("scale", graphState.getFloat((Object)node, true, Attributes.BASE_RADIUS) + " " + graphState.getFloat((Object)node, true, Attributes.BASE_RADIUS) + " " + graphState.getFloat((Object)node, true, Attributes.TOP_RADIUS) + " " + graphState.getFloat((Object)node, true, Attributes.TOP_RADIUS));
            element2.setAttribute("startpos", String.valueOf(graphState.getFloatDefault((Object)node, true, Attributes.START_POSITION, 0.0f)));
            element2.setAttribute("endpos", String.valueOf(graphState.getFloatDefault((Object)node, true, Attributes.END_POSITION, 1.0f)));
            element2.appendChild(element7);
            element.appendChild(element2);
            new Transform().export(object, document, element, node);
            new Appearance().export(object, document, element, node);
        }
    }

    public de.grogra.graph.impl.Node export(Registry registry, Node node, de.grogra.graph.impl.Node node2, URL uRL) {
        de.grogra.graph.impl.Node node3 = node2;
        if (node.getNamespaceURI().equals("http://grogra.de/msml/datatypes/groimp")) {
            for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                String string;
                ShadedNull shadedNull;
                if (node4.getNodeType() != 1 || !node4.getNamespaceURI().equals("http://www.web3d.org/specifications")) continue;
                if (node4.getLocalName().equals("Cylinder")) {
                    shadedNull = new Cylinder(2.0f, 1.0f);
                    string = Shape.getAttributeContent(node4, "radius");
                    if (string != "") {
                        ((Cylinder)shadedNull).setRadius(Float.valueOf(string).floatValue());
                    }
                    if ((string = Shape.getAttributeContent(node4, "height")) != "") {
                        ((Axis)shadedNull).setLength(Float.valueOf(string).floatValue());
                    }
                    if ((string = Shape.getAttributeContent(node4, "top")) != "") {
                        ((Cylinder)shadedNull).setTopOpen(Boolean.valueOf(string) == false);
                    }
                    if ((string = Shape.getAttributeContent(node4, "bottom")) != "") {
                        ((Cylinder)shadedNull).setBaseOpen(Boolean.valueOf(string) == false);
                    }
                    if ((string = Shape.getAttributeContent(node, "startpos")) != "") {
                        ((Axis)shadedNull).setStartPosition(Float.valueOf(string).floatValue());
                    } else {
                        ((Axis)shadedNull).setStartPosition(-0.5f);
                    }
                    string = Shape.getAttributeContent(node, "endpos");
                    if (string != "") {
                        ((Axis)shadedNull).setEndPosition(Float.valueOf(string).floatValue());
                    } else {
                        ((Axis)shadedNull).setEndPosition(0.0f);
                    }
                    node3 = shadedNull;
                    continue;
                }
                if (node4.getLocalName().equals("Cone")) {
                    shadedNull = new Cone();
                    ((Axis)shadedNull).setLength(2.0f);
                    string = Shape.getAttributeContent(node4, "bottomRadius");
                    if (string != "") {
                        ((Cone)shadedNull).setRadius(Float.valueOf(string).floatValue());
                    }
                    if ((string = Shape.getAttributeContent(node4, "height")) != "") {
                        ((Axis)shadedNull).setLength(Float.valueOf(string).floatValue());
                    }
                    if ((string = Shape.getAttributeContent(node4, "bottom")) != "") {
                        ((Cone)shadedNull).setOpen(Boolean.valueOf(string) == false);
                    }
                    if ((string = Shape.getAttributeContent(node, "startpos")) != "") {
                        ((Axis)shadedNull).setStartPosition(Float.valueOf(string).floatValue());
                    } else {
                        ((Axis)shadedNull).setStartPosition(-0.5f);
                    }
                    string = Shape.getAttributeContent(node, "endpos");
                    if (string != "") {
                        ((Axis)shadedNull).setEndPosition(Float.valueOf(string).floatValue());
                    } else {
                        ((Axis)shadedNull).setEndPosition(0.0f);
                    }
                    node3 = shadedNull;
                    continue;
                }
                if (node4.getLocalName().equals("Sphere")) {
                    shadedNull = new Sphere(1.0f);
                    string = Shape.getAttributeContent(node4, "radius");
                    if (string != "") {
                        ((Sphere)shadedNull).setRadius(Float.valueOf(string).floatValue());
                    }
                    node3 = shadedNull;
                    continue;
                }
                if (!node4.getLocalName().equals("Box")) continue;
                shadedNull = new Box();
                ((Axis)shadedNull).setLength(2.0f);
                ((Box)shadedNull).setWidth(2.0f);
                ((Box)shadedNull).setHeight(2.0f);
                string = Shape.getAttributeContent(node4, "size");
                if (string != "") {
                    Vector3f vector3f = Shape.getVector3fFromString(string);
                    ((Axis)shadedNull).setLength(vector3f.y);
                    ((Box)shadedNull).setWidth(vector3f.x);
                    ((Box)shadedNull).setHeight(vector3f.z);
                }
                if ((string = Shape.getAttributeContent(node, "startpos")) != "") {
                    ((Axis)shadedNull).setStartPosition(Float.valueOf(string).floatValue());
                } else {
                    ((Axis)shadedNull).setStartPosition(-0.5f);
                }
                string = Shape.getAttributeContent(node, "endpos");
                if (string != "") {
                    ((Axis)shadedNull).setEndPosition(Float.valueOf(string).floatValue());
                } else {
                    ((Axis)shadedNull).setEndPosition(0.0f);
                }
                node3 = shadedNull;
            }
        }
        return node3;
    }
}

