/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.imp3d.shading.Shader;
import de.grogra.math.Tuple3fType;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.ShareableBase;
import de.grogra.ray.physics.Spectrum;
import de.grogra.util.Quantity;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

public class AreaLight
extends ShareableBase {
    float power = 100.0f;
    float exponent = 4.0f;
    boolean shadowless = false;
    boolean ignoredWhenHit = false;
    public static final Type $TYPE = new Type(AreaLight.class);
    public static final SCOType.Field power$FIELD = Type._addManagedField($TYPE, "power", 0x200000, de.grogra.reflect.Type.FLOAT, null, 0);
    public static final SCOType.Field exponent$FIELD = Type._addManagedField($TYPE, "exponent", 0x200000, de.grogra.reflect.Type.FLOAT, null, 1);
    public static final SCOType.Field shadowless$FIELD = Type._addManagedField($TYPE, "shadowless", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 2);
    public static final SCOType.Field ignoredWhenHit$FIELD = Type._addManagedField($TYPE, "ignoredWhenHit", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 3);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public boolean isShadowless() {
        return this.shadowless;
    }

    public void setShadowless(boolean bl) {
        this.shadowless = bl;
    }

    public boolean isIgnoredWhenHit() {
        return this.ignoredWhenHit;
    }

    public void setIgnoredWhenHit(boolean bl) {
        this.ignoredWhenHit = bl;
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float f) {
        this.power = f;
    }

    public float getExponent() {
        return this.exponent;
    }

    public void setExponent(float f) {
        this.exponent = f;
    }

    void computeExitance(Shader shader, float f, Spectrum spectrum) {
        Color3f color3f = new Color3f();
        Tuple3fType.setColor((Tuple3f)color3f, (int)(shader != null ? shader.getAverageColor() : -1));
        spectrum.set((Tuple3f)color3f);
        spectrum.scale((double)this.power / ((double)f * spectrum.integrate()));
    }

    static {
        power$FIELD.setQuantity(Quantity.POWER);
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 4;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(AreaLight areaLight, SCOType sCOType) {
            super((Object)areaLight, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 2: {
                    ((AreaLight)((Object)object)).shadowless = bl;
                    return;
                }
                case 3: {
                    ((AreaLight)((Object)object)).ignoredWhenHit = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((AreaLight)((Object)object)).isShadowless();
                }
                case 3: {
                    return ((AreaLight)((Object)object)).isIgnoredWhenHit();
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 0: {
                    ((AreaLight)((Object)object)).power = f;
                    return;
                }
                case 1: {
                    ((AreaLight)((Object)object)).exponent = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((AreaLight)((Object)object)).getPower();
                }
                case 1: {
                    return ((AreaLight)((Object)object)).getExponent();
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new AreaLight();
        }
    }
}

