/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Attribute;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.AxisBase;
import de.grogra.math.TMatrix4d;
import de.grogra.math.Transform3D;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.Type;
import de.grogra.vecmath.Math2;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public abstract class Axis
extends AxisBase {
    protected float length = 1.0f;
    protected float startPosition = 0.0f;
    protected float endPosition = 1.0f;
    public static final Node.NType $TYPE = new Node.NType(Axis.class);
    public static final Node.NType.Field length$FIELD = new _Field("length", 0x200004, Type.FLOAT, null, 0);
    public static final Node.NType.Field startPosition$FIELD;
    public static final Node.NType.Field endPosition$FIELD;

    public Axis() {
    }

    public Axis(Transform3D transform3D) {
        this.setTransform(transform3D);
    }

    protected float getPivotShift(Object object, boolean bl, GraphState graphState) {
        return 0.0f;
    }

    public void preTransform(Object object, boolean bl, Matrix4d matrix4d, Matrix4d matrix4d2, GraphState graphState) {
        float f;
        Transform3D transform3D;
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                transform3D = this.transform;
                f = this.startPosition * this.length;
            } else {
                transform3D = (Transform3D)graphState.checkObject((Object)this, true, Attributes.TRANSFORM, (Object)this.transform);
                f = graphState.checkFloat((Object)this, true, Attributes.START_POSITION, this.startPosition);
                if (f != 0.0f) {
                    f = (float)((double)f * graphState.checkDouble((Object)this, true, Attributes.LENGTH, (double)this.length));
                }
            }
        } else {
            transform3D = (Transform3D)graphState.getObject(object, bl, null, Attributes.TRANSFORM);
            f = graphState.getFloat(object, bl, Attributes.START_POSITION);
            if (f != 0.0f) {
                f = (float)((double)f * graphState.getDouble(object, bl, Attributes.LENGTH));
            }
        }
        if (transform3D != null) {
            this.transform.transform(matrix4d, matrix4d2);
        } else {
            matrix4d2.set(matrix4d);
        }
        if ((f -= this.getPivotShift(object, bl, graphState)) != 0.0f) {
            matrix4d2.m03 += (double)f * matrix4d2.m02;
            matrix4d2.m13 += (double)f * matrix4d2.m12;
            matrix4d2.m23 += (double)f * matrix4d2.m22;
        }
    }

    public void postTransform(Object object, boolean bl, Matrix4d matrix4d, Matrix4d matrix4d2, Matrix4d matrix4d3, GraphState graphState) {
        block10: {
            float f;
            block11: {
                block8: {
                    block9: {
                        if (object != this) break block8;
                        if (graphState.getInstancingPathIndex() > 0) break block9;
                        if ((this.bits & 0x800) == 0) break block10;
                        f = (this.endPosition - this.startPosition) * this.length;
                        break block11;
                    }
                    if (!graphState.checkBoolean((Object)this, true, Attributes.TRANSFORMING, (this.bits & 0x800) != 0)) break block10;
                    f = graphState.checkFloat((Object)this, true, Attributes.END_POSITION, this.endPosition) - graphState.checkFloat((Object)this, true, Attributes.START_POSITION, this.startPosition);
                    if (f != 0.0f) {
                        f = (float)((double)f * graphState.checkDouble((Object)this, true, Attributes.LENGTH, (double)this.length));
                    }
                    break block11;
                }
                if (!graphState.getBoolean(object, bl, Attributes.TRANSFORMING)) break block10;
                f = graphState.getFloat(object, bl, Attributes.END_POSITION) - graphState.getFloat(object, bl, Attributes.START_POSITION);
                if (f != 0.0f) {
                    f = (float)((double)f * graphState.getDouble(object, bl, Attributes.LENGTH));
                }
            }
            matrix4d2.set(matrix4d);
            if ((f += this.getPivotShift(object, bl, graphState)) != 0.0f) {
                matrix4d2.m03 += (double)f * matrix4d2.m02;
                matrix4d2.m13 += (double)f * matrix4d2.m12;
                matrix4d2.m23 += (double)f * matrix4d2.m22;
            }
            return;
        }
        if (matrix4d2 != matrix4d3) {
            matrix4d2.set(matrix4d3);
        }
    }

    public void setEndPoints(Tuple3d tuple3d, Tuple3d tuple3d2) {
        this.setEndPoints(tuple3d.x, tuple3d.y, tuple3d.z, tuple3d2.x, tuple3d2.y, tuple3d2.z);
    }

    public void setEndPoints(double d, double d2, double d3, double d4, double d5, double d6) {
        Vector3d vector3d = new Vector3d(d4 - d, d5 - d2, d6 - d3);
        double d7 = vector3d.length();
        this.setLength((float)d7);
        if (d7 > 0.0) {
            Matrix3d matrix3d = new Matrix3d();
            Math2.getOrthogonalBasis((Tuple3d)vector3d, (Matrix3d)matrix3d, (boolean)true);
            TMatrix4d tMatrix4d = new TMatrix4d();
            tMatrix4d.m03 = d;
            tMatrix4d.m13 = d2;
            tMatrix4d.m23 = d3;
            tMatrix4d.setRotationScale(matrix3d);
            this.setTransform(tMatrix4d);
        } else {
            this.setTransform(d, d2, d3);
        }
    }

    public void setEndPoints(Matrix4d matrix4d, Tuple3d tuple3d) {
        Point3d point3d = new Point3d(tuple3d);
        Math2.invTransformPoint((Matrix4d)matrix4d, (Tuple3d)point3d);
        this.setEndPoints(0.0, 0.0, 0.0, point3d.x, point3d.y, point3d.z);
    }

    private static void initType() {
        $TYPE.addDependency(startPosition$FIELD.getAttribute(), (Attribute)Attributes.TRANSFORMATION);
        $TYPE.addDependency(endPosition$FIELD.getAttribute(), (Attribute)Attributes.TRANSFORMATION);
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float f) {
        this.length = f;
    }

    public float getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(float f) {
        this.startPosition = f;
    }

    public float getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(float f) {
        this.endPosition = f;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)length$FIELD);
        startPosition$FIELD = new _Field("startPosition", 0x200004, Type.FLOAT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)startPosition$FIELD);
        endPosition$FIELD = new _Field("endPosition", 0x200004, Type.FLOAT, null, 2);
        $TYPE.addManagedField((ManageableType.Field)endPosition$FIELD);
        $TYPE.declareFieldAttribute(length$FIELD, (Attribute)Attributes.LENGTH);
        $TYPE.declareFieldAttribute(startPosition$FIELD, (Attribute)Attributes.START_POSITION);
        $TYPE.declareFieldAttribute(endPosition$FIELD, (Attribute)Attributes.END_POSITION);
        Axis.initType();
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 0: {
                    ((Axis)object).length = f;
                    return;
                }
                case 1: {
                    ((Axis)object).startPosition = f;
                    return;
                }
                case 2: {
                    ((Axis)object).endPosition = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Axis)object).getLength();
                }
                case 1: {
                    return ((Axis)object).getStartPosition();
                }
                case 2: {
                    return ((Axis)object).getEndPosition();
                }
            }
            return super.getFloat(object);
        }
    }
}

