/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Attribute;
import de.grogra.graph.ContextDependent;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp3d.Pickable;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.Polygonization;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.ShadedNull;
import de.grogra.imp3d.objects.Sphere;
import de.grogra.math.Pool;
import de.grogra.math.VertexGrid;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Patch
extends ShadedNull
implements Pickable,
Polygonizable,
Polygonization,
Renderable {
    protected VertexGrid grid;
    protected int visibleSides = 2;
    public static final Node.NType $TYPE = new Node.NType((Node)new Patch());
    public static final Node.NType.Field grid$FIELD = new _Field("grid", 0x200004, (Type)ClassAdapter.wrap(VertexGrid.class), null, 0);
    public static final Node.NType.Field visibleSides$FIELD;

    public Patch() {
        this.bits |= 0x800;
        this.setLayer(1);
    }

    public Patch(VertexGrid vertexGrid) {
        this();
        this.grid = vertexGrid;
    }

    public ContextDependent getPolygonizableSource(GraphState graphState) {
        return this.grid;
    }

    public static void pick(VertexGrid vertexGrid, Point3d point3d, Vector3d vector3d, PickList pickList) {
        Sphere.pick(1.0f, point3d, vector3d, pickList);
    }

    public void pick(Object object, boolean bl, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList) {
        GraphState graphState = pickList.getGraphState();
        graphState.setObjectContext(object, bl);
        if (object == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                Patch.pick(this.grid, point3d, vector3d, pickList);
            } else {
                Patch.pick((VertexGrid)graphState.checkObject((Object)this, true, Attributes.VERTEX_GRID, (Object)this.grid), point3d, vector3d, pickList);
            }
        } else {
            Patch.pick((VertexGrid)graphState.getObject(object, bl, Attributes.VERTEX_GRID), point3d, vector3d, pickList);
        }
    }

    public Polygonization getPolygonization() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void polygonize(ContextDependent contextDependent, GraphState graphState, PolygonArray polygonArray, int n, float f) {
        int n2;
        int n3;
        boolean bl = (n & 2) != 0;
        polygonArray.init(3);
        polygonArray.edgeCount = 4;
        polygonArray.planar = false;
        polygonArray.closed = false;
        int n4 = this.grid.getUSize(graphState);
        int n5 = n4 - 1;
        int n6 = this.grid.getVSize(graphState);
        int n7 = n6 - 1;
        float f2 = 1.0f / (float)n5;
        float f3 = 1.0f / (float)n7;
        Pool pool = Pool.get((GraphState)graphState);
        float[] fArray = pool.getFloatArray(0, 3);
        Point3f point3f = pool.p3f0;
        Vector3f vector3f = pool.v3f0;
        Vector3f vector3f2 = pool.v3f1;
        Vector3f vector3f3 = pool.v3f2;
        int n8 = 0;
        while (true) {
            if (n8 > n7) break;
            for (n3 = 0; n3 <= n5; ++n3) {
                n2 = this.grid.getVertex(fArray, this.grid.getVertexIndex(n3, n8, graphState), graphState);
                point3f.x = fArray[0];
                point3f.y = n2 > 1 ? fArray[1] : 0.0f;
                point3f.z = n2 > 2 ? fArray[2] : 0.0f;
                polygonArray.vertices.push(point3f.x).push(point3f.y).push(point3f.z);
                if (!bl) continue;
                polygonArray.uv.push((float)n3 * f2).push((float)n8 * f3);
            }
            ++n8;
        }
        float[] fArray2 = polygonArray.vertices.elements;
        n3 = 0;
        n2 = 0;
        block8: while (true) {
            if (n2 > n7) {
                polygonArray.visibleSides = this.visibleSides;
                return;
            }
            int n9 = 0;
            while (true) {
                boolean bl2;
                int n10;
                if (n9 <= n5) {
                    n10 = 3 * n3;
                    point3f.x = fArray2[n10];
                    point3f.y = fArray2[n10 + 1];
                    point3f.z = fArray2[n10 + 2];
                    vector3f3.set(0.0f, 0.0f, 0.0f);
                    bl2 = false;
                } else {
                    ++n2;
                    continue block8;
                }
                block10: for (int i = -4; i <= 0; ++i) {
                    int n11 = n9;
                    int n12 = n2;
                    switch (i & 3) {
                        case 0: {
                            if (++n11 != n4) break;
                            bl2 = false;
                            continue block10;
                        }
                        case 1: {
                            if (++n12 != n6) break;
                            bl2 = false;
                            continue block10;
                        }
                        case 2: {
                            if (--n11 >= 0) break;
                            bl2 = false;
                            continue block10;
                        }
                        case 3: {
                            if (--n12 >= 0) break;
                            bl2 = false;
                            continue block10;
                        }
                    }
                    n10 = 3 * (n12 * n4 + n11);
                    vector3f2.x = fArray2[n10];
                    vector3f2.y = fArray2[n10 + 1];
                    vector3f2.z = fArray2[n10 + 2];
                    vector3f2.sub((Tuple3f)point3f);
                    if (bl2) {
                        vector3f.cross(vector3f, vector3f2);
                        vector3f3.add((Tuple3f)vector3f);
                    }
                    Vector3f vector3f4 = vector3f;
                    vector3f = vector3f2;
                    vector3f2 = vector3f4;
                    bl2 = true;
                }
                polygonArray.setNormal(n3, vector3f3.x, vector3f3.y, vector3f3.z);
                if (n2 < n7 && n9 < n5) {
                    polygonArray.polygons.push(n3).push(n3 + 1).push(n3 + 1 + n4).push(n3 + n4);
                }
                ++n3;
                ++n9;
            }
            break;
        }
    }

    public void draw(Object object, boolean bl, RenderState renderState) {
        renderState.drawPolygons(this, object, bl, null, -1, null);
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Patch();
    }

    public int getVisibleSides() {
        return this.visibleSides;
    }

    public void setVisibleSides(int n) {
        this.visibleSides = n;
    }

    public VertexGrid getGrid() {
        return this.grid;
    }

    public void setGrid(VertexGrid vertexGrid) {
        grid$FIELD.setObject((Object)this, (Object)vertexGrid);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)grid$FIELD);
        visibleSides$FIELD = new _Field("visibleSides", 0x200004, Type.INT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)visibleSides$FIELD);
        $TYPE.declareFieldAttribute(grid$FIELD, (Attribute)Attributes.VERTEX_GRID);
        $TYPE.declareFieldAttribute(visibleSides$FIELD, (Attribute)Attributes.VISIBLE_SIDES);
        $TYPE.addIdentityAccessor(Attributes.SHAPE);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setInt(Object object, int n) {
            switch (this.id) {
                case 1: {
                    ((Patch)object).visibleSides = n;
                    return;
                }
            }
            super.setInt(object, n);
        }

        public int getInt(Object object) {
            switch (this.id) {
                case 1: {
                    return ((Patch)object).getVisibleSides();
                }
            }
            return super.getInt(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((Patch)object).grid = (VertexGrid)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Patch)object).getGrid();
                }
            }
            return super.getObject(object);
        }
    }
}

