/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp3d.Pickable;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.ColoredNull;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

public class PointCloud
extends ColoredNull
implements Renderable,
Pickable {
    float pointSize = 3.0f;
    float[] points;
    private transient double minx;
    private transient double miny;
    private transient double minz;
    private transient double maxx;
    private transient double maxy;
    private transient double maxz;
    public static final Node.NType $TYPE = new Node.NType((Node)new PointCloud());
    public static final Node.NType.Field pointSize$FIELD = new _Field("pointSize", 0x200000, Type.FLOAT, null, 0);
    public static final Node.NType.Field points$FIELD;

    public PointCloud() {
        this.setPoints(new float[0]);
    }

    public PointCloud(float[] fArray) {
        this.setPoints(fArray);
    }

    public PointCloud(float[] fArray, float f) {
        this.setPoints(fArray);
    }

    public float[] getPoints() {
        float[] fArray = new float[this.points.length];
        System.arraycopy(this.points, 0, fArray, 0, this.points.length);
        return fArray;
    }

    public void setPoints(float[] fArray) {
        assert (fArray.length % 3 == 0);
        this.points = new float[fArray.length];
        System.arraycopy(fArray, 0, this.points, 0, fArray.length);
        int n = this.points.length / 3;
        this.minz = Double.POSITIVE_INFINITY;
        this.miny = Double.POSITIVE_INFINITY;
        this.minx = Double.POSITIVE_INFINITY;
        this.maxz = Double.NEGATIVE_INFINITY;
        this.maxy = Double.NEGATIVE_INFINITY;
        this.maxx = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            this.minx = Math.min(this.minx, (double)this.points[3 * i + 0]);
            this.miny = Math.min(this.miny, (double)this.points[3 * i + 1]);
            this.minz = Math.min(this.minz, (double)this.points[3 * i + 2]);
            this.maxx = Math.max(this.maxx, (double)this.points[3 * i + 0]);
            this.maxy = Math.max(this.maxy, (double)this.points[3 * i + 1]);
            this.maxz = Math.max(this.maxz, (double)this.points[3 * i + 2]);
        }
    }

    public void draw(Object object, boolean bl, RenderState renderState) {
        renderState.drawPointCloud(this.points, this.pointSize, (Tuple3f)this.color, -1, null);
    }

    public void pick(Object object, boolean bl, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        if (vector3d.x >= 0.0) {
            d6 = (this.minx - point3d.x) / vector3d.x;
            d5 = (this.maxx - point3d.x) / vector3d.x;
        } else {
            d6 = (this.maxx - point3d.x) / vector3d.x;
            d5 = (this.minx - point3d.x) / vector3d.x;
        }
        if (vector3d.y >= 0.0) {
            d4 = (this.miny - point3d.y) / vector3d.y;
            d3 = (this.maxy - point3d.y) / vector3d.y;
        } else {
            d4 = (this.maxy - point3d.y) / vector3d.y;
            d3 = (this.miny - point3d.y) / vector3d.y;
        }
        if (d6 > d3 || d4 > d5) {
            return;
        }
        if (d4 > d6) {
            d6 = d4;
        }
        if (d3 < d5) {
            d5 = d3;
        }
        if (vector3d.z >= 0.0) {
            d2 = (this.minz - point3d.z) / vector3d.z;
            d = (this.maxz - point3d.z) / vector3d.z;
        } else {
            d2 = (this.maxz - point3d.z) / vector3d.z;
            d = (this.minz - point3d.z) / vector3d.z;
        }
        if (d6 > d || d2 > d5) {
            return;
        }
        if (d2 > d6) {
            d6 = d2;
        }
        if (d < d5) {
            d5 = d;
        }
        pickList.add(d6);
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new PointCloud();
    }

    public float getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(float f) {
        this.pointSize = f;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)pointSize$FIELD);
        points$FIELD = new _Field("points", 0x200000, (Type)ClassAdapter.wrap(float[].class), null, 1);
        $TYPE.addManagedField((ManageableType.Field)points$FIELD);
        $TYPE.addIdentityAccessor(Attributes.SHAPE);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 0: {
                    ((PointCloud)object).pointSize = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 0: {
                    return ((PointCloud)object).getPointSize();
                }
            }
            return super.getFloat(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 1: {
                    ((PointCloud)object).setPoints((float[])object2);
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 1: {
                    return ((PointCloud)object).getPoints();
                }
            }
            return super.getObject(object);
        }
    }
}

