/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp3d.Pickable;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.ColoredNull;
import de.grogra.imp3d.objects.Sphere;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.math.RGBColor;
import de.grogra.math.Tuple3fType;
import de.grogra.persistence.ManageableType;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Sensor;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.reflect.Type;
import de.grogra.vecmath.Math2;
import java.util.Random;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class SensorNode
extends ColoredNull
implements Pickable,
Renderable,
Sensor {
    protected float radius = 1.0f;
    protected float exponent = 0.0f;
    protected boolean twoSided = true;
    public static final Node.NType $TYPE = new Node.NType((Node)new SensorNode());
    public static final Node.NType.Field radius$FIELD = new _Field("radius", 0x200004, Type.FLOAT, null, 0);
    public static final Node.NType.Field exponent$FIELD;
    public static final Node.NType.Field twoSided$FIELD;

    public SensorNode() {
        this.color = RGBColor.WHITE;
    }

    public int getFlags() {
        return 4;
    }

    public int getAverageColor() {
        return Tuple3fType.colorToInt((Tuple3f)this.color);
    }

    public double computeExitance(Environment environment, Spectrum spectrum) {
        spectrum.set((Tuple3f)this.color);
        spectrum.scale(1.0 / (Math.PI * (double)this.radius * (double)this.radius));
        return 0.0;
    }

    public float computeBSDF(Environment environment, Vector3f vector3f, Spectrum spectrum, Vector3f vector3f2, boolean bl, Spectrum spectrum2) {
        float f = environment.normal.dot(vector3f2);
        if (f <= 0.0f) {
            f = this.twoSided ? Math.abs(f) : 0.0f;
        }
        double d = Math.pow(f, this.exponent) * (double)(this.exponent + 1.0f) * (double)Math2.M_1_2PI;
        if (this.twoSided) {
            d *= 0.5;
        }
        spectrum2.set(spectrum);
        spectrum2.scale(d);
        return 0.0f;
    }

    public void generateRandomOrigins(Environment environment, RayList rayList, Random random) {
        throw new UnsupportedOperationException();
    }

    public void generateRandomRays(Environment environment, Vector3f vector3f, Spectrum spectrum, RayList rayList, boolean bl, Random random) {
        throw new UnsupportedOperationException();
    }

    public double completeRay(Environment environment, Point3d point3d, Ray ray) {
        throw new UnsupportedOperationException();
    }

    public float[] getUVForVertex(Environment environment, Point3d point3d) {
        throw new UnsupportedOperationException();
    }

    public void pick(Object object, boolean bl, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList) {
        Sphere.pick(this.radius, point3d, vector3d, pickList);
    }

    public void draw(Object object, boolean bl, RenderState renderState) {
        renderState.drawSphere(this.radius, new RGBAShader(this.color.x, this.color.y, this.color.z), -1, null);
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new SensorNode();
    }

    public boolean isTwoSided() {
        return this.twoSided;
    }

    public void setTwoSided(boolean bl) {
        this.twoSided = bl;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public float getExponent() {
        return this.exponent;
    }

    public void setExponent(float f) {
        this.exponent = f;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)radius$FIELD);
        exponent$FIELD = new _Field("exponent", 0x200004, Type.FLOAT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)exponent$FIELD);
        twoSided$FIELD = new _Field("twoSided", 0x200004, Type.BOOLEAN, null, 2);
        $TYPE.addManagedField((ManageableType.Field)twoSided$FIELD);
        $TYPE.addIdentityAccessor(Attributes.SHAPE);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setBoolean(Object object, boolean bl) {
            switch (this.id) {
                case 2: {
                    ((SensorNode)object).twoSided = bl;
                    return;
                }
            }
            super.setBoolean(object, bl);
        }

        public boolean getBoolean(Object object) {
            switch (this.id) {
                case 2: {
                    return ((SensorNode)object).isTwoSided();
                }
            }
            return super.getBoolean(object);
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 0: {
                    ((SensorNode)object).radius = f;
                    return;
                }
                case 1: {
                    ((SensorNode)object).exponent = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 0: {
                    return ((SensorNode)object).getRadius();
                }
                case 1: {
                    return ((SensorNode)object).getExponent();
                }
            }
            return super.getFloat(object);
        }
    }
}

